/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.ExpressionToken;
import com.wm.lang.flow.TokenBuffer;
import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.ParsedDot;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.ParsedQuery;
import com.wm.lang.xql.ParsedRelativeDescendantPath;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.ResultSet;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.Values;

class ParsedAbsoluteChildPath
extends ParsedExpression {
    ParsedExpression operand;

    static ParsedExpression createXql(TokenBuffer tokens, ParsedQuery parsedQuery, int dotResultType, Values namespaceHash) throws WattExpressionException {
        ParsedExpression parse;
        ExpressionToken token = tokens.getCurrent();
        if (token == null) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_PATH_MISSING, "");
        }
        if (token.getType() == 307) {
            parse = tokens.next() == null ? new ParsedDot(5) : ParsedRelativeDescendantPath.createXql(tokens, parsedQuery, 5, namespaceHash);
            parse = new ParsedAbsoluteChildPath(parse);
        } else {
            parse = ParsedRelativeDescendantPath.createXql(tokens, parsedQuery, dotResultType, namespaceHash);
        }
        return parse;
    }

    ParsedAbsoluteChildPath(ParsedExpression operand) {
        this.operand = operand;
    }

    int getResultType() {
        return this.operand.getResultType();
    }

    boolean isRelative() {
        return false;
    }

    void addToResults(QueryContext cx, ReferenceNode refNode, ResultSet results) throws WattEvaluationException, WMDocumentException {
        ReferenceNode rootRefNode = cx.getRootReferenceNode();
        this.operand.addToResults(cx, rootRefNode, results);
        cx.putReferenceNode(rootRefNode);
    }

    boolean getBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException, WMDocumentException {
        ReferenceNode rootRefNode = cx.getRootReferenceNode();
        boolean result = this.operand.getBoolean(cx, rootRefNode);
        cx.putReferenceNode(rootRefNode);
        return result;
    }

    String toXmlString(int t) {
        StringBuffer sb = new StringBuffer();
        sb.append(ParsedAbsoluteChildPath.tab(t) + "<CHILD-OF-ROOT>\n");
        sb.append(this.operand.toXmlString(t + 1));
        sb.append(ParsedAbsoluteChildPath.tab(t) + "</CHILD-OF-ROOT>\n");
        return sb.toString();
    }

    String toXqlString() {
        return '/' + this.operand.toXqlString();
    }
}

