/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

class LineIterator {
    private BufferedReader reader;
    private boolean inCommentBlock;
    private boolean inNamespaceBlock = false;

    LineIterator(Reader reader) {
        this.reader = new BufferedReader(reader);
    }

    String getNextLine() throws IOException {
        String nextLine = null;
        boolean done = false;
        while (!done) {
            nextLine = this.reader.readLine();
            if (nextLine == null) {
                done = true;
                continue;
            }
            if (nextLine.startsWith("[begin-comment]")) {
                this.inCommentBlock = true;
                continue;
            }
            if (nextLine.startsWith("[end-comment]")) {
                this.inCommentBlock = false;
                continue;
            }
            if (nextLine.startsWith("[begin-namespace]")) {
                this.inNamespaceBlock = true;
                done = true;
                continue;
            }
            if (nextLine.startsWith("[end-namespace]")) {
                this.inNamespaceBlock = false;
                done = true;
                continue;
            }
            if (this.inCommentBlock) continue;
            done = true;
        }
        return nextLine;
    }

    public boolean isNamespaceDecl() {
        return this.inNamespaceBlock;
    }
}

