/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.xql.ResultSet;
import com.wm.lang.xql.SubscriptArgument;

class IndexRange
implements SubscriptArgument {
    int start;
    int end;

    IndexRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public int addToResults(int prevMaxIndex, ResultSet leftSet, ResultSet results) {
        int leftSetSize = leftSet.getSize();
        int actualStart = this.start >= 0 ? this.start : this.start + leftSetSize;
        int actualEnd = this.end >= 0 ? this.end : this.end + leftSetSize;
        if (actualStart < 0) {
            actualStart = 0;
        }
        if (actualStart <= prevMaxIndex) {
            actualStart = prevMaxIndex + 1;
        }
        if (actualEnd >= leftSetSize) {
            actualEnd = leftSetSize - 1;
        }
        if (actualStart <= actualEnd) {
            for (int index = actualStart; index <= actualEnd; ++index) {
                results.addValue(leftSet, index);
            }
            prevMaxIndex = actualEnd;
        }
        return prevMaxIndex;
    }

    public boolean getBoolean(ResultSet leftSet) {
        int leftSetSize = leftSet.getSize();
        int actualStart = this.start >= 0 ? this.start : this.start + leftSetSize;
        int actualEnd = this.end >= 0 ? this.end : this.end + leftSetSize;
        return actualStart <= actualEnd && actualStart < leftSetSize && actualEnd >= 0;
    }

    public int getFirstIndex() {
        return this.start;
    }

    public String toXmlString() {
        return "<range><start>" + this.start + "/<start><end>" + this.end + "</end></range>\n";
    }

    public String toXqlString() {
        return this.start + " $to$ " + this.end;
    }
}

