/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.CastIDataNodeToString;
import com.wm.lang.xql.IllegalCast;
import com.wm.lang.xql.ObjectModel;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.Relation;
import com.wm.lang.xql.RelationSpec;
import com.wm.lang.xql.ResultSet;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.List;
import com.wm.util.Name;
import java.util.HashMap;

public class IDataModel
implements ObjectModel {
    static final int INITIAL_PARENT_ESTIMATE = 20;
    private static final boolean DEBUG = false;
    IData tree;
    boolean needNodePositions = false;
    HashMap childPositionsHash = null;

    static ObjectModel getObjectModel(IData tree) {
        return new IDataModel(tree);
    }

    static void recurseAppendRawText(StringBuffer sb, IData data) {
        IDataCursor cursor = data.getCursor();
        while (cursor.next()) {
            int i;
            int length;
            Object value = cursor.getValue();
            if (value == null) continue;
            if (value instanceof IData) {
                IDataModel.recurseAppendRawText(sb, (IData)value);
                continue;
            }
            if (value instanceof IData[]) {
                IData[] dataArray = (IData[])value;
                length = dataArray.length;
                for (i = 0; i < length; ++i) {
                    IDataModel.recurseAppendRawText(sb, dataArray[i]);
                }
                continue;
            }
            if (value instanceof String[]) {
                String[] strArray = (String[])value;
                length = strArray.length;
                for (i = 0; i < length; ++i) {
                    sb.append(strArray[i]);
                }
                continue;
            }
            sb.append(value.toString());
        }
        cursor.destroy();
    }

    static boolean recurseAppendTextAsData(StringBuffer sb, IData data, boolean spaceNeeded) {
        IDataCursor cursor = data.getCursor();
        while (cursor.next()) {
            int i;
            int length;
            Object value = cursor.getValue();
            if (value == null) continue;
            if (value instanceof IData) {
                spaceNeeded = IDataModel.recurseAppendTextAsData(sb, (IData)value, spaceNeeded);
                continue;
            }
            if (value instanceof IData[]) {
                IData[] dataArray = (IData[])value;
                length = dataArray.length;
                for (i = 0; i < length; ++i) {
                    spaceNeeded = IDataModel.recurseAppendTextAsData(sb, dataArray[i], spaceNeeded);
                }
                continue;
            }
            if (value instanceof String[]) {
                String[] strArray = (String[])value;
                length = strArray.length;
                for (i = 0; i < length; ++i) {
                    sb.append(strArray[i]);
                }
                continue;
            }
            spaceNeeded = IDataModel.appendTrimmedText(sb, value.toString(), spaceNeeded);
        }
        cursor.destroy();
        return spaceNeeded;
    }

    static boolean appendTrimmedText(StringBuffer sb, String text, boolean spaceNeeded) {
        int start;
        int end = text.length() - 1;
        for (start = 0; start <= end && Character.isWhitespace(text.charAt(start)); ++start) {
        }
        if (start <= end) {
            while (Character.isWhitespace(text.charAt(end))) {
                --end;
            }
            if (start <= end) {
                if (spaceNeeded) {
                    sb.append(' ');
                }
                do {
                    sb.append(text.charAt(start++));
                } while (start <= end);
                return true;
            }
            return false;
        }
        return false;
    }

    private IDataModel(IData tree) {
        this.tree = tree;
    }

    public Relation getRelation(RelationSpec relationSpec) {
        Relation r = relationSpec.sourceRelation.getClone();
        if (relationSpec.leftType == 5) {
            r.setLCaster(new CastIDataNodeToString(relationSpec.leftCaster, this));
        } else if (relationSpec.leftType == 6) {
            r.setLCaster(new IllegalCast());
        } else {
            r.setLCaster(relationSpec.leftCaster);
        }
        if (relationSpec.rightType == 5) {
            r.setRCaster(new CastIDataNodeToString(relationSpec.rightCaster, this));
        } else if (relationSpec.rightType == 6) {
            r.setRCaster(new IllegalCast());
        } else {
            r.setRCaster(relationSpec.rightCaster);
        }
        return r;
    }

    public void needNodePositions() throws WattEvaluationException {
        if (!this.needNodePositions) {
            this.needNodePositions = true;
            this.childPositionsHash = new HashMap(20);
            this.assignChildPositions(new List(), this.tree, 0);
        }
    }

    public void addAttributes(Object node, ResultSet results) {
    }

    public void addAttributes(Object node, int iPrefixType, Name prefixOrUri, int iNameType, Name name, ResultSet results) {
    }

    public void addChildren(Object parent, ResultSet results) throws WMDocumentException {
        this.addElementChildren(parent, results);
    }

    public void addElementChildren(Object parent, ResultSet results) throws WMDocumentException {
        block10: {
            block9: {
                if (!(parent instanceof IData)) break block9;
                IDataCursor cursor = ((IData)parent).getCursor();
                if (this.needNodePositions) {
                    int[] childPositions = (int[])this.childPositionsHash.get(parent);
                    int i = 0;
                    while (cursor.next()) {
                        Object value = cursor.getValue();
                        if (value != null) {
                            results.addValue(value, childPositions != null ? childPositions[i] : 0);
                        }
                        ++i;
                    }
                } else {
                    while (cursor.next()) {
                        Object value = cursor.getValue();
                        if (value == null) continue;
                        results.addValue(value, 0);
                    }
                }
                cursor.destroy();
                break block10;
            }
            if (!(parent instanceof IData[])) break block10;
            IData[] dataArray = (IData[])parent;
            int length = dataArray.length;
            if (this.needNodePositions) {
                int[] childPositions = (int[])this.childPositionsHash.get(parent);
                for (int i = 0; i < length; ++i) {
                    IData value = dataArray[i];
                    if (value == null) continue;
                    results.addValue(value, childPositions != null ? childPositions[i] : 0);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    IData value = dataArray[i];
                    if (value == null) continue;
                    results.addValue(value, 0);
                }
            }
        }
    }

    public void addElementChildren(Object parent, int iPrefixType, Name prefixOrUri, int iNameType, Name name, ResultSet results) throws WMDocumentException {
        if (iPrefixType == 1 || iPrefixType == 2) {
            if (iNameType == 6) {
                this.addElementChildren(parent, results);
            } else if (parent instanceof IData) {
                IDataCursor cursor = ((IData)parent).getCursor();
                if (this.needNodePositions) {
                    int[] childPositions = (int[])this.childPositionsHash.get(parent);
                    int i = 0;
                    while (cursor.next()) {
                        String key = cursor.getKey();
                        if (key == null || !key.equals(name.toString())) continue;
                        Object value = cursor.getValue();
                        if (value != null) {
                            results.addValue(value, childPositions != null ? childPositions[i] : 0);
                        }
                        ++i;
                    }
                } else {
                    while (cursor.next()) {
                        Object value;
                        String key = cursor.getKey();
                        if (key == null || !key.equals(name.toString()) || (value = cursor.getValue()) == null) continue;
                        results.addValue(value, 0);
                    }
                }
                cursor.destroy();
            }
        }
    }

    public void addTextChildren(Object parent, ResultSet results) throws WMDocumentException {
        if (parent instanceof IData) {
            if (results == null) {
                throw new RuntimeException("IDataModel.addTextChildren got IData and results is null");
            }
            IDataCursor cursor = ((IData)parent).getCursor();
            if (this.needNodePositions) {
                if (this.childPositionsHash == null) {
                    throw new RuntimeException("IDataModel.addTextChildren needNodePositions and childPositionsHash is null");
                }
                int[] childPositions = (int[])this.childPositionsHash.get(parent);
                if (childPositions != null) {
                    int i = 0;
                    while (cursor.next()) {
                        Object value = cursor.getValue();
                        if (value != null && value instanceof String) {
                            results.addValue(value, childPositions[i]);
                        }
                        ++i;
                    }
                }
            } else {
                while (cursor.next()) {
                    Object value = cursor.getValue();
                    if (value == null || !(value instanceof String)) continue;
                    results.addValue(value, 0);
                }
            }
            cursor.destroy();
        }
    }

    public void addCommentChildren(Object parent, ResultSet results) throws WMDocumentException {
    }

    public void addPIChildren(Object parent, ResultSet results) throws WMDocumentException {
    }

    public void addRegionNode(Object containingNode, Object startNode, boolean includeStart, Object endNode, boolean includeEnd, ResultSet results) throws WMDocumentException {
        throw new WMDocumentException(XqlExceptionBundle.class, XqlExceptionBundle.IDATA_REGION_UNSUPPORTED, "");
    }

    public String getAttributeName(Object attribute) {
        return null;
    }

    public String getAttributeNamePrefix(Object attribute) {
        return null;
    }

    public String getAttributeNamespaceUri(Object attribute) {
        return null;
    }

    public String getAttributeNameBase(Object attribute) {
        return null;
    }

    public String getAttributeRawText(Object attribute) {
        return null;
    }

    public String getAttributeText(Object attribute) {
        return null;
    }

    public Object getAttributeValue(Object attribute) {
        return null;
    }

    public String getNodeName(Object node) {
        return null;
    }

    public String getNodeNamePrefix(Object node) {
        return null;
    }

    public String getNodeNameBase(Object node) {
        return null;
    }

    public String getNodeNamespaceUri(Object node) {
        return null;
    }

    public String getNodeRawText(Object node) throws WMDocumentException {
        if (node instanceof IData) {
            StringBuffer sb = new StringBuffer();
            IDataModel.recurseAppendRawText(sb, (IData)node);
            return sb.toString();
        }
        if (node instanceof IData[]) {
            StringBuffer sb = new StringBuffer();
            for (IData data : (IData[])node) {
                if (data == null) continue;
                IDataModel.recurseAppendRawText(sb, data);
            }
            return sb.toString();
        }
        if (node instanceof String[]) {
            StringBuffer sb = new StringBuffer();
            String[] strArray = (String[])node;
            int length = strArray.length;
            for (int i = 0; i < length; ++i) {
                sb.append(strArray[i]);
            }
            return sb.toString();
        }
        return node.toString();
    }

    public String getCommentText(Object node) throws WMDocumentException {
        return null;
    }

    public String getNodeSource(Object node) throws WMDocumentException {
        throw new WMDocumentException(XqlExceptionBundle.class, XqlExceptionBundle.IDATA_SOURCE_UNAVAILABLE, "");
    }

    public String getNodeText(Object node) throws WMDocumentException {
        if (node instanceof IData) {
            StringBuffer sb = new StringBuffer();
            IDataModel.recurseAppendTextAsData(sb, (IData)node, false);
            return sb.toString();
        }
        if (node instanceof IData[]) {
            StringBuffer sb = new StringBuffer();
            IData[] dataArray = (IData[])node;
            int length = dataArray.length;
            boolean spaceNeeded = false;
            for (int i = 0; i < length; ++i) {
                IData data = dataArray[i];
                if (data == null) continue;
                spaceNeeded = IDataModel.recurseAppendTextAsData(sb, data, spaceNeeded);
            }
            return sb.toString();
        }
        if (node instanceof String[]) {
            StringBuffer sb = new StringBuffer();
            String[] strArray = (String[])node;
            int length = strArray.length;
            for (int i = 0; i < length; ++i) {
                sb.append(strArray[i]);
            }
            return sb.toString();
        }
        return node.toString();
    }

    public Integer getNodeTypeInteger(Object node) {
        if (node instanceof IData) {
            return TYPE_INT_IDATA;
        }
        if (node instanceof IData[]) {
            return TYPE_INT_IDATA_ARRAY;
        }
        return TYPE_INT_UNKNOWN;
    }

    public String getNodeTypeString(Object node) {
        if (node instanceof IData) {
            return "IData";
        }
        if (node instanceof IData[]) {
            return "IData[]";
        }
        return "unknown";
    }

    public Object getNodeValue(Object node) throws WMDocumentException {
        return this.getNodeText(node);
    }

    public boolean hasAttributes(Object node) {
        return false;
    }

    public boolean hasAttributes(Object node, int iPrefixType, Name prefixOrUri, int iNameType, Name name) throws WMDocumentException {
        return false;
    }

    public boolean hasCommentChildren(Object parent) throws WMDocumentException {
        return false;
    }

    public boolean hasPIChildren(Object parent) throws WMDocumentException {
        return false;
    }

    public boolean hasChildren(Object node) throws WMDocumentException {
        return this.hasElementChildren(node);
    }

    public boolean hasElementChildren(Object parent) throws WMDocumentException {
        if (parent instanceof IData) {
            IDataCursor cursor = ((IData)parent).getCursor();
            boolean hasChildren = cursor.next();
            while (cursor.next()) {
                if (cursor.getValue() == null) continue;
                cursor.destroy();
                return true;
            }
            cursor.destroy();
        } else if (parent instanceof IData[]) {
            IData[] dataArray = (IData[])parent;
            int length = dataArray.length;
            for (int i = 0; i < length; ++i) {
                if (dataArray[i] == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasElementChildren(Object parent, int iPrefixType, Name prefixOrUri, int iNameType, Name name) throws WMDocumentException {
        if (iPrefixType == 1 || iPrefixType == 2) {
            if (iNameType == 6) {
                return this.hasElementChildren(parent);
            }
            if (parent instanceof IData) {
                IDataCursor cursor = ((IData)parent).getCursor();
                while (cursor.next()) {
                    if (!cursor.getKey().equals(name.toString()) || cursor.getValue() == null) continue;
                    cursor.destroy();
                    return true;
                }
                cursor.destroy();
            }
        }
        return false;
    }

    public boolean hasTextChildren(Object parent) throws WMDocumentException {
        if (parent instanceof IData) {
            IDataCursor cursor = ((IData)parent).getCursor();
            while (cursor.next()) {
                Object value = cursor.getValue();
                if (value == null || !(value instanceof String)) continue;
                cursor.destroy();
                return true;
            }
            cursor.destroy();
        }
        return false;
    }

    public boolean containsRegion(Object containingNode, Object startNode, boolean includeStart, Object endNode, boolean includeEnd) throws WMDocumentException {
        throw new WMDocumentException(XqlExceptionBundle.class, XqlExceptionBundle.IDATA_REGION_UNSUPPORTED, "");
    }

    public boolean isHtml(Object node) throws WMDocumentException {
        return false;
    }

    public Node getNodeById(QueryContext cx, String value) throws WattEvaluationException, WMDocumentException {
        return null;
    }

    int assignChildPositions(List ancestors, IData parent, int nextPosition) throws WattEvaluationException {
        ancestors.addElement(parent);
        IDataCursor cursor = parent.getCursor();
        int childCount = IDataUtil.size(cursor);
        if (childCount > 0) {
            int[] childPositions = new int[childCount];
            int childIndex = 0;
            while (cursor.next()) {
                childPositions[childIndex++] = nextPosition++;
                Object child = cursor.getValue();
                if (child == null) continue;
                if (ancestors.contains(child)) {
                    this.failDueToRecursion(ancestors, child);
                }
                if (child instanceof IData) {
                    nextPosition = this.assignChildPositions(ancestors, (IData)child, nextPosition);
                    continue;
                }
                if (!(child instanceof IData[])) continue;
                nextPosition = this.assignChildPositions(ancestors, (IData[])child, nextPosition);
            }
            this.childPositionsHash.put(parent, childPositions);
        }
        cursor.destroy();
        ancestors.removeLastElement();
        return nextPosition;
    }

    int assignChildPositions(List ancestors, IData[] parent, int nextPosition) throws WattEvaluationException {
        ancestors.addElement(parent);
        int childCount = parent.length;
        if (childCount > 0) {
            int[] childPositions = new int[childCount];
            int childIndex = 0;
            do {
                IData child = parent[childIndex];
                childPositions[childIndex++] = nextPosition++;
                if (child == null) continue;
                if (ancestors.contains(child)) {
                    this.failDueToRecursion(ancestors, child);
                }
                nextPosition = this.assignChildPositions(ancestors, child, nextPosition);
            } while (childIndex < childCount);
            this.childPositionsHash.put(parent, childPositions);
        }
        ancestors.removeLastElement();
        return nextPosition;
    }

    void failDueToRecursion(List ancestors, Object recursiveMember) throws WattEvaluationException {
        ancestors.addElement(recursiveMember);
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.IDATA_HAS_RECURSION, "", IDataModel.buildQueryFromList(ancestors));
    }

    public static String buildQueryFromList(List ancestors) {
        return IDataModel.buildQueryFromList(ancestors, true);
    }

    public static String buildQueryFromList(List ancestors, boolean order) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ancestors.size() - 1; ++i) {
            Object child;
            Object parent;
            if (order) {
                parent = ancestors.elementAt(i);
                child = ancestors.elementAt(i + 1);
            } else {
                parent = ancestors.elementAt(i + 1);
                child = ancestors.elementAt(i);
            }
            if (parent instanceof IData[]) {
                IData[] dataArray = (IData[])parent;
                int j = 0;
                while (dataArray[j] != child) {
                    ++j;
                }
                sb.append("/*[" + j + "]");
                continue;
            }
            IDataCursor cursor = ((IData)parent).getCursor();
            while (cursor.next() && cursor.getValue() != child) {
            }
            int sibling = -1;
            String childName = cursor.getKey();
            cursor.first();
            do {
                String tmp;
                if (childName != (tmp = cursor.getKey()) && !childName.equals(tmp)) continue;
                ++sibling;
            } while (cursor.next() && cursor.getValue() != child);
            sb.append("/" + childName + "[" + sibling + "]");
            cursor.destroy();
        }
        return sb.toString();
    }
}

