/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.List;
import com.wm.util.Name;
import com.wm.util.Values;
import java.util.Enumeration;

public class GenerateXQLQueryString {
    private static final boolean DEBUG = false;
    String query;

    public GenerateXQLQueryString(Object doc, int nodeId, String attribute, boolean textQuery, Values nsDecls) throws WMDocumentException {
        this.setupXQLQueryString(doc, nodeId, attribute, textQuery, nsDecls);
    }

    private void setupXQLQueryString(IData doc, Object node, boolean textQuery) throws WMDocumentException {
        if (doc == null) {
            new WMDocumentException(XqlExceptionBundle.class, XqlExceptionBundle.NODE_PARA_NULL, "");
        }
        if (node == null) {
            new WMDocumentException(XqlExceptionBundle.class, XqlExceptionBundle.NODE_PARA_NULL, "");
        }
        IData ancestors = GenerateXQLQueryString.getIDataPath(doc, node);
        this.query = GenerateXQLQueryString.buildQueryFromList(ancestors);
        if (textQuery) {
            this.query = this.query + "/text()";
        }
    }

    public GenerateXQLQueryString(Object doc, Object nodeId, String attribute, boolean textQuery, Values nsDecls) throws WMDocumentException {
        if (attribute != null) {
            new WMDocumentException(XqlExceptionBundle.class, XqlExceptionBundle.NODE_PARA_NULL, "");
        }
        if (nsDecls != null) {
            new WMDocumentException(XqlExceptionBundle.class, XqlExceptionBundle.NODE_PARA_NULL, "");
        }
        if (!(doc instanceof IData)) {
            throw new WMDocumentException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_NODE_TREE, "", nodeId.toString());
        }
        this.setupXQLQueryString((IData)doc, nodeId, textQuery);
    }

    private void setupXQLQueryString(Object doc, int nodeId, String attribute, boolean textQuery, Values nsDecls) throws WMDocumentException {
        if (doc == null) {
            new WMDocumentException(XqlExceptionBundle.class, XqlExceptionBundle.NODE_PARA_NULL, "");
        }
        List path = new List();
        if (doc instanceof Node) {
            Node node = (Node)doc;
            this.query = GenerateXQLQueryString.getNodePath(node, nodeId, path) != null ? this.getAbsoluteObjectRef(node, path, attribute, textQuery, nsDecls) : null;
        } else {
            Object[] oArray = new Object[]{doc.getClass().getName()};
            throw new WMDocumentException(XqlExceptionBundle.class, XqlExceptionBundle.OBJ_TYPE_UNSUPPORTED, "", oArray);
        }
    }

    public String getQuery() {
        return this.query;
    }

    public static Node getNodePath(Node node, int nodeId, List path) throws WMDocumentException {
        Node result = GenerateXQLQueryString.quicklyGetNodePath(node, nodeId, path);
        if (result == null) {
            path.reset();
            result = GenerateXQLQueryString.slowlyGetNodePath(node, nodeId, path);
        }
        return result;
    }

    private static Node quicklyGetNodePath(Node node, int nodeId, List path) throws WMDocumentException {
        if (node == null) {
            return null;
        }
        if (node.getPosition() == nodeId) {
            return node;
        }
        Node child = node.getFirstChildWm();
        if (child == null) {
            return null;
        }
        Node lookAhead = node.getNextSiblingOfChild(child);
        while (lookAhead != null && nodeId >= lookAhead.getPosition()) {
            child = lookAhead;
            lookAhead = node.getNextSiblingOfChild(lookAhead);
        }
        Node theNode = GenerateXQLQueryString.getNodePath(child, nodeId, path);
        if (theNode != null) {
            path.addElement(child);
            return theNode;
        }
        return null;
    }

    private static Node slowlyGetNodePath(Node node, int nodeId, List path) throws WMDocumentException {
        if (node == null) {
            return null;
        }
        if (node.getPosition() == nodeId) {
            return node;
        }
        Node child = node.getFirstChildWm();
        while (child != null) {
            Node theNode = GenerateXQLQueryString.slowlyGetNodePath(child, nodeId, path);
            if (theNode != null) {
                path.addElement(child);
                return theNode;
            }
            child = node.getNextSiblingOfChild(child);
        }
        return null;
    }

    private String getAbsoluteObjectRef(Node doc, List v, String attribute, boolean textQuery, Values nsDecls) throws WMDocumentException {
        int iSize;
        if (v == null) {
            return null;
        }
        Node o = null;
        StringBuffer name = new StringBuffer();
        for (int i = iSize = v.size(); i > 0; --i) {
            o = (Node)v.elementAt(i - 1);
            if (o.getLocalNameWm() == null) continue;
            String tmpName = GenerateXQLQueryString.makePrefix(o, nsDecls);
            if (tmpName.length() > 0) {
                tmpName = tmpName.concat(":");
            }
            name.append(tmpName + o.getLocalNameWm() + "[" + this.getIndex(doc, o) + "]/");
        }
        String query = v.size() == 0 ? "/" : (o.isXML() ? "/" + name.toString() : "/" + name.toString().toLowerCase());
        query = attribute != null ? (textQuery ? query + "@" + attribute + "/text()" : query + "@" + attribute) : (textQuery ? query + "text()" : query.substring(0, query.length() - 1));
        return query;
    }

    private static String makePrefix(Node o, Values nsDecls) {
        Name prefix = null;
        if (nsDecls != null && o.getNamespaceUri() != null) {
            String uri = o.getNamespaceUri().toString();
            Enumeration e = nsDecls.keys();
            while (e.hasMoreElements()) {
                String newPrefix = (String)e.nextElement();
                String newUri = nsDecls.get(newPrefix).toString();
                if (!newUri.equals(uri)) continue;
                return newPrefix;
            }
        }
        if ((prefix = o.getNamespacePrefix()) != null) {
            return prefix.toString();
        }
        return "";
    }

    private String getAbsoluteObjectRef(Node doc, Node node, String attribute, boolean textQuery, Values nsDecls) throws WMDocumentException {
        List path = new List();
        if (GenerateXQLQueryString.getNodePath(doc, node.getPosition(), path) != null) {
            return this.getAbsoluteObjectRef(doc, path, attribute, textQuery, nsDecls);
        }
        return null;
    }

    private int getIndex(Node doc, Node node) throws WMDocumentException {
        int iCtr = 0;
        Node parent = null;
        List path = new List();
        GenerateXQLQueryString.getNodePath(doc, node.getPosition(), path);
        parent = path.size() > 1 ? (Node)path.elementAt(1) : doc;
        if (parent == null) {
            return iCtr;
        }
        Node sibling = parent.getFirstChildWm();
        while (sibling != node && sibling != null) {
            if (sibling.getNodeType() == 1 && node.getLocalNameWm().equals(sibling.getLocalNameWm()) && (node.getNamespaceUri() == null && sibling.getNamespaceUri() == null || node.getNamespaceUri() != null && sibling.getNamespaceUri() != null && node.getNamespaceUri().equals(sibling.getNamespaceUri()))) {
                ++iCtr;
            }
            sibling = parent.getNextSiblingOfChild(sibling);
        }
        return iCtr;
    }

    private static IData getIDataPath(IData doc, Object node) {
        IData ancestors = IDataFactory.create();
        if (doc == null) {
            return ancestors;
        }
        GenerateXQLQueryString.slowlyGetIDataPath(doc, node, ancestors);
        return ancestors;
    }

    private static Object slowlyGetIDataPath(Object tree, Object nodeId, IData path) {
        if (tree == null) {
            return null;
        }
        if (tree == nodeId) {
            return tree;
        }
        if (!(tree instanceof IData)) {
            return null;
        }
        IData node = (IData)tree;
        IDataCursor child = node.getCursor();
        while (child.next()) {
            Object value = child.getValue();
            Object theNode = null;
            if (value instanceof IData[]) {
                IData[] ida = (IData[])value;
                for (int i = 0; i < ida.length; ++i) {
                    theNode = GenerateXQLQueryString.slowlyGetIDataPath(ida[i], nodeId, path);
                    if (theNode == null) continue;
                    IDataCursor id = path.getCursor();
                    id.last();
                    id.insertAfter(child.getKey(), value);
                    id.destroy();
                    child.destroy();
                    return theNode;
                }
                continue;
            }
            theNode = GenerateXQLQueryString.slowlyGetIDataPath(value, nodeId, path);
            if (theNode == null) continue;
            IDataCursor id = path.getCursor();
            id.last();
            id.insertAfter(child.getKey(), value);
            id.destroy();
            child.destroy();
            return theNode;
        }
        child.destroy();
        return null;
    }

    public static String buildQueryFromList(IData ancestors) {
        String query = "";
        IDataCursor id = ancestors.getCursor();
        Object parent = null;
        if (id.last()) {
            do {
                String childName = id.getKey();
                Object childValue = id.getValue();
                if (parent instanceof IData[]) {
                    IData[] dataArray = (IData[])parent;
                    for (int j = 0; j < dataArray.length && dataArray[j] != childValue; ++j) {
                    }
                    query = query + "//";
                } else if (parent instanceof IData) {
                    IDataCursor cursor = ((IData)parent).getCursor();
                    int k = 0;
                    while (cursor.next() && cursor.getValue() != childValue) {
                        ++k;
                    }
                    int sibling = -1;
                    String sName = childName;
                    if (cursor.first()) {
                        do {
                            String tmpKey;
                            if (!sName.equals(tmpKey = cursor.getKey())) continue;
                            ++sibling;
                        } while (cursor.getValue() != childValue && cursor.next());
                    }
                    query = query + "/" + childName + "[" + sibling + "]";
                    cursor.destroy();
                } else {
                    query = query + "/" + childName + "[0]";
                }
                parent = childValue;
            } while (id.previous());
        }
        id.destroy();
        return query;
    }
}

