/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.widl.WattException;
import com.wm.lang.xql.TreeExpression;
import com.wm.lang.xql.VariableUtils;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.Values;

public class ConstantExpression
extends TreeExpression {
    String expression;
    Object object;

    private ConstantExpression(Object value) throws WattException {
        this.object = value;
    }

    public ConstantExpression(String expression) throws WattException {
        if (expression == null) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_EMPTY_EXPRESSION, "");
        }
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public TreeExpression getSubstitution(Values variables) throws WattException {
        String expansion = VariableUtils.substitute(this.expression, variables);
        if (expansion == this.expression) {
            return this;
        }
        if (expansion == null && variables != null) {
            expansion = this.expression.trim();
            int length = expansion.length();
            if (length < 3 || expansion.charAt(0) != '%' || expansion.charAt(length - 1) != '%') {
                return this;
            }
            Object obj = variables.get(expansion.substring(1, length - 1));
            if (obj == null) {
                return this;
            }
            ConstantExpression expr = new ConstantExpression(obj);
            return expr;
        }
        return new ConstantExpression(expansion);
    }

    public String getString(Object tree) throws WattException {
        if (this.object != null) {
            throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
        }
        return this.expression;
    }

    public String[] getStringArray(Object tree) throws WattException {
        if (this.object != null && !(this.object instanceof String[])) {
            throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
        }
        return (String[])this.object;
    }

    public String[][] getStringTable(Object tree) throws WattException {
        if (this.object != null && !(this.object instanceof String[][])) {
            throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
        }
        return (String[][])this.object;
    }

    public Values getValues(Object tree) throws WattException {
        if (this.object != null && !(this.object instanceof Values)) {
            throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
        }
        return (Values)this.object;
    }

    public Values[] getValuesArray(Object tree) throws WattException {
        if (this.object != null && !(this.object instanceof Values[])) {
            throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
        }
        return (Values[])this.object;
    }

    public Values[][] getValuesTable(Object tree) throws WattException {
        if (this.object != null && !(this.object instanceof Values[][])) {
            throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
        }
        return (Values[][])this.object;
    }
}

