/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml.token;

import com.wm.lang.xml.token.WmDocReaderHtmlScanner;
import com.wm.lang.xml.token.WmDocReaderXmlScanner;
import com.wm.util.EncodingNames;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;

public class WmDocReader
extends Reader {
    public static final int DOCTYPE_UNKNOWN = 0;
    public static final int DOCTYPE_HTML = 1;
    public static final int DOCTYPE_XML = 2;
    private static final String JAVA_UTF8 = "UTF8";
    private static final String JAVA_8859_1 = "8859_1";
    private static final String JAVA_8859_2 = "ISO8859_2";
    private static final String JAVA_8859_3 = "ISO8859_3";
    private static final String JAVA_8859_4 = "ISO8859_4";
    private static final String JAVA_8859_5 = "ISO8859_5";
    private static final String JAVA_8859_6 = "ISO8859_6";
    private static final String JAVA_8859_7 = "ISO8859_7";
    private static final String JAVA_8859_8 = "ISO8859_8";
    private static final String JAVA_8859_9 = "ISO8859_9";
    private static final String JAVA_8859_15 = "ISO8859_15_FDIS";
    private static final String JAVA_2022_JP = "ISO2022JP";
    private static final String JAVA_SHIFT_JIS = "SJIS";
    private static final String JAVA_EUC_JP = "EUC_JP";
    private static final String JAVA_UCS = "Unicode";
    private static final String JAVA_UCS_BIG = "UnicodeBig";
    private static final String JAVA_UCS_LITTLE = "UnicodeLittle";
    private static final String JAVA_EBCDIC = "Cp037";
    private static final String JAVA_BIG5 = "Big5";
    private static final String JAVA_GB2312 = "GB2312";
    private boolean _debug = false;
    private int _pushbackSize = 8192;
    private PushbackInputStream _baseInputStream;
    private String _baseStreamUrl;
    private Reader _theReader;
    private boolean _ourReader = false;
    private String _encoding;
    private boolean _allowTranscoding = false;
    private int _docType = 0;
    private WmDocReaderXmlScanner _xmlScanner = null;
    private WmDocReaderHtmlScanner _htmlScanner = null;

    public static WmDocReader create(InputStream is, String url) throws IOException {
        return new WmDocReader(is, url, null, 0, false);
    }

    public static WmDocReader create(InputStream is, String url, boolean isXml) throws IOException {
        return new WmDocReader(is, url, null, 0, isXml);
    }

    public static WmDocReader create(InputStream is, String url, String encoding) throws IOException {
        return new WmDocReader(is, url, encoding, 0, false);
    }

    public static WmDocReader create(InputStream is, String url, String encoding, boolean isXml) throws IOException {
        return new WmDocReader(is, url, encoding, 0, isXml);
    }

    public static WmDocReader create(InputStream is, String url, String encoding, int bufferSize) throws IOException {
        return new WmDocReader(is, url, encoding, bufferSize, false);
    }

    private WmDocReader(InputStream is, String url, String encoding, int bufferSize, boolean isXml) throws IOException {
        if (bufferSize >= 16) {
            this._pushbackSize = bufferSize;
        }
        this._baseInputStream = new PushbackInputStream(is, this._pushbackSize);
        this._baseStreamUrl = url;
        if (encoding != null) {
            this._encoding = encoding;
            if (this._encoding.equalsIgnoreCase("utf-8") || this._encoding.equalsIgnoreCase(JAVA_UTF8)) {
                this.removeUTF8BOM();
            }
        } else {
            this.detectEncoding(isXml);
            if (this._debug) {
                System.out.print("WmDocReader: detected: encoding=" + this._encoding + " docType=");
                switch (this._docType) {
                    case 1: {
                        System.out.println("HTML");
                        break;
                    }
                    case 2: {
                        System.out.println("XML");
                        break;
                    }
                    default: {
                        System.out.println("UNKNOWN");
                    }
                }
            }
        }
        this._theReader = this.createReader(this._baseInputStream, this._encoding);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this._allowTranscoding) {
            return this.readWithScan(cbuf, off, len);
        }
        return this._theReader.read(cbuf, off, len);
    }

    public void close() throws IOException {
        this._theReader.close();
    }

    public void setDocType(int type) {
        switch (type) {
            case 1: 
            case 2: {
                this._docType = type;
                break;
            }
            default: {
                this._docType = 0;
            }
        }
        this.allowTranscoding(this._allowTranscoding);
    }

    public void allowTranscoding(boolean b) {
        if (!this._ourReader) {
            return;
        }
        this._allowTranscoding = b;
        if (b) {
            if ((this._docType == 0 || this._docType == 2) && this._xmlScanner == null) {
                this._xmlScanner = new WmDocReaderXmlScanner();
            }
            if ((this._docType == 0 || this._docType == 1) && this._htmlScanner == null) {
                this._htmlScanner = new WmDocReaderHtmlScanner();
            }
        }
    }

    public String getBaseStreamUrl() {
        return this._baseStreamUrl;
    }

    public String getEncoding() {
        if (this._theReader instanceof WmDocReader) {
            return ((WmDocReader)this._theReader)._encoding;
        }
        return this._encoding;
    }

    private int readWithScan(char[] cbuf, int off, int len) throws IOException {
        int count = 0;
        int ixOff = off;
        while (count < len) {
            if (this._allowTranscoding) {
                int iChar = this._theReader.read();
                if (iChar == -1) {
                    if (count != 0) break;
                    count = -1;
                    break;
                }
                char c = (char)iChar;
                cbuf[ixOff++] = c;
                ++count;
                this.scanForEncoding(c);
                continue;
            }
            int i = this._theReader.read(cbuf, count, len - count);
            if (i == -1) break;
            count += i;
        }
        return count;
    }

    private void removeUTF8BOM() {
        int i = 0;
        byte[] possibleBOMData = new byte[3];
        try {
            while (true) {
                if ((i = this._baseInputStream.read(possibleBOMData)) > 0) {
                    this._baseInputStream.unread(possibleBOMData, 0, i);
                }
                if (i != 3) {
                    return;
                }
                char c1 = (char)(possibleBOMData[0] & 0xFF);
                char c2 = (char)(possibleBOMData[1] & 0xFF);
                char c3 = (char)(possibleBOMData[2] & 0xFF);
                if (c1 == '\u00ef' && c2 == '\u00bb' && c3 == '\u00bf') {
                    this._baseInputStream.skip(3L);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void detectEncoding(boolean isXml) {
        byte[] first6 = new byte[6];
        if (isXml) {
            this._docType = 2;
            this._encoding = JAVA_UTF8;
        } else {
            this._encoding = JAVA_8859_1;
            this._docType = 0;
        }
        try {
            this.removeUTF8BOM();
            int i = this._baseInputStream.read(first6);
            if (i <= 0) {
                return;
            }
            this._baseInputStream.unread(first6, 0, i);
            if (i < 6) {
                return;
            }
            char c1 = (char)(first6[0] & 0xFF);
            char c2 = (char)(first6[1] & 0xFF);
            char c3 = (char)(first6[2] & 0xFF);
            char c4 = (char)(first6[3] & 0xFF);
            char c5 = (char)(first6[4] & 0xFF);
            char c6 = (char)(first6[5] & 0xFF);
            if (c1 == '<' && c2 == '?' && Character.toLowerCase(c3) == 'x' && Character.toLowerCase(c4) == 'm') {
                this._docType = 2;
                this._encoding = JAVA_UTF8;
            } else if (c1 == '<' && Character.toLowerCase(c2) == 'h' && Character.toLowerCase(c3) == 't' && Character.toLowerCase(c4) == 'm') {
                this._docType = 1;
                this._encoding = JAVA_8859_1;
            } else if (c1 == '\u0000' && c2 == '<') {
                this._encoding = JAVA_UCS_BIG;
                if (c4 == '?') {
                    this._docType = 2;
                } else if (c4 == 'H' || c4 == 'h') {
                    this._docType = 1;
                }
            } else if (c1 == '<' && c2 == '\u0000') {
                this._encoding = JAVA_UCS_LITTLE;
                if (c3 == '?') {
                    this._docType = 2;
                } else if (c3 == 'H' || c3 == 'h') {
                    this._docType = 1;
                }
            } else if (c1 == 'L') {
                this._encoding = JAVA_EBCDIC;
                if (c2 == 'o') {
                    this._docType = 2;
                } else if (c2 == '\u00c8' || c2 == '\u0088') {
                    this._docType = 1;
                }
            } else if (c1 == '\u00fe' && c2 == '\u00ff') {
                this._encoding = JAVA_UCS;
                if (c4 == '<' && c6 == '?') {
                    this._docType = 2;
                } else if (c4 == '<' && (c6 == 'H' || c6 == 'h')) {
                    this._docType = 1;
                }
            } else if (c1 == '\u00ff' && c2 == '\u00fe') {
                this._encoding = JAVA_UCS;
                if (c3 == '<' && c5 == '?') {
                    this._docType = 2;
                } else if (c3 == '<' && (c5 == 'H' || c5 == 'h')) {
                    this._docType = 1;
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void scanForEncoding(char c) {
        block10: {
            String encoding = null;
            if (this._xmlScanner != null) {
                encoding = this._xmlScanner.process(c);
            }
            if (encoding == null && this._htmlScanner != null) {
                encoding = this._htmlScanner.process(c);
            }
            if (encoding == null) {
                return;
            }
            if (encoding.equals("")) {
                this.allowTranscoding(false);
                return;
            }
            if (this._debug) {
                System.out.println("<<<WmDocReader: transcoding: " + encoding + ">>>");
            }
            this.allowTranscoding(false);
            this._xmlScanner = null;
            this._htmlScanner = null;
            try {
                Reader newReader;
                this._theReader.close();
                int availableBytes = this._baseInputStream.available();
                if (availableBytes < this._pushbackSize) {
                    this._pushbackSize = availableBytes;
                }
                this._theReader = newReader = this.createReader(this._baseInputStream, encoding);
                this._encoding = encoding;
            }
            catch (IOException e) {
                if (this._debug) {
                    System.out.println("<<<WmDocReader: new encoding exception: " + e + ">>>");
                }
            }
            catch (IllegalArgumentException e) {
                if (!this._debug) break block10;
                System.out.println("<<<WmDocReader: new encoding exception: " + e + ">>>");
            }
        }
    }

    private Reader createReader(PushbackInputStream is, String enc) throws UnsupportedEncodingException {
        if ((enc = EncodingNames.getJavaName(enc)).equals(JAVA_UTF8)) {
            this._ourReader = true;
            return new WmDocReaderUtf8(is);
        }
        if (enc.equals(JAVA_8859_1)) {
            this._ourReader = true;
            return new WmDocReader8859_1(is);
        }
        if (enc.equals("ASCII")) {
            this._ourReader = true;
            return new WmDocReaderASCII(is);
        }
        this._ourReader = false;
        this._allowTranscoding = false;
        return new InputStreamReader((InputStream)is, enc);
    }

    class WmDocReaderUnicode
    extends WmDocReaderBase {
        boolean _firstTime;
        boolean _littleEndian;
        byte[] _bData;

        public WmDocReaderUnicode(PushbackInputStream is) {
            super(is);
            this._firstTime = true;
            this._littleEndian = false;
            this._bData = new byte[2];
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int i;
            int ix = 0;
            while (ix < len && (i = this.readBuf(this._bData, 0, 2)) >= 2) {
                if (this._firstTime) {
                    this._firstTime = false;
                    if ((this._bData[0] & 0xFF) == 254 && (this._bData[1] & 0xFF) == 255) continue;
                    if ((this._bData[0] & 0xFF) == 255 && (this._bData[1] & 0xFF) == 254) {
                        this._littleEndian = true;
                        continue;
                    }
                }
                if (!this._littleEndian) {
                    i = (this._bData[0] & 0xFF) << 8 | this._bData[1] & 0xFF;
                    cbuf[off++] = (char)i;
                } else {
                    i = (this._bData[1] & 0xFF) << 8 | this._bData[0] & 0xFF;
                    cbuf[off++] = (char)i;
                }
                ++ix;
            }
            if (ix == 0) {
                return -1;
            }
            return ix;
        }

        public void close() throws IOException {
            this.closeBuf();
        }
    }

    class WmDocReaderASCII
    extends WmDocReaderBase {
        public WmDocReaderASCII(PushbackInputStream is) {
            super(is);
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int iChar;
            int ix;
            for (ix = 0; ix < len && (iChar = this.readBuf()) != -1; ++ix) {
                cbuf[off++] = (char)iChar;
            }
            if (ix == 0) {
                return -1;
            }
            return ix;
        }

        public void close() throws IOException {
            this.closeBuf();
        }
    }

    class WmDocReader8859_1
    extends WmDocReaderBase {
        public WmDocReader8859_1(PushbackInputStream is) {
            super(is);
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int iChar;
            int ix;
            for (ix = 0; ix < len && (iChar = this.readBuf()) != -1; ++ix) {
                cbuf[off++] = (char)iChar;
            }
            if (ix == 0) {
                return -1;
            }
            return ix;
        }

        public void close() throws IOException {
            this.closeBuf();
        }
    }

    class WmDocReaderUtf8
    extends WmDocReaderBase {
        public WmDocReaderUtf8(PushbackInputStream is) {
            super(is);
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int b1;
            int ix;
            for (ix = 0; ix < len && (b1 = this.readBuf()) != -1; ++ix) {
                int b2;
                int iChar;
                if ((b1 & 0x80) == 0) {
                    iChar = b1;
                } else if ((b1 & 0xE0) == 192) {
                    b2 = this.readBuf();
                    if (b2 == -1) {
                        throw new UTFDataFormatException();
                    }
                    iChar = (b1 & 0x1F) << 6;
                    iChar |= b2 & 0x3F;
                } else if ((b1 & 0xF0) == 224) {
                    b2 = this.readBuf();
                    int b3 = this.readBuf();
                    if (b2 == -1 || b3 == -1) {
                        throw new UTFDataFormatException();
                    }
                    iChar = (b1 & 0xF) << 12;
                    iChar |= (b2 & 0x3F) << 6;
                    iChar |= b3 & 0x3F;
                } else {
                    throw new UTFDataFormatException("char=" + (char)b1 + "; offset=" + this._inBufNext);
                }
                cbuf[off++] = (char)iChar;
            }
            if (ix == 0) {
                return -1;
            }
            return ix;
        }

        public void close() throws IOException {
            this.closeBuf();
        }
    }

    abstract class WmDocReaderBase
    extends Reader {
        private byte[] _buffer;
        protected PushbackInputStream _input;
        private int _inBufCount;
        protected int _inBufNext;
        private int _inBufLeft;

        public WmDocReaderBase(PushbackInputStream is) {
            this._buffer = new byte[WmDocReader.this._pushbackSize];
            this._inBufCount = 0;
            this._inBufNext = 0;
            this._inBufLeft = 0;
            this._input = is;
        }

        private int fillBuffer() throws IOException {
            int i;
            try {
                i = this._input.read(this._buffer);
            }
            catch (EOFException e) {
                i = -1;
            }
            this._inBufCount = i;
            this._inBufNext = 0;
            this._inBufLeft = i > 0 ? i : 0;
            return i;
        }

        public int readBuf() throws IOException {
            if (this._inBufLeft == 0 && this.fillBuffer() == -1) {
                return -1;
            }
            int ret = this._buffer[this._inBufNext++] & 0xFF;
            --this._inBufLeft;
            return ret;
        }

        public int readBuf(byte[] buf, int off, int len) throws IOException {
            int count = 0;
            if (this._inBufLeft == 0 && this.fillBuffer() == -1) {
                return -1;
            }
            while (len > this._inBufLeft) {
                System.arraycopy(this._buffer, this._inBufNext, buf, off, this._inBufLeft);
                count += this._inBufLeft;
                len -= this._inBufLeft;
                if (this.fillBuffer() != -1) continue;
                return count;
            }
            System.arraycopy(this._buffer, this._inBufNext, buf, off, len);
            this._inBufNext += len;
            this._inBufLeft -= len;
            return count += len;
        }

        public void closeBuf() throws IOException {
            if (this._inBufLeft > 0) {
                this._input.unread(this._buffer, this._inBufNext, this._inBufLeft);
            }
        }
    }
}

