/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml.token;

import com.wm.lang.xml.AttributeDef;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.XmlName;
import com.wm.lang.xml.token.AttListDecl;
import com.wm.lang.xml.token.BurstBlockInputBuffer;
import com.wm.lang.xml.token.Entity;
import com.wm.lang.xml.token.EntityTable;
import com.wm.lang.xml.token.ExternalEntity;
import com.wm.lang.xml.token.ExternalID;
import com.wm.lang.xml.token.HtmlType;
import com.wm.lang.xml.token.InputBuffer;
import com.wm.lang.xml.token.Notation;
import com.wm.lang.xml.token.SourceBuffer;
import com.wm.lang.xml.token.StringEntity;
import com.wm.lang.xml.token.Token;
import com.wm.lang.xml.token.TokenAttribute;
import com.wm.lang.xml.token.TokenException;
import com.wm.lang.xml.token.TokenProcessor;
import com.wm.lang.xml.token.TokenSource;
import com.wm.lang.xml.token.TrickleBlockInputBuffer;
import com.wm.lang.xml.token.resources.TokenExceptionBundle;
import com.wm.util.List;
import com.wm.util.Name;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

public final class WMTokenSource
implements TokenSource {
    static final Name NAME_EXT_SUBSET = Name.create("$ExtDTDSubset$");
    static final String TERM_ENTITY = "ENTITY";
    static final String TERM_ELEMENT = "ELEMENT";
    static final String TERM_ATTLIST = "ATTLIST";
    static final String TERM_DOCTYPE = "DOCTYPE";
    static final String TERM_SYSTEM = "SYSTEM";
    static final String TERM_PUBLIC = "PUBLIC";
    static final String TERM_NDATA = "NDATA";
    static final String TERM_EMPTY = "EMPTY";
    static final String TERM_ANY = "ANY";
    static final String TERM_PCDATA = "PCDATA";
    static final String TERM_CDATA = "CDATA";
    static final String TERM_INCLUDE = "INCLUDE";
    static final String TERM_IGNORE = "IGNORE";
    static final String TERM_NOTATION = "NOTATION";
    static final String TERM_ID = "ID";
    static final String TERM_REQUIRED = "REQUIRED";
    static final String TERM_IMPLIED = "IMPLIED";
    static final String TERM_FIXED = "FIXED";
    static final Name DUMMY_ENTITY = Name.create("$InvalidEntity$");
    static final boolean[] nameCharTable = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, true, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true};
    static final boolean[] nameCharOrColonTable = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, true, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true};
    static final boolean[] nameStartCharTable = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, true, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true};
    static final boolean[] xmlSpaceTable = new boolean[]{false, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true};
    static final boolean[] htmlSpaceTable = new boolean[]{false, false, false, false, false, false, false, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    TokenProcessor tokenProcessor;
    boolean isXml;
    boolean expandDTD;
    boolean expandGeneralEntities = true;
    InputBuffer ib;
    boolean done;
    Token token = new Token();
    long start;
    boolean readingDTD;
    boolean readingInternalDtdSubset;
    boolean loadedExternalDtdSubset;
    boolean isEmptyElement;
    boolean abortDTD;
    boolean endAttList = false;
    List includeStack;
    boolean ignoringSection;
    long endOfLastPE;
    ArrayList notationTable;
    EntityTable geTable;
    EntityTable peTable;
    List attsToNormalize;
    List attListDecls;
    List attsRemaining = new List();
    ExternalID docExternalID;
    Name localName;
    Name nsPrefix;

    public WMTokenSource(TokenProcessor tp, Reader reader, boolean expandDTD, int syntax, boolean loadOnDemand) {
        this(tp, reader, expandDTD, true, syntax, loadOnDemand);
    }

    public WMTokenSource(TokenProcessor tp, Reader reader, boolean expandDTD, boolean expandGeneralEntities, int syntax, boolean loadOnDemand) {
        this.ib = expandDTD ? new TrickleBlockInputBuffer(reader) : new BurstBlockInputBuffer(reader);
        this.expandDTD = expandDTD;
        this.expandGeneralEntities = expandGeneralEntities;
        this.tokenProcessor = tp;
        if (syntax == 1 || syntax == 3) {
            this.isXml(true);
        }
    }

    public SourceBuffer getSourceBuffer() {
        return this.ib;
    }

    public Token nextToken() throws IOException, TokenException {
        this.done = false;
        this.token.clear();
        if (this.readingDTD) {
            int next = this.toDTDChar(this.ib.getNext());
            this.start = this.ib.getPosition();
            if (next == -1) {
                this.processDocTypeDecl();
                this.done = true;
                return null;
            }
            if (next == 60) {
                this.getElementOrDecl();
            } else if (next == 93 || next == 62) {
                this.getEndOfSection();
            } else {
                this.getDTDSpace();
            }
        } else {
            int next = this.ib.getNext();
            this.start = this.ib.getPosition();
            if (next == -1) {
                this.done = true;
                return null;
            }
            if (next == 60) {
                this.getElementOrDecl();
            } else if (next == 38) {
                this.getContentEntityRef();
            } else {
                this.getPCData();
            }
        }
        return this.token;
    }

    public EntityTable getGeTable() {
        return this.geTable;
    }

    public ArrayList getNotationTable() {
        return this.notationTable;
    }

    public void close() {
        this.peTable = null;
        this.ib.close();
    }

    public String getSystemID() {
        if (this.docExternalID != null) {
            return this.docExternalID.systemID;
        }
        return null;
    }

    public String getPublicID() {
        if (this.docExternalID != null) {
            return this.docExternalID.publicID;
        }
        return null;
    }

    public void isXml(boolean isXml) {
        if (this.geTable == null) {
            this.geTable = new EntityTable(true);
        }
        this.isXml = isXml;
    }

    void processDocTypeDecl() throws IOException, TokenException {
        if (this.attsToNormalize != null) {
            for (int i = 0; i < this.attsToNormalize.size(); ++i) {
                AttributeDef attDef = (AttributeDef)this.attsToNormalize.elementAt(i);
                attDef.getTokenAttribute().normalize(attDef.getType(), this.geTable, this.expandGeneralEntities);
            }
        }
    }

    boolean processAttListDecl(AttListDecl decl) {
        boolean found = false;
        if (decl != null) {
            if (this.attListDecls == null) {
                this.attListDecls = new List();
            }
            for (int declIndex = 0; !found && declIndex < this.attListDecls.size(); ++declIndex) {
                AttListDecl existingDecl = (AttListDecl)this.attListDecls.elementAt(declIndex);
                if (decl.elementLocalName != existingDecl.elementLocalName || decl.elementNSPrefix != existingDecl.elementNSPrefix) continue;
                existingDecl.merge(decl);
                found = true;
            }
            if (!found) {
                this.attListDecls.addElement(decl);
            }
        }
        return !found;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void getElementOrDecl() throws IOException, TokenException {
        this.ib.mark();
        int next = this.ib.getNext();
        if (WMTokenSource.isNameStartChar(next)) {
            this.isEmptyElement = false;
            this.token.type = 0;
            this.getName();
            this.token.localName = this.localName;
            this.token.nsPrefix = this.nsPrefix;
            this.smartSkipSpace();
            this.getAttributes();
            if (this.isXml) {
                this.processAttributes();
            }
            if (this.isEmptyElement) {
                this.token.type = 5;
            }
        } else if (next == 33) {
            next = this.ib.getNext();
            if (next == 45) {
                this.token.type = 200;
                if (this.ib.getNext() == 45) {
                    this.token.startTextOffset = this.ib.getPosition() + 1L;
                    this.token.endTextOffset = this.ib.readUntil("-->") ? this.ib.getPosition() - 2L : this.token.startTextOffset;
                } else {
                    this.token.startTextOffset = this.ib.getPosition();
                    this.token.endTextOffset = this.ib.readUntil("->") ? this.ib.getPosition() - 1L : this.token.startTextOffset;
                }
                if (this.readingDTD) {
                    this.skipToNextDecl();
                }
                this.done = true;
            } else if (next == 91) {
                String sectionType;
                this.ib.getNext();
                this.skipXmlSpace();
                if (this.ignoringSection) {
                    sectionType = TERM_IGNORE;
                } else {
                    sectionType = this.getNameTokenInDTD();
                    this.skipXmlSpace();
                }
                if (sectionType == null) {
                    throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.NAME_TOKEN_SHOULD_FOLLOW, "");
                }
                if (this.ib.getCurrent() != 91) {
                    if (!this.ignoringSection) throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.MISSING_BRACE, "");
                    this.ib.pushBack();
                }
                this.done = true;
                if (sectionType.equals(TERM_CDATA)) {
                    this.token.type = 2;
                    this.token.startTextOffset = this.ib.getPosition() + 1L;
                    this.ib.readUntil("]]>");
                    this.token.endTextOffset = this.ib.getPosition() - 2L;
                    if (this.token.endTextOffset < this.token.startTextOffset) {
                        throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.TERMINATE_AMID_CDATA, "");
                    }
                } else {
                    if (!this.readingDTD) {
                        throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.FOUND_INCLUDE_IGNORE, "");
                    }
                    if (sectionType.equals(TERM_INCLUDE)) {
                        this.token.type = 206;
                        if (this.includeStack == null) {
                            this.includeStack = new List();
                        }
                        if (this.ignoringSection) {
                            this.includeStack.addElement(TERM_IGNORE);
                        } else {
                            this.includeStack.addElement(TERM_INCLUDE);
                        }
                        this.skipToNextDecl();
                    } else {
                        if (!sectionType.equals(TERM_IGNORE)) throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.UNRECOGNIZE_CONSTRUCT, "", sectionType);
                        this.token.type = 207;
                        if (this.includeStack == null) {
                            this.includeStack = new List();
                        }
                        this.ignoringSection = true;
                        this.includeStack.addElement(TERM_IGNORE);
                        this.skipToNextDecl();
                    }
                }
            } else if (WMTokenSource.isNameStartChar(next)) {
                this.readingDTD = true;
                String declType = this.getNameTokenInDTD();
                if (declType.equals(TERM_ENTITY)) {
                    this.getEntityDecl();
                } else if (declType.equals(TERM_ELEMENT)) {
                    this.getElementDecl();
                } else if (declType.equals(TERM_ATTLIST)) {
                    this.getAttListDecl();
                } else if (declType.toUpperCase().equals(TERM_DOCTYPE)) {
                    this.getDTD();
                } else if (declType.equals(TERM_NOTATION)) {
                    this.getNotationDecl();
                } else {
                    this.token.type = 999;
                    this.smartSkipSpace();
                }
            } else {
                this.token.type = 999;
            }
        } else if (next == 47) {
            this.ib.getNext();
            this.token.type = 4;
            this.skipXmlSpace();
            if (WMTokenSource.isNameStartChar(this.ib.getCurrent())) {
                this.getName();
                this.token.localName = this.localName;
                this.token.nsPrefix = this.nsPrefix;
            }
            this.smartSkipSpace();
        } else if (next == 63) {
            this.getPI();
        } else {
            if (next == 60 && this.isXml) {
                throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.DUPLICATE_START_TAG, "");
            }
            this.token.type = 1;
        }
        if (!this.done && next != 62) {
            this.ib.readUntil(62);
        }
        this.token.startSourceOffset = this.start;
        this.token.endSourceOffset = this.ib.getPosition() + 1L;
    }

    private void getPCData() throws IOException {
        int next;
        this.token.type = 1;
        while ((next = this.ib.getNext()) != 60 && next != 38 && next != -1) {
        }
        if (next >= 0) {
            this.ib.pushBack();
        }
        this.token.startSourceOffset = this.start;
        this.token.endSourceOffset = this.ib.getPosition() + 1L;
    }

    void getDTDSpace() throws IOException {
        int next;
        this.token.type = 1;
        while ((next = this.ib.getNext()) != 60 && next != 37 && next != 93 && next != -1) {
        }
        if (next >= 0) {
            this.ib.pushBack();
        }
        this.token.startSourceOffset = this.start;
        this.token.endSourceOffset = this.ib.getPosition() + 1L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void getContentEntityRef() throws IOException, TokenException {
        int next = this.ib.getNext();
        this.ib.mark();
        if (this.isXml) {
            while (next != 59 && next != -1) {
                next = this.ib.getNext();
            }
            String text = null;
            String ref = this.ib.getSelection(-1);
            if (this.expandGeneralEntities) {
                text = this.geTable.resolveRef(ref, this.expandGeneralEntities);
            } else {
                Entity entity = (Entity)EntityTable.xmlGEs.get(Name.create(ref));
                if (entity != null) {
                    text = entity.getExpandedValue();
                } else {
                    text = "&" + ref + ";";
                    this.token.setText(text);
                    this.token.type = 1;
                    this.token.startSourceOffset = this.start;
                    this.token.endSourceOffset = this.ib.getPosition() + 1L;
                    return;
                }
            }
            if (text != null) {
                if (text.length() > 1 && this.expandDTD) {
                    StringReader srdr = new StringReader(text);
                    this.ib.pushReader(srdr);
                    this.token = this.nextToken();
                    return;
                }
                this.token.setText(text);
            } else {
                if (!System.getProperty("watt.server.xml.enforceEntityRef", "true").equals("false")) throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.MALFORMED_ENTITY_REF, "", this.ib.getSelection(0));
                this.token.setText("");
            }
        } else {
            while (next != 59 && next != 60 && next != 38 && !WMTokenSource.isHTMLSpace(next) && next != -1) {
                next = this.ib.getNext();
            }
            if (next == 59) {
                int c = EntityTable.resolveHtmlRef(this.ib.getSelection(-1));
                if (c != -1) {
                    this.token.setText(EntityTable.toString(c));
                }
            } else {
                this.ib.pushBack();
            }
        }
        this.token.type = 1;
        this.token.startSourceOffset = this.start;
        this.token.endSourceOffset = this.ib.getPosition() + 1L;
    }

    void getDtdEntityRef() throws IOException, TokenException {
        String ref;
        Entity entity;
        if (this.ib.getPosition() < this.endOfLastPE) {
            return;
        }
        int next = this.ib.getNext();
        this.ib.mark();
        while (next != 59 && next != -1) {
            next = this.ib.getNext();
        }
        if (this.peTable != null && (entity = this.peTable.getEntity(Name.create(ref = this.ib.getSelection(-1)))) != null) {
            this.ib.reset();
            this.ib.pushBack();
            entity.write(this.ib);
            this.endOfLastPE = this.ib.getPosition();
            this.ib.reset();
            this.ib.pushBack();
            this.ib.pushBack();
        }
    }

    void getDTD() throws IOException, TokenException {
        if (this.isXml) {
            this.getStartOfXmlDTD();
        } else {
            this.getHtmlDTD();
        }
    }

    void getStartOfXmlDTD() throws IOException, TokenException {
        this.token.type = 103;
        this.skipXmlSpace();
        int next = this.ib.getCurrent();
        this.getName();
        if (this.localName == null) {
            while (next != 91 && next != 62 && next != -1) {
                next = this.ib.getNext();
            }
        } else {
            this.token.nsPrefix = this.nsPrefix;
            this.token.localName = this.localName;
        }
        this.skipXmlSpace();
        next = this.ib.getCurrent();
        if (next != 91 && next != 62) {
            this.docExternalID = this.getExternalID();
            this.skipXmlSpace();
            next = this.ib.getCurrent();
        }
        if (next == 62) {
            this.readingInternalDtdSubset = false;
            this.ib.pushBack();
            this.done = true;
        } else {
            this.readingInternalDtdSubset = true;
            this.skipToNextDecl();
        }
    }

    void getEndOfSection() throws IOException, TokenException {
        this.ib.mark();
        if (this.ib.getCurrent() == 93) {
            this.ib.getNext();
            this.skipXmlSpace();
        }
        if (this.ib.getCurrent() == 93) {
            if (this.ib.getNext() != 62) {
                if (!this.ignoringSection) {
                    throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.INCLUDE_NOT_TERMINATED, "");
                }
                this.token.type = 201;
                this.token.ignore = true;
                this.done = true;
                return;
            }
            if (this.includeStack == null || this.includeStack.size() == 0) {
                throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.CONDITIONAL_SECTION_NOT_STARTED, "");
            }
            this.includeStack.removeLastElement();
            if (this.includeStack.size() == 0) {
                this.ignoringSection = false;
            } else if (this.ignoringSection && (String)this.includeStack.lastElement() == TERM_INCLUDE) {
                this.ignoringSection = false;
            }
            this.token.type = 208;
            this.skipToNextDecl();
            this.done = true;
            return;
        }
        if (this.ignoringSection) {
            this.token.type = 201;
            this.token.ignore = true;
            this.done = true;
            return;
        }
        if (this.ib.getCurrent() != 62) {
            throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.DTD_NOT_TERMINATED, "");
        }
        String systemID = this.getSystemID();
        if (this.expandDTD && systemID != null && !this.loadedExternalDtdSubset) {
            if (this.peTable == null) {
                this.peTable = new EntityTable(false);
            }
            ExternalEntity externalSubset = new ExternalEntity(NAME_EXT_SUBSET, this.docExternalID);
            this.ib.reset();
            if (!this.readingInternalDtdSubset) {
                this.ib.write(" [\n");
                this.readingInternalDtdSubset = true;
            }
            this.ib.pushReader(new StringReader("\n]>\n"));
            ((Entity)externalSubset).write(this.ib);
            this.ib.pushBack();
            this.loadedExternalDtdSubset = true;
            this.skipToNextDecl();
            this.nextToken();
        } else {
            this.token.type = 104;
            this.readingDTD = false;
            this.readingInternalDtdSubset = false;
            this.processDocTypeDecl();
            this.token.startSourceOffset = this.start;
            this.token.endSourceOffset = this.ib.getPosition() + 1L;
        }
    }

    void getHtmlDTD() throws IOException {
        this.token.type = 101;
        int next = this.ib.getCurrent();
        while (next != 62 && next != -1) {
            next = this.ib.getNext();
        }
        this.readingDTD = false;
        this.done = true;
    }

    void getEntityDecl() throws IOException, TokenException {
        this.token.type = 205;
        if (!this.isXml) {
            this.isXml(true);
        }
        EntityTable entityTable = this.geTable;
        this.skipXmlSpace();
        int next = this.ib.getCurrent();
        if (next == 37) {
            if (this.peTable == null) {
                this.peTable = new EntityTable(false);
            }
            entityTable = this.peTable;
            this.ib.getNext();
            this.skipXmlSpace();
            next = this.ib.getCurrent();
        }
        String name = this.getNameTokenInDTD();
        Name entityName = null;
        if (name == null) {
            if (!this.abortDTD && !this.ignoringSection) {
                throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.MISSING_ENTITY_NAME, "");
            }
        } else {
            entityName = Name.create(name);
        }
        this.skipXmlSpace();
        String value = this.getQuotedLiteralInDTD(false);
        if (value != null) {
            if (!this.abortDTD && !this.ignoringSection) {
                entityTable.addEntity(new StringEntity(entityName, entityTable, value));
            }
            this.ib.getNext();
            this.skipXmlSpace();
        } else {
            ExternalID id = this.getExternalID();
            if (!this.abortDTD && !this.ignoringSection) {
                if (id != null) {
                    String ndata = this.getNdata();
                    entityTable.addEntity(new ExternalEntity(entityName, id, ndata));
                } else {
                    throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.EXPECTING_ID, "");
                }
            }
        }
        this.skipRestOfDecl();
    }

    private String getNdata() throws IOException, TokenException {
        this.skipXmlSpace();
        String ndatadecl = this.getNameTokenInDTD();
        if (ndatadecl == null || !TERM_NDATA.equals(ndatadecl)) {
            return null;
        }
        this.skipXmlSpace();
        return this.getNameTokenInDTD();
    }

    void getElementDecl() throws IOException, TokenException {
        this.token.type = 201;
        this.token.ignore = this.ignoringSection;
        if (!this.isXml) {
            this.isXml(true);
        }
        if (this.abortDTD || this.ignoringSection) {
            this.skipRestOfDecl();
            return;
        }
        this.skipXmlSpace();
        this.getNameInDTD();
        if (this.localName != null) {
            this.token.nsPrefix = this.nsPrefix;
            this.token.localName = this.localName;
            this.skipXmlSpace();
            long start = this.ib.getPosition();
            int next = this.toDTDChar(this.ib.getCurrent());
            while (next != 62 && next != -1) {
                next = this.toDTDChar(this.ib.getNext());
            }
            if (next == -1) {
                throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.TERMINATED_AMID_ELEMENT_DECL, "");
            }
            if (this.abortDTD || this.ignoringSection) {
                this.localName = null;
            } else {
                this.token.text = this.ib.getString(start, this.ib.getPosition());
            }
            this.skipToNextDecl();
        } else {
            this.skipRestOfDecl();
        }
    }

    void getAttListDecl() throws IOException, TokenException {
        this.token.ignore = this.ignoringSection;
        if (!this.isXml) {
            this.isXml(true);
        }
        AttListDecl attListDecl = new AttListDecl();
        Name attType = null;
        String attValue = null;
        String notationValue = null;
        this.token.type = 102;
        this.token.attListDecl = attListDecl;
        this.token.idAttributeLocalName = null;
        this.skipXmlSpace();
        this.getNameInDTD();
        if (this.localName == null && !this.abortDTD && !this.ignoringSection) {
            throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.ATTLIST_ELEMENT_NAME_NOT_FOUND, "");
        }
        attListDecl.elementLocalName = this.localName;
        attListDecl.elementNSPrefix = this.nsPrefix;
        this.skipXmlSpace();
        int next = this.ib.getCurrent();
        while (next != -1 && next != 62) {
            long startingPosition = this.ib.getPosition();
            AttributeDef attDef = new AttributeDef();
            this.getNameInDTD();
            if (this.endAttList) break;
            if (this.localName == null && !this.abortDTD && !this.ignoringSection) {
                throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.ATTLIST_ATTRIBUTE_NAME_NOT_FOUND, "");
            }
            this.skipXmlSpace();
            String tempStr = this.getNameTokenInDTD();
            if (tempStr != null) {
                if (!this.abortDTD && !this.ignoringSection) {
                    attType = Name.create(tempStr);
                    if (attType == AttributeDef.TYPE_NOTATION) {
                        notationValue = this.getNotationValueInDTD();
                    } else if (attType == AttributeDef.TYPE_ID) {
                        this.token.idAttributeNSPrefix = this.nsPrefix;
                        this.token.idAttributeLocalName = this.localName;
                    }
                    attDef.setType(attType);
                }
            } else if (this.ib.getCurrent() == 40) {
                attDef.setType(AttributeDef.TYPE_ENUMERATION);
                if (this.abortDTD || this.ignoringSection) {
                    while ((next = this.ib.getNext()) != 41 && next != -1) {
                    }
                } else {
                    int validValueCount = 0;
                    while ((next = this.toDTDChar(this.ib.getNext())) != 41 && next != -1) {
                        if (WMTokenSource.isXMLSpace(next) || next == 124 || (tempStr = this.getNameTokenInDTD()) == null) continue;
                        attDef.addValidValue(tempStr);
                        ++validValueCount;
                        this.ib.pushBack();
                    }
                    if (validValueCount == 0) {
                        throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.ATTLIST_MISSING_ENUMERATION, "");
                    }
                }
                if (next == -1) {
                    throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.ATTLIST_MISSING_PARENTHESIS, "");
                }
                this.ib.getNext();
            }
            this.skipXmlSpace();
            next = this.toDTDChar(this.ib.getCurrent());
            if (next == 35) {
                this.ib.getNext();
                tempStr = this.getNameTokenInDTD();
                if (tempStr != null && tempStr.equals(TERM_IMPLIED)) {
                    attDef.isRequired(false);
                } else {
                    if (tempStr != null && tempStr.equals(TERM_FIXED)) {
                        attDef.isFixed(true);
                    }
                    attDef.isRequired(true);
                }
                this.skipXmlSpace();
                next = this.ib.getCurrent();
            }
            if ((attValue = this.getQuotedLiteralInDTD(true)) != null) {
                this.ib.getNext();
                this.skipXmlSpace();
                next = this.ib.getCurrent();
            }
            if (!this.abortDTD && !this.ignoringSection) {
                if (attType != AttributeDef.TYPE_NOTATION) {
                    attDef.setTokenAttribute(new TokenAttribute(this.nsPrefix, this.localName, attValue));
                } else {
                    attDef.setTokenAttribute(new TokenAttribute(this.nsPrefix, this.localName, attValue, notationValue));
                }
                if (attValue != null) {
                    this.addAttToNormalize(attDef);
                }
                attListDecl.addAttributeDef(attDef);
            }
            if (this.ib.getPosition() > startingPosition) continue;
            throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.ATTLIST_ATTRIBUTE_NAME_NOT_FOUND, "");
        }
        if (this.abortDTD || this.ignoringSection) {
            this.token.ignore = true;
        } else if (attListDecl.firstAttributeDef != null && !this.processAttListDecl(attListDecl)) {
            this.token.attListDecl.firstAttributeDef = null;
        }
        this.skipToNextDecl();
    }

    void getNotationDecl() throws IOException, TokenException {
        this.token.type = 202;
        if (!this.isXml) {
            this.isXml(true);
        }
        this.skipXmlSpace();
        String name = this.getNameTokenInDTD();
        Name notationName = null;
        if (name != null) {
            notationName = Name.create(name);
            this.skipXmlSpace();
            String externalType = this.getNameTokenInDTD();
            if (externalType != null) {
                this.skipXmlSpace();
                ExternalID externalID = new ExternalID();
                if (externalType.equals(TERM_PUBLIC)) {
                    String id = this.getQuotedLiteralInDTD(false);
                    if (id != null) {
                        externalID.publicID = id;
                        this.ib.getNext();
                    }
                } else if (externalType.equals(TERM_SYSTEM)) {
                    externalID.systemID = this.getQuotedLiteralInDTD(false);
                    if (!this.abortDTD && !this.ignoringSection) {
                        if (externalID.systemID == null) {
                            throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.MISSING_SYSTEM_ID, "");
                        }
                        externalID.qualifyPath(this.ib.getBaseStreamUrl());
                    }
                }
                Notation notation = new Notation(notationName, externalID);
                if (this.notationTable == null) {
                    this.notationTable = new ArrayList();
                }
                this.notationTable.add(notation);
            }
        }
        this.skipRestOfDecl();
    }

    void getAttributes() throws IOException, TokenException {
        if (this.done) {
            return;
        }
        Name prevName = null;
        while (!this.done) {
            if (!this.isXml) {
                String nameStr = this.getAttrValue(true);
                if (nameStr == null) {
                    return;
                }
                nameStr = nameStr.toUpperCase();
                this.nsPrefix = null;
                this.localName = Name.create(nameStr);
            } else {
                int next = this.ib.getCurrent();
                if (!WMTokenSource.isNameStartChar(next)) {
                    return;
                }
                this.getName();
                this.smartSkipSpace();
            }
            if (this.localName == prevName) {
                if (this.ib.getNext() == -1) {
                    return;
                }
                this.ib.pushBack();
            }
            prevName = this.localName;
            if (this.ib.getCurrent() == 61) {
                this.ib.getNext();
                this.smartSkipSpace();
                this.token.addAttribute(this.nsPrefix, this.localName, this.getAttrValue(false));
                continue;
            }
            this.token.addAttribute(this.nsPrefix, this.localName, "");
        }
    }

    String getAttrValue(boolean isName) throws IOException, TokenException {
        int quoteChar = -1;
        this.ib.mark();
        int next = this.ib.getCurrent();
        if (this.isXml && next != 34 && next != 39) {
            throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.UNQUOTED_ATTRIBUTE_VALUE, "", this.localName.toString());
        }
        if (next == 34 || next == 39 || next == 91) {
            quoteChar = next == 91 ? 93 : next;
            next = this.ib.getNext();
            this.ib.mark();
            if (!this.isXml) {
                while (next != quoteChar && next != 62 && next != -1) {
                    next = this.ib.getNext();
                }
            } else {
                while (next != quoteChar && next != 60 && next != -1) {
                    next = this.ib.getNext();
                }
            }
            if (next != quoteChar) {
                quoteChar = -1;
            }
        } else if (isName) {
            while (!WMTokenSource.isHTMLSpace(next) && next != 60 && next != 62 && next != 61 && next != -1) {
                next = this.ib.getNext();
            }
        } else {
            while (!WMTokenSource.isHTMLSpace(next) && next != 60 && next != 62 && next != -1) {
                next = this.ib.getNext();
            }
        }
        String value = this.ib.getSelection(-1);
        if (quoteChar > 0) {
            this.ib.getNext();
        }
        this.smartSkipSpace();
        return value;
    }

    ExternalID getExternalID() throws IOException, TokenException {
        String externalType = this.getNameTokenInDTD();
        if (externalType == null) {
            return null;
        }
        this.skipXmlSpace();
        ExternalID externalID = new ExternalID();
        if (externalType.equals(TERM_PUBLIC)) {
            String id = this.getQuotedLiteralInDTD(false);
            if (id == null) {
                return null;
            }
            externalID.publicID = id;
            this.ib.getNext();
            this.skipXmlSpace();
        } else if (!externalType.equals(TERM_SYSTEM)) {
            return null;
        }
        externalID.systemID = this.getQuotedLiteralInDTD(false);
        if (!this.abortDTD && !this.ignoringSection) {
            if (externalID.systemID == null) {
                throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.MISSING_SYSTEM_ID, "");
            }
            externalID.qualifyPath(this.ib.getBaseStreamUrl());
        }
        this.ib.getNext();
        return externalID;
    }

    public void addAttToNormalize(AttributeDef aspec) {
        if (this.attsToNormalize == null) {
            this.attsToNormalize = new List();
        }
        this.attsToNormalize.addElement(aspec);
    }

    void getName() throws IOException {
        this.ib.mark();
        if (this.isXml) {
            while (WMTokenSource.isNameChar(this.ib.getNext())) {
            }
            String name = this.ib.getSelection(-1);
            if (name == null) {
                name = this.ib.getSelection(0);
            }
            if (this.ib.getCurrent() == 58 && WMTokenSource.isNameStartChar(this.ib.getNext())) {
                this.nsPrefix = Name.create(name);
                this.ib.mark();
                while (WMTokenSource.isNameChar(this.ib.getNext())) {
                }
                name = this.ib.getSelection(-1);
                if (name == null) {
                    name = this.ib.getSelection(0);
                }
                this.localName = Name.create(name);
            } else {
                this.nsPrefix = null;
                this.localName = Name.create(name);
            }
        } else {
            while (WMTokenSource.isNameCharOrColon(this.ib.getNext())) {
            }
            String name = this.ib.getSelection(-1);
            if (name == null) {
                name = this.ib.getSelection(0);
            }
            this.nsPrefix = null;
            this.localName = HtmlType.equivalent(name.toUpperCase());
        }
    }

    void getNameInDTD() throws IOException, TokenException {
        this.skipXmlSpace();
        int position = this.ib.getCurrent();
        if (position == 62) {
            this.endAttList = true;
        }
        int toDtdChar = this.toDTDChar(position);
        this.skipXmlSpace();
        if (WMTokenSource.isNameStartChar(this.toDTDChar(this.ib.getCurrent()))) {
            this.getName();
        } else {
            this.nsPrefix = null;
            this.localName = null;
        }
    }

    String getNameTokenInDTD() throws IOException, TokenException {
        int next = this.toDTDChar(this.ib.getCurrent());
        if (WMTokenSource.isNameCharOrColon(next)) {
            this.ib.mark();
            while (WMTokenSource.isNameCharOrColon(next = this.ib.getNext())) {
            }
            String name = this.ib.getSelection(-1);
            if (name == null || name.length() == 0) {
                return null;
            }
            return name;
        }
        return null;
    }

    String getNotationValueInDTD() throws IOException, TokenException {
        int next;
        this.skipXmlSpace();
        this.ib.mark();
        while ((next = this.ib.getNext()) != -1 && next != 41) {
        }
        String value = this.ib.getSelection(0);
        if (value == null || value.length() == 0) {
            return null;
        }
        this.ib.getNext();
        return value;
    }

    String getQuotedLiteralInDTD(boolean expandRefs) throws IOException, TokenException {
        int next = this.toDTDChar(this.ib.getCurrent());
        if (next == 39 || next == 34) {
            int delim = next;
            next = this.ib.getNext();
            long start = this.ib.getPosition();
            while (next != delim && next != -1) {
                if (next == 37 && expandRefs) {
                    if (this.expandDTD) {
                        this.getDtdEntityRef();
                        if (this.ib.getPosition() < this.endOfLastPE) {
                            this.ib.gotoPosition(this.endOfLastPE - 1L);
                        }
                    } else {
                        this.skipPERef();
                    }
                }
                next = this.ib.getNext();
            }
            String rawValue = this.ib.getString(start, this.ib.getPosition());
            if (expandRefs) {
                return EntityTable.expandString(rawValue, null, true, this.expandGeneralEntities);
            }
            return rawValue;
        }
        return null;
    }

    void getPI() throws IOException, TokenException {
        int next = this.ib.getNext();
        this.skipXmlSpace();
        this.token.type = 204;
        this.getNameInDTD();
        this.token.localName = this.localName;
        if (this.localName == Document.xmlName) {
            this.isXml(true);
        } else if (this.localName == Document.XMLName) {
            this.isXml(true);
            this.localName = Document.xmlName;
        }
        if (this.isXml && this.localName.toString().equals("xml")) {
            long temp = this.ib.getPosition();
            boolean check = this.ib.readUntil("version");
            this.ib.getNext();
            this.skipXmlSpace();
            if (check && (char)this.ib.getCurrent() != '=') {
                throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.XML_VERSION_NOT_1_0, "");
            }
            this.ib.getNext();
            this.skipXmlSpace();
            int versionChar1 = this.ib.getCurrent();
            int versionChar2 = this.ib.getNext();
            int versionChar3 = this.ib.getNext();
            int versionChar4 = this.ib.getNext();
            int versionChar5 = this.ib.getNext();
            this.ib.gotoPosition(temp);
            if (versionChar2 != 49 || versionChar3 != 46 || versionChar4 != 48 || (versionChar1 != 34 || versionChar5 != 34) && (versionChar1 != 39 || versionChar5 != 39)) {
                throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.XML_VERSION_NOT_1_0, "");
            }
        }
        this.skipXmlSpace();
        long databegin = this.ib.getPosition();
        if (this.ib.getCurrent() == 63) {
            this.ib.pushBack();
        }
        this.ib.readUntil("?>");
        this.token.startTextOffset = databegin;
        this.token.endTextOffset = this.ib.getPosition() - 1L;
        this.done = true;
    }

    int toDTDChar(int next) throws IOException, TokenException {
        if (next == 37) {
            if (this.expandDTD) {
                this.getDtdEntityRef();
            } else {
                this.skipPERef();
            }
            return this.ib.getNext();
        }
        return next;
    }

    void skipPERef() throws IOException, TokenException {
        int next;
        while ((next = this.ib.getNext()) != 59 && next != -1) {
        }
        if (next == -1) {
            throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.MISSING_SEMICOLON, "");
        }
        this.abortDTD = true;
    }

    void skipToNextDecl() throws IOException {
        this.ib.getNext();
        this.skipXmlSpace();
        this.ib.pushBack();
        this.done = true;
    }

    void skipToCloseParen() throws IOException {
        int next;
        while ((next = this.ib.getNext()) != -1 && next != 41) {
        }
        this.ib.getNext();
    }

    void skipXmlSpace() throws IOException {
        if (WMTokenSource.isXMLSpace(this.ib.getCurrent())) {
            while (WMTokenSource.isXMLSpace(this.ib.getNext())) {
            }
        }
    }

    void skipHtmlSpace() throws IOException {
        if (WMTokenSource.isHTMLSpace(this.ib.getCurrent())) {
            while (WMTokenSource.isHTMLSpace(this.ib.getNext())) {
            }
        }
    }

    void smartSkipSpace() throws IOException, TokenException {
        int next = this.ib.getCurrent();
        if (!this.isXml) {
            if (WMTokenSource.isHTMLSpace(next)) {
                while (WMTokenSource.isHTMLSpace(next = this.ib.getNext())) {
                }
            }
        } else if (WMTokenSource.isXMLSpace(next)) {
            while (WMTokenSource.isXMLSpace(next = this.ib.getNext())) {
            }
        }
        switch (next) {
            case 63: {
                if (this.ib.getNext() != 62) break;
                this.done = true;
                break;
            }
            case 47: {
                if (this.ib.getNext() == 62) {
                    this.isEmptyElement = true;
                    this.done = true;
                    break;
                }
                this.ib.pushBack();
                break;
            }
            case 60: {
                if (this.isXml) {
                    if (this.token.getType() == 0) {
                        throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.ELEMENT_MISSING_END_TAG, "", new XmlName(this.token.nsPrefix, this.token.localName).toString());
                    }
                    if (this.token.getType() == 4) {
                        throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.END_ELEMENT_MISSING_CLOSING_BRACKET, "", "/" + new XmlName(this.token.nsPrefix, this.token.localName).toString());
                    }
                }
                this.done = true;
                this.ib.pushBack();
                break;
            }
            case 62: {
                this.done = true;
            }
        }
    }

    void skipRestOfDecl() throws IOException {
        int next = this.ib.getCurrent();
        while (next != -1 && next != 62) {
            next = this.ib.getNext();
            if (next != 39 && next != 34) continue;
            int quoteChar = next;
            while ((next = this.ib.getNext()) != -1 && next != quoteChar) {
            }
        }
        this.skipToNextDecl();
    }

    public static boolean isNameStartChar(int ch) {
        if (ch < nameStartCharTable.length && ch >= 0) {
            return nameStartCharTable[ch];
        }
        return Character.isLetter((char)ch);
    }

    public static boolean isNameChar(int ch) {
        if (ch < nameCharTable.length && ch >= 0) {
            return nameCharTable[ch];
        }
        return Character.isLetterOrDigit((char)ch);
    }

    static boolean isNameCharOrColon(int ch) {
        if (ch < nameCharOrColonTable.length && ch >= 0) {
            return nameCharOrColonTable[ch];
        }
        return Character.isLetterOrDigit((char)ch);
    }

    static boolean isCharacter(int ch) {
        return Character.isLetter((char)ch);
    }

    static boolean isPubidChar(int ch) {
        return ch == 32 || ch == 13 || ch == 10 || ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch >= 48 && ch <= 57 || ch == 45 || ch == 39 || ch == 40 || ch == 41 || ch == 43 || ch == 44 || ch == 46 || ch == 47 || ch == 58 || ch == 61 || ch == 63;
    }

    public static boolean isHTMLSpace(int ch) {
        if (ch < htmlSpaceTable.length && ch >= 0) {
            return htmlSpaceTable[ch];
        }
        return Character.isSpaceChar((char)ch);
    }

    public static boolean isXMLSpace(int ch) {
        if (ch < xmlSpaceTable.length && ch >= 0) {
            return xmlSpaceTable[ch];
        }
        return false;
    }

    static boolean isCombiningChar(int ch) {
        return false;
    }

    static boolean isExtenderChar(int ch) {
        return false;
    }

    public void processAttributes() throws IOException, TokenException {
        int attIndex;
        TokenAttribute a;
        if (this.token.firstAssignedAttribute != null) {
            this.attsRemaining.reset();
            a = this.token.firstAssignedAttribute;
            while (a != null) {
                this.attsRemaining.addElement(a);
                a = a.next;
            }
        }
        if (this.attListDecls != null) {
            int declCount = this.attListDecls.size();
            int declIndex = 0;
            AttListDecl attListDecl = null;
            boolean found = false;
            while (!found && declIndex < declCount) {
                attListDecl = (AttListDecl)this.attListDecls.elementAt(declIndex++);
                if (attListDecl.elementLocalName != this.token.localName || attListDecl.elementNSPrefix != this.token.nsPrefix) continue;
                found = true;
            }
            if (found) {
                for (AttributeDef attDef = attListDecl.firstAttributeDef; attDef != null; attDef = attDef.getNext()) {
                    TokenAttribute attDefAttr = attDef.getTokenAttribute();
                    found = false;
                    attIndex = 0;
                    while (!found && attIndex < this.attsRemaining.size()) {
                        a = (TokenAttribute)this.attsRemaining.elementAt(attIndex);
                        if (a.localName == attDefAttr.localName && a.nsPrefix == attDefAttr.nsPrefix) {
                            a.normalize(attDef.getType(), this.geTable, this.expandGeneralEntities);
                            this.attsRemaining.removeElementAt(attIndex);
                            found = true;
                            continue;
                        }
                        ++attIndex;
                    }
                    if (found || attDefAttr.value == null) continue;
                    this.token.addAttribute(new TokenAttribute(attDefAttr));
                }
            }
        }
        for (attIndex = 0; attIndex < this.attsRemaining.size(); ++attIndex) {
            ((TokenAttribute)this.attsRemaining.elementAt(attIndex)).normalize(AttributeDef.TYPE_CDATA, this.geTable, this.expandGeneralEntities);
        }
    }

    public static void main(String[] args) {
        WMTokenSource.printCharTable("nameCharTable", new NameCharMethod(), 256);
        WMTokenSource.printCharTable("nameCharOrColonTable", new NameCharOrColonMethod(), 256);
        WMTokenSource.printCharTable("nameStartCharTable", new NameStartCharMethod(), 256);
        WMTokenSource.printCharTable("xmlSpaceTable", new XMLSpaceMethod(), 33);
        WMTokenSource.printCharTable("htmlSpaceTable", new HTMLSpaceMethod(), 256);
    }

    static void printCharTable(String name, CharTypeMethod charType, int size) {
        String[] code = charType.getCode();
        for (int i = 0; i < code.length; ++i) {
            System.out.println("    // " + code[i]);
        }
        System.out.println();
        System.out.println("    static final boolean[] " + name + " = {");
        System.out.print("        ");
        boolean prevResult = false;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                if (i % 10 == 0) {
                    System.out.print(",\n        ");
                } else {
                    System.out.print(", ");
                    if (prevResult) {
                        System.out.print(' ');
                    }
                }
            }
            boolean result = charType.isOfType(i);
            System.out.print(result);
            prevResult = result;
        }
        System.out.println(" };\n");
    }

    static class HTMLSpaceMethod
    extends CharTypeMethod {
        HTMLSpaceMethod() {
        }

        String[] getCode() {
            String[] code = new String[]{"Character.isSpaceChar((char)ch) || (ch > 6 && ch < 14)"};
            return code;
        }

        boolean isOfType(int ch) {
            return Character.isSpaceChar((char)ch) || ch > 6 && ch < 14;
        }
    }

    static class XMLSpaceMethod
    extends CharTypeMethod {
        XMLSpaceMethod() {
        }

        String[] getCode() {
            String[] code = new String[]{"(ch == 0x20 || ch == 0x09 || ch == 0x0D || ch == 0x0A)"};
            return code;
        }

        boolean isOfType(int ch) {
            return ch == 32 || ch == 9 || ch == 13 || ch == 10;
        }
    }

    static class NameStartCharMethod
    extends CharTypeMethod {
        NameStartCharMethod() {
        }

        String[] getCode() {
            String[] code = new String[]{"(Character.isLetter((char)ch) || ch == '_' || ch == ':')"};
            return code;
        }

        boolean isOfType(int ch) {
            return Character.isLetter((char)ch) || ch == 95 || ch == 58;
        }
    }

    static class NameCharOrColonMethod
    extends CharTypeMethod {
        NameCharOrColonMethod() {
        }

        String[] getCode() {
            String[] code = new String[]{"(Character.isLetterOrDigit((char)ch) || ch == '.' || ch == '-' ||", " ch == '_' || ch == ':' /*|| isCombiningChar(ch) || isExtenderChar(ch)*/)"};
            return code;
        }

        boolean isOfType(int ch) {
            return Character.isLetterOrDigit((char)ch) || ch == 46 || ch == 45 || ch == 95 || ch == 58;
        }
    }

    static class NameCharMethod
    extends CharTypeMethod {
        NameCharMethod() {
        }

        String[] getCode() {
            String[] code = new String[]{"(Character.isLetterOrDigit((char)ch) || ch == '.' || ch == '-' ||", " ch == '_' /*|| isCombiningChar(ch) || isExtenderChar(ch)*/)"};
            return code;
        }

        boolean isOfType(int ch) {
            return Character.isLetterOrDigit((char)ch) || ch == 46 || ch == 45 || ch == 95;
        }
    }

    static abstract class CharTypeMethod {
        CharTypeMethod() {
        }

        abstract String[] getCode();

        abstract boolean isOfType(int var1);
    }
}

