/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml.token;

import com.wm.lang.xml.token.BlockInputBuffer;
import com.wm.lang.xml.token.InputBuffer;
import com.wm.lang.xml.token.resources.TokenCharConversionExceptionBundle;
import com.wm.util.EncUtil;
import com.wm.util.JournalLogger;
import com.wm.util.List;
import com.wm.util.LocalizedCharConversionException;
import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;

public final class TrickleBlockInputBuffer
extends BlockInputBuffer {
    static final int XMLPARSER002 = 2;
    List readerStack;

    public TrickleBlockInputBuffer() {
        this.lastBlockSize = -1;
    }

    public TrickleBlockInputBuffer(Reader reader) {
        this.reader = reader;
        this.lastBlockSize = -1;
    }

    public TrickleBlockInputBuffer(InputStream stream) {
        this(stream, EncUtil.getFileEncoding());
    }

    public TrickleBlockInputBuffer(InputStream stream, String encoding) {
        try {
            this.reader = new InputStreamReader(this.toBufferedStream(stream), encoding);
        }
        catch (UnsupportedEncodingException e) {
            JournalLogger.log(2, 42, encoding);
            this.reader = new InputStreamReader(this.toBufferedStream(stream));
        }
        this.lastBlockSize = -1;
    }

    public void pushReader(Reader nestedReader) {
        if (this.reader != null) {
            if (this.readerStack == null) {
                this.readerStack = new List();
            }
            this.readerStack.addElement(this.reader);
        }
        this.reader = nestedReader;
    }

    public void write(String source) {
        this.write(source.toCharArray(), 0, source.length());
    }

    public void write(char[] source, int startOffset, int length) {
        if (length != 0) {
            if (this.lastBlockNumber == -1) {
                this.block = new char[8192];
                this.blockList.addElement(this.block);
                this.blockNumber = 0;
                this.blockStartPos = 0L;
                this.position = 0;
                this.lastBlockNumber = 0;
                this.lastBlockSize = 0;
                this.blockStartPos = 0L;
            }
            if (this.position + length <= 8192) {
                if (length == 1) {
                    this.block[this.position++] = source[0];
                } else {
                    System.arraycopy(source, startOffset, this.block, this.position, length);
                    this.position += length;
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    if (this.position == 8192) {
                        this.advanceBlock();
                    }
                    this.block[this.position++] = source[startOffset++];
                }
            }
        }
        this.lastBlockNumber = this.blockNumber;
        this.lastBlockSize = this.position;
    }

    public void close() {
        this.closeReader(this.reader);
        if (this.readerStack != null) {
            for (int i = 0; i < this.readerStack.size(); ++i) {
                this.closeReader((Reader)this.readerStack.removeLastElement());
            }
        }
        this.reader = null;
    }

    public void overwrite(char c) {
        this.block[this.position++] = c;
        this.lastBlockNumber = this.blockNumber;
        this.lastBlockSize = this.position;
    }

    public int getNext() throws IOException {
        if (this.blockNumber < this.lastBlockNumber) {
            if (++this.position < 8192) {
                return this.block[this.position];
            }
            this.block = (char[])this.blockList.elementAt(++this.blockNumber);
            this.position = 0;
            this.blockStartPos += 8192L;
            return this.block[0];
        }
        if (++this.position < this.lastBlockSize) {
            return this.block[this.position];
        }
        if (this.reader == null) {
            --this.position;
            return -1;
        }
        try {
            int next = this.reader.read();
            if (next == -1) {
                if (this.readerStack != null && this.readerStack.size() > 0) {
                    --this.position;
                    this.closeReader(this.reader);
                    this.reader = (Reader)this.readerStack.removeLastElement();
                    return this.getNext();
                }
                --this.position;
                this.close();
                return -1;
            }
            if (this.lastBlockSize == 8192 || this.lastBlockSize == -1) {
                this.advanceBlock();
                this.lastBlockSize = 1;
            } else {
                ++this.lastBlockSize;
            }
            this.block[this.position] = (char)next;
            return next;
        }
        catch (CharConversionException e) {
            --this.position;
            this.close();
            throw new LocalizedCharConversionException(TokenCharConversionExceptionBundle.class, TokenCharConversionExceptionBundle.INCORRECT_CHAR_ENCODING, "", e.getMessage());
        }
        catch (UTFDataFormatException e) {
            --this.position;
            this.close();
            throw new LocalizedCharConversionException(TokenCharConversionExceptionBundle.class, TokenCharConversionExceptionBundle.INCORRECT_CHAR_ENCODING, "", e.getMessage());
        }
        catch (IOException e) {
            --this.position;
            this.close();
            return -1;
        }
    }

    public void truncate() {
        this.lastBlockNumber = this.blockNumber;
        this.lastBlockSize = this.position;
    }

    InputBuffer createLikeInstance(Reader reader) {
        return new TrickleBlockInputBuffer(reader);
    }

    void closeReader(Reader r) {
        try {
            if (r != null) {
                r.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    InputStream toBufferedStream(InputStream stream) {
        if (!(stream instanceof BufferedInputStream)) {
            stream = new BufferedInputStream(stream, 8192);
        }
        return stream;
    }

    void advanceBlock() {
        if (++this.blockNumber < this.blockList.size()) {
            this.block = (char[])this.blockList.elementAt(this.blockNumber);
        } else {
            this.block = new char[8192];
            this.blockList.addElement(this.block);
        }
        if (this.blockNumber > this.lastBlockNumber) {
            this.lastBlockNumber = this.blockNumber;
        }
        this.position = 0;
        this.blockStartPos += 8192L;
    }

    public static void main(String[] argv) throws IOException {
        TrickleBlockInputBuffer.baseMain(argv, new TrickleBlockInputBuffer());
    }
}

