/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml.token;

import com.wm.lang.xml.Attribute;
import com.wm.lang.xml.AttributeDef;
import com.wm.lang.xml.token.EntityTable;
import com.wm.lang.xml.token.TokenException;
import com.wm.util.Name;
import java.io.IOException;

public final class TokenAttribute {
    public Name localName;
    public Name nsPrefix;
    public String value;
    public String notationValue;
    public Attribute actual;
    public TokenAttribute next;

    TokenAttribute() {
    }

    public TokenAttribute(Name nsPrefix, Name localName, String value) {
        this.nsPrefix = nsPrefix;
        this.localName = localName;
        this.value = value;
    }

    public TokenAttribute(Name nsPrefix, Name localName, String value, String notationValue) {
        this.nsPrefix = nsPrefix;
        this.localName = localName;
        this.value = value;
        this.notationValue = notationValue;
    }

    public TokenAttribute(TokenAttribute attr) {
        this.localName = attr.localName;
        this.nsPrefix = attr.nsPrefix;
        this.value = attr.value;
    }

    public TokenAttribute getClone() {
        TokenAttribute clone = new TokenAttribute();
        clone.localName = this.localName;
        clone.nsPrefix = this.nsPrefix;
        clone.value = this.value;
        clone.actual = this.actual;
        clone.next = null;
        return clone;
    }

    public void normalize(Name type, EntityTable entityTable, boolean expandGeneralEntities) throws IOException, TokenException {
        if (this.value != null) {
            boolean isCDATA = type == AttributeDef.TYPE_CDATA;
            String valueStr = EntityTable.expandString(this.value, entityTable, entityTable != null, expandGeneralEntities);
            if (!isCDATA) {
                valueStr = valueStr.trim();
            }
            int length = valueStr.length();
            StringBuffer sb = new StringBuffer(length);
            char ch = '\u0000';
            boolean prevWasSpace = false;
            boolean valueChanged = false;
            block5: for (int i = 0; i < length; ++i) {
                char prevCh = ch;
                ch = valueStr.charAt(i);
                switch (ch) {
                    case ' ': {
                        if (isCDATA || !prevWasSpace) {
                            prevWasSpace = true;
                            sb.append(' ');
                            continue block5;
                        }
                        valueChanged = true;
                        continue block5;
                    }
                    case '\t': 
                    case '\r': {
                        if (isCDATA || !prevWasSpace) {
                            prevWasSpace = true;
                            sb.append(' ');
                        }
                        valueChanged = true;
                        continue block5;
                    }
                    case '\n': {
                        if (prevCh != '\r' && (isCDATA || !prevWasSpace)) {
                            prevWasSpace = true;
                            sb.append(' ');
                        }
                        valueChanged = true;
                        continue block5;
                    }
                    default: {
                        prevWasSpace = false;
                        sb.append(ch);
                    }
                }
            }
            this.value = valueChanged ? sb.toString() : valueStr;
        }
    }
}

