/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml.token;

import com.wm.lang.xml.token.Entity;
import com.wm.lang.xml.token.EntityTable;
import com.wm.lang.xml.token.InputBuffer;
import com.wm.lang.xml.token.TokenException;
import com.wm.lang.xml.token.resources.TokenExceptionBundle;
import com.wm.util.List;
import com.wm.util.Name;
import java.io.IOException;

public class StringEntity
extends Entity {
    EntityTable entityTable;
    String unparsedValue;
    boolean parsed;
    List children;
    String expandedValue;
    char[] parseableValue;

    StringEntity(Name name, EntityTable entityTable, String unparsedValue) {
        super(name);
        this.entityTable = entityTable;
        this.unparsedValue = unparsedValue;
    }

    void addAsChild(List children) {
        children.addElement(this);
    }

    public String getExpandedValue() throws IOException, TokenException {
        if (this.expandedValue == null) {
            if (!this.parsed) {
                this.parse();
                this.validate();
            }
            if (this.expandedValue == null) {
                StringBuffer sb = new StringBuffer();
                this.append(sb);
                this.expandedValue = sb.toString();
            }
        }
        return this.expandedValue;
    }

    void write(InputBuffer buf) throws IOException, TokenException {
        if (this.parseableValue == null) {
            this.parseableValue = this.getExpandedValue().toCharArray();
        }
        buf.write(this.parseableValue, 0, this.parseableValue.length);
    }

    void parse() throws IOException, TokenException {
        this.children = this.parse(this.unparsedValue);
        this.parsed = true;
        if (this.children == null) {
            this.expandedValue = this.unparsedValue;
        }
    }

    List parse(String value) throws IOException, TokenException {
        int refIndex;
        char delim = '&';
        if (!this.entityTable.containsGEs()) {
            delim = '%';
        }
        if ((refIndex = value.indexOf(delim)) == -1) {
            return null;
        }
        int length = value.length();
        int currentIndex = 0;
        List children = new List();
        do {
            if (refIndex != currentIndex) {
                children.addElement(value.substring(currentIndex, refIndex));
            }
            if (++refIndex < length) {
                currentIndex = value.indexOf(59, refIndex);
                if (currentIndex != -1) {
                    String refNameStr = value.substring(refIndex, currentIndex);
                    int c = delim == '%' ? -1 : EntityTable.resolveCharRef(refNameStr);
                    if (c != -1) {
                        children.addElement(EntityTable.toString(c));
                    } else if (this.entityTable != null) {
                        Entity entity = this.entityTable.getEntity(Name.create(refNameStr));
                        if (entity != null) {
                            entity.addAsChild(children);
                        } else {
                            Object[] sArray = new String[]{String.valueOf(delim), refNameStr};
                            throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.CANNOT_RESOLVE_ENTITY, "", sArray);
                        }
                    }
                    refIndex = -1;
                    if (++currentIndex >= length) continue;
                    refIndex = value.indexOf(delim, currentIndex);
                    continue;
                }
                throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.INVALID_GE_REFERENCE, "");
            }
            currentIndex = refIndex - 1;
            refIndex = -1;
        } while (refIndex != -1 && refIndex < length);
        if (currentIndex != -1 && currentIndex < length) {
            children.addElement(value.substring(currentIndex, length));
        }
        return children;
    }

    void validate() throws IOException, TokenException {
        if (this.children != null) {
            List parentNames = new List();
            int childCount = this.children.size();
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                Object child = this.children.elementAt(childIndex);
                if (!(child instanceof StringEntity) || ((StringEntity)child).isValid(parentNames)) continue;
                String entityType = "GE ";
                if (!this.entityTable.containsGEs) {
                    entityType = "PE ";
                }
                Object[] geArray = new String[]{entityType, this.name.toString(), entityType, ((Entity)child).getName().toString()};
                throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.RECURSIVE_INCLUDE, "", geArray);
            }
        }
    }

    boolean isValid(List parentNames) throws IOException, TokenException {
        if (!this.parsed) {
            this.parse();
        }
        if (this.children != null) {
            int i;
            for (i = 0; i < parentNames.size(); ++i) {
                if (this.name != parentNames.elementAt(i)) continue;
                return false;
            }
            parentNames.addElement(this.name);
            for (i = 0; i < this.children.size(); ++i) {
                Object child = this.children.elementAt(i);
                if (!(child instanceof StringEntity) || ((StringEntity)child).isValid(parentNames)) continue;
                return false;
            }
            parentNames.removeElement(this.name);
        }
        return true;
    }

    void append(StringBuffer sb) {
        if (this.expandedValue != null) {
            sb.append(this.expandedValue);
        } else {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                Object child = this.children.elementAt(i);
                if (child instanceof String) {
                    sb.append((String)child);
                    continue;
                }
                ((StringEntity)child).append(sb);
            }
        }
    }
}

