/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml.token;

import com.wm.lang.xml.Document;
import com.wm.lang.xml.XmlName;
import com.wm.lang.xml.token.SourceBuffer;
import com.wm.lang.xml.token.Token;
import com.wm.lang.xml.token.TokenException;
import com.wm.lang.xml.token.TokenProcessor;
import com.wm.lang.xml.token.TokenSource;
import com.wm.lang.xml.token.TrickleBlockInputBuffer;
import com.wm.util.Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.crimson.parser.XmlReaderGetter;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public final class SaxTokenSource
implements TokenSource,
DocumentHandler,
EntityResolver {
    Token token = new Token();
    TokenProcessor tp;
    InputSource is;
    SourceBuffer buf = new TrickleBlockInputBuffer();
    int textOffset;
    XmlName xmlName = new XmlName();

    public SaxTokenSource(TokenProcessor tp, InputSource is, Parser parser) throws TokenException {
        this.tp = tp;
        this.is = is;
        tp.setTokenSource(this);
        parser.setDocumentHandler(this);
        parser.setEntityResolver(this);
        String baseURL = tp.getBaseURL();
        if (baseURL != null) {
            if (baseURL.indexOf(92) >= 0) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < baseURL.length(); ++i) {
                    char c = baseURL.charAt(i);
                    if (c == '\\') {
                        sb.append('/');
                        continue;
                    }
                    sb.append(c);
                }
                baseURL = sb.toString();
            }
            is.setSystemId(baseURL);
        }
        try {
            parser.parse(is);
        }
        catch (SAXException x) {
            Exception xx = x.getException();
            if (xx != null) {
                if (xx instanceof TokenException) {
                    throw (TokenException)xx;
                }
                throw new TokenException(xx.getMessage());
            }
            throw new TokenException("SAX: " + x.getMessage());
        }
        catch (IOException x) {
            throw new TokenException(x.getMessage());
        }
        this.buf.close();
    }

    public SourceBuffer getSourceBuffer() {
        return this.buf;
    }

    public Token nextToken() throws IOException, TokenException {
        return null;
    }

    public void close() {
        this.buf.close();
    }

    public void terminate() {
        this.close();
    }

    public String getSystemID() {
        return this.is.getSystemId();
    }

    public String getPublicID() {
        return this.is.getPublicId();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        this.token.clear();
        this.token.type = 0;
        this.xmlName.setName(name);
        this.token.nsPrefix = this.xmlName.nsPrefix;
        this.token.localName = this.xmlName.localName;
        if (atts != null && atts.getLength() != 0) {
            int attrIndex = atts.getLength();
            while (--attrIndex >= 0) {
                this.xmlName.setName(atts.getName(attrIndex));
                this.token.addAttribute(this.xmlName.nsPrefix, this.xmlName.localName, atts.getValue(attrIndex));
            }
        }
        try {
            this.tp.processNextToken(this.token);
        }
        catch (TokenException x) {
            throw new SAXException(x);
        }
        catch (IOException x) {
            throw new SAXException(x);
        }
    }

    public void endElement(String name) throws SAXException {
        this.token.clear();
        this.token.type = 4;
        this.xmlName.setName(name);
        this.token.nsPrefix = this.xmlName.nsPrefix;
        this.token.localName = this.xmlName.localName;
        try {
            this.tp.processNextToken(this.token);
        }
        catch (TokenException x) {
            throw new SAXException(x);
        }
        catch (IOException x) {
            throw new SAXException(x);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length > 0) {
            this.token.clear();
            this.token.type = 1;
            this.token.startTextOffset = this.textOffset;
            this.buf.write(ch, start, length);
            this.textOffset += length;
            this.token.endTextOffset = this.textOffset;
            try {
                this.tp.processNextToken(this.token);
            }
            catch (TokenException x) {
                throw new SAXException(x);
            }
            catch (IOException x) {
                throw new SAXException(x);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (length > 0) {
            this.token.clear();
            this.token.type = 1;
            this.token.startTextOffset = this.textOffset;
            this.buf.write(ch, start, length);
            this.textOffset += length;
            this.token.endTextOffset = this.textOffset;
            try {
                this.tp.processNextToken(this.token);
            }
            catch (TokenException x) {
                throw new SAXException(x);
            }
            catch (IOException x) {
                throw new SAXException(x);
            }
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.token.clear();
        this.token.type = 204;
        this.token.localName = Name.create(target);
        if (data != null && data.length() > 0) {
            this.token.startTextOffset = 0L;
            this.token.endTextOffset = data.length();
            this.token.text = data;
        } else {
            this.token.text = "";
        }
        try {
            this.tp.processNextToken(this.token);
        }
        catch (TokenException x) {
            throw new SAXException(x);
        }
        catch (IOException x) {
            throw new SAXException(x);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputStream is = Document.getHostServices().getInputStream(systemId);
        Reader reader = XmlReaderGetter.createReader(is);
        InputSource source = new InputSource(reader);
        source.setPublicId(publicId);
        source.setSystemId(systemId);
        return source;
    }
}

