/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml.token;

import com.wm.lang.xml.token.Token;
import com.wm.util.Name;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class HtmlType
implements Cloneable {
    private static Hashtable byType;
    private static Hashtable alsoAddAs;
    private static Hashtable convertTags;
    private static final Name para;
    public static final String docTag = "_DOCUMENT_";
    public static final String xmlTag = "_DXML_";
    public static final String htmlTag = "_DHTML_";
    public static HtmlType defHTML;
    public static HtmlType defXML;
    public static HtmlType docTAG;
    public Name name;
    public boolean isEmpty;
    public boolean isPretty;
    public boolean isStructural;
    public boolean allowPara;
    public boolean allowNest;
    public Name wantsParent;
    public String[] closeTags;
    public boolean isParagraph;
    public boolean squeeze;
    public Name urlAttribute;

    public HtmlType(Name name, boolean isEmpty, boolean isPretty, boolean isStructural, boolean allowNest, boolean allowPara, String closeTags, boolean squeeze) {
        this(name, isEmpty, isPretty, isStructural, allowNest, allowPara, HtmlType.parseCloseTags(closeTags), squeeze);
    }

    public HtmlType(Name name, boolean isEmpty, boolean isPretty, boolean isStructural, boolean allowNest, boolean allowPara, String[] closeTags, boolean squeeze) {
        this.isParagraph = name == para;
        this.name = name;
        this.isEmpty = isEmpty;
        this.isPretty = isPretty;
        this.isStructural = isStructural;
        this.allowNest = allowNest;
        this.allowPara = allowPara;
        this.squeeze = squeeze;
        this.closeTags = closeTags;
    }

    public static Name getAlsoAddAs(Name tag) {
        if (tag == null) {
            return null;
        }
        return (Name)alsoAddAs.get(tag);
    }

    static String[] parseCloseTags(String tagString) {
        StringTokenizer st = new StringTokenizer(tagString);
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            if (next.equals("")) continue;
            v.addElement(next);
        }
        Object[] closeTags = new String[v.size()];
        v.copyInto(closeTags);
        return closeTags;
    }

    public static synchronized HtmlType addType(HtmlType t) {
        byType.put(t.name, t);
        return t;
    }

    public static HtmlType getType(String name) {
        return (HtmlType)byType.get(Name.create(name));
    }

    public static HtmlType getType(Name name) {
        HtmlType type = null;
        if (name != null && (type = (HtmlType)byType.get(name)) != null) {
            return type;
        }
        try {
            type = (HtmlType)defHTML.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        if (name != null) {
            type.name = name;
        }
        return HtmlType.addType(type);
    }

    public boolean willEndTag(Token tag, HtmlType htmlType) {
        boolean isEnd;
        boolean bl = isEnd = tag.type == 4;
        if (this.isParagraph && isEnd) {
            return true;
        }
        if (this.name == tag.localName && (!this.allowNest || isEnd)) {
            return true;
        }
        if (!(!this.isPretty || this.isStructural || htmlType.isPretty && !htmlType.isStructural || htmlType.isEmpty)) {
            return true;
        }
        if (this.closeTags.length > 0 && tag.localName != null) {
            String match = new String((isEnd ? "/" : "") + tag.localName.toString());
            for (int i = 0; i < this.closeTags.length; ++i) {
                if (this.closeTags[i].equals(match)) {
                    return true;
                }
                if (isEnd && this.closeTags[i].equals("/*")) {
                    return true;
                }
                if (!this.closeTags[i].equals("*")) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static Name equivalent(String t) {
        Name name = Name.create(t);
        Name equiv = (Name)convertTags.get(name);
        return equiv == null ? name : equiv;
    }

    private static void initialize() {
        String[][] convert = new String[][]{{"DOC", docTag}, {"DOCUMENT", docTag}, {"IMAGE", "IMG"}, {"ANCHOR", "A"}, {"PARA", "P"}, {"ITEM", "LI"}, {"LINKS", "LINK"}, {"LISTS", "LIST"}, {"INPUTS", "INPUT"}, {"ITEMS", "LI"}, {"HEADINGS", "HEADING"}, {"TABLES", "TABLE"}, {"FORMS", "FORM"}, {"IMAGES", "IMG"}, {"ANCHORS", "A"}, {"PARAS", "P"}};
        convertTags = new Hashtable(convert.length);
        for (int i = 0; i < convert.length; ++i) {
            convertTags.put(Name.create(convert[i][0]), Name.create(convert[i][1]));
        }
        String[][] known = new String[][]{{htmlTag, "0", "0", "0", "0", "1", ""}, {xmlTag, "1", "0", "0", "0", "1", ""}, {docTag, "1", "0", "0", "1", "1", ""}, {"OBJECT", "1", "0", "0", "1", "1", ""}, {"LAYER", "1", "0", "0", "1", "1", ""}, {"LABEL", "1", "0", "0", "1", "1", ""}, {"TBODY", "1", "0", "0", "1", "1", ""}, {"!--", "0", "0", "0", "0", "1", ""}, {"A", "1", "2", "0", "0", "1", "TH /TH TD /TD TR /TR TABLE /TABLE"}, {"ADDRESS", "1", "0", "0", "0", "1", ""}, {"APPLET", "1", "0", "0", "0", "1", ""}, {"AREA", "0", "0", "0", "0", "1", ""}, {"B", "1", "1", "0", "0", "1", ""}, {"BASE", "0", "0", "0", "0", "1", ""}, {"BASEFONT", "0", "0", "0", "0", "1", ""}, {"BIG", "1", "1", "0", "0", "1", ""}, {"BLOCKQUOTE", "1", "1", "0", "0", "1", ""}, {"BODY", "1", "2", "0", "1", "1", ""}, {"BR", "0", "0", "0", "0", "1", ""}, {"CENTER", "1", "1", "0", "0", "1", ""}, {"CITE", "1", "2", "0", "0", "1", ""}, {"CODE", "1", "1", "0", "0", "1", ""}, {"DFN", "1", "1", "0", "0", "1", ""}, {"DL", "1", "0", "1", "0", "1", ""}, {"DIV", "1", "0", "1", "1", "1", ""}, {"EM", "1", "1", "0", "0", "1", ""}, {"FONT", "1", "2", "0", "1", "1", "TH /TH TD /TD TR /TR TABLE /TABLE LI /LI /A"}, {"FORM", "1", "0", "0", "0", "1", ""}, {"FRAME", "0", "0", "0", "0", "1", ""}, {"FRAMESET", "1", "0", "0", "0", "1", ""}, {"H1", "1", "1", "0", "0", "1", ""}, {"H2", "1", "1", "0", "0", "1", ""}, {"H3", "1", "1", "0", "0", "1", ""}, {"H4", "1", "1", "0", "0", "1", ""}, {"H5", "1", "1", "0", "0", "1", ""}, {"H6", "1", "1", "0", "0", "1", ""}, {"HEAD", "1", "0", "0", "0", "1", ""}, {"HR", "0", "0", "0", "0", "1", ""}, {"HTML", "1", "2", "0", "1", "1", ""}, {"I", "1", "1", "0", "0", "1", ""}, {"IMG", "0", "0", "0", "0", "1", ""}, {"ISINDEX", "0", "0", "0", "0", "1", ""}, {"KBD", "1", "1", "0", "0", "1", ""}, {"LINK", "0", "0", "0", "0", "1", ""}, {"MAP", "1", "0", "0", "0", "1", ""}, {"META", "0", "0", "0", "0", "1", ""}, {"NOBR", "1", "1", "0", "0", "1", ""}, {"OL", "1", "0", "1", "0", "1", ""}, {"P", "1", "2", "0", "1", "1", "PRE LI TD TH DD /*"}, {"PARAM", "0", "0", "0", "0", "1", ""}, {"PRE", "1", "2", "0", "0", "0", "TH /TH TD /TD TR /TR /TABLE"}, {"S", "1", "1", "0", "0", "1", "/STRONG"}, {"SAMP", "1", "1", "0", "0", "1", ""}, {"SMALL", "1", "1", "0", "0", "1", ""}, {"SUB", "1", "1", "0", "0", "1", ""}, {"SUP", "1", "1", "0", "0", "1", ""}, {"SCRIPT", "1", "0", "0", "0", "0", ""}, {"STRIKE", "1", "1", "0", "0", "1", ""}, {"STRONG", "1", "1", "0", "0", "1", "/S"}, {"STYLE", "1", "1", "0", "0", "1", ""}, {"TABLE", "1", "0", "1", "0", "1", ""}, {"TITLE", "1", "0", "0", "0", "1", ""}, {"TT", "1", "1", "0", "0", "1", ""}, {"U", "1", "1", "0", "0", "1", ""}, {"UL", "1", "0", "1", "0", "1", ""}, {"VAR", "1", "1", "0", "0", "1", ""}, {"INPUT", "0", "0", "0", "0", "1", ""}, {"SELECT", "1", "0", "0", "1", "1", ""}, {"OPTION", "1", "0", "0", "0", "1", "/SELECT"}, {"TEXTAREA", "1", "0", "0", "1", "1", ""}, {"TR", "1", "2", "0", "1", "1", "/TABLE"}, {"TD", "1", "2", "0", "1", "1", "/TABLE TR /TR TH /TH"}, {"TH", "1", "2", "0", "1", "1", "/TABLE TR /TR TD /TD"}, {"LI", "1", "0", "0", "1", "1", "UL /UL OL /OL TR /TR TH /TH TD /TD /TABLE"}, {"DD", "1", "0", "0", "0", "1", "/DL DT /DT"}, {"DT", "1", "0", "0", "0", "1", "/DL DD /DD"}, {"LINE", "1", "2", "0", "0", "1", ""}, {"SEC-DOCUMENT", "1", "0", "0", "0", "1", ""}};
        byType = new Hashtable(known.length);
        for (int i = 0; i < known.length; ++i) {
            HtmlType.addType(new HtmlType(Name.create(known[i][0]), !known[i][1].equals("1"), !known[i][2].equals("0"), known[i][2].equals("2"), known[i][3].equals("1"), known[i][4].equals("1"), known[i][6], known[i][5].equals("1")));
        }
        HtmlType.getType((String)"A").urlAttribute = Name.create("HREF");
        HtmlType.getType((String)"IMG").urlAttribute = Name.create("SRC");
        HtmlType.getType((String)"FRAME").urlAttribute = Name.create("SRC");
        HtmlType.getType((String)"FORM").urlAttribute = Name.create("ACTION");
        HtmlType.getType((String)"INPUT").urlAttribute = Name.create("SRC");
        HtmlType.getType((String)"TABLE").urlAttribute = Name.create("BACKGROUND");
        HtmlType.getType((String)"TD").urlAttribute = Name.create("BACKGROUND");
        HtmlType.getType((String)"TH").urlAttribute = Name.create("BACKGROUND");
        HtmlType.getType((String)"BODY").urlAttribute = Name.create("BACKGROUND");
        HtmlType.getType((String)"AREA").urlAttribute = Name.create("HREF");
        HtmlType.getType((String)"SCRIPT").urlAttribute = Name.create("SRC");
        HtmlType.getType((String)"BLOCKQUOTE").urlAttribute = Name.create("CITE");
        HtmlType.getType((String)"A").urlAttribute = Name.create("HREF");
        HtmlType.getType((String)"LINK").urlAttribute = Name.create("HREF");
        HtmlType.getType((String)"HEAD").urlAttribute = Name.create("PROFILE");
        HtmlType.getType((String)"BASE").urlAttribute = Name.create("HREF");
        HtmlType.getType((String)"INPUT").wantsParent = Name.create("FORM");
        HtmlType.getType((String)"SELECT").wantsParent = Name.create("FORM");
        HtmlType.getType((String)"TEXTAREA").wantsParent = Name.create("FORM");
        defHTML = HtmlType.getType(htmlTag);
        defXML = HtmlType.getType(xmlTag);
        docTAG = HtmlType.getType(docTag);
        String[][] alsoDumpAs = new String[][]{{"OL", "LIST"}, {"UL", "LIST"}, {"H1", "HEADING"}, {"H2", "HEADING"}, {"H3", "HEADING"}, {"H4", "HEADING"}, {"H5", "HEADING"}, {"H6", "HEADING"}};
        alsoAddAs = new Hashtable(alsoDumpAs.length);
        for (int i = 0; i < alsoDumpAs.length; ++i) {
            alsoAddAs.put(Name.create(alsoDumpAs[i][0]), Name.create(alsoDumpAs[i][1]));
        }
    }

    public String toString() {
        return "<" + this.name + ":" + this.isEmpty + ":" + this.isPretty + ">";
    }

    static {
        HtmlType.initialize();
        para = Name.create("P");
        HtmlType.initialize();
    }
}

