/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml.token;

import com.wm.lang.xml.Document;
import com.wm.lang.xml.XmlUtil;
import com.wm.lang.xml.token.Entity;
import com.wm.lang.xml.token.ExternalID;
import com.wm.lang.xml.token.InputBuffer;
import com.wm.lang.xml.token.TokenException;
import com.wm.lang.xml.token.WmDocReader;
import com.wm.lang.xml.token.resources.TokenExceptionBundle;
import com.wm.util.List;
import com.wm.util.Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.crimson.parser.XmlReaderGetter;

public class ExternalEntity
extends Entity {
    static final int BLOCK_SIZE = 8192;
    ExternalID externalID;
    boolean alreadyIncluded;
    String notation;
    static final String PROPERTY_READER = "watt.core.xmlreader";
    static final int UXR_UNKNOWN = 0;
    static final int UXR_WM = 1;
    static final int UXR_SUN = 2;
    static int useXmlReader = 0;

    ExternalEntity(Name name, ExternalID externalID) {
        super(name);
        this.externalID = externalID;
    }

    ExternalEntity(Name name, ExternalID externalID, String ndata) {
        super(name);
        this.externalID = externalID;
        this.notation = ndata;
    }

    void addAsChild(List children) throws TokenException {
        throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.NOT_SUPPORT_REF_EXT_ENTITIES, "", this.name.toString());
    }

    public String getExpandedValue() throws IOException, TokenException {
        throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.NOT_SUPPORT_EXT_GENERAL_ENTITIES, "", this.name.toString());
    }

    public String getSystemID() {
        return this.externalID.systemID;
    }

    public String getPublicID() {
        return this.externalID.publicID;
    }

    public String getNotationName() {
        return this.notation;
    }

    void write(InputBuffer buf) throws IOException, TokenException {
        buf.truncate();
        if (!this.alreadyIncluded) {
            Reader reader;
            String encoding = XmlUtil.getEncodingJavaName(Document.getHostServices().getInputStream(this.externalID.systemID));
            if (encoding.equalsIgnoreCase("UTF8")) {
                encoding = null;
            }
            InputStream is = Document.getHostServices().getInputStream(this.externalID.systemID);
            if (ExternalEntity.useSunReader()) {
                reader = XmlReaderGetter.createReader(is);
            } else {
                WmDocReader wmReader = WmDocReader.create(is, this.externalID.systemID, encoding);
                wmReader.allowTranscoding(false);
                reader = wmReader;
            }
            buf.pushReader(reader);
            this.alreadyIncluded = true;
        }
    }

    static boolean useSunReader() {
        if (useXmlReader == 0) {
            String p = System.getProperty(PROPERTY_READER);
            useXmlReader = p != null && p.equals("sun") ? 2 : 1;
        }
        return useXmlReader == 2;
    }
}

