/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml.token;

import com.wm.lang.xml.token.CharacterEntity;
import com.wm.lang.xml.token.Entity;
import com.wm.lang.xml.token.TokenException;
import com.wm.util.Name;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;

public final class EntityTable {
    static final Name NAME_AMP = Name.create("amp");
    static final Name NAME_LT = Name.create("lt");
    static final Name NAME_GT = Name.create("gt");
    static final Name NAME_QUOT = Name.create("quot");
    static final Name NAME_APOS = Name.create("apos");
    static final CharacterEntity CHAR_AMP = new CharacterEntity(NAME_AMP, 38);
    static final CharacterEntity CHAR_LT = new CharacterEntity(NAME_LT, 60);
    static final CharacterEntity CHAR_GT = new CharacterEntity(NAME_GT, 62);
    static final CharacterEntity CHAR_QUOT = new CharacterEntity(NAME_QUOT, 34);
    static final CharacterEntity CHAR_APOS = new CharacterEntity(NAME_APOS, 39);
    static final int CHAR_TABLE_SIZE = 256;
    static Character[] charTable;
    static String[] charAsStringTable;
    static Hashtable htmlEntities;
    boolean containsGEs;
    Hashtable entities;
    static Hashtable xmlGEs;

    EntityTable(boolean containsGEs) {
        this.containsGEs = containsGEs;
        if (containsGEs) {
            if (xmlGEs == null) {
                xmlGEs = new Hashtable();
                xmlGEs.put(NAME_AMP, CHAR_AMP);
                xmlGEs.put(NAME_LT, CHAR_LT);
                xmlGEs.put(NAME_GT, CHAR_GT);
                xmlGEs.put(NAME_QUOT, CHAR_QUOT);
                xmlGEs.put(NAME_APOS, CHAR_APOS);
            }
            this.entities = (Hashtable)xmlGEs.clone();
        } else {
            this.entities = new Hashtable();
        }
    }

    boolean containsGEs() {
        return this.containsGEs;
    }

    void addEntity(Entity entity) {
        if (this.entities.get(entity.getName()) == null) {
            this.entities.put(entity.getName(), entity);
        }
    }

    public Entity getEntity(Name name) {
        return (Entity)this.entities.get(name);
    }

    public Entity[] getEntities() {
        Collection values = this.entities.values();
        Entity[] ents = (Entity[])values.toArray();
        return ents;
    }

    public int getSize() {
        return this.entities.size();
    }

    String resolveRef(String ref, boolean expandGeneralEntities) throws IOException, TokenException {
        int c = EntityTable.resolveCharRef(ref);
        if (c != -1) {
            return EntityTable.toString(c);
        }
        if (ref.length() > 0) {
            Name refName = Name.create(ref);
            if (expandGeneralEntities) {
                Entity entity = this.getEntity(Name.create(ref));
                if (entity != null) {
                    return entity.getExpandedValue();
                }
            } else {
                Entity entity = (Entity)xmlGEs.get(refName);
                if (entity != null) {
                    return entity.getExpandedValue();
                }
            }
        }
        return null;
    }

    static String expandString(String s, EntityTable entityTable, boolean isXmlElseHtml, boolean expandGeneralEntities) throws IOException, TokenException {
        int to;
        int from = s.indexOf(38);
        if (from < 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        if (from > 0) {
            to = 0;
            while (to < from) {
                sb.append(s.charAt(to++));
            }
        }
        do {
            int c;
            if ((to = s.indexOf(59, from)) < 0) continue;
            String ref = s.substring(from + 1, to);
            if (entityTable != null) {
                c = -1;
                String value = entityTable.resolveRef(ref, expandGeneralEntities);
                if (value != null) {
                    sb.append(value);
                    c = 0;
                }
            } else {
                c = isXmlElseHtml ? EntityTable.resolveCharRef(ref) : EntityTable.resolveHtmlRef(ref);
                if (c != -1) {
                    sb.append(c);
                }
            }
            if (c == -1) {
                sb.append('&');
                sb.append(ref);
                sb.append(';');
            }
            if ((from = s.indexOf(38, to)) <= to) continue;
            while (++to < from) {
                sb.append(s.charAt(to));
            }
        } while (to >= 0 && from >= 0);
        if (from < 0) {
            from = to + 1;
        }
        if (from >= 0) {
            while (from < len) {
                sb.append(s.charAt(from++));
            }
        }
        return sb.toString();
    }

    public static String getXmlString(String s, boolean isAttributeValue) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = null;
        int from = 0;
        int length = s.length();
        while (from < length) {
            String escape = null;
            int to = from;
            while (to < length && escape == null) {
                char ch = s.charAt(to);
                if (ch == '&') {
                    escape = "&amp;";
                    continue;
                }
                if (ch == '<') {
                    escape = "&lt;";
                    continue;
                }
                if (ch == '>') {
                    escape = "&gt;";
                    continue;
                }
                if (ch == '\"' && isAttributeValue) {
                    escape = "&quot;";
                    continue;
                }
                ++to;
            }
            if (to == from) {
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append(escape);
            } else if (escape != null) {
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append(s.substring(from, to));
                sb.append(escape);
            } else {
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append(s.substring(from, to));
            }
            from = to + 1;
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }

    static int resolveCharRef(String ref) {
        block5: {
            if (ref.length() >= 2 && ref.charAt(0) == '#') {
                try {
                    if (ref.charAt(1) == 'x') {
                        if (ref.length() >= 3) {
                            return Integer.parseInt(ref.substring(2), 16);
                        }
                        break block5;
                    }
                    return Integer.parseInt(ref.substring(1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return -1;
    }

    static int resolveHtmlRef(String ref) {
        int c = EntityTable.resolveCharRef(ref);
        if (c != -1) {
            return c;
        }
        if (ref.length() > 0) {
            Character ch;
            if (htmlEntities == null) {
                EntityTable.initClass();
            }
            if ((ch = (Character)htmlEntities.get(Name.create(ref))) != null) {
                return ch.charValue();
            }
        }
        return -1;
    }

    static void initClass() {
        charTable = new Character[256];
        charAsStringTable = new String[256];
        for (int i = 0; i < 256; ++i) {
            Character c;
            EntityTable.charTable[i] = c = new Character((char)i);
            EntityTable.charAsStringTable[i] = c.toString();
        }
        htmlEntities = new Hashtable();
        htmlEntities.put(Name.create("sp"), EntityTable.toChar(32));
        htmlEntities.put(Name.create("apos"), EntityTable.toChar(39));
        htmlEntities.put(Name.create("quot"), EntityTable.toChar(34));
        htmlEntities.put(Name.create("amp"), EntityTable.toChar(38));
        htmlEntities.put(Name.create("lt"), EntityTable.toChar(60));
        htmlEntities.put(Name.create("gt"), EntityTable.toChar(62));
        htmlEntities.put(Name.create("nbsp"), EntityTable.toChar(160));
        htmlEntities.put(Name.create("iexcl"), EntityTable.toChar(161));
        htmlEntities.put(Name.create("cent"), EntityTable.toChar(162));
        htmlEntities.put(Name.create("pound"), EntityTable.toChar(163));
        htmlEntities.put(Name.create("curren"), EntityTable.toChar(164));
        htmlEntities.put(Name.create("yen"), EntityTable.toChar(165));
        htmlEntities.put(Name.create("brvbar"), EntityTable.toChar(166));
        htmlEntities.put(Name.create("sect"), EntityTable.toChar(167));
        htmlEntities.put(Name.create("uml"), EntityTable.toChar(168));
        htmlEntities.put(Name.create("copy"), EntityTable.toChar(169));
        htmlEntities.put(Name.create("ordf"), EntityTable.toChar(170));
        htmlEntities.put(Name.create("laquo"), EntityTable.toChar(171));
        htmlEntities.put(Name.create("not"), EntityTable.toChar(172));
        htmlEntities.put(Name.create("shy"), EntityTable.toChar(173));
        htmlEntities.put(Name.create("reg"), EntityTable.toChar(174));
        htmlEntities.put(Name.create("macr"), EntityTable.toChar(175));
        htmlEntities.put(Name.create("deg"), EntityTable.toChar(176));
        htmlEntities.put(Name.create("plusmn"), EntityTable.toChar(177));
        htmlEntities.put(Name.create("sup2"), EntityTable.toChar(178));
        htmlEntities.put(Name.create("sup3"), EntityTable.toChar(179));
        htmlEntities.put(Name.create("acute"), EntityTable.toChar(180));
        htmlEntities.put(Name.create("micro"), EntityTable.toChar(181));
        htmlEntities.put(Name.create("para"), EntityTable.toChar(182));
        htmlEntities.put(Name.create("middot"), EntityTable.toChar(183));
        htmlEntities.put(Name.create("cedil"), EntityTable.toChar(184));
        htmlEntities.put(Name.create("sup1"), EntityTable.toChar(185));
        htmlEntities.put(Name.create("ordm"), EntityTable.toChar(186));
        htmlEntities.put(Name.create("raquo"), EntityTable.toChar(187));
        htmlEntities.put(Name.create("frac14"), EntityTable.toChar(188));
        htmlEntities.put(Name.create("frac12"), EntityTable.toChar(189));
        htmlEntities.put(Name.create("frac34"), EntityTable.toChar(190));
        htmlEntities.put(Name.create("iquest"), EntityTable.toChar(191));
        htmlEntities.put(Name.create("Agrave"), EntityTable.toChar(192));
        htmlEntities.put(Name.create("Aacute"), EntityTable.toChar(193));
        htmlEntities.put(Name.create("Acirc"), EntityTable.toChar(194));
        htmlEntities.put(Name.create("Atilde"), EntityTable.toChar(195));
        htmlEntities.put(Name.create("Auml"), EntityTable.toChar(196));
        htmlEntities.put(Name.create("Aring"), EntityTable.toChar(197));
        htmlEntities.put(Name.create("AElig"), EntityTable.toChar(198));
        htmlEntities.put(Name.create("Ccedil"), EntityTable.toChar(199));
        htmlEntities.put(Name.create("Egrave"), EntityTable.toChar(200));
        htmlEntities.put(Name.create("Eacute"), EntityTable.toChar(201));
        htmlEntities.put(Name.create("Ecirc"), EntityTable.toChar(202));
        htmlEntities.put(Name.create("Euml"), EntityTable.toChar(203));
        htmlEntities.put(Name.create("Igrave"), EntityTable.toChar(204));
        htmlEntities.put(Name.create("Iacute"), EntityTable.toChar(205));
        htmlEntities.put(Name.create("Icirc"), EntityTable.toChar(206));
        htmlEntities.put(Name.create("Iuml"), EntityTable.toChar(207));
        htmlEntities.put(Name.create("ETH"), EntityTable.toChar(208));
        htmlEntities.put(Name.create("Ntilde"), EntityTable.toChar(209));
        htmlEntities.put(Name.create("Ograve"), EntityTable.toChar(210));
        htmlEntities.put(Name.create("Oacute"), EntityTable.toChar(211));
        htmlEntities.put(Name.create("Ocirc"), EntityTable.toChar(212));
        htmlEntities.put(Name.create("Otilde"), EntityTable.toChar(213));
        htmlEntities.put(Name.create("Ouml"), EntityTable.toChar(214));
        htmlEntities.put(Name.create("times"), EntityTable.toChar(215));
        htmlEntities.put(Name.create("Oslash"), EntityTable.toChar(216));
        htmlEntities.put(Name.create("Ugrave"), EntityTable.toChar(217));
        htmlEntities.put(Name.create("Uacute"), EntityTable.toChar(218));
        htmlEntities.put(Name.create("Ucirc"), EntityTable.toChar(219));
        htmlEntities.put(Name.create("Uuml"), EntityTable.toChar(220));
        htmlEntities.put(Name.create("Yacute"), EntityTable.toChar(221));
        htmlEntities.put(Name.create("THORN"), EntityTable.toChar(222));
        htmlEntities.put(Name.create("szlig"), EntityTable.toChar(223));
        htmlEntities.put(Name.create("agrave"), EntityTable.toChar(224));
        htmlEntities.put(Name.create("aacute"), EntityTable.toChar(225));
        htmlEntities.put(Name.create("acirc"), EntityTable.toChar(226));
        htmlEntities.put(Name.create("atilde"), EntityTable.toChar(227));
        htmlEntities.put(Name.create("auml"), EntityTable.toChar(228));
        htmlEntities.put(Name.create("aring"), EntityTable.toChar(229));
        htmlEntities.put(Name.create("aelig"), EntityTable.toChar(230));
        htmlEntities.put(Name.create("ccedil"), EntityTable.toChar(231));
        htmlEntities.put(Name.create("egrave"), EntityTable.toChar(232));
        htmlEntities.put(Name.create("eacute"), EntityTable.toChar(233));
        htmlEntities.put(Name.create("ecirc"), EntityTable.toChar(234));
        htmlEntities.put(Name.create("euml"), EntityTable.toChar(235));
        htmlEntities.put(Name.create("igrave"), EntityTable.toChar(236));
        htmlEntities.put(Name.create("iacute"), EntityTable.toChar(237));
        htmlEntities.put(Name.create("icirc"), EntityTable.toChar(238));
        htmlEntities.put(Name.create("iuml"), EntityTable.toChar(239));
        htmlEntities.put(Name.create("eth"), EntityTable.toChar(240));
        htmlEntities.put(Name.create("ntilde"), EntityTable.toChar(241));
        htmlEntities.put(Name.create("ograve"), EntityTable.toChar(242));
        htmlEntities.put(Name.create("oacute"), EntityTable.toChar(243));
        htmlEntities.put(Name.create("ocirc"), EntityTable.toChar(244));
        htmlEntities.put(Name.create("otilde"), EntityTable.toChar(245));
        htmlEntities.put(Name.create("ouml"), EntityTable.toChar(246));
        htmlEntities.put(Name.create("divide"), EntityTable.toChar(247));
        htmlEntities.put(Name.create("oslash"), EntityTable.toChar(248));
        htmlEntities.put(Name.create("ugrave"), EntityTable.toChar(249));
        htmlEntities.put(Name.create("uacute"), EntityTable.toChar(250));
        htmlEntities.put(Name.create("ucirc"), EntityTable.toChar(251));
        htmlEntities.put(Name.create("uuml"), EntityTable.toChar(252));
        htmlEntities.put(Name.create("yacute"), EntityTable.toChar(253));
        htmlEntities.put(Name.create("thorn"), EntityTable.toChar(254));
        htmlEntities.put(Name.create("yuml"), EntityTable.toChar(255));
    }

    static Character toChar(int c) {
        if (charTable == null) {
            EntityTable.initClass();
        }
        if (c < 256) {
            return charTable[c];
        }
        return new Character((char)c);
    }

    static String toString(int c) {
        if (charAsStringTable == null) {
            EntityTable.initClass();
        }
        if (c < 256) {
            return charAsStringTable[c];
        }
        return new Character((char)c).toString();
    }
}

