/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml.token;

import com.wm.lang.xml.token.BlockInputBuffer;
import com.wm.lang.xml.token.InputBuffer;
import com.wm.lang.xml.token.resources.TokenCharConversionExceptionBundle;
import com.wm.util.EncUtil;
import com.wm.util.JournalLogger;
import com.wm.util.LocalizedCharConversionException;
import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public final class BurstBlockInputBuffer
extends BlockInputBuffer {
    static final int XML0001 = 1;
    static final int XMLPARSER002 = 2;

    public BurstBlockInputBuffer() {
    }

    public BurstBlockInputBuffer(Reader reader) {
        this.reader = reader;
    }

    public BurstBlockInputBuffer(InputStream stream) {
        this(stream, EncUtil.getFileEncoding());
    }

    public BurstBlockInputBuffer(InputStream stream, String encoding) {
        try {
            this.reader = new InputStreamReader((InputStream)new BufferedInputStream(stream), encoding);
        }
        catch (UnsupportedEncodingException e) {
            JournalLogger.logError(2, 42, encoding);
            this.reader = new InputStreamReader(stream);
        }
    }

    public void write(String source) {
    }

    public void write(char[] source, int startOffset, int length) {
        if (length != 0) {
            if (this.lastBlockNumber == -1) {
                this.block = new char[8192];
                this.blockList.addElement(this.block);
                this.blockNumber = 0;
                this.blockStartPos = 0L;
                this.position = 0;
                this.lastBlockNumber = 0;
                this.lastBlockSize = 8192;
                this.blockStartPos = 0L;
            }
            if (this.position + length <= 8192) {
                if (length == 1) {
                    this.block[this.position++] = source[0];
                } else {
                    System.arraycopy(source, startOffset, this.block, this.position, length);
                    this.position += length;
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    if (this.position == 8192) {
                        this.block = new char[8192];
                        this.blockList.addElement(this.block);
                        this.position = 0;
                        this.blockNumber = ++this.lastBlockNumber;
                        this.blockStartPos += 8192L;
                    }
                    this.block[this.position++] = source[startOffset++];
                }
            }
        }
    }

    public void pushReader(Reader reader) {
    }

    public void overwrite(char c) {
    }

    public final int getNext() throws IOException {
        block14: {
            if (this.blockNumber < this.lastBlockNumber) {
                if (++this.position < 8192) {
                    return this.block[this.position];
                }
                this.block = (char[])this.blockList.elementAt(++this.blockNumber);
                this.position = 0;
                this.blockStartPos += 8192L;
                return this.block[0];
            }
            if (++this.position < this.lastBlockSize) {
                return this.block[this.position];
            }
            if (this.reader == null) {
                --this.position;
                return -1;
            }
            this.block = new char[8192];
            try {
                int bytesRead;
                this.lastBlockSize = this.reader.read(this.block);
                if (this.lastBlockSize == 8192 || this.lastBlockSize == -1) break block14;
                while ((bytesRead = this.reader.read(this.block, this.lastBlockSize, 8192 - this.lastBlockSize)) != -1) {
                    this.lastBlockSize += bytesRead;
                    if (this.lastBlockSize != 8192) continue;
                    break;
                }
            }
            catch (CharConversionException e) {
                if (this.blockNumber != -1) {
                    this.block = (char[])this.blockList.elementAt(this.blockNumber);
                    --this.position;
                }
                this.close();
                throw new LocalizedCharConversionException(TokenCharConversionExceptionBundle.class, TokenCharConversionExceptionBundle.INCORRECT_CHAR_ENCODING, "", e.getMessage());
            }
            catch (IOException e) {
                if (JournalLogger.isLogEnabledDebug(1, 42)) {
                    JournalLogger.logDebug(1, 42, e.getMessage());
                }
                if (this.blockNumber != -1) {
                    this.block = (char[])this.blockList.elementAt(this.blockNumber);
                    --this.position;
                }
                this.close();
                return -1;
            }
        }
        if (this.lastBlockSize <= 0) {
            if (this.blockNumber >= 0) {
                this.block = (char[])this.blockList.elementAt(this.blockNumber);
            }
            this.lastBlockNumber = this.blockNumber;
            this.lastBlockSize = 8192;
            this.close();
            --this.position;
            return -1;
        }
        this.blockList.addElement(this.block);
        ++this.blockNumber;
        ++this.lastBlockNumber;
        this.position = 0;
        this.blockStartPos += 8192L;
        if (this.lastBlockSize != 8192) {
            this.close();
        }
        return this.block[0];
    }

    public void truncate() {
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reader = null;
    }

    InputBuffer createLikeInstance(Reader reader) {
        return new BurstBlockInputBuffer(reader);
    }

    public static void main(String[] argv) throws IOException {
        BurstBlockInputBuffer.baseMain(argv, new BurstBlockInputBuffer());
    }
}

