/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml.token;

import com.wm.lang.xml.token.InputBuffer;
import com.wm.lang.xml.token.WmDocReader;
import com.wm.util.List;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public abstract class BlockInputBuffer
implements InputBuffer {
    static final int BLOCK_SIZE = 8192;
    static final int BLOCK_SIZE_POW2 = 13;
    static final int INITIAL_CAPACITY = 32;
    static char[] purgeBlock = null;
    static final String purgeText = "*PURGED*";
    Reader reader;
    List blockList = new List(32);
    int lastBlockNumber = -1;
    int lastBlockSize;
    int totalSize = -1;
    int purgedBlockCount;
    char[] block;
    int blockNumber = -1;
    long blockStartPos = -8192L;
    int position = -1;
    char[] markBlock;
    int markBlockNumber;
    long markBlockStartPos;
    int markPosition;

    public char getChar(long i) {
        int targetBlockNumber = (int)(i >> 13);
        int targetPosition = (int)(i & 0x1FFFL);
        return ((char[])this.blockList.elementAt(targetBlockNumber))[targetPosition];
    }

    public String getString(long start, long end) {
        return this.getOrAppendString(null, start, end);
    }

    public void appendString(StringBuffer sb, long start, long end) {
        this.getOrAppendString(sb, start, end);
    }

    public void purge(long beforeOffset) {
        if (beforeOffset <= 0L || this.lastBlockNumber < 0) {
            return;
        }
        int beforeBlockNumber = (int)(beforeOffset >> 13);
        if (beforeBlockNumber > this.lastBlockNumber) {
            beforeBlockNumber = this.lastBlockNumber + 1;
            if (this.lastBlockSize != 8192) {
                --beforeBlockNumber;
            }
        }
        if (beforeBlockNumber <= this.purgedBlockCount) {
            return;
        }
        if (purgeBlock == null) {
            purgeBlock = new char[8192];
            int maxj = purgeText.length();
            int j = 0;
            for (int i = 0; i < 8192; ++i) {
                BlockInputBuffer.purgeBlock[i] = purgeText.charAt(j);
                if (++j != maxj) continue;
                j = 0;
            }
        }
        while (this.purgedBlockCount < beforeBlockNumber) {
            this.blockList.setElementAt(purgeBlock, this.purgedBlockCount++);
        }
    }

    public int size() {
        if (this.totalSize < 0 && this.lastBlockNumber >= 0) {
            this.totalSize = (this.lastBlockNumber << 13) + this.lastBlockSize;
        }
        return this.totalSize;
    }

    public long getPosition() {
        return this.blockStartPos + (long)this.position;
    }

    public int getLast() {
        if (this.position > 0) {
            return this.block[this.position - 1];
        }
        if (this.blockNumber > 0) {
            return ((char[])this.blockList.elementAt(this.blockNumber - 1))[8191];
        }
        return -1;
    }

    public int getCurrent() {
        if (this.position >= 0) {
            return this.block[this.position];
        }
        return -1;
    }

    public void gotoPosition(long i) {
        this.blockNumber = (int)(i >> 13);
        this.position = (int)(i & 0x1FFFL);
        this.block = (char[])this.blockList.elementAt(this.blockNumber);
        this.blockStartPos = this.blockNumber << 13;
    }

    public boolean readUntil(int find) throws IOException {
        int next;
        while ((next = this.getNext()) != find && next != -1) {
        }
        return next != -1;
    }

    public boolean readUntil(String match) throws IOException {
        int next;
        if (match == null) {
            return false;
        }
        if (match.length() == 1) {
            return this.readUntil(match.charAt(0));
        }
        int matchLen = match.length();
        char matchChar = match.charAt(0);
        int matchPos = 0;
        char[] backoffBlock = null;
        int backoffBlockNumber = 0;
        int backoffPosition = 0;
        long backoffBlockStartPos = 0L;
        while ((next = this.getNext()) != -1) {
            if (next == matchChar) {
                if (matchPos == 0) {
                    backoffBlock = this.block;
                    backoffBlockNumber = this.blockNumber;
                    backoffPosition = this.position;
                    backoffBlockStartPos = this.blockStartPos;
                }
                if (++matchPos == matchLen) {
                    return true;
                }
                matchChar = match.charAt(matchPos);
                continue;
            }
            if (matchPos <= 0) continue;
            matchPos = 0;
            matchChar = match.charAt(0);
            this.block = backoffBlock;
            this.blockNumber = backoffBlockNumber;
            this.position = backoffPosition;
            this.blockStartPos = backoffBlockStartPos;
        }
        return false;
    }

    public void pushBack() {
        this.pushBack(1);
    }

    public void pushBack(int delta) {
        this.position -= delta;
        if (this.position < 0) {
            if (this.position >= -8192) {
                if (this.blockNumber == 0) {
                    this.position = 0;
                } else {
                    this.block = (char[])this.blockList.elementAt(--this.blockNumber);
                    this.position += 8192;
                    this.blockStartPos -= 8192L;
                }
            } else {
                this.gotoPosition(this.blockStartPos + (long)this.position);
            }
        }
    }

    public void mark() {
        this.markBlock = this.block;
        this.markBlockNumber = this.blockNumber;
        this.markPosition = this.position;
        this.markBlockStartPos = this.blockStartPos;
    }

    public void reset() {
        this.block = this.markBlock;
        this.blockNumber = this.markBlockNumber;
        this.position = this.markPosition;
        this.blockStartPos = this.markBlockStartPos;
    }

    public String getSelection(int offset) {
        if (offset == 0) {
            return this.getOrAppendString(null, this.markBlockNumber, this.markPosition, this.blockNumber, this.position);
        }
        long offsetPosition = this.position + offset;
        if (offsetPosition >= 0L && offsetPosition < 8192L) {
            return this.getOrAppendString(null, this.markBlockNumber, this.markPosition, this.blockNumber, (int)offsetPosition);
        }
        int endBlockNumber = (int)((offsetPosition += this.blockStartPos) >> 13);
        int endPosition = (int)(offsetPosition & 0x1FFFL);
        return this.getOrAppendString(null, this.markBlockNumber, this.markPosition, endBlockNumber, endPosition);
    }

    public String getBaseStreamUrl() {
        if (this.reader instanceof WmDocReader) {
            return ((WmDocReader)this.reader).getBaseStreamUrl();
        }
        return null;
    }

    String getOrAppendString(StringBuffer sb, long start, long end) {
        int startBlockNumber = (int)(start >> 13);
        int startPosition = (int)start & 0x1FFF;
        int endBlockNumber = (int)(end - 1L >> 13);
        int endPosition = (int)(end - 1L & 0x1FFFL);
        return this.getOrAppendString(sb, startBlockNumber, startPosition, endBlockNumber, endPosition);
    }

    String getOrAppendString(StringBuffer sb, int startBlockNumber, int startPosition, int endBlockNumber, int endPosition) {
        if (startBlockNumber == endBlockNumber) {
            if (endPosition < startPosition) {
                return "";
            }
            if (sb == null) {
                return new String((char[])this.blockList.elementAt(startBlockNumber), startPosition, endPosition + 1 - startPosition);
            }
            sb.append((char[])this.blockList.elementAt(startBlockNumber), startPosition, endPosition + 1 - startPosition);
        } else {
            if (endBlockNumber < startBlockNumber) {
                return "";
            }
            if (sb == null) {
                char[] stringChars = new char[(endBlockNumber - startBlockNumber << 13) + endPosition - startPosition + 1];
                System.arraycopy((char[])this.blockList.elementAt(startBlockNumber), startPosition, stringChars, 0, 8192 - startPosition);
                startPosition = 8192 - startPosition;
                while (++startBlockNumber < endBlockNumber) {
                    System.arraycopy((char[])this.blockList.elementAt(startBlockNumber), 0, stringChars, startPosition, 8192);
                    startPosition += 8192;
                }
                System.arraycopy((char[])this.blockList.elementAt(endBlockNumber), 0, stringChars, startPosition, endPosition + 1);
                return new String(stringChars);
            }
            sb.append((char[])this.blockList.elementAt(startBlockNumber), startPosition, 8192 - startPosition);
            while (++startBlockNumber < endBlockNumber) {
                sb.append((char[])this.blockList.elementAt(startBlockNumber), 0, 8192);
            }
            sb.append((char[])this.blockList.elementAt(endBlockNumber), 0, endPosition + 1);
        }
        return null;
    }

    abstract InputBuffer createLikeInstance(Reader var1);

    public static void baseMain(String[] argv, BlockInputBuffer sampleBuffer) throws IOException {
        char c;
        long i;
        System.out.println("Note: BLOCK_SIZE = 8192");
        System.out.println("Testing read until end...");
        InputBuffer testBuf = BlockInputBuffer.getTestBuffer(sampleBuffer, 8194);
        while (testBuf.getNext() != -1) {
        }
        BlockInputBuffer.showString(testBuf, 0, 8194);
        System.out.println("Testing getNext()...");
        int n = 3;
        testBuf = BlockInputBuffer.getTestBuffer(sampleBuffer, n * 8192);
        StringBuffer sb = new StringBuffer();
        for (i = 0L; i < 100L; ++i) {
            c = (char)testBuf.getNext();
            if (c == '\uffffffff') {
                System.out.println("prematurely hit EOF");
                break;
            }
            sb.append(c);
        }
        String testStr = sb.toString();
        BlockInputBuffer.showString(testStr, 0, 100);
        System.out.println("Testing getLast() in middle of block...");
        System.out.println("  getLast() = '" + (char)testBuf.getLast() + "'");
        System.out.println("Testing read until end of first block...");
        sb = new StringBuffer();
        while (i < 8192L) {
            c = (char)testBuf.getNext();
            if (c == '\uffffffff') {
                System.out.println("prematurely hit EOF");
                break;
            }
            sb.append(c);
            ++i;
        }
        testStr = sb.toString();
        BlockInputBuffer.showString(testStr, 100, 8192);
        System.out.println("Testing getLast() at end of first block...");
        System.out.println("  getLast() = '" + (char)testBuf.getLast() + "'");
        System.out.println("Testing getNext() into second block...");
        System.out.println("  getNext() = '" + (char)testBuf.getNext() + "'");
        System.out.println("Testing getLast() at start of second block...");
        System.out.println("  getLast() = '" + (char)testBuf.getLast() + "'");
        System.out.println("Testing pushBack(10) into previous block + getNext() across blocks...");
        System.out.println("  Note: mark() is called immediately after pushBack(10).");
        testBuf.pushBack(10);
        testBuf.mark();
        sb = new StringBuffer();
        i -= 10L;
        while (i < 8202L) {
            c = (char)testBuf.getNext();
            if (c == '\uffffffff') {
                System.out.println("prematurely hit EOF");
                break;
            }
            sb.append(c);
            ++i;
        }
        testStr = sb.toString();
        BlockInputBuffer.showString(testStr, 8183, 8203);
        System.out.println("Testing reset() to mark; should be same output as before...");
        testBuf.reset();
        i -= 20L;
        sb = new StringBuffer();
        while (i < 8202L) {
            c = (char)testBuf.getNext();
            if (c == '\uffffffff') {
                System.out.println("prematurely hit EOF");
                break;
            }
            sb.append(c);
            ++i;
        }
        testStr = sb.toString();
        BlockInputBuffer.showString(testStr, 8183, 8203);
        System.out.println("Testing getSelection(0) after reading 10 more chars...");
        while (i < 8212L) {
            c = (char)testBuf.getNext();
            if (c == '\uffffffff') {
                System.out.println("prematurely hit EOF");
                break;
            }
            ++i;
        }
        testStr = testBuf.getSelection(0);
        BlockInputBuffer.showString(testStr, 8182, 8213);
        System.out.println("Testing getSelection(-10) immediately afterwards...");
        testStr = testBuf.getSelection(-10);
        BlockInputBuffer.showString(testStr, 8182, 8203);
        System.out.println("Testing getSelection(-20) immediately afterwards...");
        testStr = testBuf.getSelection(-20);
        BlockInputBuffer.showString(testStr, 8182, 8192);
        System.out.println("Testing getSelection(-22) immediately afterwards...");
        testStr = testBuf.getSelection(-22);
        BlockInputBuffer.showString(testStr, 8182, 8190);
        System.out.println("Testing reading until end of buffer...");
        i = testBuf.getPosition();
        while (testBuf.getNext() != -1) {
        }
        BlockInputBuffer.showString(testBuf, i, n * 8192);
        System.out.println("Testing reading to end of buffer that doesn't fill last block...");
        testBuf = BlockInputBuffer.getTestBuffer(sampleBuffer, 12288);
        while (testBuf.getNext() != -1) {
        }
        BlockInputBuffer.showString(testBuf, 0, 12288);
        System.out.println("Testing readUntil('9') and getPosition()...");
        testBuf = BlockInputBuffer.getTestBuffer(sampleBuffer, 256);
        testBuf.readUntil(57);
        System.out.println("  getPosition() = " + testBuf.getPosition());
        BlockInputBuffer.showString(testBuf, 0, testBuf.getPosition() + 1L);
        System.out.println("Testing readUntil(\"1:1\") and getPosition()...");
        n = 3;
        testBuf = BlockInputBuffer.getTestBuffer(sampleBuffer, n * 8192);
        testBuf.readUntil("1:1");
        System.out.println("  getPosition() = " + testBuf.getPosition());
        BlockInputBuffer.showString(testBuf, 0, testBuf.getPosition() + 1L);
        System.out.println("Testing one block for single-block retrievals...");
        testBuf = BlockInputBuffer.getTestBuffer(sampleBuffer, 256);
        BlockInputBuffer.readToEnd(testBuf);
        BlockInputBuffer.showString(testBuf, 0, 256);
        BlockInputBuffer.showString(testBuf, 0, 1);
        BlockInputBuffer.showString(testBuf, 0, 10);
        BlockInputBuffer.showString(testBuf, 255, 256);
        BlockInputBuffer.showString(testBuf, 246, 256);
        BlockInputBuffer.showString(testBuf, 100, 200);
        System.out.println("Testing multi-block for single-block retrievals...");
        n = 3;
        testBuf = BlockInputBuffer.getTestBuffer(sampleBuffer, 8192 * n);
        BlockInputBuffer.readToEnd(testBuf);
        BlockInputBuffer.showString(testBuf, 0, 10);
        BlockInputBuffer.showString(testBuf, 8182, 8192);
        BlockInputBuffer.showString(testBuf, 8192, 8202);
        BlockInputBuffer.showString(testBuf, (n - 1) * 8192, (n - 1) * 8192 + 10);
        BlockInputBuffer.showString(testBuf, n * 8192 - 10, n * 8192);
        System.out.println("Testing multi-block for cross-block retrievals...");
        n = 3;
        testBuf = BlockInputBuffer.getTestBuffer(sampleBuffer, 8192 * n);
        BlockInputBuffer.readToEnd(testBuf);
        BlockInputBuffer.showString(testBuf, 0, n * 8192);
        BlockInputBuffer.showString(testBuf, 8182, 8202);
        BlockInputBuffer.showString(testBuf, (n - 1) * 8192 - 10, (n - 1) * 8192 + 10);
        BlockInputBuffer.showString(testBuf, 8182, (n - 1) * 8192 + 10);
        System.out.println("Testing purge of first block from first block");
        n = 5;
        testBuf = BlockInputBuffer.getTestBuffer(sampleBuffer, 8192 * n);
        for (i = 0L; i < 256L; ++i) {
            testBuf.getNext();
        }
        testBuf.purge(0L);
        BlockInputBuffer.showString(testBuf, 0, 256);
        testBuf.purge(100L);
        BlockInputBuffer.showString(testBuf, 0, 256);
        System.out.println("Testing purge of second block from second block");
        while (i < 8292L) {
            testBuf.getNext();
            ++i;
        }
        testBuf.purge(8192L);
        BlockInputBuffer.showString(testBuf, 0, 8292);
        testBuf.purge(8242L);
        BlockInputBuffer.showString(testBuf, 0, 8292);
        System.out.println("Testing purge of middle of 2nd block from 3rd block");
        while (i < 16484L) {
            testBuf.getNext();
            ++i;
        }
        testBuf.purge(8292L);
        BlockInputBuffer.showString(testBuf, 0, 8192);
        BlockInputBuffer.showString(testBuf, 8193, 16384);
        BlockInputBuffer.showString(testBuf, 16385, 16484);
        System.out.println("Testing purge of blocks 1-4 from block 5");
        while (i < 32868L) {
            testBuf.getNext();
            ++i;
        }
        testBuf.purge(32818L);
        BlockInputBuffer.showString(testBuf, 8192, 32768);
        BlockInputBuffer.showString(testBuf, 32769, 32818);
        System.out.println("Testing purge of last block after completing read");
        while (i < 40960L) {
            testBuf.getNext();
            ++i;
        }
        testBuf.purge(40960L);
        BlockInputBuffer.showString(testBuf, 32769, 40960);
    }

    private static void showString(InputBuffer testBuf, int i, long l) {
        BlockInputBuffer.showString(testBuf, i, (int)l);
    }

    private static void showString(InputBuffer testBuf, long i, int end) {
        BlockInputBuffer.showString(testBuf, (int)i, end);
    }

    static InputBuffer getTestBuffer(BlockInputBuffer sampleBuffer, int size) {
        char[] testChars = new char[size];
        String writing = new String(BlockInputBuffer.getPositionString(0) + " ");
        int blockNum = 0;
        int blockOffset = 0;
        int j = 0;
        for (int i = 0; i < size; ++i) {
            testChars[i] = writing.charAt(j);
            if (++blockOffset == 8192) {
                ++blockNum;
                blockOffset = 0;
            }
            if (++j != writing.length()) continue;
            j = 0;
            writing = new String(BlockInputBuffer.getPositionString(i + 1) + " ");
        }
        return sampleBuffer.createLikeInstance(new StringReader(new String(testChars)));
    }

    static void readToEnd(InputBuffer testBuf) throws IOException {
        while (testBuf.getNext() != -1) {
        }
    }

    static void showString(InputBuffer testBuf, int start, int end) {
        String testStr = testBuf.getString(start, end);
        BlockInputBuffer.showString(testStr, start, end);
    }

    static void showString(String testStr, int start, int end) {
        int length = testStr.length();
        if (length > 20) {
            testStr = testStr.substring(0, 10) + " ... " + testStr.substring(length - 10, length);
        }
        System.out.println("  getString(" + BlockInputBuffer.getPositionString(start) + ", " + BlockInputBuffer.getPositionString(end) + ") => length " + length + ", \"" + testStr + "\"");
    }

    static String getPositionString(int pos) {
        int block = pos >> 13;
        int offset = pos & 0x1FFF;
        return new String(block + ":" + offset);
    }
}

