/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import java.io.File;

public class parserTest {
    static boolean writeDTD = false;
    static boolean writeContent = true;

    public static void main(String[] args) {
        try {
            parserTest.generateBatchFile(args);
        }
        catch (IllegalArgumentException x) {
            parserTest.usage(x.getMessage());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void generateBatchFile(String[] args) throws Exception {
        boolean oldReader = false;
        if (args.length < 1) {
            throw new IllegalArgumentException("too few arguments");
        }
        File batchDir = new File(args[0]);
        if (batchDir.isFile()) {
            throw new IllegalArgumentException(batchDir.getPath() + " is not a directory!");
        }
        String arg = " ";
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-oldReader")) {
                oldReader = true;
                continue;
            }
            arg = arg + args[i] + " ";
        }
        String osName = System.getProperty("os.name");
        if (osName.equals("Linux") || osName.equals("Unix")) {
            System.out.println("#!/bin/sh");
        }
        String[] filenames = batchDir.list();
        for (int i = 0; i < filenames.length; ++i) {
            int end;
            File testFile = new File(batchDir.getPath(), filenames[i]);
            if (!testFile.exists()) {
                throw new IllegalArgumentException(testFile.getPath() + " doesn't exist");
            }
            if (!testFile.isFile() || !testFile.getPath().endsWith(".xml") && !testFile.getPath().endsWith(".XML") && !testFile.getPath().endsWith(".html") && !testFile.getPath().endsWith(".htm")) continue;
            String fn = testFile.getName();
            String e = null;
            String encodeEsc = "_encode";
            String encodeEnd = ".";
            int start = fn.indexOf(encodeEsc);
            if (start >= 0 && (end = fn.indexOf(encodeEnd, start)) > 0) {
                e = fn.substring(start + encodeEsc.length(), end);
            }
            if (e != null) {
                System.out.println();
                System.out.println("java com.wm.lang.xml.Document " + testFile.getAbsolutePath() + arg + "-" + e + " > " + testFile.getAbsolutePath() + "Result");
                continue;
            }
            System.out.println();
            if (oldReader) {
                System.out.println("java -Dwatt.core.xmlreader=sun com.wm.lang.xml.Document " + testFile.getAbsolutePath() + arg + "> " + testFile.getAbsolutePath() + "Result");
            } else {
                System.out.println("java com.wm.lang.xml.Document " + testFile.getAbsolutePath() + arg + "> " + testFile.getAbsolutePath() + "Result");
            }
            System.out.println();
        }
    }

    static void usage(String message) {
        if (message != null) {
            System.out.println("Error: " + message);
        }
        System.out.println("java ParserTest <file directory> [<options>] > <out put batch file>");
        System.out.println();
        System.out.println("<options>:");
        System.out.println("  -x  : force parsing as XML");
        System.out.println("  -h  : force parsing as HTML");
        System.out.println("  -s  : time source generation");
        System.out.println("  -d  : display generated source");
        System.out.println("  -o[<encoding>] <file> : output file");
        System.out.println("  -qf : display DTD without expanding it");
        System.out.println("  -qs : display DTD after expanding it");
        System.out.println("  -r  : test webtap reconstitution");
        System.out.println("  -n# : number of iterations");
        System.out.println("  -m  : parse from memory");
        System.out.println("  -e<encoding> : input document encoding");
        System.out.println("  -p<parser> : <parser> = SunSAX");
        System.out.println("  -!  : run temporary testing code");
        System.out.println("  -c  : display cannonical source");
        System.out.println("  -v  : verify expected properties");
        System.out.println("  -oldReader: use sun's xmlReader");
    }
}

