/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.lang.xml.Document;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.EncodingNames;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;

public class XmlUtil {
    public static String getEncodingSpec(PushbackInputStream in) {
        int i2;
        String s;
        byte[] ba = new byte[64];
        try {
            int len = in.read(ba, 0, ba.length);
            in.unread(ba, 0, len);
            s = new String(ba, 0, len, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        if ((ba[0] & 0xFF) == 255 && (ba[1] & 0xFF) == 254 || (ba[0] & 0xFF) == 254 && (ba[1] & 0xFF) == 255) {
            return "Unicode";
        }
        int i1 = s.indexOf("encoding=");
        if (i1 == -1) {
            return null;
        }
        char quot = s.charAt(i1 += 9);
        if (quot != '\"' && quot != '\'') {
            return null;
        }
        if ((i2 = s.indexOf(quot, ++i1)) == -1) {
            return null;
        }
        return s.substring(i1, i2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getEncodingJavaName(InputStream anXmlInputStream) throws IOException {
        String encoding;
        PushbackInputStream pushbackInputStream = null;
        try {
            pushbackInputStream = new PushbackInputStream(anXmlInputStream, 8192);
            encoding = EncodingNames.getJavaName(XmlUtil.getEncodingSpec(pushbackInputStream));
        }
        finally {
            if (pushbackInputStream != null) {
                pushbackInputStream.close();
            }
        }
        if (encoding == null) {
            encoding = "UTF8";
        }
        return encoding;
    }

    public static final Document urlToDocument(String htmlOrXmlUrl) throws IOException, WMDocumentException {
        if (htmlOrXmlUrl == null) {
            throw new IllegalArgumentException();
        }
        String encoding = XmlUtil.getEncodingJavaName(Document.getHostServices().getInputStream(htmlOrXmlUrl));
        Document document = new Document(Document.getHostServices().getInputStream(htmlOrXmlUrl), htmlOrXmlUrl, encoding, true, true);
        document.completeLoad();
        return document;
    }

    public static void main(String[] argv) {
        String xml = "<?xml version=\"1.0\" encoding=\"EUC-JP\"?><tag1>text<\tag1>";
        byte[] ba = xml.getBytes();
        PushbackInputStream pbis = new PushbackInputStream(new ByteArrayInputStream(ba), 64);
        String result = XmlUtil.getEncodingSpec(pbis);
        System.out.println("result=\"" + result + "\"");
    }
}

