/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.lang.xml.Attribute;
import com.wm.lang.xml.CDataNode;
import com.wm.lang.xml.CommentNode;
import com.wm.lang.xml.DTD;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.DocumentTreeBuilder;
import com.wm.lang.xml.ElementDef;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.ElementNodeBase;
import com.wm.lang.xml.NamespaceDecl;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.PINode;
import com.wm.lang.xml.TextNode;
import com.wm.lang.xml.XmlName;
import com.wm.lang.xml.token.AttListDecl;
import com.wm.lang.xml.token.ExternalID;
import com.wm.lang.xml.token.Token;
import com.wm.lang.xml.token.TokenAttribute;
import com.wm.lang.xml.token.TokenException;
import com.wm.lang.xml.token.resources.TokenExceptionBundle;
import com.wm.util.List;
import com.wm.util.Name;
import java.io.IOException;

public class XMLTreeBuilder
extends DocumentTreeBuilder {
    protected ElementNodeBase parent;
    List ancestors;
    DTD dtd;
    public static NamespaceDecl defaultNamespaceDecl = new NamespaceDecl(null, null, null);
    public static NamespaceDecl xmlNamespaceDecl = new NamespaceDecl(Document.xmlName, Name.create("http://www.w3.org/XML/1998/namespace"));
    public static NamespaceDecl dtNamespaceDecl = new NamespaceDecl(Document.dtName, Name.create("urn:uuid:C2F41010-65B3-11d1-A29F-00AA00C14882/"));
    private static final String WEBM_DEFAULT_NAMESPACE_DEFAULT = "http://www.webMethods.com/noNamespace/";
    private static final String WATT_DEFAULT_NAMESPACE = "watt.server.ws.defaultNamespace";
    private static final String WEBM_DEFAULT_NAMESPACE_STRING = System.getProperty("watt.server.ws.defaultNamespace", "http://www.webMethods.com/noNamespace/");
    private static final Name WEBM_DEFAULT_NAMESPACE = Name.create(WEBM_DEFAULT_NAMESPACE_STRING);
    private static final boolean debug = false;

    protected XMLTreeBuilder(Document docnode) {
        super(docnode);
        this.init();
    }

    protected XMLTreeBuilder(DocumentTreeBuilder treeBuilder) {
        super(treeBuilder);
        this.init();
    }

    void init() {
        this.parent = this.root;
        this.ancestors = new List();
        this.root.setNamespaceDecl(defaultNamespaceDecl);
        this.root.setFirstNamespaceDecl(defaultNamespaceDecl);
        if (XMLTreeBuilder.defaultNamespaceDecl.next == null) {
            XMLTreeBuilder.defaultNamespaceDecl.next = dtNamespaceDecl;
            XMLTreeBuilder.dtNamespaceDecl.next = xmlNamespaceDecl;
        }
    }

    void completeDocumentTree() throws TokenException {
        this.tokenSource.close();
        this.root.isComplete(true);
        if (this.ancestors.size() > 0) {
            XmlName name = new XmlName(this.parent.getNamespacePrefix(), this.parent.getLocalNameWm());
            throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.ELEMENT_MISSING_END_TAG, "", name.toString());
        }
        Node lastChild = this.root.getLastLoadedChild();
        if (lastChild != null && lastChild.getEndSourceIndex() >= 0L) {
            this.root.startSourceIndex = 0L;
            this.root.endSourceIndex = lastChild.getEndSourceIndex();
        }
    }

    public void processNextToken(Token token) throws IOException, TokenException {
        switch (token.type) {
            case 1: {
                this.addNodeToDocument(token, new TextNode(this.root, token));
                break;
            }
            case 0: {
                this.addNodeToDocument(token, new ElementNode(this.root, token));
                break;
            }
            case 4: {
                this.endElement(token);
                break;
            }
            case 5: {
                ElementNode node = new ElementNode(this.root, token);
                this.addNodeToDocument(token, node);
                this.endElement(token);
                node.isShownAsEmpty(true);
                break;
            }
            case 200: {
                this.addNodeToDocument(token, new CommentNode(this.root, token));
                break;
            }
            case 2: {
                this.addNodeToDocument(token, new CDataNode(this.root, token));
                break;
            }
            case 204: {
                this.addNodeToDocument(token, new PINode(this.root, token));
                break;
            }
            case 201: {
                if (token.ignore) break;
                this.addElementDecl(token);
                break;
            }
            case 102: {
                if (token.ignore) break;
                this.addAttListDecl(token);
                break;
            }
            case 103: {
                this.addDTD(token);
            }
        }
    }

    protected void addNodeToDocument(Token token, Node node) throws TokenException {
        if (this.parent.isComplete()) {
            throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.ERROR_IN_TREE_STRUCTURE, "");
        }
        this.parent.addChild(node);
        if (node.getNodeType() == 1) {
            this.assignNamespaces(token, (ElementNode)node);
            this.ancestors.addElement(this.parent);
            this.parent = (ElementNode)node;
        } else {
            node.isComplete(true);
        }
        node.setPosition(++this.root.lastPosition);
    }

    protected void endElement(Token token) throws TokenException {
        if (token.localName != this.parent.getLocalNameWm() || token.nsPrefix != this.parent.getNamespacePrefix()) {
            XmlName actualName = new XmlName(token.nsPrefix, token.localName);
            XmlName expectedName = new XmlName(this.parent.getNamespacePrefix(), this.parent.getLocalNameWm());
            Object[] sArray = new String[]{expectedName.toString(), actualName.toString()};
            throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.EXPECTING_GOT, "", sArray);
        }
        this.parent.isComplete(true);
        this.parent.endSourceIndex = token.endSourceOffset;
        NamespaceDecl nsDecl = this.parent.getNamespaceDecl();
        Name parentUri = null;
        if (nsDecl != null && (parentUri = nsDecl.getUri()) != null && parentUri == WEBM_DEFAULT_NAMESPACE) {
            this.parent.setNamespaceDecl(null);
        }
        for (Attribute attr = this.parent.getFirstAttribute(); attr != null; attr = attr.getNext()) {
            Name uri = attr.getNamespaceUri();
            if (uri == null || uri != WEBM_DEFAULT_NAMESPACE || parentUri != uri) continue;
            attr.setNamespaceDecl(null);
        }
        this.parent = (ElementNodeBase)this.ancestors.removeLastElement();
    }

    void assignNamespaces(Token token, ElementNode node) throws TokenException {
        NamespaceDecl firstNSDecl = node.getFirstNamespaceDecl();
        if (firstNSDecl == null) {
            firstNSDecl = this.parent.getFirstNamespaceDecl();
            node.setFirstNamespaceDecl(firstNSDecl);
        } else {
            NamespaceDecl lastNSDecl = firstNSDecl;
            while (lastNSDecl.next != null) {
                lastNSDecl = lastNSDecl.next;
            }
            lastNSDecl.next = this.parent.getFirstNamespaceDecl();
        }
        NamespaceDecl nodeNSDecl = firstNSDecl.lookupByPrefix(token.nsPrefix);
        if (nodeNSDecl == null) {
            Object[] eArray = new String[]{token.nsPrefix.toString(), token.localName.toString()};
            throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.NS_NOT_DEFINED_ELEMENT, "", eArray);
        }
        node.setNamespaceDecl(nodeNSDecl);
        TokenAttribute tokenAttr = token.firstAssignedAttribute;
        while (tokenAttr != null) {
            Attribute attr = tokenAttr.actual;
            Name nsPrefix = tokenAttr.nsPrefix;
            if (attr != null && nsPrefix != null) {
                if (nsPrefix == token.nsPrefix) {
                    attr.setNamespaceDecl(nodeNSDecl);
                } else {
                    NamespaceDecl nsDecl = firstNSDecl.lookupByPrefix(nsPrefix);
                    if (nsDecl == null) {
                        Object[] mArray = new String[]{nsPrefix.toString(), tokenAttr.localName.toString(), token.nsPrefix == null ? "" : token.nsPrefix.toString(), node.getLocalNameWm().toString()};
                        throw new TokenException(TokenExceptionBundle.class, TokenExceptionBundle.NS_NOT_DEFINED_ATTRIBUTE, "", mArray);
                    }
                    attr.setNamespaceDecl(nsDecl);
                }
            }
            tokenAttr = tokenAttr.next;
        }
    }

    protected void addDTD(Token token) {
        this.dtd = new DTD(this.root);
        this.root.setDTD(this.dtd);
        this.dtd.rootElementName = new XmlName(token.nsPrefix, token.localName);
        if (this.tokenSource.getSystemID() != null) {
            this.dtd.externalID = new ExternalID(this.tokenSource.getPublicID(), this.tokenSource.getSystemID());
        }
    }

    void addImplicitDTD() {
        this.dtd = new DTD(this.root);
        this.root.setDTD(this.dtd);
    }

    protected void addElementDecl(Token token) {
        if (this.dtd == null) {
            this.addImplicitDTD();
        }
        if (token.localName == null) {
            return;
        }
        this.dtd.addElement(new ElementDef(token.nsPrefix, token.localName, token.text));
    }

    protected void addAttListDecl(Token token) {
        if (this.dtd == null) {
            this.addImplicitDTD();
        }
        AttListDecl attListDecl = token.attListDecl;
        if (attListDecl.firstAttributeDef != null) {
            this.dtd.addAttributes(attListDecl);
        }
        if (token.idAttributeLocalName != null) {
            this.root.declareIdAttribute(attListDecl.elementNSPrefix, attListDecl.elementLocalName, token.idAttributeNSPrefix, token.idAttributeLocalName);
        }
    }
}

