/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.dom.DOMExceptionImpl;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.SourceNode;
import com.wm.lang.xml.TextNode;
import com.wm.lang.xml.token.EntityTable;
import com.wm.lang.xml.token.SourceBuffer;
import com.wm.lang.xml.token.Token;
import java.io.PrintStream;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class TextNodeBase
extends SourceNode {
    String text;
    long startTextIndex;
    long endTextIndex;

    TextNodeBase(Document doc, String inputtext) {
        super(doc);
        this.text = inputtext;
        this.startTextIndex = -1L;
        this.endTextIndex = -1L;
    }

    TextNodeBase(Document doc, Token token) {
        super(doc, token);
        this.text = token.getText();
        this.startTextIndex = token.getStartTextIndex();
        this.endTextIndex = token.getEndTextIndex();
        if (this.startTextIndex == -1L) {
            this.startTextIndex = token.getStartSourceIndex();
            this.endTextIndex = token.getEndSourceIndex();
        }
    }

    protected TextNodeBase(TextNodeBase node) {
        super(node);
        this.text = node.getText();
        this.setStartTextIndex(node.getStartTextIndex());
        this.setEndTextIndex(node.getEndTextIndex());
    }

    public char[] getTextArray() {
        return this.text.toCharArray();
    }

    public void appendGeneratedMarkup(StringBuffer sb) {
        if (this.getOwnerDocument() != null && ((Document)this.getOwnerDocument()).isCanonicalize()) {
            sb.append(Document.canonicalizeText(EntityTable.getXmlString(this.getText(), false)));
        } else if (this.text != null) {
            sb.append(EntityTable.getXmlString(this.text, false));
        } else {
            this.appendText(sb, false);
        }
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        return this.document.sourceBuffer.getString(this.startTextIndex, this.endTextIndex);
    }

    void appendText(StringBuffer sb, boolean recurse) {
        try {
            if (this.text != null) {
                sb.append(this.text);
            } else {
                this.document.sourceBuffer.appendString(sb, this.startTextIndex, this.endTextIndex);
            }
        }
        catch (Throwable e) {
            System.out.println("TNB - startTextIndex=" + this.startTextIndex + "; endTextIndex=" + this.endTextIndex);
            System.out.println("TNB - sb=" + sb);
            throw new RuntimeException(e);
        }
    }

    boolean appendSqueezedText(StringBuffer sb, boolean recurse, boolean inSpaces) {
        if (this.text != null) {
            int start;
            int length = this.text.length();
            int fromIndex = 0;
            int toIndex = -1;
            while (++toIndex < length) {
                if (!inSpaces) {
                    if (!this.isSpace(this.text.charAt(toIndex))) continue;
                    inSpaces = true;
                    if (toIndex != 0) {
                        start = fromIndex;
                        while (start < toIndex) {
                            sb.append(this.text.charAt(start++));
                        }
                    }
                    sb.append(' ');
                    continue;
                }
                if (this.isSpace(this.text.charAt(toIndex))) continue;
                fromIndex = toIndex;
                inSpaces = false;
            }
            if (!inSpaces) {
                start = fromIndex;
                while (start < toIndex) {
                    sb.append(this.text.charAt(start++));
                }
            }
        } else {
            long endIndex = this.endTextIndex;
            long fromIndex = this.startTextIndex;
            long toIndex = fromIndex - 1L;
            SourceBuffer ib = this.document.sourceBuffer;
            while (++toIndex < endIndex) {
                if (!inSpaces) {
                    if (!this.isSpace(ib.getChar(toIndex))) continue;
                    inSpaces = true;
                    if (toIndex != this.startTextIndex) {
                        ib.appendString(sb, fromIndex, toIndex);
                    }
                    sb.append(' ');
                    continue;
                }
                if (this.isSpace(ib.getChar(toIndex))) continue;
                fromIndex = toIndex;
                inSpaces = false;
            }
            if (!inSpaces) {
                ib.appendString(sb, fromIndex, toIndex);
            }
        }
        return inSpaces;
    }

    public String getTextAsData() {
        if (this.text != null) {
            return this.text.trim();
        }
        StringBuffer sb = new StringBuffer();
        this.appendTextAsData(sb, false, false);
        return sb.toString();
    }

    boolean appendTextAsData(StringBuffer sb, boolean prevIsText, boolean nextIsText) {
        long start;
        if (prevIsText) {
            long end;
            if (nextIsText) {
                if (this.text != null) {
                    sb.append(this.text);
                    return true;
                }
                this.document.sourceBuffer.appendString(sb, this.startTextIndex, this.endTextIndex);
                return true;
            }
            if (this.text != null) {
                int end2;
                for (end2 = this.text.length() - 1; end2 >= 0 && Character.isWhitespace(this.text.charAt(end2)); --end2) {
                }
                if (end2 >= 0) {
                    int i = 0;
                    do {
                        sb.append(this.text.charAt(i++));
                    } while (i <= end2);
                    return true;
                }
                return false;
            }
            long start2 = this.startTextIndex;
            SourceBuffer ib = this.document.sourceBuffer;
            for (end = this.endTextIndex - 1L; end >= start2 && Character.isWhitespace(ib.getChar(end)); --end) {
            }
            if (end >= start2) {
                long i = start2;
                do {
                    sb.append(ib.getChar(i++));
                } while (i <= end);
                return true;
            }
            return false;
        }
        if (this.text != null) {
            int start3;
            int end = this.text.length() - 1;
            for (start3 = 0; start3 <= end && Character.isWhitespace(this.text.charAt(start3)); ++start3) {
            }
            if (start3 <= end) {
                if (!nextIsText) {
                    while (Character.isWhitespace(this.text.charAt(end))) {
                        --end;
                    }
                }
                if (start3 <= end) {
                    do {
                        sb.append(this.text.charAt(start3++));
                    } while (start3 <= end);
                    return true;
                }
                return false;
            }
            return false;
        }
        long end = this.endTextIndex - 1L;
        SourceBuffer ib = this.document.sourceBuffer;
        for (start = this.startTextIndex; start <= end && Character.isWhitespace(ib.getChar(start)); ++start) {
        }
        if (start <= end) {
            if (!nextIsText) {
                while (Character.isWhitespace(ib.getChar(end))) {
                    --end;
                }
            }
            if (start <= end) {
                do {
                    sb.append(ib.getChar(start++));
                } while (start <= end);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isSpace(int ch) {
        return Character.isSpaceChar((char)ch) || ch > 6 && ch < 14;
    }

    public long getStartTextIndex() {
        return this.startTextIndex;
    }

    public long getEndTextIndex() {
        return this.endTextIndex;
    }

    public void setStartTextIndex(long l) {
        this.startTextIndex = l;
    }

    public void setEndTextIndex(long l) {
        this.endTextIndex = l;
    }

    public void printNode(PrintStream stream) {
        stream.println("Number " + this.getPosition() + ": " + this.getNodeTypeString());
        stream.println(this.getText());
    }

    public String toString() {
        return "Text: " + this.getText();
    }

    static void appendSubstring(StringBuffer sb, String text, int start, int end) {
        while (start < end) {
            sb.append(text.charAt(start++));
        }
    }

    public boolean isTextNode() {
        return false;
    }

    public String getNodeName() {
        return "#text";
    }

    public String getNodeValue() {
        return this.getData();
    }

    public void appendData(String arg) {
        String s;
        this.text = s = this.getData() + arg;
    }

    public void normalize() {
        if (this.parent != null && this.getClass() == TextNode.class) {
            int crlf;
            String td = this.getData();
            if (td == null || td.length() < 1) {
                this.parent.removeChild(this);
                return;
            }
            if (this.next != null && this.next.getClass() == TextNode.class) {
                String nextData = ((TextNode)this.next).getData();
                if (nextData != null && td.length() > 0) {
                    this.setData(td + nextData);
                }
                this.parent.removeChild(this.next);
                this.normalize();
            }
            if ((crlf = td.indexOf("\r\n")) != -1) {
                while (crlf != -1) {
                    td = td.substring(0, crlf) + td.substring(crlf + 1);
                    crlf = td.indexOf("\r\n");
                }
                this.setData(td);
            }
        }
    }

    public void deleteData(int offset, int count) throws DOMException {
        char[] ca = this.getData().toCharArray();
        int len = ca.length;
        if (offset < 0 || offset > len) {
            throw new DOMExceptionImpl(1);
        }
        int offset1 = offset + count;
        if (offset1 > len) {
            offset1 = len;
        }
        int lenmove = len - offset1;
        for (int i = 0; i < lenmove; ++i) {
            ca[offset++] = ca[offset1++];
        }
        this.text = new String(ca, 0, offset);
    }

    public String getData() {
        if (this.text != null) {
            return this.text;
        }
        return this.document.sourceBuffer.getString(this.startTextIndex, this.endTextIndex);
    }

    public int getLength() {
        String s = this.getData();
        return s.length();
    }

    public void insertData(int offset, String arg) throws DOMException {
        String s = this.getData();
        int len = s.length();
        if (offset < 0 || offset > len) {
            throw new DOMExceptionImpl(1);
        }
        this.text = new String(s.substring(0, offset) + arg + s.substring(offset));
    }

    public void replaceData(int offset, int count, String arg) throws DOMException {
        this.deleteData(offset, count);
        this.insertData(offset, arg);
    }

    public void setData(String arg) throws DOMException {
        this.text = arg;
    }

    public String substringData(int offset, int count) throws DOMException {
        String s = this.getData();
        int len = s.length();
        if (offset < 0 || offset > len) {
            throw new DOMExceptionImpl(1);
        }
        if (offset + count > len) {
            count = len - offset;
        }
        return s.substring(offset, offset + count);
    }

    public Text splitText(int offset) throws DOMException {
        Node nextNode = this.getNextSibling();
        String s = this.getData();
        String s1 = s.substring(0, offset);
        String s2 = s.substring(offset);
        this.setData(s1);
        Text newText = this.createSameTypeNode(s2);
        if (this.parent != null) {
            this.parent.insertBefore(newText, nextNode);
        }
        return newText;
    }

    protected Text createSameTypeNode(String s) {
        return this.getDocument().createTextNode(s);
    }

    public boolean isElementContentWhitespace() {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public String getWholeText() {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public Text replaceWholeText(String content) throws DOMException {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }
}

