/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.lang.xml.Document;
import com.wm.lang.xml.DocumentTreeBuilder;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.token.Token;

public abstract class SourceNode
extends Node {
    long startSourceIndex;
    long endSourceIndex;

    SourceNode() {
        this.startSourceIndex = -1L;
        this.endSourceIndex = -1L;
    }

    public SourceNode(Document doc) {
        super(doc);
        this.startSourceIndex = -1L;
        this.endSourceIndex = -1L;
    }

    protected SourceNode(Document doc, Token token) {
        super(doc);
        this.startSourceIndex = token.getStartSourceIndex();
        this.endSourceIndex = token.getEndSourceIndex();
    }

    protected SourceNode(SourceNode node) {
        super(node);
        this.startSourceIndex = node.startSourceIndex;
        this.endSourceIndex = node.endSourceIndex;
    }

    long getStartSourceIndex() {
        return this.startSourceIndex;
    }

    long getEndSourceIndex() {
        return this.endSourceIndex;
    }

    public void appendOriginalMarkup(StringBuffer sb) throws WMDocumentException {
        DocumentTreeBuilder tb = this.document.getTreeBuilder();
        while (tb != null && !this.isComplete() && tb.processNextToken()) {
        }
        if (this.startSourceIndex < 0L) {
            this.appendGeneratedMarkup(sb);
        } else {
            this.document.sourceBuffer.appendString(sb, this.startSourceIndex, this.endSourceIndex);
        }
    }
}

