/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.lang.xml.Document;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.SourceNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.token.HtmlType;
import com.wm.util.Name;

class SiblingRegionNode
extends SourceNode {
    Node firstNode;
    Node lastNode;
    Name localname;
    HtmlType htmlType;

    SiblingRegionNode(Document doc, Node first, Node last, Name name, HtmlType htmlType) {
        super(doc);
        while (first.isFalseNode()) {
            first = first.next;
        }
        this.firstNode = first;
        while (last.isFalseNode()) {
            last = last.prev;
        }
        this.lastNode = last;
        this.localname = name;
        this.htmlType = htmlType;
        this.startSourceIndex = first.getStartSourceIndex();
        this.endSourceIndex = last.getEndSourceIndex();
    }

    private SiblingRegionNode(SiblingRegionNode node) {
        super(node);
        this.firstNode = node.firstNode;
        this.lastNode = node.lastNode;
        this.localname = node.getLocalNameWm();
        this.htmlType = node.htmlType;
    }

    public boolean isComplete() {
        return true;
    }

    public boolean isFalseNode() {
        return true;
    }

    public boolean isQueryReturnable() {
        return true;
    }

    public boolean appendGeneratedStartTag(StringBuffer sb) {
        sb.append('<');
        sb.append(this.localname);
        sb.append('>');
        return false;
    }

    public void appendOriginalMarkup(StringBuffer sb) throws WMDocumentException {
    }

    void appendGeneratedEndTag(StringBuffer sb) {
        sb.append("</");
        sb.append(this.localname);
        sb.append('>');
    }

    public void appendGeneratedMarkup(StringBuffer sb) throws WMDocumentException {
        Node node;
        sb.append('<');
        sb.append(this.localname.toString());
        sb.append('>');
        for (node = this.firstNode; node != this.lastNode; node = node.getNextSiblingWm()) {
            if (node.isFalseNode()) continue;
            node.appendGeneratedMarkup(sb);
        }
        if (!node.isFalseNode()) {
            node.appendGeneratedMarkup(sb);
        }
        sb.append("</");
        sb.append(this.localname.toString());
        sb.append('>');
    }

    public Name getLocalNameWm() {
        return this.localname;
    }

    public Node getFirstChildWm() throws WMDocumentException {
        return this.firstNode;
    }

    public short getNodeType() {
        return 1;
    }

    public Node getLastChildWm() throws WMDocumentException {
        return this.lastNode;
    }

    public Node getFirstLoadedChild() {
        return this.firstNode;
    }

    public Node getNextLoadedChild(Node previousChild) {
        while (previousChild != this.lastNode && previousChild.isFalseNode()) {
            previousChild = previousChild.next;
        }
        if (previousChild == this.lastNode) {
            return null;
        }
        return previousChild.next;
    }

    public Node getLastLoadedChild() {
        return this.lastNode;
    }

    public HtmlType getHtmlType() {
        return this.htmlType;
    }

    public String getText() throws WMDocumentException {
        StringBuffer sb = new StringBuffer();
        if (this.htmlType != null && !this.htmlType.squeeze) {
            this.appendText(sb, true);
        } else {
            this.appendSqueezedText(sb, true, false);
        }
        return sb.toString();
    }

    public String getTextAsData() throws WMDocumentException {
        StringBuffer sb = new StringBuffer();
        SiblingRegionNode.appendTextAsData(sb, this);
        return sb.toString();
    }

    public String getTextOfChildren() throws WMDocumentException {
        StringBuffer sb = new StringBuffer();
        this.appendSqueezedText(sb, false, false);
        return sb.toString();
    }

    boolean appendSqueezedText(StringBuffer sb, boolean recurse, boolean inSpaces) throws WMDocumentException {
        Node next;
        for (next = this.firstNode; next != this.lastNode; next = next.getNextSiblingWm()) {
            if (next.isFalseNode() || !recurse && !next.isTextNode()) continue;
            inSpaces = next.appendSqueezedText(sb, recurse, inSpaces);
        }
        if (!next.isFalseNode() && (recurse || next.isTextNode())) {
            inSpaces = next.appendSqueezedText(sb, recurse, inSpaces);
        }
        return inSpaces;
    }

    public Node getPreviousSiblingOfChild(Node child) {
        if (child == this.firstNode) {
            return null;
        }
        child = child.prev;
        while (child != this.firstNode && child.isFalseNode()) {
            child = child.prev;
        }
        if (child == this.firstNode && child.isFalseNode()) {
            return null;
        }
        return child;
    }

    public Node getNextSiblingOfChild(Node child) {
        if (child == this.lastNode) {
            return null;
        }
        child = child.next;
        while (child != this.lastNode && child.isFalseNode()) {
            child = child.next;
        }
        if (child == this.lastNode && child.isFalseNode()) {
            return null;
        }
        return child;
    }

    public Node getClone() {
        return new SiblingRegionNode(this);
    }
}

