/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.lang.xml.Document;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.resources.WMDocumentExceptionBundle;

public abstract class Reconstituter {
    Document doc;
    StringBuffer sb;
    long sourceStart = 0L;

    public Reconstituter(Document doc) throws WMDocumentException {
        if (!doc.usesWMParser()) {
            throw new WMDocumentException(WMDocumentExceptionBundle.class, WMDocumentExceptionBundle.SAX_NO_INFO_FOR_WEBTAP, "");
        }
        this.doc = doc;
    }

    public void reconstitute(StringBuffer sb) throws WMDocumentException {
        this.sb = sb;
        this.sourceStart = 0L;
        this.recurse(this.doc);
        if (this.sourceStart < (long)this.doc.sourceBuffer.size()) {
            this.doc.sourceBuffer.appendString(sb, this.sourceStart, this.doc.sourceBuffer.size());
        }
    }

    public abstract boolean updateNode(Node var1) throws WMDocumentException;

    void recurse(Node node) throws WMDocumentException {
        for (node = node.getFirstChildWm(); node != null; node = node.getNextSiblingWm()) {
            if (node.isFalseNode()) continue;
            if (this.updateNode(node) || node.isQualified()) {
                long nodeStart = node.getStartSourceIndex();
                if (this.sourceStart < nodeStart) {
                    this.doc.sourceBuffer.appendString(this.sb, this.sourceStart, nodeStart);
                }
                if (node.getNodeType() == 1) {
                    node.appendGeneratedStartTag(this.sb);
                    this.sourceStart = node.getEndStartTagIndex();
                } else {
                    node.appendGeneratedMarkup(this.sb);
                    this.sourceStart = node.getEndSourceIndex();
                }
            }
            this.recurse(node);
        }
    }
}

