/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.lang.xml.Document;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.SourceNode;
import com.wm.lang.xml.token.Token;
import com.wm.util.Name;
import java.io.PrintStream;
import org.w3c.dom.DOMException;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.UserDataHandler;

final class PINode
extends SourceNode
implements ProcessingInstruction {
    private Name target;
    private String data;
    long startDataOffset;
    long endDataOffset;
    private static final String PIStart = "<?";
    private static final String PIEnd = "?>";

    PINode(Document doc, Name tgt, String dt) {
        super(doc);
        this.target = tgt;
        this.data = dt;
    }

    PINode(Document doc, Token token) {
        super(doc);
        if (token.getType() != 204) {
            return;
        }
        this.target = token.localName;
        this.startSourceIndex = token.startSourceOffset;
        this.endSourceIndex = token.endSourceOffset;
        if (token.text != null) {
            this.data = token.text;
        } else {
            this.startDataOffset = token.startTextOffset;
            this.endDataOffset = token.endTextOffset;
        }
    }

    PINode(PINode node) {
        super(node);
        this.target = node.target;
        this.data = node.data;
        this.startDataOffset = node.startDataOffset;
        this.endDataOffset = node.endDataOffset;
    }

    public Name getPITarget() {
        return this.target;
    }

    public String getPIData() {
        if (this.data != null) {
            return this.data;
        }
        return this.document.sourceBuffer.getString(this.startDataOffset, this.endDataOffset);
    }

    public void appendGeneratedMarkup(StringBuffer sb) {
        sb.append(PIStart);
        sb.append(this.target);
        sb.append(' ');
        if (this.data != null) {
            sb.append(this.data);
        } else {
            this.document.sourceBuffer.appendString(sb, this.startDataOffset, this.endDataOffset);
        }
        sb.append(PIEnd);
    }

    public short getNodeType() {
        return 7;
    }

    public String getTextAsData() {
        return null;
    }

    public Node getClone() {
        return new PINode(this);
    }

    public void printNode(PrintStream stream) {
        stream.println("Number " + this.getPosition() + ": " + this.getNodeTypeString());
        stream.println("Target: " + this.target);
        stream.println("PI data: " + this.data);
        stream.println("\t<?" + this.target + " " + this.data + " " + PIEnd);
    }

    public String toString() {
        return "Comment: " + this.target + " " + this.data;
    }

    public String getNodeName() {
        return this.target.toString();
    }

    public String getNodeValue() {
        return this.getPIData();
    }

    public String getTarget() {
        return this.target.toString();
    }

    public String getData() {
        return this.getPIData();
    }

    public void setData(String s) {
        this.data = s;
    }

    public org.w3c.dom.Node cloneNode(boolean deep) {
        return new PINode(this);
    }

    public String getBaseURI() {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public short compareDocumentPosition(org.w3c.dom.Node other) throws DOMException {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public String getTextContent() throws DOMException {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public void setTextContent(String textContent) throws DOMException {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public boolean isSameNode(org.w3c.dom.Node other) {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public boolean isEqualNode(org.w3c.dom.Node arg) {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public Object getUserData(String key) {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }
}

