/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.lang.xml.Document;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.NodeCriterion;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.resources.WMDocumentExceptionBundle;

public class NodeIterator {
    Document doc;
    Node top;
    NodeCriterion[] criteria;
    boolean movingWindow;
    Node result;
    int lastPurgePosition;

    public NodeIterator(Node top, NodeCriterion[] criteria, boolean movingWindow) throws WMDocumentException {
        if (top == null) {
            throw new WMDocumentException(WMDocumentExceptionBundle.class, WMDocumentExceptionBundle.NODE_REFERENCE_NULL, "");
        }
        if (!top.isXML()) {
            throw new WMDocumentException(WMDocumentExceptionBundle.class, WMDocumentExceptionBundle.NODE_IS_NOT_XML, "");
        }
        if (movingWindow) {
            if (top.getNodeType() != 9) {
                throw new WMDocumentException(WMDocumentExceptionBundle.class, WMDocumentExceptionBundle.MOVING_WINDOW_NOT_AVAILABLE, "");
            }
            this.doc = (Document)top;
            if (!this.doc.usesWMParser()) {
                throw new WMDocumentException(WMDocumentExceptionBundle.class, WMDocumentExceptionBundle.MOVING_WINDOW_NOT_FOR_SAX, "");
            }
        }
        this.top = top;
        this.criteria = criteria;
        this.movingWindow = movingWindow;
        this.result = top;
    }

    public Node getNextNode() throws WMDocumentException {
        Node testNode;
        int criterionIndex;
        if (this.result == null) {
            return null;
        }
        Node lastNode = this.result;
        do {
            testNode = lastNode != this.result || lastNode == this.top ? lastNode.getFirstChildWm() : null;
            if (testNode == null && (testNode = lastNode.getNextSiblingWm()) == null) {
                testNode = lastNode;
                do {
                    if ((testNode = testNode.getParent()) != this.top) continue;
                    this.result = null;
                    return null;
                } while (testNode.getNextSiblingWm() == null);
                testNode = testNode.getNextSiblingWm();
            }
            lastNode = testNode;
            if (this.criteria == null) break;
            criterionIndex = this.criteria.length;
            while (--criterionIndex >= 0 && !this.criteria[criterionIndex].isSatisfiedBy(testNode)) {
            }
        } while (criterionIndex < 0);
        if (this.movingWindow) {
            this.doc.purgeUpTo(testNode);
        }
        this.result = testNode;
        return this.result;
    }
}

