/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.dom.DOMExceptionImpl;
import com.wm.dom.DOMImplementationImpl;
import com.wm.dom.NodeListImpl;
import com.wm.dom.NodeListRefresh;
import com.wm.lang.xml.Attribute;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.DocumentTreeBuilder;
import com.wm.lang.xml.NamespaceDecl;
import com.wm.lang.xml.PINode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.token.HtmlType;
import com.wm.util.Name;
import com.wm.util.coder.RemoteReferenceCodable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public abstract class Node
implements RemoteReferenceCodable,
org.w3c.dom.Node,
javax.xml.soap.Node {
    public static final int DOCUMENT_NODE = 9;
    public static final int ELEMENT_NODE = 1;
    public static final int TEXT_NODE = 3;
    public static final int CDATA_NODE = 4;
    public static final int PI_NODE = 7;
    public static final int COMMENT_NODE = 8;
    public static final String DOCUMENT_STR = "Document";
    public static final String ELEMENT_STR = "Element";
    public static final String TEXT_STR = "Text";
    public static final String CDATA_STR = "CDATA";
    public static final String PI_STR = "PI";
    public static final String COMMENT_STR = "Comment";
    public static final String UNKNOWN_STR = "Unknown";
    static final short FLAG_IS_LAST_SIBLING = 1;
    static final short FLAG_IS_HTML = 2;
    static final short FLAG_IS_EMPTY_ELEMENT = 4;
    static final short FLAG_IS_COMPLETE = 8;
    static final short FLAG_URL_WAS_QUALIFIED = 16;
    private static final short FLAG_IS_READ_ONLY = 32;
    protected static final short FLAG_IS_SPECIFIED = 64;
    protected static final short FLAG_IS_DOM1 = 128;
    static DOMImplementationImpl domImpl = new DOMImplementationImpl();
    Document document;
    int position;
    short multiflags;
    Node parent;
    Node prev;
    Node next;
    int changeNumber = 0;

    public Node(Document doc) {
        this.document = doc;
        this.position = -1;
    }

    protected Node() {
        this.document = null;
        this.position = -1;
    }

    Node(Node node) {
        this.document = node.document;
        this.position = -1;
        this.multiflags = node.multiflags;
    }

    public abstract void appendGeneratedMarkup(StringBuffer var1) throws WMDocumentException;

    public abstract void appendOriginalMarkup(StringBuffer var1) throws WMDocumentException;

    public abstract Node getClone();

    public int getChangeNumber() {
        return this.changeNumber;
    }

    public void incrementChangeNumber() {
        Node n = this.parent;
        if (n != null) {
            n.incrementChangeNumber();
        }
        ++this.changeNumber;
    }

    public Node getReferenceNode() {
        return this;
    }

    public abstract short getNodeType();

    public String getNodeTypeString() {
        switch (this.getNodeType()) {
            case 9: {
                return DOCUMENT_STR;
            }
            case 1: {
                return ELEMENT_STR;
            }
            case 3: {
                return TEXT_STR;
            }
            case 4: {
                return CDATA_STR;
            }
            case 7: {
                return PI_STR;
            }
            case 8: {
                return COMMENT_STR;
            }
        }
        return UNKNOWN_STR;
    }

    public String getText() throws WMDocumentException {
        return "";
    }

    public String getTextOfChildren() throws WMDocumentException {
        return "";
    }

    public String getTextAsData() throws WMDocumentException {
        return "";
    }

    public HtmlType getHtmlType() {
        return null;
    }

    public void qualifyUrls() {
    }

    public boolean isXML() throws WMDocumentException {
        return this.document.isXML();
    }

    public void isXML(boolean isXML) {
        this.multiflags = isXML ? (short)(this.multiflags & 0xFFFFFFFD) : (short)(this.multiflags | 2);
    }

    final boolean isLastSibling() {
        return (this.multiflags & 1) > 0;
    }

    final void isLastSibling(boolean val) {
        this.multiflags = val ? (short)(this.multiflags | 1) : (short)(this.multiflags & 0xFFFFFFFE);
    }

    public boolean isShownAsEmpty() {
        return (this.multiflags & 4) > 0;
    }

    public void isShownAsEmpty(boolean showAsEmpty) {
        this.multiflags = showAsEmpty ? (short)(this.multiflags | 4) : (short)(this.multiflags & 0xFFFFFFFB);
    }

    public boolean isComplete() {
        return (this.multiflags & 8) > 0;
    }

    public void isComplete(boolean val) {
        this.multiflags = val ? (short)(this.multiflags | 8) : (short)(this.multiflags & 0xFFFFFFF7);
    }

    public boolean isFalseNode() {
        return false;
    }

    public boolean isQueryReturnable() {
        return !this.isFalseNode();
    }

    long getEndStartTagIndex() {
        return 0L;
    }

    long getStartSourceIndex() {
        return -1L;
    }

    long getEndSourceIndex() {
        return -1L;
    }

    public final Node getNextSiblingWm() throws WMDocumentException {
        DocumentTreeBuilder tb = this.document.getTreeBuilder();
        while (!this.isLastSibling() && this.next == null && tb != null && tb.processNextToken()) {
        }
        return this.next;
    }

    public Node getParent() {
        return this.parent;
    }

    public void addChild(Node node) {
    }

    public void resetDocumentPointers(Document doc) throws WMDocumentException {
        Node newNode = this;
        while (newNode != null) {
            newNode.document = doc;
            Node child = newNode.getFirstChildWm();
            if (child != null) {
                child.resetDocumentPointers(doc);
            }
            newNode = newNode.next;
        }
    }

    void setFirstChild(Node node) {
    }

    public void addFosterChild(Node node) {
    }

    public Node getFirstChildWm() throws WMDocumentException {
        return null;
    }

    public Node getFirstRealChild() throws WMDocumentException {
        Node first = this.getFirstChildWm();
        if (first != null && first.isFalseNode()) {
            return this.getNextRealSiblingOfChild(first);
        }
        return first;
    }

    public Node getLastChildWm() throws WMDocumentException {
        return null;
    }

    public Node getLastRealChild() throws WMDocumentException {
        Node last = this.getLastChildWm();
        if (last != null && last.isFalseNode()) {
            return this.getPreviousRealSiblingOfChild(last);
        }
        return last;
    }

    public Node getFirstLoadedChild() {
        return null;
    }

    public Node getNextLoadedChild(Node previousChild) {
        return null;
    }

    public Node getLastLoadedChild() {
        return null;
    }

    public Node getNextSiblingOfChild(Node child) throws WMDocumentException {
        return null;
    }

    public Node getNextRealSiblingOfChild(Node child) throws WMDocumentException {
        Node next = this.getNextSiblingOfChild(child);
        while (next != null && next.isFalseNode()) {
            next = this.getNextSiblingOfChild(next);
        }
        return next;
    }

    public Node getPreviousSiblingOfChild(Node child) {
        return null;
    }

    public Node getPreviousRealSiblingOfChild(Node child) {
        Node prev = this.getPreviousSiblingOfChild(child);
        while (prev != null && prev.isFalseNode()) {
            prev = this.getPreviousSiblingOfChild(prev);
        }
        return prev;
    }

    public String getValue() {
        return "com.wm.lang.xml.Node:" + this.getPosition() + ":" + Integer.toString(this.hashCode());
    }

    public void setValue(String val) {
    }

    public IData getAsData() {
        String key = "com.wm.lang.xml.Node:";
        IData idt = IDataFactory.create();
        IDataCursor idc = idt.getCursor();
        idc.first();
        StringBuffer sb = new StringBuffer(key);
        sb.append(this.getPosition());
        sb.append(":");
        sb.append(Integer.toString(this.hashCode()));
        idc.insertAfter(key, sb.toString());
        idc.destroy();
        return idt;
    }

    public void setFromData(IData data) {
    }

    public void insertChildNode(Node nodeToPrecede, Node nodeToInsert) throws WMDocumentException {
    }

    public void removeChild(Node node) {
    }

    public boolean appendGeneratedStartTag(StringBuffer sb) throws WMDocumentException {
        return false;
    }

    void appendGeneratedEndTag(StringBuffer sb) {
    }

    public void appendOriginalStartTag(StringBuffer sb) throws WMDocumentException {
    }

    public Attribute assignAttribute(Name nsdecl, Name localname, String value) throws WMDocumentException {
        return null;
    }

    public void assignNamespaceDecl(Name prefix, Name url) {
    }

    public Attribute getFirstAttribute() {
        return null;
    }

    public String getFirstPIData() throws WMDocumentException {
        return null;
    }

    public String getDocumentEncoding() throws WMDocumentException {
        return null;
    }

    public String getAttributeValue(Name namespaceUri, Name localname) {
        return null;
    }

    public Name getLocalNameWm() {
        return null;
    }

    public NamespaceDecl getFirstNamespaceDecl() {
        return null;
    }

    public NamespaceDecl getNextNamespaceDecl(NamespaceDecl prevDecl) {
        return null;
    }

    public Name getNamespacePrefix() {
        return null;
    }

    public Name getNamespaceUri() {
        return null;
    }

    public boolean removeAttribute(Name namespaceUri, Name localname) {
        return false;
    }

    public void removeNamespaceDecl(Name prefix) {
    }

    final void setPosition(int val) {
        this.position = val;
    }

    public int getPosition() {
        return this.position;
    }

    public final Document getDocument() {
        return this.document;
    }

    public boolean isTextNode() {
        return false;
    }

    public boolean isQualified() {
        return (this.multiflags & 0x10) != 0;
    }

    public Name getPITarget() {
        return null;
    }

    public String getPIData() {
        return null;
    }

    public String getComment() {
        return null;
    }

    final String toFormatedString(int indentation) throws WMDocumentException {
        StringBuffer sb = new StringBuffer(1024);
        this.appendFormatedMarkup(sb, indentation);
        return sb.toString();
    }

    void appendFormatedMarkup(StringBuffer sb, int t) throws WMDocumentException {
        sb.append("\n" + this.getPosition() + "\t");
        this.appendTabs(sb, t);
        if (this.isTextNode() || this.getNodeType() == 8) {
            String data = this.getText().trim();
            int length = data.length();
            if (length > 20) {
                data = data.substring(0, 10) + "..." + data.substring(length - 10, length);
            }
            sb.append("[" + data + "]");
        } else if (this.getNodeType() == 1 || this.getNodeType() == 9) {
            try {
                this.appendGeneratedStartTag(sb);
                for (Node child = this.getFirstChildWm(); child != null; child = child.getNextSiblingWm()) {
                    child.appendFormatedMarkup(sb, t + 1);
                }
            }
            catch (WMDocumentException e) {
                System.err.println("WMDocumentException caught: " + e.getMessage());
            }
        } else {
            this.appendGeneratedStartTag(sb);
        }
    }

    void appendTabs(StringBuffer sb, int t) {
        String tabstring = "  ";
        for (int i = 0; i < t; ++i) {
            sb.append(tabstring);
        }
    }

    void appendText(StringBuffer sb, boolean recurse) throws WMDocumentException {
        sb.append(this.getText());
    }

    boolean appendSqueezedText(StringBuffer sb, boolean recurse, boolean inSpaces) throws WMDocumentException {
        return false;
    }

    static boolean appendTextAsData(StringBuffer sb, Node node) throws WMDocumentException {
        Node child1 = node.getFirstChildWm();
        if (child1 == null) {
            return false;
        }
        Node child2 = node.getNextSiblingOfChild(child1);
        Node child3 = null;
        if (child2 != null) {
            child3 = node.getNextSiblingOfChild(child2);
        }
        if (child2 == null) {
            if (child1.isTextNode()) {
                return child1.appendTextAsData(sb, false, false);
            }
            if (!child1.isFalseNode()) {
                return Node.appendTextAsData(sb, child1);
            }
            return false;
        }
        if (child3 == null) {
            boolean gotChars = false;
            if (child1.isTextNode()) {
                gotChars = child1.appendTextAsData(sb, false, child2.isTextNode());
            } else if (!child1.isFalseNode()) {
                gotChars = Node.appendTextAsData(sb, child1);
            }
            if (child2.isTextNode()) {
                if (child1.isTextNode()) {
                    return child2.appendTextAsData(sb, true, false) || gotChars;
                }
                if (gotChars) {
                    sb.append(' ');
                    if (!child2.appendTextAsData(sb, false, false)) {
                        sb.setLength(sb.length() - 1);
                    }
                    return true;
                }
                return child2.appendTextAsData(sb, false, false);
            }
            if (!child2.isFalseNode()) {
                if (gotChars) {
                    sb.append(' ');
                    if (!Node.appendTextAsData(sb, child2)) {
                        sb.setLength(sb.length() - 1);
                    }
                    return true;
                }
                return Node.appendTextAsData(sb, child2);
            }
            return false;
        }
        boolean child1IsText = child1.isTextNode();
        boolean child2IsText = child2.isTextNode();
        boolean lastGotChars = false;
        if (child1IsText) {
            lastGotChars = child1.appendTextAsData(sb, false, child2IsText);
        } else if (!child1.isFalseNode()) {
            lastGotChars = Node.appendTextAsData(sb, child1);
        }
        boolean gotAnyChars = lastGotChars;
        while ((child3 = node.getNextSiblingOfChild(child2)) != null) {
            boolean child0IsText = child1IsText;
            child1 = child2;
            child1IsText = child2IsText;
            child2 = child3;
            child2IsText = child3.isTextNode();
            if (child1IsText) {
                if (!child0IsText && lastGotChars) {
                    sb.append(' ');
                }
                lastGotChars = child1.appendTextAsData(sb, child0IsText, child2IsText);
            } else if (!child1.isFalseNode()) {
                if (lastGotChars) {
                    sb.append(' ');
                }
                lastGotChars = Node.appendTextAsData(sb, child1);
            } else {
                lastGotChars = false;
            }
            if (gotAnyChars || !lastGotChars) continue;
            gotAnyChars = true;
        }
        if (child2IsText) {
            if (!child1IsText && lastGotChars) {
                sb.append(' ');
            }
            lastGotChars = child2.appendTextAsData(sb, child1IsText, false);
        } else if (!child2.isFalseNode()) {
            if (lastGotChars) {
                sb.append(' ');
            }
            lastGotChars = Node.appendTextAsData(sb, child2);
        } else {
            lastGotChars = false;
        }
        if (!gotAnyChars && lastGotChars) {
            gotAnyChars = true;
        }
        if (!(!gotAnyChars || lastGotChars || child1IsText && child2IsText)) {
            sb.setLength(sb.length() - 1);
        }
        return gotAnyChars;
    }

    boolean appendTextAsData(StringBuffer sb, boolean prevIsText, boolean nextIsText) {
        return false;
    }

    public static String qualifyUrl(String base, String url) {
        String qualFile;
        String baseFile;
        String baseProto;
        String basePort;
        String baseHost;
        if (base == null || url == null || url.length() == 0) {
            return url;
        }
        String tmp = (url = url.trim()).toLowerCase();
        if (tmp.startsWith("#") || tmp.startsWith("http://") || tmp.startsWith("https://") || tmp.startsWith("mailto:") || tmp.startsWith("javascript:") || tmp.startsWith("telnet:") || tmp.startsWith("nntp:") || tmp.startsWith("news:") || tmp.startsWith("file:") || tmp.startsWith("gopher:") || tmp.startsWith("ftp:")) {
            return url;
        }
        try {
            URL baseUrl = new URL(base);
            baseHost = baseUrl.getHost();
            int p = baseUrl.getPort();
            basePort = p >= 0 ? ":" + p : "";
            baseProto = baseUrl.getProtocol();
            baseFile = baseUrl.getFile();
            int pos = baseFile.lastIndexOf("/");
            baseFile = pos > 0 ? baseFile.substring(0, pos) : "";
        }
        catch (Exception e) {
            return url;
        }
        try {
            URL qaulUrl = new URL(url);
            baseProto = qaulUrl.getProtocol();
            int colonPos = url.indexOf(":");
            qualFile = url.length() > colonPos && url.substring(0, colonPos).equals(baseProto) && url.charAt(colonPos + 1) != '/' ? url.substring(colonPos + 1) : qaulUrl.getFile();
        }
        catch (Exception e) {
            qualFile = url;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(baseProto);
        sb.append("://");
        sb.append(baseHost);
        sb.append(basePort);
        if (qualFile.length() != 0 && qualFile.charAt(0) != '/') {
            sb.append(baseFile);
            sb.append('/');
        }
        sb.append(qualFile);
        return sb.toString();
    }

    public Node getNodePath(int nodeId, com.wm.util.List path) throws WMDocumentException {
        if (nodeId == this.getPosition()) {
            return this;
        }
        if (path == null) {
            Node node = this.quickGetNodePath(nodeId, null);
            if (node == null && !this.isXML()) {
                return this.slowGetNodePath(nodeId, null);
            }
            return node;
        }
        int originalSize = path.size();
        Node node = this.quickGetNodePath(nodeId, path);
        if (node == null && !this.isXML()) {
            path.truncate(originalSize);
            return this.slowGetNodePath(nodeId, path);
        }
        return node;
    }

    Node quickGetNodePath(int nodeId, com.wm.util.List path) throws WMDocumentException {
        Node child = this.getFirstChildWm();
        if (child != null) {
            Node lookAhead = this.getNextSiblingOfChild(child);
            while (lookAhead != null && nodeId >= lookAhead.getPosition()) {
                child = lookAhead;
                lookAhead = this.getNextSiblingOfChild(lookAhead);
            }
            if (path != null) {
                path.addElement(this);
            }
            if (child.getPosition() == nodeId) {
                return child;
            }
            return child.quickGetNodePath(nodeId, path);
        }
        return null;
    }

    Node slowGetNodePath(int nodeId, com.wm.util.List path) throws WMDocumentException {
        Node child = this.getFirstChildWm();
        if (path == null) {
            while (child != null && nodeId != child.getPosition()) {
                Node foundNode = child.slowGetNodePath(nodeId, null);
                if (foundNode != null) {
                    return foundNode;
                }
                child = this.getNextSiblingOfChild(child);
            }
        } else {
            path.addElement(this);
            while (child != null && nodeId != child.getPosition()) {
                Node foundNode = child.slowGetNodePath(nodeId, path);
                if (foundNode != null) {
                    return foundNode;
                }
                child = this.getNextSiblingOfChild(child);
            }
            if (child == null) {
                path.removeLastElement();
            }
        }
        return child;
    }

    public NamespaceDecl lookUpInScopeNSDeclByPrefix(Name prefix) {
        return null;
    }

    public NamespaceDecl lookUpInScopeNSDeclByURI(Name uri) {
        return null;
    }

    public void setOwnerDocument(Document doc) {
        if (this.document == null) {
            this.document = doc;
        }
    }

    public boolean isReadOnly() {
        return (this.multiflags & 0x20) > 0;
    }

    public void setReadOnly(boolean ro) {
        this.multiflags = ro ? (short)(this.multiflags | 0x20) : (short)(this.multiflags & 0xFFFFFFDF);
    }

    public boolean getDOM1() {
        return (this.multiflags & 0x80) > 0;
    }

    public void setDOM1(boolean d1) {
        this.multiflags = d1 ? (short)(this.multiflags | 0x80) : (short)(this.multiflags & 0xFFFFFF7F);
    }

    public org.w3c.dom.Node appendChild(org.w3c.dom.Node newChild) {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, "appendChild");
        }
        if (newChild instanceof DocumentFragment) {
            DocumentFragment frag = (DocumentFragment)newChild;
            NodeList children = frag.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.appendChild(frag.removeChild(children.item(0)));
            }
        } else {
            org.w3c.dom.Node n = newChild.getParentNode();
            if (n != null) {
                n.removeChild(newChild);
            }
            this.addChild((Node)newChild);
        }
        return newChild;
    }

    public org.w3c.dom.Node cloneNode(boolean deep) {
        return null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public NodeList getChildNodes() {
        GetChildNodesCallback callback = new GetChildNodesCallback(this);
        return new NodeListImpl(callback);
    }

    private List getChildNodesList() {
        ArrayList<org.w3c.dom.Node> list = new ArrayList<org.w3c.dom.Node>();
        for (org.w3c.dom.Node n = this.getFirstChild(); n != null; n = n.getNextSibling()) {
            list.add(n);
        }
        return list;
    }

    public org.w3c.dom.Node getFirstChild() {
        this.document.completeLoadDOM();
        try {
            return this.getFirstChildWm();
        }
        catch (WMDocumentException excp) {
            throw new DOMException(15, excp.toString());
        }
    }

    public org.w3c.dom.Node getLastChild() {
        this.document.completeLoadDOM();
        try {
            return this.getLastChildWm();
        }
        catch (WMDocumentException excp) {
            throw new DOMException(15, excp.toString());
        }
    }

    public String getLocalName() {
        return null;
    }

    public String getNamespaceURI() {
        return null;
    }

    public org.w3c.dom.Node getNextSibling() {
        this.document.completeLoadDOM();
        return this.next;
    }

    public String getNodeName() {
        return null;
    }

    public String getNodeValue() {
        return null;
    }

    public org.w3c.dom.Document getOwnerDocument() {
        return this.document;
    }

    public org.w3c.dom.Node getParentNode() {
        return this.parent;
    }

    public String getPrefix() {
        return null;
    }

    public org.w3c.dom.Node getPreviousSibling() {
        Node n = this.prev;
        if (n instanceof PINode && n.prev == null) {
            return null;
        }
        return this.prev;
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildNodes() {
        this.document.completeLoadDOM();
        try {
            return this.getFirstChildWm() != null;
        }
        catch (WMDocumentException e) {
            return false;
        }
    }

    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node newChild, org.w3c.dom.Node refChild) {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, "insertBefore");
        }
        this.document.completeLoadDOM();
        try {
            if (newChild instanceof DocumentFragment) {
                DocumentFragment frag = (DocumentFragment)newChild;
                NodeList children = frag.getChildNodes();
                while (children.getLength() > 0) {
                    this.insertBefore(frag.removeChild(children.item(0)), refChild);
                }
            } else if (refChild != null) {
                if (refChild.getParentNode() != this) {
                    throw new DOMException(8, "refChild not in this");
                }
                this.insertChildNode((Node)refChild, (Node)newChild);
            } else {
                this.appendChild(newChild);
            }
        }
        catch (WMDocumentException e) {
            throw new DOMException(15, e.toString());
        }
        return newChild;
    }

    public boolean isSupported(String feature, String version) {
        return domImpl.hasFeature(feature, version);
    }

    public void normalize() {
        this.document.completeLoadDOM();
        NamedNodeMap attributes = this.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                attributes.item(i).normalize();
            }
        }
        NodeList children = this.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            int originalSize = children.getLength();
            children.item(i).normalize();
            if (originalSize != children.getLength()) continue;
            ++i;
        }
    }

    public org.w3c.dom.Node removeChild(org.w3c.dom.Node oldChild) {
        this.document.completeLoadDOM();
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, "removeChild");
        }
        this.removeChild((Node)oldChild);
        return oldChild;
    }

    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node newChild, org.w3c.dom.Node oldChild) {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, "replaceChild");
        }
        this.document.completeLoadDOM();
        org.w3c.dom.Node next = oldChild.getNextSibling();
        this.removeChild(oldChild);
        this.insertBefore(newChild, next);
        return newChild;
    }

    public void setNodeValue(String nodeValue) {
    }

    public void setPrefix(String prefix) {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, "setPrefix");
        }
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public String getBaseURI() {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public short compareDocumentPosition(org.w3c.dom.Node other) throws DOMException {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public String getTextContent() throws DOMException {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public void setTextContent(String textContent) throws DOMException {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public boolean isSameNode(org.w3c.dom.Node other) {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public boolean isEqualNode(org.w3c.dom.Node arg) {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public Object getUserData(String key) {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }

    public void setParentElement(SOAPElement newparent) throws SOAPException {
        Node oldparent = this.getParent();
        if (oldparent != null) {
            oldparent.removeChild(this);
        }
        this.parent.addChild(this);
        this.parent = (Node)newparent;
    }

    public SOAPElement getParentElement() {
        return (SOAPElement)this.getParent();
    }

    public void detachNode() {
        this.parent.removeChild(this);
    }

    public void recycleNode() {
    }

    static class GetChildNodesCallback
    implements NodeListRefresh {
        Node node;

        public GetChildNodesCallback(Node n) {
            this.node = n;
        }

        public void refresh(NodeListImpl nodelist) {
            int cn = this.node.getChangeNumber();
            if (nodelist.getChangeNumber() == cn) {
                return;
            }
            nodelist.setChangeNumber(cn);
            List list = this.node.getChildNodesList();
            nodelist.setList(list);
        }
    }
}

