/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.lang.xml.Document;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.ElementNodeBase;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.XMLTreeBuilder;
import com.wm.util.Name;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class NamespaceDecl
extends ElementNodeBase
implements Attr {
    Name prefix;
    Name uri;
    NamespaceDecl next;
    Node owner;

    public NamespaceDecl(Name pref, Name u) {
        this(pref, u, null);
    }

    public NamespaceDecl(Name uri) {
        this((Name)null, uri, (Node)null);
    }

    NamespaceDecl(Name pref, Name u, Node node) {
        this.prefix = pref;
        this.uri = u;
        this.owner = node;
        if (this.owner != null) {
            this.document = this.owner.document;
        }
    }

    public Name getUri() {
        return this.uri;
    }

    public Name getPrefixWm() {
        return this.prefix;
    }

    public Name getUri(Name pref) {
        if (pref == null) {
            return null;
        }
        if (this.prefix == pref) {
            return this.getUri();
        }
        if (this.next == null) {
            return null;
        }
        return this.next.getUri(pref);
    }

    public void attachNamespaceDecl(NamespaceDecl nsdecl) {
        this.next = nsdecl;
    }

    public void appendGeneratedMarkup(StringBuffer sb) {
        if (this.prefix == null) {
            sb.append("xmlns=\"");
            if (this.uri != null) {
                sb.append(this.uri.toString());
            }
            sb.append('\"');
        } else {
            sb.append("xmlns:");
            sb.append(this.prefix.toString());
            sb.append("=\"");
            if (this.uri != null) {
                sb.append(this.uri.toString());
            }
            sb.append('\"');
        }
    }

    public void appendNSDecls(StringBuffer sb) {
        this.appendGeneratedMarkup(sb);
    }

    public void setUri(Name urival) {
        this.uri = urival;
    }

    void setOwner(Node node) {
        this.owner = node;
    }

    NamespaceDecl lookupByPrefix(Name prefixToFind) {
        NamespaceDecl decl = this;
        do {
            if (decl.prefix != prefixToFind) continue;
            return decl;
        } while ((decl = decl.next) != null);
        return null;
    }

    public NamespaceDecl lookupByUri(Name uriToFind) {
        NamespaceDecl decl = this;
        do {
            if (decl.uri != uriToFind) continue;
            return decl;
        } while ((decl = decl.next) != null);
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("NamespaceDecl(prefix:'");
        if (this.prefix != null) {
            sb.append(this.prefix.toString());
        }
        sb.append("' uri:'");
        if (this.uri != null) {
            sb.append(this.uri.toString());
        }
        sb.append("' owner:'");
        if (this.owner != null) {
            sb.append(this.owner.toString());
        }
        sb.append("')");
        return sb.toString();
    }

    public NamespaceDecl getNext() {
        return this.next;
    }

    public Node getOwner() {
        return this.owner;
    }

    public org.w3c.dom.Node cloneNode(boolean deep) {
        NamespaceDecl clone = new NamespaceDecl(this.prefix, this.uri);
        clone.isComplete(true);
        clone.setDOM1(this.getDOM1());
        clone.document = this.document;
        for (Node node = this.firstChild; node != null; node = (Node)node.getNextSibling()) {
            Node clonedChild = (Node)node.cloneNode(true);
            clonedChild.isComplete(true);
            clone.addChild(clonedChild);
        }
        return clone;
    }

    public String getLocalName() {
        return this.prefix != null ? this.prefix.toString() : "xmlns";
    }

    public void normalize() {
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public org.w3c.dom.Node getNextSibling() {
        return null;
    }

    public short getNodeType() {
        return 2;
    }

    public String getPrefix() {
        if (this.prefix != null) {
            return "xmlns";
        }
        return null;
    }

    public String getNodeValue() {
        String txt = null;
        if (this.uri != null) {
            txt = this.uri.toString();
        }
        return txt;
    }

    public String getValue() {
        return this.getNodeValue();
    }

    public org.w3c.dom.Node getParentNode() {
        return null;
    }

    public org.w3c.dom.Node getPreviousSibling() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public void setNodeValue(String nodeValue) {
        this.setValue(nodeValue);
    }

    public String getName() {
        if (this.prefix == null) {
            return "xmlns";
        }
        return "xmlns:" + this.prefix.toString();
    }

    public String getNodeName() {
        if (this.prefix == null) {
            return "xmlns";
        }
        return "xmlns:" + this.prefix.toString();
    }

    public String getNamespaceURI() {
        return this.uri != null ? Document.xmlnsUri.toString() : null;
    }

    public Element getOwnerElement() {
        return (Element)((Object)this.owner);
    }

    public boolean getSpecified() {
        return true;
    }

    public void setNamespaceDecl(NamespaceDecl nsdecl) {
        super.setNamespaceDecl(nsdecl);
    }

    public void setOwnerElement(ElementNode element) {
        if (this != XMLTreeBuilder.defaultNamespaceDecl && this != XMLTreeBuilder.dtNamespaceDecl && this != XMLTreeBuilder.xmlNamespaceDecl) {
            this.owner = element;
            if (this.document == null) {
                this.document = element.document;
            }
        }
    }

    public boolean isId() {
        throw new UnsupportedOperationException("Implement for DOM Level 3 compliance");
    }
}

