/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.lang.xml.Attribute;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.HTMLTreeBuilder;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.token.HtmlType;
import com.wm.lang.xml.token.Token;
import com.wm.util.Name;

class HtmlElementNode
extends ElementNode {
    HtmlType htmlType;

    HtmlElementNode(Document doc, Token token, HtmlType htmlType) {
        super(doc, token);
        String baseURL;
        this.htmlType = htmlType;
        if (htmlType == HTMLTreeBuilder.bsID && (baseURL = this.getAttributeValue(null, HTMLTreeBuilder.bsID.urlAttribute)) != null && baseURL.length() != 0) {
            this.document.setBaseURL(baseURL);
        }
        this.qualifyUrls();
    }

    HtmlElementNode(Document doc, Name name, HtmlType htmlType) {
        super(doc, null, name);
        this.htmlType = htmlType;
    }

    HtmlElementNode(HtmlElementNode node) {
        super(node);
        this.htmlType = node.htmlType;
    }

    public Node getClone() {
        return new HtmlElementNode(this);
    }

    public HtmlType getHtmlType() {
        return this.htmlType;
    }

    public void addFosterChild(Node node) {
        if (this.firstChild == null) {
            this.firstChild = node;
            this.lastChild = node;
        } else {
            node.prev = this.lastChild;
            this.lastChild.next = node;
            this.lastChild = node;
        }
    }

    public String getText() throws WMDocumentException {
        Node child = this.getFirstChildWm();
        if (child == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (this.isXML() || this.htmlType != null && !this.htmlType.squeeze) {
            this.appendText(sb, true);
        } else {
            this.appendSqueezedText(sb, true, false);
        }
        return sb.toString();
    }

    public void qualifyUrls() {
        String baseUrl = this.document.getBaseURL();
        if (baseUrl == null || this.htmlType == null || this.htmlType.urlAttribute == null || this.firstAttribute == null) {
            return;
        }
        Attribute a = this.findAttribute(null, this.htmlType.urlAttribute);
        if (a != null) {
            a.setValue(HtmlElementNode.qualifyUrl(baseUrl, a.getValue()));
            this.multiflags = (short)(this.multiflags | 0x10);
        }
    }
}

