/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.lang.xml.CustomRegionNode;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.DocumentTreeBuilder;
import com.wm.lang.xml.ElementNodeBase;
import com.wm.lang.xml.FalseElementNode;
import com.wm.lang.xml.FalseTextElementNode;
import com.wm.lang.xml.HtmlElementNode;
import com.wm.lang.xml.NamedProxyNode;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.ProxyNode;
import com.wm.lang.xml.SiblingRegionNode;
import com.wm.lang.xml.TextNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.token.HtmlType;
import com.wm.lang.xml.token.Token;
import com.wm.lang.xml.token.TokenException;
import com.wm.util.BooleanList;
import com.wm.util.List;
import com.wm.util.Name;
import java.io.IOException;

class HTMLTreeBuilder
extends DocumentTreeBuilder {
    static final int POSITION_DELTA = 256;
    Node parent;
    Token next;
    HtmlType nextHtmlType;
    long lastEndSourceIndex;
    Node current;
    List openAtoms;
    int depth;
    BooleanList lastSiblingStack = new BooleanList();
    static HtmlType pID;
    static HtmlType bID;
    static HtmlType dID;
    static HtmlType bsID;
    static HtmlType lineID;
    static Name pName;
    static Name aName;
    static Name brName;
    static Name linkName;
    static Name lineName;
    static Name hrefName;

    HTMLTreeBuilder(Document doc) {
        super(doc);
        this.init();
    }

    HTMLTreeBuilder(DocumentTreeBuilder treeBuilder) {
        super(treeBuilder);
        this.init();
    }

    void init() {
        this.root.isXML(false);
        this.root.position = this.getNextPosition();
        this.openAtoms = new List();
        this.openAtoms.addElement(this.root);
        this.setParent(this.root);
        this.depth = 1;
        if (pID == null) {
            pID = HtmlType.getType("P");
            bID = HtmlType.getType("BR");
            dID = HtmlType.getType("_DOCUMENT_");
            bsID = HtmlType.getType("BASE");
            lineID = HtmlType.getType("LINE");
        }
    }

    void setParent(Node parent) {
        if (parent == null) {
            parent = null;
            this.current = this.root;
        } else {
            this.parent = parent;
            this.current = parent;
        }
    }

    public void processNextToken(Token next) throws IOException, TokenException {
        this.next = next;
        int nextType = next.type;
        if (nextType == 1) {
            TextNode node = new TextNode(this.root, next);
            node.position = this.getNextPosition();
            node.isComplete(true);
            this.current.addChild(node);
        } else if (nextType == 0 || nextType == 4 || nextType == 5) {
            Node offender;
            this.nextHtmlType = HtmlType.getType(next.localName);
            boolean isEndTag = nextType == 4;
            boolean closeParent = false;
            boolean sameAsParent = false;
            if (this.parent != null) {
                sameAsParent = this.parent.getLocalNameWm() == next.localName;
                closeParent = this.parent.getHtmlType().willEndTag(next, this.nextHtmlType);
            }
            if (isEndTag && sameAsParent || !isEndTag && closeParent && sameAsParent) {
                this.closeParent(this.openAtoms.size() - 1);
            } else if (closeParent) {
                for (int i = this.openAtoms.size(); closeParent && i > 0 && !sameAsParent; --i) {
                    sameAsParent = this.parent.getLocalNameWm() == next.localName;
                    this.closeParent(i - 1);
                    if (this.parent == null) continue;
                    closeParent = this.parent.getHtmlType().willEndTag(next, this.nextHtmlType);
                }
            } else if (isEndTag && (offender = this.findOpenTag(next.localName)) != null) {
                this.closeSpecific(offender);
            }
            if (!isEndTag) {
                Node p;
                HtmlElementNode node = new HtmlElementNode(this.root, next, this.nextHtmlType);
                if (this.nextHtmlType.wantsParent != null && this.nextHtmlType.wantsParent != this.parent.getLocalNameWm() && (p = this.findOpenTag(this.nextHtmlType.wantsParent)) != null) {
                    p.addChild(new ProxyNode(node));
                }
                if (this.parent != null) {
                    if (this.nextHtmlType == pID) {
                        this.processParagraph(this.parent);
                    }
                    if (this.nextHtmlType == bID) {
                        this.processBreak(this.parent, false);
                    }
                    node.position = this.getNextPosition();
                    this.current.addChild(node);
                    Name synonym = HtmlType.getAlsoAddAs(next.localName);
                    if (synonym != null) {
                        this.current.addChild(new NamedProxyNode(synonym, (Node)node));
                        if (this.current != this.root) {
                            this.root.addChild(new NamedProxyNode(synonym, (Node)node));
                        }
                    }
                }
                if (this.nextHtmlType != null && !this.nextHtmlType.isEmpty) {
                    if (this.nextHtmlType == pID && !this.parent.getHtmlType().allowPara) {
                        ((Node)node).isComplete(true);
                    } else {
                        ++this.depth;
                        this.setParent(node);
                        this.openAtoms.addElement(node);
                    }
                } else {
                    ((Node)node).isComplete(true);
                }
            }
        }
        this.lastEndSourceIndex = next.endSourceOffset;
    }

    void completeDocumentTree() throws TokenException {
        this.next = null;
        this.tokenSource.close();
        this.root.isComplete(true);
        this.processLinks();
        for (int i = this.openAtoms.size() - 1; i >= 0; --i) {
            this.closeParent(i);
        }
        Node lastChild = this.root.getLastLoadedChild();
        while (lastChild != null && lastChild.isFalseNode()) {
            lastChild = this.root.getPreviousSiblingOfChild(lastChild);
        }
        if (lastChild != null && lastChild.getEndSourceIndex() >= 0L) {
            this.root.startSourceIndex = 0L;
            this.root.endSourceIndex = lastChild.getEndSourceIndex();
        }
    }

    void processParagraph(Node parent) throws TokenException {
        if (!parent.getHtmlType().allowPara) {
            return;
        }
        Node c = parent.getFirstLoadedChild();
        while (c != null && c.isFalseNode()) {
            c = c.next;
        }
        if (c == null) {
            return;
        }
        do {
            if (c.getLocalNameWm() != pName) continue;
            return;
        } while ((c = c.next) != null);
        CustomRegionNode o = new CustomRegionNode(this.root, pName, pID);
        o.position = this.getNextPosition();
        c = parent.getFirstLoadedChild();
        while (c != null) {
            Node nextC = c.next;
            if (!c.isFalseNode()) {
                if (c.getHtmlType() == bID) {
                    this.processBreak(o, false);
                }
                ((Node)o).addChild(c);
            }
            c = nextC;
        }
        this.processBreak(o, true);
        parent.addChild(o);
    }

    private void processLinks() throws TokenException {
        Node o = this.current.getFirstLoadedChild();
        if (o != null) {
            try {
                Node lastChild = this.current.getLastLoadedChild();
                while (o != null) {
                    String href;
                    if (o.getLocalNameWm() == aName && (href = o.getAttributeValue(null, hrefName)) != null && href.indexOf(35) >= 0) {
                        this.current.addChild(new NamedProxyNode(linkName, o));
                    }
                    if (o == lastChild) {
                        o = null;
                        continue;
                    }
                    o = this.current.getNextSiblingOfChild(o);
                }
            }
            catch (WMDocumentException x) {
                throw new TokenException(x.getMessage());
            }
        }
    }

    void processBreak(Node parent, boolean closeParent) throws TokenException {
        Node n = parent.getFirstLoadedChild();
        while (n != null && n.isFalseNode()) {
            n = n.next;
        }
        if (n == null) {
            return;
        }
        Node lastLoadedChild = parent.getLastLoadedChild();
        if (closeParent) {
            try {
                while (n.getLocalNameWm() != brName) {
                    if (n == lastLoadedChild) {
                        return;
                    }
                    n = parent.getNextSiblingOfChild(n);
                }
            }
            catch (WMDocumentException x) {
                throw new TokenException(x.getMessage());
            }
        }
        n = lastLoadedChild;
        while (n != null && (n.isFalseNode() || n.getHtmlType() != bID)) {
            n = parent.getPreviousSiblingOfChild(n);
        }
        if (closeParent && n == lastLoadedChild) {
            return;
        }
        if ((n = n == null ? parent.getFirstLoadedChild() : parent.getNextLoadedChild(n)) == null) {
            n = new FalseElementNode(this.root, lineName, lineID);
            n.isComplete(true);
        } else {
            n = new SiblingRegionNode(this.root, n, lastLoadedChild, lineName, lineID);
        }
        n.position = this.getNextPosition();
        parent.addFosterChild(n);
    }

    void closeSpecific(Node object) throws TokenException {
        int pos = this.openAtoms.indexOf(object);
        if (pos < 0) {
            return;
        }
        int i = this.openAtoms.size();
        while (--i > pos) {
            ((Node)this.openAtoms.elementAt(i)).isComplete(true);
        }
        this.setParent(object);
        this.closeParent(pos);
    }

    void closeParent(int num) throws TokenException {
        ((ElementNodeBase)this.parent).endSourceIndex = this.next != null && this.parent.getLocalNameWm() == this.next.localName && this.next.type == 4 ? this.next.endSourceOffset : this.lastEndSourceIndex;
        this.openAtoms.removeElementAt(num);
        if (!(this.next == null || this.next.type != 0 && this.next.type != 4 || this.nextHtmlType.squeeze)) {
            Node nestedLastLoadedChild;
            Node lastLoadedChild = this.parent.getLastLoadedChild();
            String txt = "";
            if (lastLoadedChild != null) {
                this.lastSiblingStack.reset();
                nestedLastLoadedChild = lastLoadedChild;
                do {
                    this.lastSiblingStack.addBoolean(nestedLastLoadedChild.isLastSibling());
                    nestedLastLoadedChild.isLastSibling(true);
                } while ((nestedLastLoadedChild = nestedLastLoadedChild.getLastLoadedChild()) != null);
                try {
                    txt = this.parent.getText().replace('\r', '\n');
                }
                catch (WMDocumentException x) {
                    throw new TokenException(x.getMessage());
                }
            }
            if (lastLoadedChild != null) {
                nestedLastLoadedChild = lastLoadedChild;
                for (int i = 0; i < this.lastSiblingStack.size(); ++i) {
                    nestedLastLoadedChild.isLastSibling(this.lastSiblingStack.booleanAt(i));
                    nestedLastLoadedChild = nestedLastLoadedChild.getLastLoadedChild();
                }
            }
            String nextLine = null;
            int index = 0;
            int pos = 0;
            boolean done = false;
            while (!done && index < txt.length()) {
                pos = txt.indexOf(10, index);
                if (pos >= 0) {
                    nextLine = txt.substring(index, pos);
                    index = pos + 1;
                    if (pos + 1 < txt.length() - 1 && txt.charAt(pos + 1) == '\n') {
                        ++index;
                    }
                } else if (index < txt.length()) {
                    nextLine = txt.substring(index + 1);
                    done = true;
                    index = pos + 1;
                }
                if (nextLine == null) continue;
                FalseTextElementNode lineNode = new FalseTextElementNode(this.root, nextLine, lineName, lineID);
                lineNode.position = this.getNextPosition();
                this.parent.addChild(lineNode);
            }
        }
        this.processBreak(this.parent, true);
        this.parent.isComplete(true);
        if (this.openAtoms.size() > 0) {
            this.setParent((Node)this.openAtoms.lastElement());
        } else {
            this.setParent(null);
        }
        --this.depth;
    }

    Node findOpenTag(Name type) {
        for (int i = this.openAtoms.size(); i > 0; --i) {
            Node find = (Node)this.openAtoms.elementAt(i - 1);
            if (type != find.getLocalNameWm()) continue;
            return find;
        }
        return null;
    }

    String listOpen() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.openAtoms.size(); ++i) {
            sb.append("<" + ((Node)this.openAtoms.elementAt(i)).getLocalNameWm() + "> ");
        }
        sb.append(" -- <" + this.next.localName + ">");
        return sb.toString();
    }

    int getNextPosition() {
        return this.root.lastPosition += 256;
    }

    static {
        pName = Name.create("P");
        aName = Name.create("A");
        brName = Name.create("BR");
        linkName = Name.create("LINK");
        lineName = Name.create("LINE");
        hrefName = Name.create("HREF");
    }
}

