/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.lang.xml.Document;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.SourceNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.List;

abstract class GeneralRegionNode
extends SourceNode {
    List children = new List(4);

    GeneralRegionNode(Document doc) {
        super(doc);
    }

    GeneralRegionNode(GeneralRegionNode node) {
        super(node);
        this.children = node.children;
    }

    public boolean isComplete() {
        return true;
    }

    public void appendGeneratedMarkup(StringBuffer sb) throws WMDocumentException {
        boolean isEmpty = this.appendGeneratedStartTag(sb);
        int childCount = this.children.size();
        for (int i = 0; i < childCount; ++i) {
            Node child = (Node)this.children.elementAt(i);
            if (child.isFalseNode()) continue;
            child.appendGeneratedMarkup(sb);
        }
        if (!isEmpty) {
            this.appendGeneratedEndTag(sb);
        }
    }

    public Node getFirstRealChild() throws WMDocumentException {
        if (this.children.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < this.children.size()) {
            Node node;
            if ((node = (Node)this.children.elementAt(i++)).isFalseNode()) continue;
            return node;
        }
        return null;
    }

    public Node getFirstLoadedChild() {
        if (this.children.size() == 0) {
            return null;
        }
        return (Node)this.children.elementAt(0);
    }

    public Node getNextLoadedChild(Node n) {
        int i;
        for (i = 0; i < this.children.size() && this.children.elementAt(i) != n; ++i) {
        }
        if (++i < this.children.size()) {
            return (Node)this.children.elementAt(i);
        }
        return null;
    }

    public short getNodeType() {
        return 1;
    }

    public Node getLastRealChild() throws WMDocumentException {
        if (this.children.size() == 0) {
            return null;
        }
        int i = this.children.size();
        while (--i >= 0) {
            Node node = (Node)this.children.elementAt(i);
            if (node.isFalseNode()) continue;
            return node;
        }
        return null;
    }

    public Node getPreviousRealSiblingOfChild(Node child) {
        int childCount = this.children.size();
        Node previous = null;
        for (int i = 0; i < childCount; ++i) {
            Node current = (Node)this.children.elementAt(i);
            if (current == child) {
                return previous;
            }
            if (current.isFalseNode()) continue;
            previous = current;
        }
        return null;
    }

    public Node getNextRealSiblingOfChild(Node child) {
        int childCount = this.children.size();
        for (int i = 0; i < childCount; ++i) {
            Node current = (Node)this.children.elementAt(i);
            if (current != child) continue;
            if (++i == childCount) {
                return null;
            }
            current = (Node)this.children.elementAt(i);
            while (current.isFalseNode() && ++i < childCount) {
                current = (Node)this.children.elementAt(i);
            }
            if (i == childCount) {
                return null;
            }
            return current;
        }
        return null;
    }

    public Node getLastLoadedChild() {
        if (this.children.size() == 0) {
            return null;
        }
        return (Node)this.children.elementAt(this.children.size() - 1);
    }

    public String getTextAsData() throws WMDocumentException {
        StringBuffer sb = new StringBuffer();
        GeneralRegionNode.appendTextAsData(sb, this);
        return sb.toString();
    }

    public String getTextOfChildren() throws WMDocumentException {
        StringBuffer sb = new StringBuffer();
        this.appendSqueezedText(sb, false, false);
        return sb.toString();
    }

    void appendText(StringBuffer sb, boolean recurse) throws WMDocumentException {
        int childCount = this.children.size();
        if (childCount == 0) {
            return;
        }
        for (int i = 0; i < childCount; ++i) {
            Node next = (Node)this.children.elementAt(i);
            if (next.isFalseNode() || !recurse && !next.isTextNode()) continue;
            next.appendText(sb, recurse);
        }
    }

    boolean appendSqueezedText(StringBuffer sb, boolean recurse, boolean inSpaces) throws WMDocumentException {
        int childCount = this.children.size();
        if (childCount == 0) {
            return inSpaces;
        }
        for (int i = 0; i < childCount; ++i) {
            Node next = (Node)this.children.elementAt(i);
            if (next.isFalseNode() || !recurse && !next.isTextNode()) continue;
            inSpaces = next.appendSqueezedText(sb, recurse, inSpaces);
        }
        return inSpaces;
    }
}

