/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.lang.xml.Document;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.Name;
import com.wm.util.Values;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public class FactoryTest {
    public static void main(String[] args) throws IOException, FileNotFoundException, WMDocumentException {
        Document doc;
        InputStream inputStream;
        boolean incremental = false;
        boolean structureonly = false;
        if (args.length < 1) {
            FactoryTest.usage();
            return;
        }
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-i")) {
                incremental = true;
                continue;
            }
            if (arg.startsWith("-p")) {
                structureonly = true;
                continue;
            }
            FactoryTest.usage();
            return;
        }
        String inputFile = args[0];
        if (inputFile.startsWith("http://", 0)) {
            URL url = new URL(inputFile);
            inputStream = url.openStream();
        } else {
            inputStream = new FileInputStream(inputFile);
        }
        try {
            doc = new Document(inputStream, "", null, false, true);
            if (!incremental) {
                doc.completeLoad();
            }
        }
        catch (WMDocumentException e) {
            System.err.println("Error: WMDocumentException caught! " + e.getMessage());
            doc = null;
            System.exit(-1);
        }
        if (doc == null) {
            return;
        }
        System.out.println("Namespace definitions: ");
        Values result = doc.getNamespaces();
        if (result != null) {
            Enumeration prefixes = result.keys();
            while (prefixes.hasMoreElements()) {
                String keystring = (String)prefixes.nextElement();
                String uri = ((Name)result.get(keystring)).toString();
                System.out.println("Prefix: " + keystring + "\tUri: " + uri);
            }
        }
        try {
            if (structureonly) {
                System.out.println("Printing tree structure...");
                System.out.println(doc.toFormatedString(0));
            } else {
                StringBuffer sb = new StringBuffer(1024);
                doc.appendGeneratedMarkup(sb);
                System.out.println(sb);
            }
        }
        catch (WMDocumentException e) {
            System.err.println("WMDocumentException caught: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    static void usage() {
        System.out.println("java ParseTreeTest <input-file> [<output-file>] [<options>]");
        System.out.println();
        System.out.println("<options>:");
        System.out.println("  -x   xml  mode (default is html)");
        System.out.println("  -i   using incremental binding");
        System.out.println("  -p   Output parse structure, not source.");
    }
}

