/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.dom.DOMExceptionImpl;
import com.wm.dom.NodeListImpl;
import com.wm.dom.NodeListRefresh;
import com.wm.lang.xml.Attribute;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.DocumentTreeBuilder;
import com.wm.lang.xml.NamespaceDecl;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.SourceNode;
import com.wm.lang.xml.TextNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.resources.WMDocumentExceptionBundle;
import com.wm.util.Name;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.NodeList;

public class ElementNodeBase
extends SourceNode {
    Name localname;
    NamespaceDecl namespaceDecl;
    long endStartTagIndex = -1L;
    NamespaceDecl firstNamespaceDecl;
    Attribute firstAttribute;
    Node firstChild;
    Node lastChild;
    private String baseURI;

    protected ElementNodeBase() {
        this(null, null, null);
    }

    ElementNodeBase(Document doc) {
        this(doc, null, null);
    }

    ElementNodeBase(Document doc, Name nsUri, Name lname) {
        super(doc);
        this.localname = lname;
    }

    protected ElementNodeBase(ElementNodeBase node) {
        super(node);
        this.localname = node.localname;
        this.namespaceDecl = node.namespaceDecl;
        this.endStartTagIndex = node.endStartTagIndex;
        this.firstChild = node.firstChild;
        this.lastChild = node.lastChild;
        this.firstNamespaceDecl = node.firstNamespaceDecl;
        this.firstAttribute = node.firstAttribute;
    }

    void setEndStartTagIndex(int val) {
        this.endStartTagIndex = val;
    }

    long getEndStartTagIndex() {
        return this.endStartTagIndex;
    }

    public void appendGeneratedMarkup(StringBuffer sb) throws WMDocumentException {
        boolean isEmpty = this.appendGeneratedStartTag(sb);
        for (Node node = this.getFirstChildWm(); node != null; node = node.getNextSiblingWm()) {
            if (node == this) {
                throw new WMDocumentException(WMDocumentExceptionBundle.class, WMDocumentExceptionBundle.NODE_IS_THIS, "");
            }
            if (node.isFalseNode()) continue;
            node.appendGeneratedMarkup(sb);
        }
        if (!isEmpty) {
            this.appendGeneratedEndTag(sb);
        }
    }

    public short getNodeType() {
        return 1;
    }

    public String getText() throws WMDocumentException {
        Node child = this.getFirstChildWm();
        if (child == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (this.isXML()) {
            this.appendText(sb, true);
        } else {
            this.appendSqueezedText(sb, true, false);
        }
        return sb.toString();
    }

    public String getTextAsData() throws WMDocumentException {
        StringBuffer sb = new StringBuffer();
        ElementNodeBase.appendTextAsData(sb, this);
        return sb.toString();
    }

    public String getTextOfChildren() throws WMDocumentException {
        Node child = this.getFirstChildWm();
        if (child == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (this.isXML()) {
            this.appendText(sb, false);
        } else {
            this.appendSqueezedText(sb, false, false);
        }
        return sb.toString();
    }

    void appendText(StringBuffer sb, boolean recurse) throws WMDocumentException {
        for (Node child = this.getFirstChildWm(); child != null; child = child.getNextSiblingWm()) {
            if (child.isFalseNode() || !recurse && !child.isTextNode()) continue;
            child.appendText(sb, recurse);
        }
    }

    boolean appendSqueezedText(StringBuffer sb, boolean recurse, boolean inSpaces) throws WMDocumentException {
        for (Node next = this.getFirstChildWm(); next != null; next = next.getNextSiblingWm()) {
            if (next.isFalseNode() || !recurse && !next.isTextNode()) continue;
            inSpaces = next.appendSqueezedText(sb, recurse, inSpaces);
        }
        return inSpaces;
    }

    void setFirstChild(Node node) {
        this.firstChild = node;
        this.incrementChangeNumber();
    }

    public void addChild(Node node) {
        if (this.firstChild == null) {
            this.firstChild = node;
            this.lastChild = node;
            node.parent = this;
        } else {
            this.lastChild.isLastSibling(false);
            node.prev = this.lastChild;
            this.lastChild.next = node;
            this.lastChild = node;
            node.parent = this;
        }
        if (this.document.isComplete()) {
            this.lastChild.isLastSibling(true);
        }
        this.incrementChangeNumber();
    }

    public final void addChildren(Node node) throws WMDocumentException {
        if (this.firstChild == null) {
            this.firstChild = node;
            node.parent = this;
        } else {
            this.lastChild.isLastSibling(false);
            node.prev = this.lastChild;
            this.lastChild.next = node;
            node.parent = this;
        }
        this.lastChild = node;
        for (Node next = node.getNextSiblingWm(); next != null; next = next.getNextSiblingWm()) {
            this.lastChild = next;
        }
        this.lastChild.isLastSibling(true);
        this.incrementChangeNumber();
    }

    public void insertChildNode(Node nodeToPrecede, Node nodeToInsert) throws WMDocumentException {
        if (nodeToPrecede.prev == null) {
            nodeToInsert.prev = null;
            nodeToInsert.next = this.firstChild;
            this.firstChild.prev = nodeToInsert;
            this.firstChild = nodeToInsert;
            nodeToInsert.parent = this;
        } else {
            nodeToPrecede.prev.next = nodeToInsert;
            nodeToInsert.prev = nodeToPrecede.prev;
            nodeToInsert.next = nodeToPrecede;
            nodeToPrecede.prev = nodeToInsert;
            nodeToInsert.parent = this;
        }
        this.incrementChangeNumber();
    }

    public Node getFirstChildWm() throws WMDocumentException {
        DocumentTreeBuilder tb = this.document.getTreeBuilder();
        while (tb != null && !this.isComplete() && this.firstChild == null) {
            tb.processNextToken();
        }
        return this.firstChild;
    }

    public Node getLastChildWm() throws WMDocumentException {
        DocumentTreeBuilder tb = this.document.getTreeBuilder();
        while (tb != null && !this.isComplete()) {
            tb.processNextToken();
        }
        return this.lastChild;
    }

    public Node getFirstLoadedChild() {
        return this.firstChild;
    }

    public Node getNextLoadedChild(Node previousChild) {
        return previousChild.next;
    }

    public Node getLastLoadedChild() {
        return this.lastChild;
    }

    public boolean appendGeneratedStartTag(StringBuffer sb) throws WMDocumentException {
        if (this.namespaceDecl == null || this.namespaceDecl.prefix == null) {
            sb.append('<');
            sb.append(this.localname.toString());
        } else {
            sb.append('<');
            sb.append(this.namespaceDecl.prefix.toString());
            sb.append(':');
            sb.append(this.localname.toString());
        }
        NamespaceDecl decl = this.firstNamespaceDecl;
        while (decl != null && decl.owner == this) {
            sb.append(' ');
            decl.appendGeneratedMarkup(sb);
            decl = decl.next;
        }
        if (this.getOwnerDocument() == null || !((Document)this.getOwnerDocument()).isCanonicalize()) {
            for (Attribute attr = this.firstAttribute; attr != null; attr = attr.getNext()) {
                sb.append(' ');
                attr.appendGeneratedMarkup(sb);
            }
            if (this.getFirstChildWm() != null || !this.isShownAsEmpty()) {
                sb.append('>');
                return false;
            }
            sb.append("/>");
            return true;
        }
        if (this.firstAttribute != null) {
            int attrCount = 0;
            for (Attribute attr = this.firstAttribute; attr != null; attr = attr.getNext()) {
                ++attrCount;
            }
            Attribute[] sortedAtts = new Attribute[attrCount];
            int i = 0;
            for (Attribute attr = this.firstAttribute; attr != null; attr = attr.getNext()) {
                sortedAtts[i++] = attr;
            }
            while (--attrCount > 0) {
                for (i = 0; i < attrCount; ++i) {
                    if (sortedAtts[i].getLocalName().toString().compareTo(sortedAtts[i + 1].getLocalName().toString()) <= 0) continue;
                    Attribute savedAtt = sortedAtts[i];
                    sortedAtts[i] = sortedAtts[i + 1];
                    sortedAtts[i + 1] = savedAtt;
                }
            }
            for (i = 0; i < sortedAtts.length; ++i) {
                sb.append(' ');
                sortedAtts[i].appendGeneratedMarkup(sb);
            }
        }
        sb.append('>');
        return false;
    }

    void appendGeneratedEndTag(StringBuffer sb) {
        sb.append("</");
        if (this.namespaceDecl != null && this.namespaceDecl.uri != null && this.namespaceDecl.prefix != null) {
            sb.append(this.namespaceDecl.prefix.toString());
            sb.append(':');
        }
        sb.append(this.localname.toString());
        sb.append('>');
    }

    public void appendOriginalStartTag(StringBuffer sb) throws WMDocumentException {
        if (this.endStartTagIndex < 0L) {
            this.appendGeneratedStartTag(sb);
        } else {
            this.document.sourceBuffer.appendString(sb, this.startSourceIndex, this.endStartTagIndex);
        }
    }

    public void assignNamespaceDecl(Name prefix, Name uri) {
        NamespaceDecl decl;
        if (this.firstNamespaceDecl != null) {
            decl = this.firstNamespaceDecl;
            while (decl != null && decl.owner == this) {
                if (decl.prefix == prefix && decl.uri == uri) {
                    return;
                }
                decl = decl.next;
            }
        }
        decl = new NamespaceDecl(prefix, uri, this);
        decl.next = this.firstNamespaceDecl;
        this.firstNamespaceDecl = decl;
    }

    public NamespaceDecl assignNamespaceDecl(NamespaceDecl newNsd) {
        NamespaceDecl prev = null;
        NamespaceDecl removed = null;
        if (this.firstNamespaceDecl != null) {
            NamespaceDecl decl = this.firstNamespaceDecl;
            while (decl != null && decl.owner == this) {
                if (decl.prefix == newNsd.prefix && decl.uri == newNsd.uri) {
                    removed = decl;
                    if (prev == null) {
                        this.firstNamespaceDecl = newNsd;
                    } else {
                        prev.next = newNsd;
                    }
                    newNsd.next = removed.next;
                    return removed;
                }
                prev = decl;
                decl = decl.next;
            }
        }
        newNsd.next = this.firstNamespaceDecl;
        this.firstNamespaceDecl = newNsd;
        return null;
    }

    public Attribute getFirstAttribute() {
        return this.firstAttribute;
    }

    public String getAttributeValue(Name nsuri, Name localname) {
        for (Attribute attr = this.firstAttribute; attr != null; attr = attr.getNext()) {
            if (localname != attr.localname || !(nsuri != null ? attr.namespaceDecl != null && attr.namespaceDecl.uri == nsuri : attr.namespaceDecl == null || attr.namespaceDecl.equals(this.namespaceDecl))) continue;
            return attr.value;
        }
        return null;
    }

    public Name getLocalNameWm() {
        return this.localname;
    }

    protected void setLocalName(Name name) {
        this.localname = name;
    }

    public NamespaceDecl getFirstNamespaceDecl() {
        return this.firstNamespaceDecl;
    }

    public NamespaceDecl getNextNamespaceDecl(NamespaceDecl prevDecl) {
        if (prevDecl == null) {
            if (this.firstNamespaceDecl == null) {
                return null;
            }
            if (this.firstNamespaceDecl.owner != this) {
                return null;
            }
            return this.firstNamespaceDecl;
        }
        if (prevDecl.next == null) {
            return null;
        }
        if (prevDecl.next.owner != this) {
            return null;
        }
        return prevDecl.next;
    }

    public void setFirstNamespaceDecl(NamespaceDecl nsdecl) {
        this.firstNamespaceDecl = nsdecl;
    }

    public Name getNamespacePrefix() {
        if (this.namespaceDecl == null) {
            return null;
        }
        return this.namespaceDecl.prefix;
    }

    public Name getNamespaceUri() {
        if (this.namespaceDecl == null) {
            return null;
        }
        return this.namespaceDecl.uri;
    }

    NamespaceDecl getNamespaceDecl() {
        return this.namespaceDecl;
    }

    public NamespaceDecl getPrimaryNamespaceDecl() {
        return this.namespaceDecl;
    }

    public void setNamespaceDecl(NamespaceDecl nsdecl) {
        this.namespaceDecl = nsdecl != null && nsdecl.uri != null && nsdecl.uri.toString() != null && nsdecl.uri.toString().length() == 0 ? null : nsdecl;
    }

    public void removeNamespaceDecl(Name prefix) {
        NamespaceDecl decl = this.firstNamespaceDecl;
        NamespaceDecl prevDecl = null;
        while (decl != null && decl.getPrefixWm() != prefix) {
            prevDecl = decl;
            decl = decl.next;
        }
        if (decl != null) {
            if (prevDecl == null) {
                this.firstNamespaceDecl = decl.next;
            } else {
                prevDecl.next = decl.next;
            }
        }
        this.incrementChangeNumber();
    }

    public void isComplete(boolean val) {
        super.isComplete(val);
        if (this.lastChild != null && val) {
            this.lastChild.isLastSibling(true);
        }
    }

    public Node getClone() {
        return new ElementNodeBase(this);
    }

    public Node getPreviousSiblingOfChild(Node child) {
        return child.prev;
    }

    public Node getNextSiblingOfChild(Node child) throws WMDocumentException {
        return child.getNextSiblingWm();
    }

    public void removeChild(Node node) {
        if (node == this.firstChild && node == this.lastChild) {
            this.lastChild = null;
            this.firstChild = null;
            node.isLastSibling(false);
        } else if (node == this.firstChild) {
            this.firstChild = node.next;
            this.firstChild.prev = null;
        } else if (node == this.lastChild) {
            this.lastChild = node.prev;
            this.lastChild.next = null;
            this.lastChild.isLastSibling(true);
            node.isLastSibling(false);
        } else {
            Node prevsibling;
            Node nextsibling = node.next;
            nextsibling.prev = prevsibling = node.prev;
            prevsibling.next = nextsibling;
        }
        node.parent = null;
        node.prev = null;
        node.next = null;
        this.incrementChangeNumber();
    }

    Attribute findAttribute(Name uri, Name name) {
        for (Attribute att = this.firstAttribute; att != null; att = att.getNext()) {
            if (att.localname != name) continue;
            if (uri != null) {
                if (att.namespaceDecl == null || att.namespaceDecl.uri != uri) continue;
                return att;
            }
            return att;
        }
        return null;
    }

    Attribute findAttribute1(Name prefix, Name name) {
        for (Attribute att = this.firstAttribute; att != null; att = att.getNext()) {
            if (att.localname != name) continue;
            if (prefix != null) {
                if (att.namespaceDecl == null || att.namespaceDecl.prefix != prefix) continue;
                return att;
            }
            return att;
        }
        return null;
    }

    public String toString() {
        if (this.getNamespaceDecl() == null) {
            return "Element: " + this.getLocalNameWm().toString();
        }
        return "Element: " + this.getNamespaceDecl().getPrefixWm() + ":" + this.getLocalNameWm().toString();
    }

    public boolean equals(String name, String URI2) {
        if (name.equals(this.getLocalNameWm().toString())) {
            String nsuri = this.getNamespaceUri().toString();
            if (nsuri == null && (URI2 == null || URI2.equals(""))) {
                return true;
            }
            if (nsuri.equals(URI2)) {
                return true;
            }
        }
        return false;
    }

    String slowGetNodeName() {
        if (this.namespaceDecl == null || this.namespaceDecl.uri == null || this.namespaceDecl.prefix == null) {
            return this.localname.toString();
        }
        return this.namespaceDecl.prefix.toString() + ":" + this.localname.toString();
    }

    public NamespaceDecl lookUpInScopeNSDeclByPrefix(Name prefix) {
        if (this.firstNamespaceDecl == null) {
            return null;
        }
        return this.firstNamespaceDecl.lookupByPrefix(prefix);
    }

    public NamespaceDecl lookUpInScopeNSDeclByURI(Name uri) {
        if (uri == null || this.firstNamespaceDecl == null) {
            return null;
        }
        return this.firstNamespaceDecl.lookupByUri(uri);
    }

    public String getInScopeNSDecls() {
        StringBuffer sb = new StringBuffer();
        NamespaceDecl ns = this.firstNamespaceDecl;
        while (ns != null) {
            sb.append(ns.getPrefixWm() + "=" + ns.getUri() + "\n");
            ns = ns.next;
        }
        return sb.toString();
    }

    public String getNodeName() {
        if (this.namespaceDecl == null || this.namespaceDecl.prefix == null) {
            return this.localname.toString();
        }
        Name pre = this.namespaceDecl.getPrefixWm();
        String prefix = pre != null ? pre.toString() : null;
        return prefix != null ? prefix + ":" + this.localname.toString() : this.localname.toString();
    }

    public String getNamespaceURI() {
        Name uri = this.getNamespaceUri();
        if (uri != null) {
            return uri.toString();
        }
        return null;
    }

    public String getLocalName() {
        if (this.getDOM1()) {
            return null;
        }
        return this.localname.toString();
    }

    public String getPrefix() {
        if (this.namespaceDecl == null || this.namespaceDecl.prefix == null) {
            return null;
        }
        return this.namespaceDecl.prefix.toString();
    }

    public void setPrefix(String prefix) throws DOMException {
        super.setPrefix(prefix);
        Document.checkValidName(prefix);
        if (this.namespaceDecl == null || this.getNamespaceUri() == null) {
            throw new DOMException(14, "DOM Namespace error");
        }
        if (prefix != null && (prefix.equals("xml") && !this.getNamespaceUri().toString().equals("http://www.w3.org/XML/1998/namespace") || prefix.equals("xmlns") && !this.getNamespaceUri().toString().equals("http://www.w3.org/2000/xmlns/") || prefix.indexOf(58) != -1)) {
            throw new DOMExceptionImpl(14);
        }
        if ("xmlns".equals(this.localname.toString())) {
            throw new DOMExceptionImpl(14);
        }
        this.namespaceDecl.prefix = Name.create(prefix);
    }

    public NodeList getElementsByTagName(String tagname) {
        GetByTagNameNodeListCallback callback = new GetByTagNameNodeListCallback(this, tagname);
        return new NodeListImpl(callback);
    }

    private List getElementListByTagName(String tagname) {
        ArrayList list = new ArrayList();
        this.getElementListByTagNameRecurse(list, tagname);
        return list;
    }

    private void getElementListByTagNameRecurse(List list, String tagname) {
        Node n = this.firstChild;
        while (n != null) {
            if (n instanceof ElementNodeBase) {
                ElementNodeBase e = (ElementNodeBase)n;
                if (tagname.equals("*") || tagname.equals(e.getTagName())) {
                    // empty if block
                }
                e.getElementListByTagNameRecurse(list, tagname);
            }
            n = n.next;
        }
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        GetByTagNameNodeListCallback callback = new GetByTagNameNodeListCallback(this, namespaceURI, localName);
        return new NodeListImpl(callback);
    }

    private List getElementListByTagNameNS(String namespaceURI, String localName) {
        ArrayList list = new ArrayList();
        this.getElementListByTagNameNSRecurse(list, namespaceURI, localName);
        return list;
    }

    private void getElementListByTagNameNSRecurse(List list, String namespaceURI, String lname) {
        Node n = this.firstChild;
        while (n != null) {
            if (n instanceof ElementNodeBase) {
                ElementNodeBase e = (ElementNodeBase)n;
                if ((lname.equals("*") || lname.equals(e.getLocalName())) && (namespaceURI == null && e.getNamespaceURI() == null || "*".equals(namespaceURI) || namespaceURI != null && namespaceURI.equals(e.getNamespaceURI()))) {
                    list.add(e);
                }
                e.getElementListByTagNameNSRecurse(list, namespaceURI, lname);
            }
            n = n.next;
        }
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public short compareDocumentPosition(org.w3c.dom.Node other) throws DOMException {
        if (other instanceof Node) {
            return (short)(this.getPosition() - ((Node)other).getPosition());
        }
        throw new DOMExceptionImpl(9);
    }

    public String getTextContent() throws DOMException {
        try {
            return this.getText();
        }
        catch (WMDocumentException e) {
            throw new DOMExceptionImpl(9, (Throwable)e);
        }
    }

    public void setTextContent(String textContent) throws DOMException {
        try {
            Node child;
            if (textContent == null || textContent.equals("")) {
                return;
            }
            for (child = this.getFirstChildWm(); child != null; child = child.getNextSiblingWm()) {
                this.removeChild(child);
            }
            if (child == null) {
                this.setFirstChild(new TextNode((Document)this.getOwnerDocument(), textContent));
                return;
            }
        }
        catch (WMDocumentException e) {
            throw new DOMExceptionImpl(9, (Throwable)e);
        }
    }

    public boolean isSameNode(org.w3c.dom.Node other) {
        return this == other;
    }

    public boolean isEqualNode(org.w3c.dom.Node arg) {
        return this.equals(arg.getNodeName(), arg.getNamespaceURI());
    }

    static class GetByTagNameNodeListCallback
    implements NodeListRefresh {
        ElementNodeBase node;
        String tagname = null;
        String namespaceURI = null;
        String localName = null;

        public GetByTagNameNodeListCallback(ElementNodeBase n, String tag) {
            this.node = n;
            this.tagname = tag;
        }

        public GetByTagNameNodeListCallback(ElementNodeBase n, String uri, String name) {
            this.node = n;
            this.namespaceURI = uri;
            this.localName = name;
        }

        public void refresh(NodeListImpl nodelist) {
            int cn = this.node.getChangeNumber();
            if (nodelist.getChangeNumber() == cn) {
                return;
            }
            nodelist.setChangeNumber(cn);
            List list = this.tagname != null ? this.node.getElementListByTagName(this.tagname) : this.node.getElementListByTagNameNS(this.namespaceURI, this.localName);
            nodelist.setList(list);
        }
    }
}

