/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.dom.AttributeNamedNodeMap;
import com.wm.dom.DOMExceptionImpl;
import com.wm.lang.xml.Attribute;
import com.wm.lang.xml.AttributeDef;
import com.wm.lang.xml.DTD;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.ElementDef;
import com.wm.lang.xml.ElementNodeBase;
import com.wm.lang.xml.NamespaceDecl;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.XMLTreeBuilder;
import com.wm.lang.xml.resources.WMDocumentExceptionBundle;
import com.wm.lang.xml.token.Token;
import com.wm.lang.xml.token.TokenAttribute;
import com.wm.util.List;
import com.wm.util.Name;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class ElementNode
extends ElementNodeBase
implements Element {
    static final String XML_URI = "http://www.w3.org/XML/1998/namespace";
    static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";

    protected ElementNode() {
    }

    protected ElementNode(Document doc) {
        super(doc);
    }

    protected ElementNode(Document doc, Name nsUri, Name lname) {
        super(doc, nsUri, lname);
    }

    protected ElementNode(ElementNode node) {
        super(node);
    }

    public ElementNode(Document doc, Token token) {
        this(doc);
        this.localname = token.localName;
        if (token.firstAssignedAttribute != null) {
            List idAttrLocalNames = this.document.idAttrLocalNames;
            boolean foundUnique = idAttrLocalNames == null;
            TokenAttribute tokenAttr = token.firstAssignedAttribute;
            while (tokenAttr != null) {
                int idAttrIndex;
                Attribute attr;
                Name attrLocalName = tokenAttr.localName;
                Name attrNSPrefix = tokenAttr.nsPrefix;
                if (attrNSPrefix == null) {
                    if (attrLocalName == Document.xmlnsName) {
                        this.assignNamespaceDecl(null, Name.create(tokenAttr.value));
                    } else {
                        attr = new Attribute(this.document, this, attrLocalName, tokenAttr.value);
                        attr.next = this.firstAttribute;
                        this.firstAttribute = attr;
                        tokenAttr.actual = attr;
                        if (!foundUnique) {
                            idAttrIndex = this.document.idAttrLocalNameCount;
                            while (--idAttrIndex >= 0) {
                                if (idAttrLocalNames.elementAt(idAttrIndex) != attrLocalName || !this.document.cacheIfUnique(this, token.nsPrefix, token.localName, tokenAttr.nsPrefix, attrLocalName, tokenAttr.value)) continue;
                                foundUnique = true;
                            }
                        }
                    }
                } else if (attrNSPrefix == Document.xmlnsName) {
                    this.assignNamespaceDecl(attrLocalName, Name.create(tokenAttr.value));
                } else {
                    attr = new Attribute(this.document, this, attrLocalName, tokenAttr.value);
                    attr.next = this.firstAttribute;
                    this.firstAttribute = attr;
                    tokenAttr.actual = attr;
                    if (!foundUnique) {
                        idAttrIndex = this.document.idAttrLocalNameCount;
                        while (--idAttrIndex >= 0) {
                            if (idAttrLocalNames.elementAt(idAttrIndex) != attrLocalName || !this.document.cacheIfUnique(this, token.nsPrefix, token.localName, tokenAttr.nsPrefix, attrLocalName, tokenAttr.value)) continue;
                            foundUnique = true;
                        }
                    }
                }
                tokenAttr = tokenAttr.next;
            }
        }
        this.startSourceIndex = token.startSourceOffset;
        this.endSourceIndex = token.endSourceOffset;
        this.endStartTagIndex = token.endSourceOffset;
    }

    public Attribute assignAttribute(Name uri, Name localname, String value) throws WMDocumentException {
        Attribute attr;
        block6: {
            attr = this.findAttribute(uri, localname);
            if (attr != null) {
                attr.value = value;
                return attr;
            }
            attr = new Attribute(this.document, this, localname, value);
            if (uri != null) {
                if (this.firstNamespaceDecl != null) {
                    attr.namespaceDecl = this.firstNamespaceDecl.lookupByUri(uri);
                }
                if (attr.namespaceDecl == null) {
                    Object[] sArray = new String[]{uri.toString(), this.slowGetNodeName().toString()};
                    throw new WMDocumentException(WMDocumentExceptionBundle.class, WMDocumentExceptionBundle.URI_NOT_DECLARED, "", sArray);
                }
            }
            attr.next = this.firstAttribute;
            this.firstAttribute = attr;
            if (this.document.idAttrLocalNameCount == 0) break block6;
            List idAttrLocalNames = this.document.idAttrLocalNames;
            int idAttrIndex = this.document.idAttrLocalNameCount;
            Name attrPrefix = null;
            if (uri != null) {
                attrPrefix = attr.namespaceDecl.prefix;
            }
            while (!(--idAttrIndex < 0 || idAttrLocalNames.elementAt(idAttrIndex) == localname && this.document.cacheIfUnique(this, this.namespaceDecl.prefix, this.localname, attrPrefix, localname, value))) {
            }
        }
        return attr;
    }

    public boolean removeAttribute(Name namespaceUri, Name localName) {
        Attribute attr;
        Attribute prevAttr = null;
        for (attr = this.firstAttribute; attr != null && (attr.getLocalNameWm() != localName || attr.getNamespaceUri() != namespaceUri); attr = attr.getNext()) {
            prevAttr = attr;
        }
        if (attr != null) {
            attr.setOwnerElement(null);
            if (prevAttr == null) {
                this.firstAttribute = attr.getNext();
            } else {
                prevAttr.next = attr.next;
            }
            this.removeDefaultAttribute(attr);
            this.incrementChangeNumber();
            return true;
        }
        if (Document.xmlnsName == localName && XMLNS_URI.equals(namespaceUri)) {
            localName = null;
        } else if ((namespaceUri != null && namespaceUri.equals(XMLNS_URI) || localName == null) && this.firstNamespaceDecl != null) {
            Object prev = null;
            NamespaceDecl current = this.firstNamespaceDecl;
            while (current != null) {
                if (current.getPrefixWm() == localName && this == current.getOwner()) {
                    if (prev == null) {
                        this.firstNamespaceDecl = current.next;
                    } else {
                        prev.next = current.next;
                    }
                    this.incrementChangeNumber();
                    return true;
                }
                current = current.next;
            }
        }
        return false;
    }

    public Node getClone() {
        return new ElementNode(this);
    }

    public org.w3c.dom.Node cloneNode(boolean deep) {
        this.document.completeLoadDOM();
        ElementNode clone = new ElementNode(this.document, null, this.localname);
        clone.namespaceDecl = this.namespaceDecl;
        clone.setDOM1(this.getDOM1());
        for (NamespaceDecl nsd = this.firstNamespaceDecl; nsd != null; nsd = nsd.getNext()) {
            if (nsd.owner != null && nsd.owner != this) continue;
            clone.assignNamespaceDecl(nsd.getPrefixWm(), nsd.getUri());
        }
        for (Attribute attr = this.firstAttribute; attr != null; attr = attr.getNext()) {
            if (!attr.getSpecified()) continue;
            clone.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getValue());
        }
        if (deep) {
            for (Node node = this.firstChild; node != null; node = (Node)node.getNextSibling()) {
                Node clonedChild = (Node)node.cloneNode(deep);
                clonedChild.isComplete(true);
                clone.addChild(clonedChild);
            }
        }
        return clone;
    }

    public boolean hasAttributes() {
        if (this.firstAttribute != null) {
            return true;
        }
        if (this.firstNamespaceDecl == null) {
            return false;
        }
        boolean hasAttrib = false;
        for (NamespaceDecl current = this.firstNamespaceDecl; current != null; current = current.getNext()) {
            if (current == XMLTreeBuilder.defaultNamespaceDecl || current == XMLTreeBuilder.xmlNamespaceDecl || current == XMLTreeBuilder.dtNamespaceDecl || current.owner != this) continue;
            hasAttrib = true;
            break;
        }
        return hasAttrib;
    }

    public String getAttribute(String name) {
        Attr a = this.findAttr(name);
        if (a == null) {
            return "";
        }
        return a.getValue();
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        Attr a = this.findAttr(namespaceURI, localName);
        if (a == null) {
            return "";
        }
        return a.getValue();
    }

    public Attr getAttributeNode(String name) {
        Attr a = this.findAttr(name);
        return a;
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        Attr a = this.findAttr(namespaceURI, localName);
        return a;
    }

    public boolean hasAttribute(String name) {
        Attr a = this.findAttr(name);
        return a != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        Attr a = this.findAttr(namespaceURI, localName);
        return a != null;
    }

    public void removeAttribute(String name) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, "removeAttribute");
        }
        if (this.removeAttribute(null, Name.create(name))) {
            return;
        }
        throw new DOMExceptionImpl(8);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, "removeAttributeNS");
        }
        if (this.removeAttribute(Name.create(namespaceURI), Name.create(localName))) {
            return;
        }
        throw new DOMExceptionImpl(8);
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        Attribute attr;
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, "removeAttributeNode");
        }
        Attribute prevAttr = null;
        for (attr = this.firstAttribute; attr != null && attr != oldAttr; attr = attr.getNext()) {
            prevAttr = attr;
        }
        if (attr != null) {
            attr.setOwnerElement(null);
            if (prevAttr == null) {
                this.firstAttribute = attr.getNext();
            } else {
                prevAttr.next = attr.next;
            }
            this.removeDefaultAttribute(attr);
            this.incrementChangeNumber();
            return attr;
        }
        if (oldAttr instanceof NamespaceDecl) {
            NamespaceDecl nsd = this.firstNamespaceDecl;
            NamespaceDecl prevnsd = null;
            while (nsd != null && nsd != oldAttr) {
                prevnsd = nsd;
                nsd = nsd.next;
            }
            if (nsd != null) {
                nsd.setOwnerElement(null);
                if (prevnsd == null) {
                    this.firstNamespaceDecl = nsd.next;
                } else {
                    prevnsd.next = nsd.next;
                }
                this.incrementChangeNumber();
                return nsd;
            }
        }
        throw new DOMExceptionImpl(8);
    }

    public void setAttribute(String name, String value) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, "setAttribute");
        }
        Document.checkValidName(name);
        if (Document.xmlnsName.toString().equalsIgnoreCase(name)) {
            this.assignNamespaceDecl(null, Name.create(value));
            return;
        }
        try {
            this.assignAttribute(null, Name.create(name), value);
        }
        catch (WMDocumentException e) {
            throw new DOMException(15, e.toString());
        }
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        Name nameUri = Name.create(namespaceURI);
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, "setAttributeNS");
        }
        Document.checkValidName(qualifiedName);
        try {
            Attribute attr;
            int i = qualifiedName.indexOf(58);
            if (i == -1) {
                Name prefix = null;
                Name localNM = Name.create(qualifiedName);
                if (Document.xmlnsName.toString().equalsIgnoreCase(qualifiedName) && nameUri != Document.xmlnsUri) {
                    throw new DOMException(14, "DOM Namespace error");
                }
                if (Document.xmlnsName.toString().equalsIgnoreCase(qualifiedName)) {
                    this.assignNamespaceDecl(null, Name.create(value));
                    return;
                }
                this.assignNamespaceDecl(prefix, nameUri);
                attr = this.assignAttribute(nameUri, localNM, value);
            } else {
                if (namespaceURI == null) {
                    throw new DOMException(14, "DOM Namespace error");
                }
                Name prefix = Name.create(qualifiedName.substring(0, i));
                Name localNM = Name.create(qualifiedName.substring(i + 1));
                if (Document.xmlnsName.toString().equalsIgnoreCase(prefix.toString()) && nameUri != Document.xmlnsUri) {
                    throw new DOMException(14, "DOM Namespace error");
                }
                if (Document.xmlName.toString().equalsIgnoreCase(prefix.toString()) && nameUri != Document.defaultUri) {
                    throw new DOMException(14, "DOM Namespace error");
                }
                if (Document.xmlnsName == prefix) {
                    this.assignNamespaceDecl(localNM, Name.create(value));
                    return;
                }
                this.assignNamespaceDecl(prefix, nameUri);
                attr = this.assignAttribute(nameUri, localNM, value);
            }
            if (nameUri != null && this.firstNamespaceDecl != null) {
                NamespaceDecl nsd = this.firstNamespaceDecl.lookupByUri(nameUri);
                if (nsd == null) {
                    Object[] sArray = new String[]{nameUri.toString(), this.slowGetNodeName().toString()};
                    throw new WMDocumentException(WMDocumentExceptionBundle.class, WMDocumentExceptionBundle.URI_NOT_DECLARED, "", sArray);
                }
                attr.setNamespaceDecl(nsd);
            }
        }
        catch (WMDocumentException e) {
            throw new DOMException(15, e.toString());
        }
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, "setAttributeNode");
        }
        if (newAttr instanceof NamespaceDecl) {
            return this.assignNamespaceDecl((NamespaceDecl)newAttr);
        }
        return this.insertAttribute((Attribute)newAttr);
    }

    public Attr setAttributeNodeNS(Attr newAttr) {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, "setAttributeNodeNS");
        }
        return this.setAttributeNode(newAttr);
    }

    public NamedNodeMap getAttributes() {
        return new AttributeNamedNodeMap(this);
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
    }

    private Attr findAttr(String uri, String localName) {
        NamespaceDecl nsdecl = null;
        Node attr = null;
        Name localNm = Name.create(localName);
        if (Document.xmlnsName == localNm && XMLNS_URI.equals(uri)) {
            localNm = null;
        }
        if (this.firstNamespaceDecl != null) {
            nsdecl = this.firstNamespaceDecl.lookupByPrefix(localNm);
        }
        if (nsdecl != null && this == nsdecl.getOwner()) {
            attr = nsdecl;
        }
        if (attr == null) {
            attr = this.findAttribute(Name.create(uri), localNm);
        }
        return attr;
    }

    private Attr findAttr(String nodeName) {
        NamespaceDecl nsdecl = null;
        NamespaceDecl attr = null;
        String prefix = null;
        String localName = null;
        int i = nodeName.indexOf(58);
        if (i != -1) {
            prefix = nodeName.substring(0, i);
            localName = nodeName.substring(i + 1);
        } else {
            localName = nodeName;
        }
        if (localName.equals("xmlns") || prefix != null && prefix.equals("xmlns")) {
            if (localName.equals("xmlns")) {
                localName = null;
            }
            if (this.firstNamespaceDecl != null) {
                nsdecl = this.firstNamespaceDecl.lookupByPrefix(Name.create(localName));
            }
            if (nsdecl != null && this == nsdecl.getOwner()) {
                attr = nsdecl;
            }
            return attr;
        }
        if (prefix == null) {
            return this.findAttribute1(null, Name.create(localName));
        }
        return this.findAttribute1(Name.create(prefix), Name.create(localName));
    }

    private Attribute insertAttribute(Attribute attr) throws DOMException {
        Attribute replaced;
        block6: {
            replaced = null;
            Name uri = attr.getNamespaceUri();
            String value = attr.getNodeValue();
            if (attr.getOwnerDocument() != this.getOwnerDocument()) {
                throw new DOMExceptionImpl(4);
            }
            if (attr.getOwnerElement() != null) {
                throw new DOMExceptionImpl(10);
            }
            attr.setOwnerElement(this);
            attr.next = this.firstAttribute;
            this.firstAttribute = attr;
            Attribute prev = attr;
            while (prev.next != null) {
                if (prev.getNext().equals(attr.getLocalNameWm(), uri)) {
                    replaced = prev.getNext();
                    prev.next = prev.next.next;
                    break;
                }
                prev = prev.getNext();
            }
            if (this.document.idAttrLocalNameCount == 0) break block6;
            List idAttrLocalNames = this.document.idAttrLocalNames;
            int idAttrIndex = this.document.idAttrLocalNameCount;
            Name attrPrefix = null;
            if (uri != null) {
                attrPrefix = attr.namespaceDecl.prefix;
            }
            while (!(--idAttrIndex < 0 || idAttrLocalNames.elementAt(idAttrIndex) == this.localname && this.document.cacheIfUnique(this, this.namespaceDecl.prefix, this.localname, attrPrefix, this.localname, value))) {
            }
        }
        return replaced;
    }

    private void removeDefaultAttribute(Attribute attr) {
        DTD dtd = null;
        Document doc = null;
        if (attr != null && (doc = (Document)attr.getOwnerDocument()) != null) {
            ElementDef elementDef;
            try {
                dtd = doc.getDTD();
            }
            catch (WMDocumentException ex) {
                // empty catch block
            }
            if (dtd != null && (elementDef = dtd.getElementDef(Name.create(this.getPrefix()), this.getLocalNameWm())) != null) {
                String defValue;
                AttributeDef attrDef;
                for (attrDef = elementDef.getFirstAttributeDef(); attrDef != null && (attrDef.getLocalName() != attr.getLocalNameWm() || attrDef.getNSPrefix() != attr.getNamespacePrefix()); attrDef = attrDef.getNext()) {
                }
                if (attrDef != null && (defValue = attrDef.getDefaultValue()) != null) {
                    try {
                        this.assignAttribute(attr.getNamespaceUri(), attr.getLocalNameWm(), defValue);
                    }
                    catch (WMDocumentException ex2) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void resetDocumentPointers(Document doc) throws WMDocumentException {
        super.resetDocumentPointers(doc);
        this.addDefaultAttributes(doc);
    }

    private void addDefaultAttributes(Document doc) {
        DTD dtd = null;
        if (doc != null) {
            ElementDef elementDef;
            try {
                dtd = this.document.getDTD();
            }
            catch (WMDocumentException ex) {
                // empty catch block
            }
            if (dtd != null && (elementDef = dtd.getElementDef(Name.create(this.getPrefix()), this.getLocalNameWm())) != null) {
                for (AttributeDef attrDef = elementDef.getFirstAttributeDef(); attrDef != null; attrDef = attrDef.getNext()) {
                    String defValue = attrDef.getDefaultValue();
                    if (defValue == null) continue;
                    try {
                        NamespaceDecl nsdecl = this.lookUpInScopeNSDeclByPrefix(attrDef.getNSPrefix());
                        Name nsUri = nsdecl != null ? nsdecl.getUri() : null;
                        this.assignAttribute(nsUri, attrDef.getLocalName(), defValue);
                        continue;
                    }
                    catch (WMDocumentException ex2) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

