/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.lang.xml.AttributeDef;
import com.wm.lang.xml.AttributeDefEnumeration;
import com.wm.lang.xml.ContentParticle;
import com.wm.lang.xml.ContentParticleName;
import com.wm.lang.xml.ContentParticleSet;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.XmlName;
import com.wm.lang.xml.resources.WMDocumentExceptionBundle;
import com.wm.lang.xml.token.WMTokenSource;
import com.wm.util.Name;
import java.util.Enumeration;

public class ElementDef {
    public static final int CONTENT_EMPTY = 0;
    public static final int CONTENT_ANY = 1;
    public static final int CONTENT_PARTICLES = 2;
    static final String TERM_ANY = "ANY";
    static final String TERM_EMPTY = "EMPTY";
    static final String TERM_PCDATA = "PCDATA";
    static final int GOT_NOTHING = 0;
    static final int GOT_NAME = 1;
    static final int GOT_MULTIPLIER = 2;
    static final int GOT_DELIMITER = 3;
    static final int GOT_GROUP = 4;
    boolean isDeclared;
    boolean dupsRemoved;
    XmlName name;
    AttributeDef firstAttributeDef;
    AttributeDef lastAttributeDef;
    int contentType;
    ContentParticle cp;
    ElementDef next;
    String contentspec;
    int charIndex;
    int nameCount = 0;
    boolean pcdataDisallowed = false;
    boolean pcdataFound = false;

    ElementDef(Name nsPrefix, Name localName) {
        this.name = new XmlName(nsPrefix, localName);
    }

    ElementDef(Name nsPrefix, Name localName, String contentspec) {
        this.name = new XmlName(nsPrefix, localName);
        this.setContentspec(contentspec);
    }

    public XmlName getName() {
        return this.name;
    }

    public Name getNSPrefix() {
        return this.name.nsPrefix;
    }

    public Name getLocalName() {
        return this.name.localName;
    }

    public AttributeDef getFirstAttributeDef() {
        if (!this.dupsRemoved) {
            for (AttributeDef lookingFor = this.firstAttributeDef; lookingFor != null; lookingFor = lookingFor.getNext()) {
                AttributeDef previous = lookingFor;
                for (AttributeDef lookingAt = lookingFor.next; lookingAt != null; lookingAt = lookingAt.getNext()) {
                    if (lookingAt.getLocalName() == lookingFor.getLocalName() && lookingAt.getNSPrefix() == lookingFor.getNSPrefix()) {
                        previous.setNext(lookingAt.getNext());
                    }
                    previous = lookingAt;
                }
            }
            this.dupsRemoved = true;
        }
        return this.firstAttributeDef;
    }

    public int getContentType() throws WMDocumentException {
        if (this.contentspec != null) {
            this.parseContentspec();
        }
        return this.contentType;
    }

    public ContentParticle getContentParticle() throws WMDocumentException {
        if (this.contentspec != null) {
            this.parseContentspec();
        }
        return this.cp;
    }

    public ContentParticle getFlattenedModel() throws WMDocumentException {
        if (this.contentspec != null) {
            this.parseContentspec();
        }
        return this.cp.getFlattenedModel();
    }

    public Enumeration getAttributeDefs() {
        AttributeDef first = this.getFirstAttributeDef();
        if (first != null) {
            return new AttributeDefEnumeration(first);
        }
        return null;
    }

    public void append(StringBuffer sb) throws WMDocumentException {
        sb.append("<!ELEMENT ");
        sb.append(this.name);
        sb.append(' ');
        int type = this.getContentType();
        switch (type) {
            case 0: {
                sb.append(TERM_EMPTY);
                break;
            }
            case 1: {
                sb.append(TERM_ANY);
                break;
            }
            case 2: {
                this.cp.appendString(sb);
            }
        }
        sb.append(" >\n");
        if (this.firstAttributeDef != null) {
            sb.append("<!ATTLIST ");
            sb.append(this.name);
            for (AttributeDef attDef = this.firstAttributeDef; attDef != null; attDef = attDef.getNext()) {
                sb.append("\n    ");
                attDef.append(sb);
            }
            sb.append(" >\n");
        }
    }

    void appendFlattened(StringBuffer sb) throws WMDocumentException {
        sb.append("<!ELEMENT ");
        sb.append(this.name);
        sb.append(' ');
        int type = this.getContentType();
        switch (type) {
            case 0: {
                sb.append(TERM_EMPTY);
                break;
            }
            case 1: {
                sb.append(TERM_ANY);
                break;
            }
            case 2: {
                ContentParticle flat = this.getFlattenedModel();
                flat.appendString(sb);
            }
        }
        sb.append(" >\n");
    }

    void addAttributes(AttributeDef firstNewAttDef) {
        if (firstNewAttDef != null) {
            if (this.firstAttributeDef == null) {
                this.firstAttributeDef = firstNewAttDef;
            } else {
                this.lastAttributeDef.next = firstNewAttDef;
            }
            while (firstNewAttDef.next != null) {
                firstNewAttDef = firstNewAttDef.next;
            }
            this.lastAttributeDef = firstNewAttDef;
        }
    }

    void setContentspec(String contentspec) {
        this.contentspec = contentspec;
    }

    void parseContentspec() throws WMDocumentException {
        this.skipSpaces();
        char next = this.contentspec.charAt(this.charIndex);
        if (next != '(') {
            String typeStr = this.getNameToken();
            if (typeStr == null) {
                this.contentspecError("no contentspec supplied");
            } else if (typeStr.equals(TERM_EMPTY)) {
                this.contentType = 0;
            } else if (typeStr.equals(TERM_ANY)) {
                this.contentType = 1;
            } else {
                this.contentspecError("contentspec must begin with EMPTY, ANY, or '('");
            }
            this.skipSpaces();
            if (this.charIndex < this.contentspec.length()) {
                this.contentspecError("nothing may follow EMPTY or ANY in contentspec");
            }
        } else {
            this.cp = this.parseContentParticle();
            if (this.pcdataFound && this.pcdataDisallowed) {
                this.contentspecError("contentspec does not conform to mixed content grammar");
            }
            if (this.nameCount == 0) {
                this.contentspecError("contentspec must contain at least one name or #PCDATA");
            }
            if (++this.charIndex < this.contentspec.length()) {
                next = this.contentspec.charAt(this.charIndex);
                if (this.pcdataFound && this.nameCount > 1 && next != '*') {
                    this.contentspecError("contentspec for mixed content must end with '*'");
                }
                this.assignMultiplicity(this.cp, next);
            }
            this.contentType = 2;
        }
        this.contentspec = null;
    }

    ContentParticle parseContentParticle() throws WMDocumentException {
        int delimiter = 0;
        int justRead = 0;
        String nameStr = null;
        ++this.charIndex;
        this.skipSpaces();
        int next = this.contentspec.charAt(this.charIndex);
        ContentParticleSet currentCP = new ContentParticleSet();
        ContentParticle nestedCP = null;
        while (next != 41 && next != -1) {
            switch (next) {
                case 40: {
                    if (justRead != 0 && justRead != 3) {
                        this.contentspecError("'(' is not valid here");
                    }
                    nestedCP = this.parseContentParticle();
                    if (this.contentspec.charAt(this.charIndex) == ')') {
                        currentCP.addChild(nestedCP);
                    } else {
                        this.contentspecError("'(' has no matching ')'");
                    }
                    ++this.charIndex;
                    this.pcdataDisallowed = true;
                    justRead = 4;
                    break;
                }
                case 44: 
                case 124: {
                    ++this.charIndex;
                    if (delimiter != 0 && next != delimiter || justRead == 3) {
                        this.contentspecError("cannot mix '|' and ',' in same content particle");
                    }
                    delimiter = next;
                    if (next == 44) {
                        this.pcdataDisallowed = true;
                    }
                    justRead = 3;
                    break;
                }
                case 42: 
                case 43: 
                case 63: {
                    ++this.charIndex;
                    if (justRead != 1 && justRead != 4) {
                        this.contentspecError("'" + (char)next + "' is not valid here");
                    }
                    this.assignMultiplicity(nestedCP, next);
                    this.pcdataDisallowed = true;
                    justRead = 2;
                    break;
                }
                case 35: {
                    ++this.charIndex;
                    nameStr = this.getNameToken();
                    if (justRead != 0 || nameStr == null || !nameStr.equals(TERM_PCDATA)) {
                        this.contentspecError("# is not allowed except in term #PCDATA");
                    }
                    this.pcdataFound = true;
                    ++this.nameCount;
                    justRead = 1;
                    break;
                }
                default: {
                    if (justRead != 0 && justRead != 3) {
                        this.contentspecError("'|' or ',' is required here");
                    }
                    if (!WMTokenSource.isNameStartChar(next) || (nameStr = this.getNameToken()) == null) {
                        this.contentspecError("not a valid element type name");
                    }
                    nestedCP = new ContentParticleName(new XmlName(nameStr));
                    currentCP.addChild(nestedCP);
                    ++this.nameCount;
                    justRead = 1;
                }
            }
            this.skipSpaces();
            if (this.charIndex < this.contentspec.length()) {
                next = this.contentspec.charAt(this.charIndex);
                continue;
            }
            next = -1;
        }
        if (justRead == 3 || justRead == 0 || next == -1) {
            this.contentspecError("incomplete contentspec");
        }
        if (this.pcdataFound && delimiter == 44) {
            this.contentspecError("',' is not allowed in mixed content");
        }
        if (this.pcdataFound) {
            currentCP.setType(3);
        } else if (delimiter == 124) {
            currentCP.setType(1);
        } else {
            currentCP.setType(2);
        }
        return currentCP;
    }

    void skipSpaces() {
        while (this.charIndex < this.contentspec.length() && WMTokenSource.isXMLSpace(this.contentspec.charAt(this.charIndex))) {
            ++this.charIndex;
        }
    }

    String getNameToken() {
        int start = this.charIndex;
        while (this.charIndex < this.contentspec.length() && (WMTokenSource.isNameChar(this.contentspec.charAt(this.charIndex)) || this.contentspec.charAt(this.charIndex) == ':')) {
            ++this.charIndex;
        }
        if (start == this.charIndex) {
            return null;
        }
        return this.contentspec.substring(start, this.charIndex);
    }

    void assignMultiplicity(ContentParticle cp, int next) {
        if (next == 63) {
            cp.isOptional(true);
        } else if (next == 42) {
            cp.isOptional(true);
            cp.isRepeatable(true);
        } else if (next == 43) {
            cp.isRepeatable(true);
        }
    }

    void contentspecError(String msg) throws WMDocumentException {
        Object[] sArray = new String[]{this.name.toString(), this.contentspec, String.valueOf(this.charIndex), msg};
        throw new WMDocumentException(WMDocumentExceptionBundle.class, WMDocumentExceptionBundle.ELEMENT_DEF_ERROR, "", sArray);
    }

    public boolean containsPCDATA() throws WMDocumentException {
        this.getContentType();
        return this.pcdataFound;
    }
}

