/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.lang.xml.Document;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.token.Token;
import com.wm.lang.xml.token.TokenException;
import com.wm.lang.xml.token.TokenProcessor;
import com.wm.lang.xml.token.TokenSource;
import com.wm.util.LocalizedExceptionInfo;
import java.io.IOException;

public abstract class DocumentTreeBuilder
implements TokenProcessor {
    protected Document root;
    TokenSource tokenSource;

    DocumentTreeBuilder(Document doc) {
        this.root = doc;
    }

    DocumentTreeBuilder(DocumentTreeBuilder treeBuilder) {
        this.root = treeBuilder.root;
        this.tokenSource = treeBuilder.tokenSource;
    }

    public TokenSource getTokenSource() {
        return this.tokenSource;
    }

    public void setTokenSource(TokenSource tsource) {
        this.tokenSource = tsource;
    }

    public String getBaseURL() {
        return this.root.getBaseURL();
    }

    public void terminate() {
        this.tokenSource.close();
    }

    public boolean processNextToken() throws WMDocumentException {
        try {
            Token token = this.tokenSource.nextToken();
            if (token == null) {
                this.completeDocumentTree();
                return false;
            }
            this.processNextToken(token);
        }
        catch (IOException x) {
            throw new WMDocumentException(x.getClass().getName() + ": " + x.getMessage());
        }
        catch (TokenException x) {
            TokenException te = x;
            LocalizedExceptionInfo info = te.getInfo();
            if (info != null) {
                throw new WMDocumentException(info);
            }
            throw new WMDocumentException(x.getMessage());
        }
        return true;
    }

    abstract void completeDocumentTree() throws TokenException;
}

