/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.ValuesEmulator;
import com.wm.dom.DOMExceptionImpl;
import com.wm.dom.DocumentFragmentImpl;
import com.wm.dom.DocumentTypeImpl;
import com.wm.dom.EntityReferenceImpl;
import com.wm.lang.xml.Attribute;
import com.wm.lang.xml.CDataNode;
import com.wm.lang.xml.CommentNode;
import com.wm.lang.xml.DTD;
import com.wm.lang.xml.DefaultXmlHostServices;
import com.wm.lang.xml.DocumentTreeBuilder;
import com.wm.lang.xml.ElementDef;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.ElementNodeBase;
import com.wm.lang.xml.GeneralRegionNode;
import com.wm.lang.xml.HTMLTreeBuilder;
import com.wm.lang.xml.IdAttributeDecl;
import com.wm.lang.xml.NamespaceDecl;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.NodeCriterion;
import com.wm.lang.xml.NodeIterator;
import com.wm.lang.xml.PINode;
import com.wm.lang.xml.ProxyNode;
import com.wm.lang.xml.SiblingRegionNode;
import com.wm.lang.xml.StructuredRegionNode;
import com.wm.lang.xml.TestReconstituter;
import com.wm.lang.xml.TextNode;
import com.wm.lang.xml.TextNodeBase;
import com.wm.lang.xml.UndecidedTreeBuilder;
import com.wm.lang.xml.VerificationState;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.WmDocumentTreeBuilderException;
import com.wm.lang.xml.XMLTreeBuilder;
import com.wm.lang.xml.XmlHostServices;
import com.wm.lang.xml.XmlName;
import com.wm.lang.xml.resources.WMDocumentExceptionBundle;
import com.wm.lang.xml.resources.XmlInterruptedIOExceptionBundle;
import com.wm.lang.xml.token.HtmlType;
import com.wm.lang.xml.token.SourceBuffer;
import com.wm.lang.xml.token.SunSaxTokenSourceFactory;
import com.wm.lang.xml.token.TokenException;
import com.wm.lang.xml.token.TokenSource;
import com.wm.lang.xml.token.TokenSourceFactory;
import com.wm.lang.xml.token.WMTokenSourceFactory;
import com.wm.lang.xml.token.WmDocReader;
import com.wm.util.Config;
import com.wm.util.EncUtil;
import com.wm.util.List;
import com.wm.util.LocalizedInterruptedIOException;
import com.wm.util.Name;
import com.wm.util.Strings;
import com.wm.util.Values;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.crimson.parser.XmlReaderGetter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class Document
extends ElementNodeBase
implements org.w3c.dom.Document {
    private boolean canonicalize = false;
    public static Name defaultUri = Name.create("http://www.w3.org/XML/1998/namespace");
    public static final int DOCTYPE_FLOW = 3;
    public static final int DOCTYPE_HTML = 5;
    public static final int DOCTYPE_MAPPING = 2;
    public static final int DOCTYPE_UNKNOWN = 0;
    public static final int DOCTYPE_WIDL = 1;
    public static final int DOCTYPE_XML = 4;
    public static final String[] docTypeString = new String[]{"Unknown", "WIDL", "Mapping", "Flow", "XML", "Text"};
    public static Name DOCUMENT_NAME = Name.create("_DOCUMENT_");
    public static Name dtName = Name.create("dt");
    static XmlHostServices host = new DefaultXmlHostServices();
    static final int INTERRUPT_TEST_INTERVAL = 20;
    static final int MAX_LOOKAHEAD_BUFFER = 256;
    static final int MAX_LOOKAHEAD_WORD = 6;
    public static final int OPT_DOC_ENTITY_REFS = 2;
    public static final int OPT_DONT_EXPAND_DTD = 0;
    public static final int OPT_EXPAND_DTD = 1;
    static final String PROPERTY_READER = "watt.core.xmlreader";
    private static final String PROPERTY_EXPAND_GENERAL_ENTITIES = "watt.core.xml.expandGeneralEntities";
    private static final String expandGeneralEntitiesSysPropValue = Config.getProperty("true", "watt.core.xml.expandGeneralEntities");
    public static boolean trace = false;
    static final int UXR_SUN = 2;
    static final int UXR_UNKNOWN = 0;
    static final int UXR_WM = 1;
    static int useXmlReader = 0;
    static TokenSourceFactory wmFactory = new WMTokenSourceFactory();
    public static final String XML_DECLARATION = "<?xml version=\"1.0\"?>";
    static TokenSourceFactory xmlFactory = null;
    public static Name xmlName = Name.create("xml");
    public static Name XMLName = Name.create("XML");
    public static Name xmlnsName = Name.create("xmlns");
    public static Name xmlnsUri = Name.create("http://www.w3.org/2000/xmlns/");
    static Constructor<? extends DocumentTreeBuilder> soapConstructor;
    private Reader _reader;
    String assignedEncoding;
    String baseURL;
    Vector cookies;
    DocumentType docType;
    int documentType;
    private DOMConfiguration domConfiguration;
    DTD dtd;
    boolean firstElementVerified;
    Hashtable headerInfo;
    int idAttributeDeclCount;
    List idAttributeDecls;
    int idAttrLocalNameCount;
    List idAttrLocalNames;
    private boolean isXmlStandalone;
    int lastPosition;
    long lastPurgeSourceIndex;
    Values misc;
    IData nodesById;
    String publicId;
    SourceBuffer sourceBuffer;
    String systemId;
    DocumentTreeBuilder treeBuilder;
    TokenSourceFactory tsFactory;
    String URLString;
    private boolean useEntityReferences = false;
    private boolean useStrictErrorChecking = true;
    String xmlDecl;
    private String xmlUri;
    private String xmlVersion = "7.0";

    static String canonicalizeText(String inputText) {
        StringBuffer sb = new StringBuffer();
        boolean prevWas0x0D = false;
        for (int i = 0; i < inputText.length(); ++i) {
            char c = inputText.charAt(i);
            if (prevWas0x0D && c != '\n') {
                sb.append("&#13;");
            }
            switch (c) {
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\t': {
                    sb.append("&#9;");
                    break;
                }
                case '\n': {
                    sb.append("&#10;");
                    break;
                }
                case '\r': {
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            prevWas0x0D = c == '\r';
        }
        if (prevWas0x0D) {
            sb.append("&#13;");
        }
        return sb.toString();
    }

    public static void checkValidName(String name) {
        char c;
        if (name == null) {
            throw new DOMExceptionImpl(5);
        }
        int len = name.length();
        if (len == 0) {
            throw new DOMExceptionImpl(5);
        }
        int i = name.indexOf(58);
        if (i != -1) {
            if (i == 0 || i == len - 1) {
                throw new DOMExceptionImpl(14);
            }
            if (i != name.lastIndexOf(58)) {
                throw new DOMExceptionImpl(14);
            }
        }
        if (!Document.isXmlBaseChar(c = name.charAt(0)) && !Document.isXmlIdeoChar(c) && c != '_') {
            throw new DOMExceptionImpl(5);
        }
        for (i = 1; i < len; ++i) {
            c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || ".-_:".indexOf(c) != -1 || Document.isExtenderChar(c) || Document.isCombiningChar(c)) continue;
            throw new DOMExceptionImpl(5);
        }
    }

    public static XmlHostServices getHostServices() {
        return host;
    }

    static NodeCriterion[] getNodeIteratorCriteria(String patternFile) throws IOException, WMDocumentException {
        Values nsDecls = new Values();
        Object[] criteria = null;
        if (patternFile != null) {
            String line;
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(patternFile), EncUtil.getFileEncoding());
            LineNumberReader reader = new LineNumberReader(isr);
            List criteriaList = new List();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("namespace")) {
                    line = line.substring(9).trim();
                    int space = line.indexOf(32);
                    String prefix = line.substring(0, space);
                    String uri = line.substring(space).trim();
                    nsDecls.put(prefix, Name.create(uri));
                    continue;
                }
                if (line.startsWith("criterion")) {
                    line = line.substring(9).trim();
                    criteriaList.addElement(new NodeCriterion(line, nsDecls));
                    continue;
                }
                System.out.println("Pattern file must consist of lines of the form:");
                System.out.println("  namespace <prefix> <uri>");
                System.out.println("  criterion <pattern>");
                System.out.println("Furthermore, all namespaces must precede all criteria.");
                return null;
            }
            criteria = new NodeCriterion[criteriaList.size()];
            criteriaList.copyInto(criteria);
        }
        return criteria;
    }

    static int inferSyntax(String url) {
        if (url == null) {
            return 0;
        }
        int pos = url.lastIndexOf(46);
        if (pos < 0) {
            return 0;
        }
        if (url.substring(pos + 1).equalsIgnoreCase("xml") || url.substring(pos + 1).equalsIgnoreCase("widl") || url.substring(pos + 1).equalsIgnoreCase("flow")) {
            return 1;
        }
        return 0;
    }

    private static boolean isCombiningChar(char c) {
        return c >= '\u0300' && c <= '\u0345' || c >= '\u0360' && c <= '\u0361' || c >= '\u0483' && c <= '\u0486' || c >= '\u0591' && c <= '\u05a1' || c >= '\u05a3' && c <= '\u05b9' || c >= '\u05bb' && c <= '\u05bd' || c >= '\u05c1' && c <= '\u05c2' || c == '\u05c4' || c >= '\u064b' && c <= '\u0652' || c == '\u0670' || c >= '\u06d6' && c <= '\u06dc' || c >= '\u06dd' && c <= '\u06df' || c >= '\u06e0' && c <= '\u06e4' || c >= '\u06e7' && c <= '\u06e8' || c >= '\u06ea' && c <= '\u06ed' || c >= '\u0901' && c <= '\u0903' || c == '\u093c' || c >= '\u093e' && c <= '\u094c' || c == '\u094d' || c >= '\u0951' && c <= '\u0954' || c >= '\u0962' && c <= '\u0663' || c >= '\u0981' && c <= '\u0983' || c == '\u09bc' || c == '\u09be' || c == '\u09bf' || c >= '\u09c0' && c <= '\u09c4' || c >= '\u09c7' && c <= '\u09c8' || c >= '\u09cb' && c <= '\u09cd' || c == '\u09d7' || c >= '\u09e2' && c <= '\u09e3' || c == '\u0a02' || c == '\u0a3c' || c == '\u0a3e' || c == '\u0a3f' || c >= '\u0a40' && c <= '\u0a42' || c >= '\u0a47' && c <= '\u0a48' || c >= '\u0a4b' && c <= '\u0a4d' || c >= '\u0a70' && c <= '\u0a71' || c >= '\u0a81' && c <= '\u0a83' || c == '\u0abc' || c >= '\u0abe' && c <= '\u0ac5' || c >= '\u0ac7' && c <= '\u0ac9' || c >= '\u0acb' && c <= '\u0acd' || c >= '\u0b01' && c <= '\u0b03' || c == '\u0b3c' || c >= '\u0b3e' && c <= '\u0b43' || c >= '\u0b47' && c <= '\u0b48' || c >= '\u0b4b' && c <= '\u0b4d' || c >= '\u0b56' && c <= '\u0b57' || c >= '\u0b82' && c <= '\u0b83' || c >= '\u0bbe' && c <= '\u0bc2' || c >= '\u0bc6' && c <= '\u0bc8' || c >= '\u0bca' && c <= '\u0bcd' || c == '\u0bd7' || c >= '\u0c01' && c <= '\u0c03' || c >= '\u0c3e' && c <= '\u0c44' || c >= '\u0c46' && c <= '\u0c48' || c >= '\u0c4a' && c <= '\u0c4d' || c >= '\u0c55' && c <= '\u0c56' || c >= '\u0c82' && c <= '\u0c83' || c >= '\u0cbe' && c <= '\u0cc4' || c >= '\u0cc6' && c <= '\u0cc8' || c >= '\u0cca' && c <= '\u0ccd' || c >= '\u0cd5' && c <= '\u0cd6' || c >= '\u0d02' && c <= '\u0d03' || c >= '\u0d3e' && c <= '\u0d43' || c >= '\u0d46' && c <= '\u0d48' || c >= '\u0d4a' && c <= '\u0d4d' || c == '\u0d57' || c == '\u0e31' || c >= '\u0e34' && c <= '\u0e3a' || c >= '\u0e47' && c <= '\u0e4e' || c == '\u0eb1' || c >= '\u0eb4' && c <= '\u0eb9' || c >= '\u0ebb' && c <= '\u0ebc' || c >= '\u0ec8' && c <= '\u0ecd' || c >= '\u0f18' && c <= '\u0f19' || c == '\u0f35' || c == '\u0f37' || c == '\u0f39' || c == '\u0f3e' || c == '\u0f3f' || c >= '\u0f71' && c <= '\u0f84' || c >= '\u0f86' && c <= '\u0f8b' || c >= '\u0f90' && c <= '\u0f95' || c == '\u0f97' || c >= '\u0f99' && c <= '\u0fad' || c >= '\u0fb1' && c <= '\u0fb7' || c == '\u0fb9' || c >= '\u20d0' && c <= '\u20dc' || c == '\u20e1' || c >= '\u302a' && c <= '\u302f' || c == '\u3099' || c == '\u309a';
    }

    private static boolean isExtenderChar(char c) {
        return c == '\u00b7' || c == '\u02d0' || c == '\u02d1' || c == '\u0387' || c == '\u0640' || c == '\u0e46' || c == '\u0ec6' || c == '\u3005' || c >= '\u30d9' && c <= '\u309e' || c >= '\u30fc' && c <= '\u30fe';
    }

    private static boolean isXmlBaseChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u00ff' || c >= '\u0100' && c <= '\u0131' || c >= '\u0134' && c <= '\u013e' || c >= '\u0141' && c <= '\u0148' || c >= '\u014a' && c <= '\u017e' || c >= '\u0180' && c <= '\u01c3' || c >= '\u01cd' && c <= '\u01f0' || c >= '\u01f4' && c <= '\u01f5' || c >= '\u01fa' && c <= '\u0217' || c >= '\u0250' && c <= '\u02a8' || c >= '\u02bb' && c <= '\u02c1' || c == '\u0386' || c >= '\u0388' && c <= '\u038a' || c == '\u038c' || c >= '\u038e' && c <= '\u03a1' || c >= '\u03a3' && c <= '\u03ce' || c >= '\u03d0' && c <= '\u03d6' || c == '\u03da' || c == '\u03dc' || c == '\u03de' || c == '\u03e0' || c >= '\u03e2' && c <= '\u03f3' || c >= '\u0401' && c <= '\u040c' || c >= '\u040e' && c <= '\u044f' || c >= '\u0451' && c <= '\u045c' || c >= '\u045e' && c <= '\u0481' || c >= '\u0490' && c <= '\u04c4' || c >= '\u04c7' && c <= '\u04c8' || c >= '\u04cb' && c <= '\u04cc' || c >= '\u04d0' && c <= '\u04eb' || c >= '\u04ee' && c <= '\u04f5' || c >= '\u04f8' && c <= '\u04f9' || c >= '\u0531' && c <= '\u0556' || c == '\u0559' || c >= '\u0561' && c <= '\u0586' || c >= '\u05d0' && c <= '\u05ea' || c >= '\u05f0' && c <= '\u05f2' || c >= '\u0621' && c <= '\u063a' || c >= '\u0641' && c <= '\u064a' || c >= '\u0671' && c <= '\u06b7' || c >= '\u06ba' && c <= '\u06be' || c >= '\u06c0' && c <= '\u06ce' || c >= '\u06d0' && c <= '\u06d3' || c == '\u06d5' || c >= '\u06e5' && c <= '\u06e6' || c >= '\u0905' && c <= '\u0939' || c == '\u093d' || c >= '\u0958' && c <= '\u0961' || c >= '\u0985' && c <= '\u098c' || c >= '\u098f' && c <= '\u0990' || c >= '\u0993' && c <= '\u09a8' || c >= '\u09aa' && c <= '\u09b0' || c == '\u09b2' || c >= '\u09b6' && c <= '\u09b9' || c >= '\u09dc' && c <= '\u09dd' || c >= '\u09df' && c <= '\u09e1' || c >= '\u09f0' && c <= '\u09f1' || c >= '\u0a05' && c <= '\u0a0a' || c >= '\u0a0f' && c <= '\u0a10' || c >= '\u0a13' && c <= '\u0a28' || c >= '\u0a2a' && c <= '\u0a30' || c >= '\u0a32' && c <= '\u0a33' || c >= '\u0a35' && c <= '\u0a36' || c >= '\u0a38' && c <= '\u0a39' || c >= '\u0a59' && c <= '\u0a5c' || c == '\u0a5e' || c >= '\u0a72' && c <= '\u0a74' || c >= '\u0a85' && c <= '\u0a8b' || c == '\u0a8d' || c >= '\u0a8f' && c <= '\u0a91' || c >= '\u0a93' && c <= '\u0aa8' || c >= '\u0aaa' && c <= '\u0ab0' || c >= '\u0ab2' && c <= '\u0ab3' || c >= '\u0ab5' && c <= '\u0ab9' || c == '\u0abd' || c == '\u0ae0' || c >= '\u0b05' && c <= '\u0b0c' || c >= '\u0b0f' && c <= '\u0b10' || c >= '\u0b13' && c <= '\u0b28' || c >= '\u0b2a' && c <= '\u0b30' || c >= '\u0b32' && c <= '\u0b33' || c >= '\u0b36' && c <= '\u0b39' || c == '\u0b3d' || c >= '\u0b5c' && c <= '\u0b5d' || c >= '\u0b5f' && c <= '\u0b61' || c >= '\u0b85' && c <= '\u0b8a' || c >= '\u0b8e' && c <= '\u0b90' || c >= '\u0b92' && c <= '\u0b95' || c >= '\u0b99' && c <= '\u0b9a' || c == '\u0b9c' || c >= '\u0b9e' && c <= '\u0bbf' || c >= '\u0ba3' && c <= '\u0ba4' || c >= '\u0ba8' && c <= '\u0baa' || c >= '\u0bae' && c <= '\u0bb5' || c >= '\u0bb7' && c <= '\u0bb9' || c >= '\u0c05' && c <= '\u0c0c' || c >= '\u0c0e' && c <= '\u0c10' || c >= '\u0c12' && c <= '\u0c28' || c >= '\u0c2a' && c <= '\u0c33' || c >= '\u0c35' && c <= '\u0c39' || c >= '\u0c60' && c <= '\u0c61' || c >= '\u0c85' && c <= '\u0c8c' || c >= '\u0c8e' && c <= '\u0c90' || c >= '\u0c92' && c <= '\u0ca8' || c >= '\u0caa' && c <= '\u0cb3' || c >= '\u0cb5' && c <= '\u0cb9' || c == '\u0cde' || c >= '\u0ce0' && c <= '\u0ce1' || c >= '\u0d05' && c <= '\u0d0c' || c >= '\u0d0e' && c <= '\u0d10' || c >= '\u0d12' && c <= '\u0d28' || c >= '\u0d2a' && c <= '\u0d39' || c >= '\u0d60' && c <= '\u0d61' || c >= '\u0e01' && c <= '\u0e2e' || c == '\u0e30' || c >= '\u0e32' && c <= '\u0e33' || c >= '\u0e40' && c <= '\u0e45' || c >= '\u0e81' && c <= '\u0e82' || c == '\u0e84' || c >= '\u0e87' && c <= '\u0e88' || c == '\u0e8a' || c == '\u0e8d' || c >= '\u0e94' && c <= '\u0e97' || c >= '\u0e99' && c <= '\u0e9f' || c >= '\u0ea1' && c <= '\u0ea3' || c == '\u0ea5' || c == '\u0ea7' || c >= '\u0eaa' && c <= '\u0eab' || c >= '\u0ead' && c <= '\u0eae' || c == '\u0eb0' || c >= '\u0eb2' && c <= '\u0eb3' || c == '\u0ebd' || c >= '\u0ec0' && c <= '\u0ec4' || c >= '\u0f40' && c <= '\u0f47' || c >= '\u0f49' && c <= '\u0f69' || c >= '\u10a0' && c <= '\u10c5' || c >= '\u10d0' && c <= '\u10f6' || c == '\u1100' || c >= '\u1102' && c <= '\u1103' || c >= '\u1105' && c <= '\u1107' || c == '\u1109' || c >= '\u110b' && c <= '\u110c' || c >= '\u110e' && c <= '\u1112' || c == '\u113c' || c == '\u113e' || c == '\u1140' || c == '\u114c' || c == '\u114e' || c == '\u1150' || c >= '\u116d' && c <= '\u116e' || c == '\u1159' || c >= '\u115f' && c <= '\u1161' || c == '\u1163' || c == '\u1165' || c == '\u1167' || c == '\u1169' || c >= '\u116d' && c <= '\u116e' || c >= '\u1172' && c <= '\u1173' || c == '\u1175' || c == '\u119e' || c == '\u11a8' || c == '\u11ab' || c >= '\u11ae' && c <= '\u11af' || c >= '\u11b7' && c <= '\u11b8' || c == '\u11ba' || c >= '\u11bc' && c <= '\u11c2' || c == '\u11eb' || c == '\u11f0' || c == '\u11f9' || c >= '\u1e00' && c <= '\u1e9b' || c >= '\u1ea0' && c <= '\u1ef9' || c >= '\u1f00' && c <= '\u1f15' || c >= '\u1f18' && c <= '\u1f1d' || c >= '\u1f20' && c <= '\u1f45' || c >= '\u1f48' && c <= '\u1f4d' || c >= '\u1f50' && c <= '\u1f57' || c == '\u1f59' || c == '\u1f5b' || c == '\u1f5d' || c >= '\u1f5f' && c <= '\u1f7d' || c >= '\u1f80' && c <= '\u1fb4' || c >= '\u1fb6' && c <= '\u1fbc' || c == '\u1fbe' || c >= '\u1fc2' && c <= '\u1fc4' || c >= '\u1fc6' && c <= '\u1fcc' || c >= '\u1fd0' && c <= '\u1fd3' || c >= '\u1fd6' && c <= '\u1fdb' || c >= '\u1fe0' && c <= '\u1fec' || c >= '\u1ff2' && c <= '\u1ff4' || c >= '\u1ff6' && c <= '\u1ffc' || c == '\u2126' || c >= '\u212a' && c <= '\u212b' || c == '\u212e' || c >= '\u2180' && c <= '\u2182' || c >= '\u3041' && c <= '\u3094' || c >= '\u30a1' && c <= '\u30fa' || c >= '\u3105' && c <= '\u312c' || c >= '\uac00' && c <= '\ud7a3';
    }

    private static boolean isXmlIdeoChar(char c) {
        return c >= '\u4e00' && c <= '\u59a5' || c == '\u3007' || c >= '\u3021' && c <= '\u3029';
    }

    public static void main(String[] args) throws IOException, WMDocumentException {
        boolean isXml = false;
        boolean isHtml = false;
        boolean genSource = false;
        int iterations = 0;
        boolean fromMemory = false;
        boolean getText = false;
        boolean displaySource = false;
        boolean displayDTD = false;
        String inputEncoding = null;
        String outputEncoding = null;
        String outputFile = null;
        boolean testReconstitution = false;
        boolean expandDTD = false;
        boolean runTempTestCode = false;
        boolean verifyProperties = false;
        boolean iterateOverNodes = false;
        boolean movingWindow = false;
        boolean monitorMemory = false;
        boolean flattenContentspecs = false;
        boolean getDocumetEncoding = false;
        NodeCriterion[] criteria = null;
        boolean showMemoryConsumed = false;
        boolean isCanonicalize = false;
        Runtime runtime = Runtime.getRuntime();
        if (args.length < 1) {
            Document.usage();
            return;
        }
        String fileName = args[0];
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-x")) {
                isXml = true;
                continue;
            }
            if (arg.startsWith("-h")) {
                isHtml = true;
                continue;
            }
            if (arg.startsWith("-ts")) {
                genSource = true;
                continue;
            }
            if (arg.startsWith("-tt")) {
                getText = true;
                continue;
            }
            if (arg.startsWith("-m")) {
                fromMemory = true;
                continue;
            }
            if (arg.startsWith("-sm")) {
                showMemoryConsumed = true;
                continue;
            }
            if (arg.startsWith("-d")) {
                displaySource = true;
                continue;
            }
            if (arg.startsWith("-c")) {
                displaySource = true;
                isCanonicalize = true;
                continue;
            }
            if (arg.startsWith("-o")) {
                int colon = arg.indexOf(58);
                if (colon == -1) {
                    Document.usage();
                    return;
                }
                if (colon > 2) {
                    outputEncoding = arg.substring(2, colon);
                }
                if (arg.length() == colon) {
                    Document.usage();
                    return;
                }
                if (arg.length() <= colon + 1) continue;
                outputFile = arg.substring(colon + 1);
                continue;
            }
            if (arg.startsWith("-qf")) {
                displayDTD = true;
                expandDTD = false;
                continue;
            }
            if (arg.startsWith("-qs")) {
                displayDTD = true;
                expandDTD = true;
                continue;
            }
            if (arg.startsWith("-qc")) {
                expandDTD = true;
                displayDTD = true;
                flattenContentspecs = true;
                continue;
            }
            if (arg.startsWith("-r")) {
                testReconstitution = true;
                continue;
            }
            if (arg.startsWith("-n")) {
                try {
                    iterations = Integer.parseInt(arg.substring(2));
                    continue;
                }
                catch (NumberFormatException x) {
                    Document.usage();
                    return;
                }
            }
            if (arg.startsWith("-e")) {
                inputEncoding = arg.substring(2);
                continue;
            }
            if (arg.startsWith("-p")) {
                String parser = arg.substring(2);
                if (parser.equalsIgnoreCase("SunSAX")) {
                    Document.setXmlTokenSourceFactory(new SunSaxTokenSourceFactory(false));
                    continue;
                }
                Document.setXmlTokenSourceFactory(new WMTokenSourceFactory());
                continue;
            }
            if (arg.startsWith("-!")) {
                runTempTestCode = true;
                continue;
            }
            if (arg.startsWith("-v")) {
                verifyProperties = true;
                continue;
            }
            if (arg.startsWith("-i")) {
                int colon;
                String patternFile = null;
                iterateOverNodes = true;
                if (arg.length() >= 3 && arg.charAt(2) == 'w') {
                    movingWindow = true;
                    if (arg.length() >= 4 && arg.charAt(3) == 'k') {
                        monitorMemory = true;
                    }
                }
                if ((colon = arg.indexOf(58)) >= 0 && arg.length() > colon + 1) {
                    patternFile = arg.substring(colon + 1);
                }
                criteria = Document.getNodeIteratorCriteria(patternFile);
                continue;
            }
            if (arg.startsWith("-fde")) {
                getDocumetEncoding = true;
                continue;
            }
            Document.usage();
            return;
        }
        byte[] data = null;
        if (fromMemory) {
            int b;
            InputStream is = host.getInputStream(fileName);
            int size = 0;
            while ((b = is.read()) != -1) {
                ++size;
            }
            is.close();
            data = new byte[size];
            is = host.getInputStream(fileName);
            int i = 0;
            while ((b = is.read()) != -1) {
                data[i++] = (byte)b;
            }
            is.close();
        }
        long initialFreeMemory = 0L;
        if (showMemoryConsumed) {
            initialFreeMemory = runtime.freeMemory();
        }
        Document doc = Document.oneIteration(fileName, fromMemory, data, isXml || isHtml, isXml, genSource, getText, inputEncoding, expandDTD, iterateOverNodes, criteria, movingWindow, displaySource, monitorMemory, isCanonicalize);
        if (showMemoryConsumed) {
            long finalFreeMemory = runtime.freeMemory();
            System.out.println("Document consumes " + Document.toKBytes(initialFreeMemory - finalFreeMemory) + "K");
        }
        long startMillis = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            doc = Document.oneIteration(fileName, fromMemory, data, isXml || isHtml, isXml, genSource, getText, inputEncoding, expandDTD, iterateOverNodes, criteria, movingWindow, displaySource, monitorMemory, isCanonicalize);
        }
        long endMillis = System.currentTimeMillis();
        if (runTempTestCode) {
            // empty if block
        }
        if (getDocumetEncoding) {
            String docEncoding = doc.getDocumentEncoding();
            System.out.println("Document Encoding is: " + docEncoding);
        }
        if (verifyProperties) {
            Document.verifyDocument(doc);
        }
        if (displayDTD) {
            DTD dtd = doc.getDTD();
            if (dtd == null) {
                System.out.println("No DTD found.");
            } else if (flattenContentspecs) {
                Enumeration elemDefs = dtd.getElementDefs();
                if (elemDefs == null) {
                    System.out.println("No elements declared.");
                } else {
                    StringBuffer sb = new StringBuffer();
                    while (elemDefs.hasMoreElements()) {
                        ElementDef elemDef = (ElementDef)elemDefs.nextElement();
                        elemDef.appendFlattened(sb);
                    }
                    System.out.println(sb.toString());
                }
            } else {
                System.out.println(dtd.getString(false));
            }
        }
        if (!iterateOverNodes) {
            if (testReconstitution) {
                TestReconstituter recon = new TestReconstituter(doc);
                StringBuffer sb = new StringBuffer();
                recon.reconstitute(sb);
                if (displaySource) {
                    System.out.print(sb.toString());
                } else {
                    System.out.println("Reconstituter enumerated:");
                    System.out.println("  " + recon.realNodeCount + " real nodes");
                    System.out.println("  " + recon.realElementCount + " real elements");
                }
            } else if (displaySource || outputFile != null) {
                StringBuffer sb = new StringBuffer();
                doc.appendGeneratedMarkup(sb);
                String src = sb.toString();
                if (displaySource) {
                    System.out.println(src);
                } else {
                    FileOutputStream fs = new FileOutputStream(new File(outputFile));
                    DataOutputStream ds = new DataOutputStream(fs);
                    byte[] byteAry = src.getBytes(outputEncoding);
                    ds.write(byteAry, 0, byteAry.length);
                    ds.close();
                }
            }
        }
        if (iterations > 0) {
            System.out.println("Averaged " + (endMillis - startMillis) / (long)iterations + " millis");
        }
    }

    static Document oneIteration(String fileName, boolean fromMemory, byte[] data, boolean selectDocType, boolean isXml, boolean genSource, boolean getText, String inputEncoding, boolean expandDTD, boolean iterateOverNodes, NodeCriterion[] criteria, boolean movingWindow, boolean displaySource, boolean monitorMemory, boolean isCanonicalize) throws IOException, WMDocumentException {
        InputStream is = fromMemory ? new ByteArrayInputStream(data) : host.getInputStream(fileName);
        Document doc = selectDocType ? new Document(is, fileName, inputEncoding, expandDTD, isXml) : new Document(is, fileName, inputEncoding, expandDTD);
        if (iterateOverNodes) {
            Node node;
            Runtime runtime = Runtime.getRuntime();
            NodeIterator iterator = new NodeIterator(doc, criteria, movingWindow);
            long freeMemoryBefore = 0L;
            long totalMemoryUsed = 0L;
            long minMemoryUsed = Integer.MAX_VALUE;
            long maxMemoryUsed = 0L;
            int iterations = 0;
            if (monitorMemory) {
                freeMemoryBefore = runtime.freeMemory();
            }
            while ((node = iterator.getNextNode()) != null) {
                if (monitorMemory) {
                    long memoryUsed = freeMemoryBefore - runtime.freeMemory();
                    ++iterations;
                    totalMemoryUsed += memoryUsed;
                    if (memoryUsed < minMemoryUsed) {
                        minMemoryUsed = memoryUsed;
                    }
                    if (memoryUsed > maxMemoryUsed) {
                        maxMemoryUsed = memoryUsed;
                    }
                }
                if (!displaySource) continue;
                StringBuffer sb = new StringBuffer();
                node.appendGeneratedMarkup(sb);
                System.out.println(sb.toString());
            }
            if (monitorMemory) {
                if (iterations == 0) {
                    System.out.println("No nodes meet iteration criteria.");
                } else {
                    System.out.println("Iterated through " + iterations + " nodes:");
                    System.out.println("  Memory consumed: average " + Document.toKBytes(totalMemoryUsed / (long)iterations) + "K, min " + Document.toKBytes(minMemoryUsed) + "K, max " + Document.toKBytes(maxMemoryUsed) + "K");
                }
            }
        } else if (genSource) {
            StringBuffer sb = new StringBuffer();
            doc.appendGeneratedMarkup(sb);
            sb.toString();
        }
        doc.setCanonicalize(isCanonicalize);
        doc.completeLoad();
        is.close();
        return doc;
    }

    public static void setHostServices(XmlHostServices hostServices) {
        host = hostServices;
    }

    public static void setXmlTokenSourceFactory(TokenSourceFactory f) {
        xmlFactory = f;
    }

    static void showNodeId(String prefix, Node node) {
        System.out.print(prefix);
        System.out.print(node.getClass().getName());
        if (node.getNodeType() == 1) {
            System.out.print(", name ");
            System.out.print(new XmlName(node.getNamespacePrefix(), node.getLocalNameWm()).toString());
        }
        System.out.print(", position ");
        System.out.println(node.getPosition());
    }

    static long toKBytes(long bytes) {
        return (bytes + 1023L) / 1024L;
    }

    static void usage() {
        System.out.println("java Document <input-file> [<options>]");
        System.out.println();
        System.out.println("<options>:");
        System.out.println("  -x  = force parsing as XML");
        System.out.println("  -h  = force parsing as HTML");
        System.out.println("  -ts = time source generation");
        System.out.println("  -tt = time text generation");
        System.out.println("  -sm = show memory consumed");
        System.out.println("  -d  = display generated source");
        System.out.println("  -o[<encoding>]:<file> = output to file");
        System.out.println("  -qf = show DTD without expanding it (fast)");
        System.out.println("  -qs = show DTD after expanding it (slow)");
        System.out.println("  -qc = show flattened element contentspecs");
        System.out.println("  -r  = test webtap reconstitution");
        System.out.println("  -n# = number of iterations");
        System.out.println("  -m  = parse from memory");
        System.out.println("  -e<encoding> = input document encoding");
        System.out.println("  -p<parser> = select parser (only \"SunSAX\")");
        System.out.println("  -!  = run temporary testing code");
        System.out.println("  -c  = display cannonical source");
        System.out.println("  -v  = verify expected properties");
        System.out.println("  -i[w[k]][:<pattern-file>] = iterate over nodes");
        System.out.println("         using patterns (w = moving window,");
        System.out.println("         k = monitor memory consumption)");
    }

    static boolean useSunReader() {
        if (useXmlReader == 0) {
            String p = System.getProperty(PROPERTY_READER);
            useXmlReader = p != null && p.equals("sun") ? 2 : 1;
        }
        return useXmlReader == 2;
    }

    static void verifyDocument(Document doc) throws WMDocumentException {
        if (Document.verifyNode(doc, new VerificationState())) {
            System.out.println("Document is verified to have expected properties.");
        }
    }

    static boolean verifyNode(Node parent, VerificationState state) throws WMDocumentException {
        boolean verified = true;
        Node node = parent.getFirstChildWm();
        while (node != null) {
            if (!(node instanceof ProxyNode) && state.previousNode != null && node.getPosition() <= state.previousNode.getPosition()) {
                System.out.println("Node positions not monotonically increasing:");
                Document.showNodeId("  1st: ", state.previousNode);
                System.out.println("  precedes");
                Document.showNodeId("  2nd: ", node);
                System.out.println();
                verified = false;
            }
            state.previousNode = node;
            if (!(node instanceof SiblingRegionNode || node instanceof GeneralRegionNode || Document.verifyNode(node, state))) {
                verified = false;
            }
            node = parent.getNextSiblingOfChild(node);
        }
        return verified;
    }

    public Document() {
        super(null, null, DOCUMENT_NAME);
        this.document = this;
    }

    Document(Document node) {
        super(node, null, DOCUMENT_NAME);
        this.URLString = node.getURL();
        this.systemId = node.systemId;
        this.publicId = node.publicId;
        if (node.getHeaderInfo() != null) {
            this.headerInfo = (Hashtable)node.getHeaderInfo().clone();
        }
        if (node.getCookies() != null) {
            this.cookies = (Vector)node.getCookies().clone();
        }
        if (node.getMisc() != null) {
            this.misc = (Values)node.getMisc().clone();
        }
        this.documentType = node.getDocumentType();
        this.treeBuilder = node.getTreeBuilder();
    }

    public Document(InputStream stream, String url, String encoding, boolean expandDTD) throws IOException, WMDocumentException {
        this(stream, url, encoding, expandDTD, null);
    }

    public Document(InputStream stream, String url, String encoding, boolean expandDTD, String expandGeneralEntities) throws IOException, WMDocumentException {
        Reader reader = this.getReader(stream, url, encoding, false);
        this.initFromReader(reader, url, expandDTD, expandGeneralEntities, Document.inferSyntax(url), true);
    }

    public Document(InputStream stream, String url, String encoding, boolean expandDTD, int syntax) throws IOException, WMDocumentException {
        Reader reader = this.getReader(stream, url, encoding, 2 != syntax);
        this.initFromReader(reader, url, expandDTD, syntax, true);
    }

    public Document(InputStream stream, String url, String encoding, boolean expandDTD, boolean isXmlElseHtml) throws IOException, WMDocumentException {
        this(stream, url, encoding, expandDTD, null, isXmlElseHtml);
    }

    public Document(InputStream stream, String url, String encoding, boolean expandDTD, String expandGeneralEntities, boolean isXmlElseHtml) throws IOException, WMDocumentException {
        Reader reader = this.getReader(stream, url, encoding, isXmlElseHtml);
        this.initFromReader(reader, url, expandDTD, expandGeneralEntities, isXmlElseHtml ? 1 : 2, true);
    }

    public Document(InputStream stream, String url, String encoding, int option) throws IOException, WMDocumentException {
        boolean expandDTD = false;
        if (option == 1) {
            expandDTD = true;
        } else if (option == 2) {
            expandDTD = true;
            this.useEntityReferences = true;
        }
        Reader reader = this.getReader(stream, url, encoding, false);
        this.initFromReader(reader, url, expandDTD, 1, false);
    }

    public Document(Reader reader, String url, String encoding, boolean expandDTD) throws IOException, WMDocumentException {
        this.assignedEncoding = encoding;
        this.initFromReader(reader, url, expandDTD, 1, false);
    }

    public Document(Reader reader, String url, String encoding, int option) throws IOException, WMDocumentException {
        boolean expandDTD = false;
        if (option == 1) {
            expandDTD = true;
        } else if (option == 2) {
            expandDTD = true;
            this.useEntityReferences = true;
        }
        this.initFromReader(reader, url, expandDTD, 1, false);
    }

    public Document(String text, String url, String encoding, boolean expandDTD) throws IOException, WMDocumentException {
        this(text, url, encoding, expandDTD, null);
    }

    public Document(String text, String url, String encoding, boolean expandDTD, String expandGeneralEntities) throws IOException, WMDocumentException {
        this.initFromText(text, encoding, url, expandDTD, expandGeneralEntities, 0, false);
    }

    public Document(String text, String url, String encoding, boolean expandDTD, boolean isXmlElseHtml) throws IOException, WMDocumentException {
        this(text, url, encoding, expandDTD, null, isXmlElseHtml);
    }

    public Document(String text, String url, String encoding, boolean expandDTD, String expandGeneralEntities, boolean isXmlElseHtml) throws IOException, WMDocumentException {
        this.initFromText(text, encoding, url, expandDTD, expandGeneralEntities, isXmlElseHtml ? 1 : 2, false);
    }

    int addNamespacesToValues(ElementNodeBase enode, Values result, int id) throws WMDocumentException {
        int defaultid = id;
        NamespaceDecl nsdecl = enode.getFirstNamespaceDecl();
        while (nsdecl != null && nsdecl.owner == enode) {
            String prfS;
            Name uri = nsdecl.getUri();
            Name pre = nsdecl.getPrefixWm();
            String string = prfS = pre != null ? pre.toString() : null;
            if (prfS != null) {
                Name val = (Name)result.get(prfS);
                if (val == null) {
                    result.put(prfS, uri);
                } else if (val != uri) {
                    int i = 0;
                    String prfstr = null;
                    while (val != null) {
                        prfstr = Strings.cat(prfS, Integer.toString(++i));
                        val = (Name)result.get(prfstr);
                    }
                    result.put(prfstr, uri);
                }
            } else {
                String temp = Strings.cat("prefix", Integer.toString(defaultid));
                if (result.get(temp) == null) {
                    result.put(temp, uri);
                    ++defaultid;
                }
            }
            nsdecl = nsdecl.next;
        }
        Node n = enode.getFirstChildWm();
        while (n != null) {
            if (n.getNodeType() == 1 && !n.isFalseNode()) {
                defaultid = this.addNamespacesToValues((ElementNodeBase)n, result, defaultid);
            }
            n = enode.getNextSiblingOfChild(n);
        }
        return defaultid;
    }

    public org.w3c.dom.Node adoptNode(org.w3c.dom.Node node) throws DOMException {
        this.removeAllFromOwnerDocument(node);
        node.getParentNode().removeChild(node);
        return this.getFirstChild().appendChild(this.importNode(node, true));
    }

    public void appendGeneratedMarkup(StringBuffer sb) throws WMDocumentException {
        if (this.isXML()) {
            if (!this.isCanonicalize()) {
                for (Node node = this.getFirstChildWm(); node != null; node = node.getNextSiblingWm()) {
                    node.appendGeneratedMarkup(sb);
                }
            } else {
                for (Node node = this.getFirstChildWm(); node != null; node = node.getNextSiblingWm()) {
                    if (node.isTextNode() || node.getPITarget() == xmlName) continue;
                    node.appendGeneratedMarkup(sb);
                }
            }
        } else {
            for (Node node = this.getFirstChildWm(); node != null; node = node.getNextSiblingWm()) {
                node.appendGeneratedMarkup(sb);
            }
        }
    }

    boolean cacheIfUnique(org.w3c.dom.Node node, Name elemNSPrefix, Name elemLocalName, Name attrNSPrefix, Name attrLocalName, String uniqueID) {
        int idAttrDeclIndex = this.idAttributeDeclCount;
        while (--idAttrDeclIndex >= 0) {
            IdAttributeDecl decl = (IdAttributeDecl)this.idAttributeDecls.elementAt(idAttrDeclIndex);
            if (decl.attributeLocalName != attrLocalName || decl.elementLocalName != elemLocalName || decl.attributeNSPrefix != attrNSPrefix || decl.elementNSPrefix != elemNSPrefix) continue;
            if (this.nodesById == null) {
                this.nodesById = IDataFactory.create();
            }
            ValuesEmulator.put(this.nodesById, uniqueID, (Object)node);
            return true;
        }
        return false;
    }

    public void completeLoad() throws IOException, WMDocumentException {
        if (this.isComplete()) {
            return;
        }
        int interruptTestInterval = 20;
        while (this.treeBuilder != null && this.treeBuilder.processNextToken()) {
            if (--interruptTestInterval != 0) continue;
            if (Thread.currentThread().isInterrupted()) {
                throw new LocalizedInterruptedIOException("com.wm.lang.xml.resources.XmlInterruptedIOExceptionBundle", XmlInterruptedIOExceptionBundle.PARSER_INTERRUPTED, this.getClass().getClassLoader());
            }
            interruptTestInterval = 20;
        }
    }

    public void completeLoadDOM() throws DOMException {
        block7: {
            try {
                if (!this.isComplete()) {
                    this.document.completeLoad();
                }
            }
            catch (WMDocumentException excp) {
                if (this.getStrictErrorChecking()) {
                    throw new DOMException(15, excp.toString());
                }
            }
            catch (IOException excp) {
                if (this.getStrictErrorChecking()) {
                    throw new DOMException(15, excp.toString());
                }
            }
            catch (DOMException x) {
                if (!this.getStrictErrorChecking()) break block7;
                throw x;
            }
        }
    }

    public Attr createAttribute(String name) {
        Node attr = null;
        Document.checkValidName(name);
        if ("xmlns".equals(name)) {
            attr = new NamespaceDecl(null, Name.create(""));
            ((Node)attr).setOwnerDocument(this);
        } else {
            attr = new Attribute(this, null, Name.create(name), "");
        }
        ((Attribute)attr).setDOM1(true);
        return attr;
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        Node attr;
        NamespaceDecl nsd;
        String prefix = null;
        String localName = null;
        Document.checkValidName(qualifiedName);
        int i = qualifiedName.indexOf(":");
        if (i == -1) {
            if (namespaceURI == null) {
                nsd = null;
            } else {
                nsd = new NamespaceDecl(null, Name.create(namespaceURI));
                nsd.setOwnerDocument(this);
            }
            localName = "xmlns".equals(qualifiedName) ? null : qualifiedName;
            if ("xmlns".equals(qualifiedName) && !namespaceURI.equals(xmlnsUri.toString())) {
                throw new DOMExceptionImpl(14);
            }
        } else {
            if (namespaceURI == null) {
                throw new DOMExceptionImpl(14);
            }
            prefix = qualifiedName.substring(0, i);
            if (prefix.equals("xml") && !namespaceURI.equals(defaultUri.toString())) {
                throw new DOMExceptionImpl(14);
            }
            nsd = new NamespaceDecl(Name.create(prefix), Name.create(namespaceURI));
            nsd.setOwnerDocument(this);
            localName = qualifiedName.substring(i + 1);
        }
        if ("xmlns".equals(qualifiedName)) {
            attr = new NamespaceDecl(null, Name.create(""), null);
            ((Node)attr).setOwnerDocument(this);
        } else if ("xmlns".equals(prefix)) {
            attr = new NamespaceDecl(Name.create(localName), Name.create(namespaceURI), null);
            ((Node)attr).setOwnerDocument(this);
        } else {
            attr = new Attribute(this, null, Name.create(localName), "");
            ((Attribute)attr).setNamespaceDecl(nsd);
        }
        return attr;
    }

    public CDATASection createCDATASection(String data) {
        return new CDataNode(this, data);
    }

    public Comment createComment(String data) {
        return new CommentNode(this, data);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public Element createElement(String tagName) {
        Document.checkValidName(tagName);
        ElementNode elem = new ElementNode(this);
        elem.setLocalName(Name.create(tagName));
        elem.setDOM1(true);
        return elem;
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) {
        String localName;
        String prefix;
        Name prefixName = null;
        Name nsUriName = null;
        NamespaceDecl nsd = null;
        Document.checkValidName(qualifiedName);
        int i = qualifiedName.indexOf(":");
        if (i == -1) {
            prefix = null;
            localName = qualifiedName;
        } else {
            prefix = qualifiedName.substring(0, i);
            localName = qualifiedName.substring(i + 1);
        }
        if (prefix != null) {
            prefixName = Name.create(prefix);
        }
        if (namespaceURI != null) {
            nsUriName = Name.create(namespaceURI);
        }
        if (prefixName != null && namespaceURI == null) {
            throw new DOMExceptionImpl(14);
        }
        if (prefixName == xmlName && nsUriName != defaultUri) {
            throw new DOMExceptionImpl(14);
        }
        ElementNode elem = new ElementNode(this);
        elem.isComplete(true);
        elem.setLocalName(Name.create(localName));
        if (nsUriName != null) {
            nsd = new NamespaceDecl(prefixName, nsUriName, elem);
            nsd.setOwnerDocument(this);
        }
        elem.setNamespaceDecl(nsd);
        return elem;
    }

    public EntityReference createEntityReference(String name) {
        return new EntityReferenceImpl(this, name);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        return new PINode(this, Name.create(target), data);
    }

    public Text createTextNode(String data) {
        return new TextNode(this, data);
    }

    public void declareIdAttribute(Name elementPrefix, Name elementLocalName, Name attrPrefix, Name attrLocalName) {
        if (this.idAttrLocalNames == null) {
            this.idAttributeDecls = new List();
            this.idAttributeDeclCount = 0;
            this.idAttrLocalNames = new List();
            this.idAttrLocalNameCount = 0;
        }
        IdAttributeDecl decl = new IdAttributeDecl(elementPrefix, elementLocalName, attrPrefix, attrLocalName);
        this.idAttributeDecls.addElement(decl);
        ++this.idAttributeDeclCount;
        int idAttrIndex = this.idAttrLocalNameCount;
        while (--idAttrIndex >= 0) {
            if (this.idAttrLocalNames.elementAt(idAttrIndex) != attrLocalName) continue;
            return;
        }
        this.idAttrLocalNames.addElement(attrLocalName);
        ++this.idAttrLocalNameCount;
    }

    public String getAssignedEncoding() {
        return this.assignedEncoding;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public Node getClone() {
        Document docnode = new Document(this);
        return docnode;
    }

    public String[] getCookieList() {
        String[] result = new String[this.cookies.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)this.cookies.elementAt(i);
        }
        return result;
    }

    public Vector getCookies() {
        return this.cookies;
    }

    public DocumentType getDoctype() {
        if (this.docType != null) {
            return this.docType;
        }
        if (this.dtd == null) {
            return null;
        }
        XmlName rootName = null;
        try {
            rootName = this.dtd.getRootElementName();
        }
        catch (WMDocumentException ex) {
            System.out.println("DocumentType Exception:" + ex.toString());
        }
        String qualifiedName = rootName != null ? rootName.toString() : "";
        String publicId = this.dtd.getPublicID();
        String systemId = this.dtd.getSystemID();
        this.docType = new DocumentTypeImpl(qualifiedName, publicId, systemId, this);
        return this.docType;
    }

    public Element getDocumentElement() {
        try {
            return (Element)((Object)this.getFirstElement());
        }
        catch (WMDocumentException excp) {
            throw new DOMException(15, excp.toString());
        }
    }

    public String getDocumentEncoding() throws WMDocumentException {
        String pidata = this.getFirstPIData();
        if (pidata != null && pidata.length() != 0) {
            int i;
            pidata = pidata.trim();
            pidata = pidata.replace('\"', '\'');
            pidata = pidata.replace('=', ' ');
            StringTokenizer parser = new StringTokenizer(pidata, "' ");
            String[] tokenArray = new String[parser.countTokens()];
            try {
                i = 0;
                while (parser.hasMoreTokens()) {
                    tokenArray[i] = parser.nextToken();
                    ++i;
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            for (i = 0; i < tokenArray.length; ++i) {
                if (!tokenArray[i].toString().equalsIgnoreCase("encoding")) continue;
                return tokenArray[i + 1];
            }
            return null;
        }
        return null;
    }

    public int getDocumentType() {
        return this.documentType;
    }

    public String getDocumentTypeString() {
        int i = this.getDocumentType();
        return docTypeString[i];
    }

    public String getDocumentURI() {
        if (this.xmlUri != null) {
            return this.xmlUri;
        }
        return defaultUri.toString();
    }

    public DOMConfiguration getDomConfig() {
        return this.domConfiguration;
    }

    public DTD getDTD() throws WMDocumentException {
        if (this.isXML() && this.tsFactory != null) {
            if (this.tsFactory instanceof WMTokenSourceFactory) {
                this.getFirstElement();
            } else {
                throw new WMDocumentException(WMDocumentExceptionBundle.class, WMDocumentExceptionBundle.SAX_NO_ENOUGH_DTD_INFO, "");
            }
        }
        return this.dtd;
    }

    public Element getElementById(String elementId) {
        try {
            org.w3c.dom.Node idNode = this.getNodeById(elementId);
            if (idNode instanceof Element) {
                return (Element)idNode;
            }
        }
        catch (WMDocumentException ex) {
            System.out.println("getElementByID WMDocumentException:");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("getElementByID IOException:");
            ex.printStackTrace();
        }
        return null;
    }

    public org.w3c.dom.Node getFirstChild() {
        org.w3c.dom.Node node = super.getFirstChild();
        if (node != null && node.getNodeType() == 7) {
            node = node.getNextSibling();
        }
        return node;
    }

    public Node getFirstElement() throws WMDocumentException {
        Node node;
        for (node = this.getFirstChildWm(); node != null && node.getNodeType() != 1; node = node.getNextSiblingWm()) {
        }
        this.firstElementVerified = true;
        return node;
    }

    public String getFirstPIData() throws WMDocumentException {
        Node node;
        String pidata = null;
        for (node = this.getFirstChildWm(); node != null && node.getNodeType() != 7; node = node.getNextSiblingWm()) {
        }
        if (node != null && node.getNodeType() == 7) {
            pidata = node.getPIData();
        }
        return pidata;
    }

    public Hashtable getHeaderInfo() {
        return this.headerInfo;
    }

    public HtmlType getHtmlType() {
        return HtmlType.docTAG;
    }

    public DOMImplementation getImplementation() {
        return domImpl;
    }

    public String getInputEncoding() {
        String encoding = this.getAssignedEncoding();
        if (encoding == null && this._reader != null && this._reader instanceof WmDocReader) {
            encoding = ((WmDocReader)this._reader).getEncoding();
        }
        return encoding == null ? "UTF-8" : encoding;
    }

    public Values getMisc() {
        return this.misc;
    }

    public Values getNamespaces() throws WMDocumentException {
        if (!this.isXML()) {
            return null;
        }
        Values result = new Values();
        int defaultid = 0;
        Document enode = this;
        defaultid = this.addNamespacesToValues(enode, result, defaultid);
        return result;
    }

    public org.w3c.dom.Node[] getNodeArrayById(String id) throws IOException, WMDocumentException {
        if (this.idAttrLocalNames == null) {
            return null;
        }
        this.completeLoad();
        if (this.nodesById == null) {
            return null;
        }
        Vector<Object> holder = new Vector<Object>();
        IDataCursor cursor = this.nodesById.getCursor();
        while (cursor.next(id)) {
            holder.addElement(cursor.getValue());
        }
        if (holder.isEmpty()) {
            return null;
        }
        org.w3c.dom.Node[] nodeArray = new org.w3c.dom.Node[holder.size()];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray[i] = (org.w3c.dom.Node)holder.elementAt(i);
        }
        return nodeArray;
    }

    public org.w3c.dom.Node getNodeById(String id) throws IOException, WMDocumentException {
        if (this.idAttrLocalNames == null) {
            return null;
        }
        this.completeLoad();
        if (this.nodesById == null) {
            return null;
        }
        return (org.w3c.dom.Node)ValuesEmulator.get(this.nodesById, id);
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public org.w3c.dom.Document getOwnerDocument() {
        return null;
    }

    public String getPublicId() throws WMDocumentException {
        if (this.publicId != null) {
            return this.publicId;
        }
        if (this.treeBuilder == null) {
            return null;
        }
        if (this.getFirstElement() == null) {
            return null;
        }
        this.publicId = this.treeBuilder.getTokenSource().getPublicID();
        return this.publicId;
    }

    private Reader getReader(InputStream stream, String url, String encoding, boolean isXmlElseHtml) throws IOException {
        Reader reader;
        if (Document.useSunReader()) {
            reader = encoding == null ? XmlReaderGetter.createReader(stream) : XmlReaderGetter.createReader(stream, encoding);
        } else {
            WmDocReader wmReader = encoding == null ? WmDocReader.create(stream, url, isXmlElseHtml) : WmDocReader.create(stream, url, encoding, isXmlElseHtml);
            wmReader.allowTranscoding(true);
            reader = wmReader;
        }
        this.assignedEncoding = encoding;
        return reader;
    }

    public Node getRegionNode(Node first, boolean includeFirst, Node last, boolean includeLast) throws WMDocumentException {
        Node parent;
        Node endNode;
        int parentIndex;
        if (first == null || last == null) {
            return null;
        }
        List firstAncestors = new List();
        if (this.getNodePath(first.getPosition(), firstAncestors) == null) {
            throw new WMDocumentException(WMDocumentExceptionBundle.class, WMDocumentExceptionBundle.FIRST_NODE_OF_REGION_NOT_FOUND, "");
        }
        if (!includeFirst) {
            parentIndex = firstAncestors.size();
            endNode = null;
            while (--parentIndex >= 0 && endNode == null) {
                parent = (Node)firstAncestors.elementAt(parentIndex);
                endNode = parent.getNextSiblingOfChild(first);
                if (endNode != null) continue;
                firstAncestors.removeLastElement();
                first = parent;
            }
            if (endNode == null) {
                return null;
            }
            first = endNode;
        }
        List lastAncestors = new List();
        if (this.getNodePath(last.getPosition(), lastAncestors) == null) {
            throw new WMDocumentException(WMDocumentExceptionBundle.class, WMDocumentExceptionBundle.LAST_NODE_OF_REGION_NOT_FOUND, "");
        }
        if (!includeLast) {
            parentIndex = lastAncestors.size();
            endNode = null;
            while (--parentIndex >= 0 && endNode == null) {
                parent = (Node)lastAncestors.elementAt(parentIndex);
                endNode = parent.getPreviousSiblingOfChild(last);
                if (endNode != null) continue;
                lastAncestors.removeLastElement();
                last = parent;
            }
            if (endNode == null) {
                return null;
            }
            last = endNode;
        }
        if (last.getPosition() < first.getPosition()) {
            return null;
        }
        if (first == last) {
            return first;
        }
        StructuredRegionNode region = new StructuredRegionNode(firstAncestors, first, lastAncestors, last);
        region.setPosition(++this.lastPosition);
        return region;
    }

    public boolean getStrictErrorChecking() {
        return this.useStrictErrorChecking;
    }

    public String getSystemId() throws WMDocumentException {
        if (this.systemId != null) {
            return this.systemId;
        }
        if (this.treeBuilder == null) {
            return null;
        }
        if (this.getFirstElement() == null) {
            return null;
        }
        this.systemId = this.treeBuilder.getTokenSource().getSystemID();
        return this.systemId;
    }

    public String getText() throws WMDocumentException {
        if (this.isXML()) {
            Node node = this.getFirstElement();
            if (node == null) {
                return "";
            }
            if (node instanceof Node) {
                return node.getText();
            }
            return node.getNodeValue();
        }
        return super.getText();
    }

    public String getTextOfChildren() throws WMDocumentException {
        if (this.isXML()) {
            Node node = this.getFirstElement();
            if (node == null) {
                return "";
            }
            if (node instanceof Node) {
                return node.getTextOfChildren();
            }
            return node.getFirstChild().getNodeValue();
        }
        return super.getTextOfChildren();
    }

    public DocumentTreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    public String getURL() {
        return this.URLString;
    }

    public boolean getUseEntityReferences() {
        return this.useEntityReferences;
    }

    public String getXmlEncoding() {
        return this.getAssignedEncoding();
    }

    public boolean getXmlStandalone() {
        return this.isXmlStandalone;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public org.w3c.dom.Node importNode(org.w3c.dom.Node importedNode, boolean deep) {
        if (importedNode instanceof org.w3c.dom.Document || importedNode instanceof DocumentType) {
            throw new DOMExceptionImpl(9, "importNode");
        }
        org.w3c.dom.Node cloned = importedNode.cloneNode(deep);
        try {
            if (cloned instanceof Node) {
                ((Node)cloned).isComplete(true);
                ((Node)cloned).resetDocumentPointers(this);
            }
            if (cloned instanceof TextNodeBase) {
                ((TextNodeBase)cloned).setData(((TextNodeBase)importedNode).getData());
            } else if (cloned instanceof PINode) {
                ((PINode)cloned).setData(((PINode)importedNode).getData());
            }
        }
        catch (WMDocumentException ex) {
            throw new DOMExceptionImpl(9, (Throwable)ex);
        }
        return cloned;
    }

    void initFromReader(Reader reader, String url, boolean expandDTD, String expandGeneralEntities, int syntax, boolean loadOnDemand) throws IOException, WMDocumentException {
        this._reader = reader;
        this.setBaseURL(url);
        this.setURL(url);
        switch (syntax) {
            case 2: {
                this.treeBuilder = new HTMLTreeBuilder(this);
                break;
            }
            case 0: {
                this.treeBuilder = new UndecidedTreeBuilder(this);
                break;
            }
            case 3: {
                this.treeBuilder = Document.getSoapBuilder(this);
                if (this.treeBuilder != null) break;
                this.treeBuilder = new UndecidedTreeBuilder(this);
                break;
            }
            default: {
                this.treeBuilder = new XMLTreeBuilder(this);
            }
        }
        try {
            this.tsFactory = xmlFactory != null && (syntax == 1 || syntax == 3) && !expandDTD ? xmlFactory : wmFactory;
            if (expandGeneralEntities == null) {
                expandGeneralEntities = expandGeneralEntitiesSysPropValue;
            }
            boolean bExpandGeneralEntities = expandGeneralEntities == null || expandGeneralEntities.equals("true");
            TokenSource tsource = this.tsFactory.create(this.treeBuilder, reader, expandDTD, bExpandGeneralEntities, syntax, loadOnDemand);
            this.treeBuilder.setTokenSource(tsource);
            this.sourceBuffer = tsource.getSourceBuffer();
        }
        catch (TokenException x) {
            throw new WMDocumentException(x.getMessage());
        }
        this.document = this;
        this.setLocalName(DOCUMENT_NAME);
        if (syntax == 2) {
            this.completeLoad();
        }
    }

    void initFromReader(Reader reader, String url, boolean expandDTD, int syntax, boolean loadOnDemand) throws IOException, WMDocumentException {
        this.initFromReader(reader, url, expandDTD, null, syntax, loadOnDemand);
    }

    void initFromText(String text, String encoding, String url, boolean expandDTD, String expandGeneralEntities, int syntax, boolean loadOnDemand) throws IOException, WMDocumentException {
        Reader reader;
        ByteArrayInputStream is = encoding == null ? new ByteArrayInputStream(text.getBytes("Unicode")) : new ByteArrayInputStream(text.getBytes(encoding));
        if (Document.useSunReader()) {
            reader = encoding == null ? XmlReaderGetter.createReader(is, "Unicode") : XmlReaderGetter.createReader(is, encoding);
        } else {
            WmDocReader wmReader = encoding == null ? WmDocReader.create((InputStream)is, url, "Unicode", syntax == 1) : WmDocReader.create((InputStream)is, url, encoding, syntax == 1);
            wmReader.allowTranscoding(false);
            reader = wmReader;
        }
        this.assignedEncoding = encoding;
        if (syntax == 0) {
            this.initFromReader(reader, url, expandDTD, expandGeneralEntities, Document.inferSyntax(url), loadOnDemand);
        } else {
            this.initFromReader(reader, url, expandDTD, expandGeneralEntities, syntax, loadOnDemand);
        }
    }

    void initFromText(String text, String encoding, String url, boolean expandDTD, int syntax, boolean loadOnDemand) throws IOException, WMDocumentException {
        this.initFromText(text, encoding, url, expandDTD, null, syntax, loadOnDemand);
    }

    public boolean isCompletelyLoaded() {
        return this.isComplete();
    }

    public boolean isXML() throws WMDocumentException {
        if (!this.firstElementVerified) {
            this.getFirstElement();
        }
        return (this.multiflags & 2) == 0;
    }

    public void normalizeDocument() {
    }

    void purgeUpTo(Node node) {
        long startSourceIndex = node.getStartSourceIndex();
        if (startSourceIndex > this.lastPurgeSourceIndex) {
            Node child = node;
            for (node = node.getParent(); node != null && child.getStartSourceIndex() > this.lastPurgeSourceIndex; node = node.getParent()) {
                child.prev = null;
                node.setFirstChild(child);
                child = node;
            }
            this.sourceBuffer.purge(startSourceIndex);
            this.lastPurgeSourceIndex = startSourceIndex;
        }
    }

    public org.w3c.dom.Node removeAllFromOwnerDocument(org.w3c.dom.Node node) {
        if (node.getOwnerDocument() != null) {
            node.getOwnerDocument().removeChild(node);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.removeAllFromOwnerDocument(nodeList.item(i));
        }
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.removeAllFromOwnerDocument(attributes.item(i));
        }
        return node;
    }

    public org.w3c.dom.Node renameNode(org.w3c.dom.Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    public void setBaseURL(String URLString) {
        if (URLString == null) {
            this.baseURL = null;
            return;
        }
        int pos = 0;
        pos = URLString.indexOf(63);
        this.baseURL = pos > 0 ? URLString.substring(0, pos) : URLString;
    }

    public void setCookies(Vector val) {
        this.cookies = val;
    }

    public void setDocumentURI(String documentURI) {
        this.xmlUri = documentURI;
    }

    void setDTD(DTD dtd) {
        this.dtd = dtd;
    }

    public void setHeaderInfo(Hashtable val) {
        this.headerInfo = val;
    }

    public void setPublicId(String id) {
        this.publicId = id;
    }

    public void setStrictErrorChecking(boolean useStrictErrorChecking) {
        this.useStrictErrorChecking = useStrictErrorChecking;
    }

    public void setSystemId(String id) {
        this.systemId = id;
    }

    void setTreeBuilder(DocumentTreeBuilder tb) {
        this.treeBuilder = tb;
    }

    public void setURL(String val) {
        this.URLString = val;
    }

    void setXmlDecl(String val) {
        this.xmlDecl = val;
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        this.isXmlStandalone = xmlStandalone;
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        this.xmlVersion = xmlVersion;
    }

    public void terminate() {
        if (this.treeBuilder != null) {
            this.treeBuilder.terminate();
        }
    }

    public String toString() {
        return "" + this.getLocalNameWm() + " System ID: " + this.systemId + " Public ID: " + this.publicId;
    }

    public boolean usesWMParser() {
        return this.tsFactory instanceof WMTokenSourceFactory;
    }

    public boolean isCanonicalize() {
        return this.canonicalize;
    }

    public void setCanonicalize(boolean canonicalize) {
        this.canonicalize = canonicalize;
    }

    public static DocumentTreeBuilder getSoapBuilder(Document d) throws WMDocumentException {
        DocumentTreeBuilder retval = null;
        if (soapConstructor != null) {
            try {
                retval = soapConstructor.newInstance(d);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new WmDocumentTreeBuilderException("");
        }
        return retval;
    }

    static {
        try {
            Class<?> clazz = Class.forName("com.wm.app.b2b.server.saaj.SAAJDocumentBuilder");
            soapConstructor = clazz.getConstructor(Document.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

