/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.lang.xml.ContentParticle;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.ElementDef;
import com.wm.lang.xml.ElementDefEnumeration;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.XmlName;
import com.wm.lang.xml.resources.WMDocumentExceptionBundle;
import com.wm.lang.xml.token.AttListDecl;
import com.wm.lang.xml.token.ExternalID;
import com.wm.util.List;
import com.wm.util.Name;
import com.wm.util.Values;
import java.util.Enumeration;
import java.util.Hashtable;

public class DTD {
    static final String MSG_AMBIGUOUS_ROOT = "Cannot uniquely identify the root element";
    static final String MSG_AMBIGUOUS_RETRY = "Try loading the DTD from a sample document having a DOCTYPE declaration.";
    static final int MAX_ROOT_NAMES_IN_MSG = 4;
    Document doc;
    XmlName rootElementName;
    ExternalID externalID;
    Hashtable elementDefHash;
    List elementDefList;

    public DTD(Document doc) {
        this.doc = doc;
    }

    public XmlName getRootElementName() throws WMDocumentException {
        if (this.rootElementName == null) {
            ElementDef elemDef;
            Enumeration elemDefEnum = this.getElementDefs();
            Hashtable<String, ElementDef> topmostHash = new Hashtable<String, ElementDef>();
            while (elemDefEnum.hasMoreElements()) {
                elemDef = (ElementDef)elemDefEnum.nextElement();
                while (elemDef != null) {
                    topmostHash.put(elemDef.getName().toString(), elemDef);
                    elemDef = elemDef.next;
                }
            }
            elemDefEnum = this.getElementDefs();
            while (elemDefEnum.hasMoreElements()) {
                elemDef = (ElementDef)elemDefEnum.nextElement();
                XmlName elemDefName = elemDef.getName();
                while (elemDef != null) {
                    if (elemDef.getContentType() == 2) {
                        this.removeNonRoots(elemDefName, elemDef.getContentParticle(), topmostHash);
                    }
                    elemDef = elemDef.next;
                }
            }
            elemDefEnum = topmostHash.elements();
            if (topmostHash.size() == 0) {
                throw new WMDocumentException(WMDocumentExceptionBundle.class, WMDocumentExceptionBundle.AMBIGUOUS_ROOT_MULTI_CONTAINER, "");
            }
            if (topmostHash.size() > 1) {
                StringBuffer sb = new StringBuffer();
                boolean delimit = false;
                int i = 0;
                while (elemDefEnum.hasMoreElements() && i++ < 4) {
                    if (delimit) {
                        sb.append(", ");
                    }
                    elemDef = (ElementDef)elemDefEnum.nextElement();
                    sb.append(elemDef.getName().toString());
                    delimit = true;
                }
                if (topmostHash.size() > 4) {
                    sb.append(", ...");
                }
                throw new WMDocumentException(WMDocumentExceptionBundle.class, WMDocumentExceptionBundle.AMBIGUOUS_ROOT_MULTI_TOP_ELEMENT, "", sb.toString());
            }
            elemDef = (ElementDef)elemDefEnum.nextElement();
            this.rootElementName = elemDef.getName();
        }
        return this.rootElementName;
    }

    public String getSystemID() {
        if (this.externalID == null) {
            return null;
        }
        return this.externalID.systemID;
    }

    public String getPublicID() {
        if (this.externalID == null) {
            return null;
        }
        return this.externalID.publicID;
    }

    public ElementDef getElementDef(Name nsPrefix, Name localName) {
        if (this.elementDefList == null) {
            return null;
        }
        ElementDef elemDef = (ElementDef)this.elementDefHash.get(localName);
        while (elemDef != null && elemDef.getNSPrefix() != nsPrefix) {
            elemDef = elemDef.next;
        }
        return elemDef;
    }

    public Enumeration getElementDefs() {
        if (this.elementDefList == null) {
            return null;
        }
        return new ElementDefEnumeration(this.elementDefList);
    }

    public int getElementDefCount() {
        return this.elementDefHash.size();
    }

    public String getString(boolean wrapInDOCTYPE) throws WMDocumentException {
        Node firstElem;
        StringBuffer sb = new StringBuffer();
        this.append(sb, wrapInDOCTYPE);
        if (this.doc != null && (firstElem = this.doc.getFirstElement()) != null) {
            String[] prefixes;
            XmlName name = new XmlName(firstElem.getNamespacePrefix(), firstElem.getLocalNameWm());
            boolean foundNSDecl = false;
            sb.append("\n<");
            sb.append(name.toString());
            Values nsDecls = this.doc.getNamespaces();
            if (nsDecls != null && (prefixes = nsDecls.getValueKeys()) != null) {
                for (int i = 0; i < prefixes.length; ++i) {
                    Name uri = (Name)nsDecls.get(prefixes[i]);
                    if (uri == null) continue;
                    foundNSDecl = true;
                    sb.append("\n    xmlns:");
                    sb.append(prefixes[i]);
                    sb.append('=');
                    sb.append('\"');
                    sb.append(uri.toString());
                    sb.append('\"');
                }
            }
            if (foundNSDecl) {
                sb.append(">\n</");
            } else {
                sb.append("></");
            }
            sb.append(name.toString());
            sb.append('>');
        }
        return sb.toString();
    }

    public void append(StringBuffer sb, boolean wrapInDOCTYPE) throws WMDocumentException {
        Enumeration enumvar;
        if (wrapInDOCTYPE) {
            sb.append("<?xml version=\"1.0\"?>");
            sb.append('\n');
            sb.append('\n');
            sb.append("<!DOCTYPE ");
            sb.append(this.getRootElementName());
        }
        if (wrapInDOCTYPE) {
            if (this.elementDefList == null) {
                sb.append(">\n");
            } else {
                sb.append(" [\n");
            }
        }
        if ((enumvar = this.getElementDefs()) != null) {
            while (enumvar.hasMoreElements()) {
                ElementDef elemDef = (ElementDef)enumvar.nextElement();
                elemDef.append(sb);
            }
        }
        if (this.elementDefList != null && wrapInDOCTYPE) {
            sb.append("]>\n");
        }
    }

    void addElement(ElementDef elemDef) {
        if (this.elementDefList == null) {
            this.initElementDefList();
        }
        Name localName = elemDef.getLocalName();
        ElementDef existingElemDef = this.getElementDef(elemDef.getNSPrefix(), localName);
        if (existingElemDef != null) {
            if (!existingElemDef.isDeclared) {
                existingElemDef.setContentspec(elemDef.contentspec);
                existingElemDef.isDeclared = true;
            }
        } else {
            this.elementDefList.addElement(elemDef);
            elemDef.next = (ElementDef)this.elementDefHash.get(localName);
            this.elementDefHash.put(localName, elemDef);
            elemDef.isDeclared = true;
        }
    }

    void addAttributes(AttListDecl attListDecl) {
        Name localName;
        ElementDef elemDef;
        if (this.elementDefList == null) {
            this.initElementDefList();
        }
        if ((elemDef = this.getElementDef(attListDecl.elementNSPrefix, localName = attListDecl.elementLocalName)) != null) {
            elemDef.addAttributes(attListDecl.firstAttributeDef);
        } else {
            elemDef = new ElementDef(attListDecl.elementNSPrefix, localName);
            elemDef.addAttributes(attListDecl.firstAttributeDef);
            elemDef.next = (ElementDef)this.elementDefHash.get(localName);
            this.elementDefList.addElement(elemDef);
            this.elementDefHash.put(localName, elemDef);
        }
    }

    void initElementDefList() {
        this.elementDefList = new List();
        this.elementDefHash = new Hashtable();
    }

    void removeNonRoots(XmlName elemDefName, ContentParticle cp, Hashtable topmostHash) {
        if (cp.getType() == 0) {
            XmlName cpName = cp.getName();
            if (!cpName.equals(elemDefName)) {
                topmostHash.remove(cpName.toString());
            }
        } else {
            List children = cp.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                this.removeNonRoots(elemDefName, (ContentParticle)children.elementAt(i), topmostHash);
            }
        }
    }
}

