/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.lang.xml.Document;
import com.wm.lang.xml.GeneralRegionNode;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.token.HtmlType;
import com.wm.util.Name;

class CustomRegionNode
extends GeneralRegionNode {
    Name localname;
    HtmlType htmlType;

    CustomRegionNode(Document doc, Name name, HtmlType htmlType) {
        super(doc);
        this.localname = name;
        this.htmlType = htmlType;
    }

    private CustomRegionNode(CustomRegionNode node) {
        super(node);
        this.localname = node.localname;
        this.htmlType = node.htmlType;
    }

    public boolean isFalseNode() {
        return true;
    }

    public boolean isQueryReturnable() {
        return true;
    }

    public boolean isComplete() {
        return true;
    }

    public boolean appendGeneratedStartTag(StringBuffer sb) {
        sb.append('<');
        sb.append(this.localname);
        sb.append('>');
        return false;
    }

    void appendGeneratedEndTag(StringBuffer sb) {
        sb.append("</");
        sb.append(this.localname);
        sb.append('>');
    }

    public void appendOriginalMarkup(StringBuffer sb) throws WMDocumentException {
        for (int i = 0; i < this.children.size(); ++i) {
            ((Node)this.children.elementAt(i)).appendOriginalMarkup(sb);
        }
    }

    public Name getLocalNameWm() {
        return this.localname;
    }

    public short getNodeType() {
        return 1;
    }

    public HtmlType getHtmlType() {
        return this.htmlType;
    }

    public Node getFirstChildWm() throws WMDocumentException {
        if (this.children.size() == 0) {
            return null;
        }
        return (Node)this.children.elementAt(0);
    }

    public Node getLastChildWm() throws WMDocumentException {
        if (this.children.size() == 0) {
            return null;
        }
        return (Node)this.children.elementAt(this.children.size() - 1);
    }

    public Node getPreviousSiblingOfChild(Node child) {
        int childCount = this.children.size();
        Node previous = null;
        for (int i = 0; i < childCount; ++i) {
            Node current = (Node)this.children.elementAt(i);
            if (current == child) {
                return previous;
            }
            previous = current;
        }
        return null;
    }

    public Node getNextSiblingOfChild(Node child) {
        int childCount = this.children.size();
        for (int i = 0; i < childCount; ++i) {
            Node current = (Node)this.children.elementAt(i);
            if (current != child) continue;
            if (++i == childCount) {
                return null;
            }
            return (Node)this.children.elementAt(i);
        }
        return null;
    }

    public String getText() throws WMDocumentException {
        StringBuffer sb = new StringBuffer();
        if (this.htmlType != null && !this.htmlType.squeeze) {
            this.appendText(sb, true);
        } else {
            this.appendSqueezedText(sb, true, false);
        }
        return sb.toString();
    }

    public Node getClone() {
        return new CustomRegionNode(this);
    }

    public void addChild(Node node) {
        this.children.addElement(node);
        node.parent = this;
    }

    public void addFosterChild(Node node) {
        this.children.addElement(node);
    }
}

