/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.lang.xml.DTD;
import com.wm.lang.xml.Document;
import com.wm.util.EncUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class CompareDirs {
    static boolean writeDTD = false;
    static boolean writeContent = true;

    public static void main(String[] args) {
        try {
            CompareDirs.doCompare(args);
        }
        catch (IllegalArgumentException x) {
            CompareDirs.usage(x.getMessage());
            return;
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    static void doCompare(String[] args) throws Exception {
        if (args.length < 2) {
            throw new IllegalArgumentException("too few arguments");
        }
        File inputDir = new File(args[0]);
        if (inputDir.isFile()) {
            throw new IllegalArgumentException(inputDir.getPath() + " is not a directory");
        }
        File outputDir = new File(args[1]);
        if (outputDir.isFile()) {
            throw new IllegalArgumentException(outputDir.getPath() + " is not a directory");
        }
        File canonicalDir = null;
        for (int i = 2; i < args.length; ++i) {
            if (args[i].startsWith("-d")) {
                writeDTD = true;
                continue;
            }
            if (args[i].startsWith("-c-")) {
                writeContent = false;
                continue;
            }
            canonicalDir = new File(args[i]);
            if (!canonicalDir.isFile()) continue;
            throw new IllegalArgumentException(canonicalDir.getPath() + " is not a directory");
        }
        String[] filenames = inputDir.list();
        for (int i = 0; i < filenames.length; ++i) {
            File canonicalFile;
            File inputFile = new File(inputDir.getPath(), filenames[i]);
            if (!inputFile.exists()) {
                throw new IllegalArgumentException(inputFile.getPath() + " doesn't exist");
            }
            if (!inputFile.isFile() || !inputFile.getPath().toUpperCase().endsWith(".XML")) continue;
            File outputFile = new File(outputDir, inputFile.getName());
            CompareDirs.parseFile(inputFile, outputFile);
            if (canonicalDir != null) {
                canonicalFile = new File(canonicalDir, inputFile.getName());
                if (!canonicalFile.exists()) {
                    throw new IllegalArgumentException(canonicalFile.getPath() + " doesn't exist");
                }
            } else {
                canonicalFile = inputFile;
            }
            CompareDirs.compareFiles(outputFile, canonicalFile);
        }
    }

    static void parseFile(File inputFile, File outputFile) throws Exception {
        FileInputStream inStream = new FileInputStream(inputFile);
        Document doc = new Document((InputStream)inStream, inputFile.getName(), null, true, true);
        if (doc != null) {
            String s;
            doc.setCanonicalize(true);
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)outputStream, "UTF8");
            StringBuffer sb = new StringBuffer();
            if (writeDTD) {
                DTD dtd = doc.getDTD();
                if (dtd == null) {
                    sb.append("No DTD found.\n");
                } else {
                    dtd.append(sb, true);
                }
            }
            if (writeContent) {
                doc.appendGeneratedMarkup(sb);
            }
            if ((s = sb.toString()) != null) {
                outputWriter.write(s, 0, s.length());
            }
            outputWriter.close();
        }
    }

    static void compareFiles(File testFile, File canonicalFile) throws Exception {
        String line;
        String exec = "diff " + testFile.getPath() + " " + canonicalFile.getPath();
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(exec);
        InputStream inputStream = process.getInputStream();
        InputStreamReader inputReader = new InputStreamReader(inputStream, EncUtil.getFileEncoding());
        BufferedReader reader = new BufferedReader(inputReader);
        System.out.println();
        System.out.println("---------------------------------------------------------------");
        System.out.println(testFile.getName());
        System.out.println();
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
        }
        process.waitFor();
    }

    static void usage(String message) {
        if (message != null) {
            System.out.println("Error: " + message);
        }
        System.out.println("java com.wm.xml.lang.CompareDirs <indir> <outdir> [<canonicaldir>] [options]");
        System.out.println();
        System.out.println("  <indir> Directory of documents to parse (may contain DTDs that affect parse)");
        System.out.println("  <outdir> Directory into which to write source generated from our parse trees");
        System.out.println("  <canonicaldir> Directory of files with which to compare generated files.\n     These files won't contain DTDs.  If <canonical-dir> is not provided,\n     output files will be compared with input files.");
        System.out.println("  -d  : Write the fully expanded DTD");
        System.out.println("  -c- : Don't write document content");
    }
}

