/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xml;

import com.wm.dom.DOMExceptionImpl;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.ElementNodeBase;
import com.wm.lang.xml.NamespaceDecl;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.token.EntityTable;
import com.wm.util.Name;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.TypeInfo;

public final class Attribute
extends Node
implements Attr {
    private ElementNode ownerElement;
    String value;
    Name localname;
    NamespaceDecl namespaceDecl;
    private ElementNodeBase elementNodeBase;

    static Attribute getLastAttribute(Attribute attr) {
        Attribute next;
        for (next = attr.getNext(); next != null && next.getNext() != null; next = next.getNext()) {
        }
        return next;
    }

    public Attribute(Document ownerDocument, ElementNode ownerElement, Name lname, String val) {
        this(ownerDocument, ownerElement, lname, val, false, null, true);
    }

    public Attribute(Document ownerDocument, ElementNode ownerElement, Name lname, String value, boolean isId, TypeInfo schemaTypeInfo, boolean specified) {
        super(ownerDocument);
        this.localname = lname;
        this.ownerElement = ownerElement;
        this.value = value;
        this.isSpecified(specified);
        this.setNext(null);
        this.isComplete(true);
    }

    public void appendGeneratedMarkup(StringBuffer sb) {
        if (this.namespaceDecl == null) {
            sb.append(this.localname.toString());
        } else {
            if (this.namespaceDecl.getPrefixWm() != null) {
                sb.append(this.namespaceDecl.getPrefixWm().toString());
                sb.append(':');
            }
            sb.append(this.localname.toString());
        }
        sb.append('=');
        sb.append('\"');
        if (this.getOwnerDocument() != null && ((Document)this.getOwnerDocument()).isCanonicalize()) {
            sb.append(Document.canonicalizeText(EntityTable.getXmlString(this.getValue(), true)));
        } else {
            sb.append(EntityTable.getXmlString(this.getValue(), true));
        }
        sb.append('\"');
    }

    void attachAttribute(Attribute attr) {
        this.setNext(attr);
        attr.setOwnerElement(this.ownerElement);
    }

    public org.w3c.dom.Node cloneNode(boolean deep) {
        Attribute clone = new Attribute(this.document, null, this.localname, this.value);
        clone.isComplete(true);
        clone.namespaceDecl = this.namespaceDecl;
        clone.setDOM1(this.getDOM1());
        clone.isSpecified(true);
        if (this.elementNodeBase != null) {
            for (Node node = this.elementNodeBase.firstChild; node != null; node = (Node)node.getNextSibling()) {
                Node clonedChild = (Node)node.cloneNode(true);
                clonedChild.isComplete(true);
                clone.addChild(clonedChild);
            }
        }
        return clone;
    }

    public String getText() throws WMDocumentException {
        return this.getValue();
    }

    public boolean equals(Name name, Name uri) {
        if (this.localname == null || name == null) {
            return false;
        }
        if (this.localname.equals(name)) {
            Name localuri = this.getNamespaceUri();
            if (localuri == null) {
                return uri == null;
            }
            return localuri.equals(uri);
        }
        return false;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public String getName() {
        return this.getNodeName();
    }

    public Attribute getNext() {
        return (Attribute)this.next;
    }

    public org.w3c.dom.Node getNextSibling() {
        return null;
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeValue() {
        return this.getValue();
    }

    public Element getOwnerElement() {
        return this.ownerElement;
    }

    public org.w3c.dom.Node getParentNode() {
        return null;
    }

    public org.w3c.dom.Node getPreviousSibling() {
        return null;
    }

    public boolean getSpecified() {
        return (this.multiflags & 0x40) > 0;
    }

    private void isSpecified(boolean val) {
        this.multiflags = val ? (short)(this.multiflags | 0x40) : (short)(this.multiflags & 0xFFFFFFBF);
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean isId() {
        return false;
    }

    protected void setId(boolean isId) {
    }

    public void setNamespaceDecl(NamespaceDecl nsdecl) {
        this.namespaceDecl = nsdecl != null && nsdecl.uri != null && nsdecl.uri.toString() != null && nsdecl.uri.toString().length() == 0 ? null : nsdecl;
    }

    public NamespaceDecl getNamespaceDecl() {
        return this.namespaceDecl;
    }

    public void setNodeValue(String nodeValue) {
        this.setValue(nodeValue);
    }

    public void setOwnerElement(ElementNode element) {
        this.ownerElement = element;
    }

    public void setValue(String val) {
        this.value = val;
        this.isSpecified(true);
    }

    void setNext(Attribute next) {
        this.next = next;
    }

    public Name getLocalNameWm() {
        return this.localname;
    }

    public Name getNamespacePrefix() {
        if (this.namespaceDecl == null) {
            return null;
        }
        return this.namespaceDecl.prefix;
    }

    public Name getNamespaceUri() {
        if (this.namespaceDecl == null) {
            return null;
        }
        return this.namespaceDecl.uri;
    }

    public void appendOriginalMarkup(StringBuffer sb) throws WMDocumentException {
    }

    public Node getClone() {
        return null;
    }

    public String getLocalName() {
        if (this.getDOM1()) {
            return null;
        }
        return this.localname.toString();
    }

    public String getNamespaceURI() {
        Name uri = this.getNamespaceUri();
        if (uri != null) {
            return uri.toString();
        }
        return null;
    }

    public String getNodeName() {
        if (this.namespaceDecl == null || this.namespaceDecl.prefix == null) {
            return this.localname.toString();
        }
        Name pre = this.namespaceDecl.getPrefixWm();
        String prefix = pre != null ? pre.toString() : null;
        return prefix != null ? prefix + ":" + this.localname.toString() : this.localname.toString();
    }

    public String getPrefix() {
        if (this.namespaceDecl == null || this.namespaceDecl.prefix == null) {
            return null;
        }
        return this.namespaceDecl.prefix.toString();
    }

    public String getTextAsData() throws WMDocumentException {
        StringBuffer sb = new StringBuffer();
        Attribute.appendTextAsData(sb, this);
        return sb.toString();
    }

    public void addChild(Node node) {
        this.createElementNodeBase();
        this.elementNodeBase.addChild(node);
    }

    public boolean appendGeneratedStartTag(StringBuffer sb) throws WMDocumentException {
        this.createElementNodeBase();
        return this.elementNodeBase.appendGeneratedStartTag(sb);
    }

    public void appendOriginalStartTag(StringBuffer sb) throws WMDocumentException {
        this.createElementNodeBase();
        this.elementNodeBase.appendOriginalStartTag(sb);
    }

    public void assignNamespaceDecl(Name prefix, Name url) {
        this.createElementNodeBase();
        this.elementNodeBase.assignNamespaceDecl(prefix, url);
    }

    public short compareDocumentPosition(org.w3c.dom.Node other) throws DOMException {
        this.createElementNodeBase();
        return this.elementNodeBase.compareDocumentPosition(other);
    }

    public String getBaseURI() {
        this.createElementNodeBase();
        return this.elementNodeBase.getBaseURI();
    }

    public Attribute getFirstAttribute() {
        this.createElementNodeBase();
        return this.elementNodeBase.getFirstAttribute();
    }

    public Node getFirstChildWm() throws WMDocumentException {
        this.createElementNodeBase();
        return this.elementNodeBase.getFirstChildWm();
    }

    public Node getFirstLoadedChild() {
        this.createElementNodeBase();
        return this.elementNodeBase.getFirstLoadedChild();
    }

    public NamespaceDecl getFirstNamespaceDecl() {
        this.createElementNodeBase();
        return this.elementNodeBase.getFirstNamespaceDecl();
    }

    public Node getLastChildWm() throws WMDocumentException {
        this.createElementNodeBase();
        return this.elementNodeBase.getLastChildWm();
    }

    public Node getLastLoadedChild() {
        this.createElementNodeBase();
        return this.elementNodeBase.getLastLoadedChild();
    }

    public Node getNextLoadedChild(Node previousChild) {
        this.createElementNodeBase();
        return this.elementNodeBase.getNextLoadedChild(previousChild);
    }

    public NamespaceDecl getNextNamespaceDecl(NamespaceDecl prevDecl) {
        this.createElementNodeBase();
        return this.elementNodeBase.getNextNamespaceDecl(prevDecl);
    }

    public Node getNextSiblingOfChild(Node child) throws WMDocumentException {
        this.createElementNodeBase();
        return this.elementNodeBase.getNextSiblingOfChild(child);
    }

    public Node getPreviousSiblingOfChild(Node child) {
        this.createElementNodeBase();
        return this.elementNodeBase.getPreviousSiblingOfChild(child);
    }

    public String getTextContent() throws DOMException {
        this.createElementNodeBase();
        return this.elementNodeBase.getTextContent();
    }

    public String getTextOfChildren() throws WMDocumentException {
        this.createElementNodeBase();
        return this.elementNodeBase.getTextOfChildren();
    }

    public void insertChildNode(Node nodeToPrecede, Node nodeToInsert) throws WMDocumentException {
        this.createElementNodeBase();
        this.elementNodeBase.insertChildNode(nodeToPrecede, nodeToInsert);
    }

    public boolean isComplete() {
        this.createElementNodeBase();
        return this.elementNodeBase.isComplete();
    }

    public boolean isEqualNode(org.w3c.dom.Node arg) {
        this.createElementNodeBase();
        return this.elementNodeBase.isEqualNode(arg);
    }

    public NamespaceDecl lookUpInScopeNSDeclByPrefix(Name prefix) {
        this.createElementNodeBase();
        return this.elementNodeBase.lookUpInScopeNSDeclByPrefix(prefix);
    }

    public NamespaceDecl lookUpInScopeNSDeclByURI(Name uri) {
        this.createElementNodeBase();
        return this.elementNodeBase.lookUpInScopeNSDeclByURI(uri);
    }

    public void removeChild(Node node) {
        this.createElementNodeBase();
        this.elementNodeBase.removeChild(node);
    }

    public org.w3c.dom.Node removeChild(org.w3c.dom.Node node) {
        this.createElementNodeBase();
        return this.elementNodeBase.removeChild(node);
    }

    public void removeNamespaceDecl(Name prefix) {
        this.createElementNodeBase();
        this.elementNodeBase.removeNamespaceDecl(prefix);
    }

    public void setPrefix(String prefix) {
        super.setPrefix(prefix);
        Document.checkValidName(prefix);
        if (this.namespaceDecl == null || this.getNamespaceUri() == null) {
            throw new DOMException(14, "DOM Namespace error");
        }
        if (prefix != null && (prefix.equals("xml") && !this.getNamespaceUri().toString().equals("http://www.w3.org/XML/1998/namespace") || prefix.equals("xmlns") && !this.getNamespaceUri().toString().equals("http://www.w3.org/2000/xmlns/") || prefix.indexOf(58) != -1)) {
            throw new DOMExceptionImpl(14);
        }
        if ("xmlns".equals(this.localname.toString())) {
            throw new DOMExceptionImpl(14);
        }
        this.namespaceDecl.prefix = Name.create(prefix);
    }

    public void setTextContent(String textContent) throws DOMException {
        this.createElementNodeBase();
        this.elementNodeBase.setTextContent(textContent);
    }

    private void createElementNodeBase() {
        if (this.elementNodeBase == null) {
            this.elementNodeBase = new ElementNodeBase(this.document);
            this.elementNodeBase.isComplete(true);
        }
    }
}

