/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.generator;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordRef;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.NSSignature;
import com.wm.lang.ns.NSType;
import com.wm.lang.schema.W3CNamespaces;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.wsdl.Message;
import com.wm.lang.wsdl.WSDException;
import com.wm.lang.wsdl.generator.ObjectSrcBuilder;
import com.wm.lang.wsdl.generator.SourceBuilders;
import com.wm.lang.wsdl.generator.StringSrcBuilder;
import com.wm.lang.wsdl.generator.XSDContext;
import com.wm.lang.wsdl.resources.WSDMessageBundle;
import com.wm.soap.coder.SoapConstants;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Strings;
import java.util.Enumeration;
import java.util.Hashtable;

public class XSDGenerator
extends SourceBuilders {
    private static final boolean debug = false;

    public static IData generateXSD(String name, Message[] msgs) {
        boolean level = false;
        XSDContext context = new XSDContext();
        context.setIsWSDL(true);
        NSRecord[] records = new NSRecord[msgs.length];
        for (int i = 0; i < msgs.length; ++i) {
            if (msgs.length == 2) {
                if (i == 0) {
                    context.setName(name + "Input");
                } else {
                    context.setName(name + "Output");
                }
            } else {
                context.setName(name + i);
            }
            records[i] = msgs[i].getNSRecord();
            boolean useSoapArray = msgs[i].isUseSoapArray();
            context.setUseSoapArray(useSoapArray);
            if (records[i] == null) continue;
            XSDGenerator.generateXSDFromRecord(records[i], context);
        }
        return context.packageXSD();
    }

    public static IData generateXSD(NSNode nsNode, IData pipeline) throws WSDException {
        return XSDGenerator.generateXSD(nsNode, false, pipeline);
    }

    public static IData generateXSD(NSNode nsNode, boolean useSoapArray, IData pipeline) throws WSDException {
        if (nsNode == null) {
            throw new WSDException(WSDMessageBundle.class, WSDMessageBundle.NODE_IS_NULL, "");
        }
        IData result = null;
        NSType type = nsNode.getNodeTypeObj();
        if (type.equals(NSRecord.TYPE)) {
            result = XSDGenerator.generateXSD((NSRecord)nsNode, useSoapArray);
        } else if (type.equals(NSService.TYPE)) {
            result = XSDGenerator.generateXSD((NSService)nsNode, useSoapArray);
        }
        IDataCursor idc = pipeline.getCursor();
        IDataCursor rc = result.getCursor();
        IDataUtil.put(idc, "isSuccessful", IDataUtil.getString(rc, "isSuccessful"));
        IDataUtil.put(idc, "warnings", IDataUtil.get(rc, "warnings"));
        IDataUtil.put(idc, "errors", IDataUtil.get(rc, "errors"));
        IData xsd = IDataFactory.create();
        IDataCursor xsdc = xsd.getCursor();
        String url = IDataUtil.getString(rc, "url");
        String source = IDataUtil.getString(rc, "source");
        IData temp = null;
        while (rc.next("import-xsd")) {
            temp = (IData)rc.getValue();
            if (temp == null) continue;
            xsdc.last();
            xsdc.insertAfter("import-xsd", temp);
        }
        temp = IDataUtil.getIData(rc, "include-xsd");
        if (temp != null) {
            IDataUtil.put(xsdc, "include-xsd", temp);
        }
        if ((temp = IDataUtil.getIData(rc, "redefine-xsd")) != null) {
            IDataUtil.put(xsdc, "redefine-xsd", temp);
        }
        if ((temp = IDataUtil.getIData(rc, "import-dtd")) != null) {
            IDataUtil.put(xsdc, "import-dtd", temp);
        }
        IDataUtil.put(xsdc, "url", url);
        IDataUtil.put(xsdc, "source", source);
        IDataUtil.put(idc, "xsd", xsd);
        idc.destroy();
        rc.destroy();
        xsdc.destroy();
        return pipeline;
    }

    public static IData generateXSD(NSService svc, boolean useSoapArray) {
        if (svc != null) {
            NSSignature sig = svc.getSignature();
            if (sig == null) {
                return null;
            }
            XSDContext context = new XSDContext(useSoapArray);
            String name = svc.getNSName().getNodeName().toString();
            context.setName(name);
            context.setIsWSDL(true);
            int level = 0;
            String temp = null;
            NSRecord[] records = new NSRecord[2];
            records[0] = sig.getInput();
            if (records[0].getName() == null && records[0].getNSName() == null) {
                temp = Strings.cat(name, "Input");
                records[0].setName(temp);
            }
            records[1] = sig.getOutput();
            if (records[1].getName() == null && records[1].getNSName() == null) {
                records[1].setName(name + "Output");
            }
            return XSDGenerator.generate(records, context, useSoapArray, level);
        }
        return null;
    }

    public static IData generateXSD(NSSignature sig, boolean useSoapArray) {
        XSDContext context = new XSDContext(useSoapArray);
        int level = 0;
        NSRecord[] records = new NSRecord[]{sig.getInput(), sig.getOutput()};
        return XSDGenerator.generate(records, context, useSoapArray, level);
    }

    public static IData generateXSD(NSRecord record, boolean useSoapArray) {
        XSDContext context = new XSDContext(useSoapArray);
        String name = record.getNSName().getNodeName().toString();
        context.setName(name);
        int level = 0;
        NSRecord[] records = new NSRecord[]{record};
        return XSDGenerator.generate(records, context, useSoapArray, level);
    }

    static IData generate(NSRecord[] records, XSDContext context, boolean useSoapArray, int level) {
        try {
            for (int i = 0; i < records.length; ++i) {
                if (records[i] == null) continue;
                XSDGenerator.generateXSDFromRecord(records[i], context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return context.packageXSD();
    }

    private static void genComplexType(NSRecord record, XSDContext context, Hashtable complexTypeRefs) {
        Name recordUri;
        String typeName;
        int recordDim = record.getDimensions();
        QName schemaTypeName = record.getSchemaTypeName();
        if (schemaTypeName != null) {
            typeName = schemaTypeName.getLocalName().toString();
            recordUri = schemaTypeName.getNamespaceName();
            if (recordUri == null) {
                recordUri = SoapConstants.WEBM_DEFAULT_NAMESPACE;
            }
        } else {
            typeName = XSDGenerator.fieldToTypeName(record);
            recordUri = XSDGenerator.getXmlNamespace(record);
        }
        XSDGenerator.initialize(recordUri, context);
        HashSet childUris = context.getTNSPrefixes(recordUri);
        childUris.add(recordUri);
        if (!context.isDeclaredType(recordUri, typeName)) {
            boolean isClosed = record.isClosed();
            int starBodyType = XSDGenerator.checkStarBody(record, context);
            NSField[] children = record.getFieldNodes();
            XSDGenerator.writeComplexTypeOpenTag(typeName, starBodyType, context, recordUri, null, children, complexTypeRefs);
            XSDGenerator.writeSequenceCloseTag(recordUri, context, isClosed);
            XSDGenerator.genAttributes(record, context);
            XSDGenerator.writeComplexTypeCloseTag(typeName, starBodyType, context, recordUri, isClosed);
            for (int i = 0; i < children.length; ++i) {
                if (children[i].getName().startsWith("@") || children[i] instanceof NSRecord || children[i].getContentType() == null) continue;
                StringSrcBuilder.generate(children[i], context, recordUri);
            }
            context.addDeclaredType(recordUri, typeName);
            if (recordDim > 0) {
                XSDGenerator.writeArray(context, record, false);
            }
        }
        String itemName = XSDGenerator.fieldToName(context, record, XSDGenerator.getXmlNamespace(record));
        XSDGenerator.writeElementTypeRef(context, recordUri, itemName, typeName, recordDim, record.isOptional(), true, record.isNillable());
    }

    public static String fieldToTypeName(NSRecord record) {
        int idx;
        String recordName = record.getName();
        int recordType = record.getType();
        int recordDim = record.getDimensions();
        String typeName = recordType == 4 ? XSDGenerator.getRecordRefName((NSRecordRef)record) : ((idx = recordName.indexOf(58)) != -1 ? recordName.substring(idx + 1) : recordName);
        if (recordDim > 0) {
            typeName = typeName + "ArrayItem";
            QName schemaType = QName.create(XSDGenerator.getXmlNamespace(record), Name.create(typeName));
            record.setSchemaTypeName(schemaType);
        }
        return typeName;
    }

    private static void generateXSDFromRecord(NSRecord record, XSDContext context) {
        Hashtable complexTypeRefs = new Hashtable();
        if (context.isUseSoapArray()) {
            XSDGenerator.outputChildren(context, record.getFieldNodes(), complexTypeRefs);
        } else {
            NSField[] fields = new NSField[]{record};
            String name = record.getName();
            if (name == null) {
                if (context.getName() != null) {
                    record.setName(context.getName());
                } else {
                    record.setName("top");
                }
            }
            XSDGenerator.outputChildren(context, fields, complexTypeRefs);
        }
        while (!complexTypeRefs.isEmpty()) {
            Enumeration enumvar = complexTypeRefs.keys();
            String refRecordName = (String)enumvar.nextElement();
            NSField refField = (NSField)complexTypeRefs.get(refRecordName);
            complexTypeRefs.remove(refRecordName);
            if (refField instanceof NSRecord) {
                XSDGenerator.genComplexType((NSRecord)refField, context, complexTypeRefs);
                continue;
            }
            XSDGenerator.writeArray(context, refField, false);
        }
    }

    static void outputChildren(XSDContext context, NSField[] children, Hashtable complexTypeRefs) {
        boolean padding = true;
        block9: for (int index = 0; index < children.length; ++index) {
            NSField child = children[index];
            int childDim = child.getDimensions();
            int fieldType = child.getType();
            context.setRootUri(XSDGenerator.getXmlNamespace(child));
            Name childUri = XSDGenerator.getXmlNamespace(child);
            if (childDim > 0) {
                XSDGenerator.writeArray(context, child, true);
                if (context.isUseSoapArray()) {
                    // empty if block
                }
                switch (fieldType) {
                    case 1: {
                        StringSrcBuilder.generate(child, context, childUri);
                        break;
                    }
                    case 3: {
                        ObjectSrcBuilder.generate(child, context);
                        break;
                    }
                }
            }
            switch (fieldType) {
                case 2: {
                    complexTypeRefs.put(child.getName(), (NSRecord)child);
                    continue block9;
                }
                case 4: {
                    complexTypeRefs.put(child.getName(), (NSRecord)child);
                    continue block9;
                }
                case 1: {
                    if (!context.isUseSoapArray()) continue block9;
                    StringSrcBuilder.generate(child, context, childUri);
                    continue block9;
                }
            }
        }
    }

    private static String makeTypeRef(String prefix, String localName) {
        if (!prefix.equals(NULLNS)) {
            return prefix + ":" + localName;
        }
        return W3CNamespaces.WEBM_DEFAULT_PREFIX_STRING + ":" + localName;
    }

    private static void genAttributes(NSRecord record, XSDContext context) {
        NSField[] children = record.getFieldNodes();
        Name recordUri = XSDGenerator.getXmlNamespace(record);
        for (int index = 0; index < children.length; ++index) {
            NSField child = children[index];
            int fieldType = child.getType();
            String childName = child.getName();
            if (!childName.startsWith("@")) continue;
            StringSrcBuilder.generate(child, context, recordUri);
        }
    }
}

