/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.generator;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.schema.W3CNamespaces;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.util.Iterator;
import com.wm.lang.wsdl.WSDLKeys;
import com.wm.lang.wsdl.WSDWorkspace;
import com.wm.lang.wsdl.generator.MessageSrcBuilder;
import com.wm.lang.wsdl.generator.SourceBuilders;
import com.wm.soap.coder.SoapConstants;
import com.wm.util.Name;
import com.wm.util.Strings;
import java.util.Enumeration;
import java.util.Hashtable;

class XSDContext
extends WSDWorkspace
implements WSDLKeys {
    private static final boolean debug = false;
    private static final boolean debugVerbose = false;
    static final int PADDING = 1;
    private int _nextID = 1;
    static final String PREFIX_FOR_GENERATED_NAMESPACE_PREFIX = "ST";
    static final String XML_PROLOG = "<?xml version=\"1.0\"?>\n";
    static final String SCHEMA_OPEN = "<xsd:schema";
    static final String ELEMENT_FORM_DEFAULT = "elementFormDefault=\"qualified\"";
    static final String ATTRIBUTE_FORM_DEFAULT = "attributeFormDefault=\"qualified\"";
    static final String HTTP = " \"http://";
    static final String CLOSE = "/\">\n";
    static final String IMPORT = "<xsd:import namespace=\"";
    static final String IMPORT_NO_NS = "<xsd:import ";
    static final String SCHEMA_LOCATION = " schemaLocation=\"";
    static final String SCHEMA_CLOSE = "\n</xsd:schema>";
    static final String XSD_FILE_EXT = ".xsd";
    static final String XMLNS = "xmlns:";
    static final String DEFAULT_XMLNS = "xmlns=\"";
    static final String SOAP_ENC_NS = "xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\"";
    static final String IMPORT_SOAP_ENC = "<xsd:import namespace=\"http://schemas.xmlsoap.org/soap/encoding/\" schemaLocation=\"http://schemas.xmlsoap.org/soap/encoding/\"/>";
    static final String TARGET_NAMESPACE = "targetNamespace=\"";
    private String _defName = "default";
    private Hashtable _namespaceDecls = new Hashtable(11);
    Hashtable _tnsXSD = new Hashtable(11);
    Hashtable _tnsPrefixes = new Hashtable(11);
    Hashtable _tnsPadding = new Hashtable(11);
    HashSet _targetHoler = new HashSet();
    Hashtable _dupTopFields = new Hashtable();
    Hashtable _dupSoapNames = new Hashtable();
    HashSet _dupSimpleType = new HashSet();
    Hashtable _topNoNsST = new Hashtable(5);
    Hashtable _tnsDeclaredTypes;
    Hashtable _tnsDeclaredElements;
    boolean _hasTopAlready = false;
    Name _rootUri;
    private boolean _useSoapArray;
    private boolean _isWSDL;
    private int _nextPrefix = 1;

    XSDContext() {
        this._useSoapArray = true;
        this._isWSDL = false;
        this._tnsDeclaredTypes = new Hashtable();
        this._tnsDeclaredElements = new Hashtable();
        this.addNamespacePrefix(WSDLKeys.SCHEMA_REC_NS, MessageSrcBuilder.XSD_PREFIX);
        this.addNamespacePrefix(SoapConstants.SOAP_ENCODING_11_NS, SoapConstants.PREFIX_FOR_SOAP_ENCODING_11);
    }

    XSDContext(boolean useSoapArray) {
        this._useSoapArray = useSoapArray;
        this._tnsDeclaredTypes = new Hashtable();
        this._tnsDeclaredElements = new Hashtable();
        this._isWSDL = false;
        this.addNamespacePrefix(WSDLKeys.SCHEMA_REC_NS, MessageSrcBuilder.XSD_PREFIX);
        if (useSoapArray) {
            this.addNamespacePrefix(SoapConstants.SOAP_ENCODING_11_NS, SoapConstants.PREFIX_FOR_SOAP_ENCODING_11);
        }
    }

    void setRootUri(Name uri) {
        this._rootUri = uri;
    }

    Name getRootUri() {
        if (this._rootUri == null) {
            return SoapConstants.WEBM_DEFAULT_NAMESPACE;
        }
        return this._rootUri;
    }

    void setName(String name) {
        this._defName = name;
    }

    String getName() {
        return this._defName;
    }

    String createNamespacePrefix(Name uri) {
        return this.createNamespacePrefix(uri, null);
    }

    String createNamespacePrefix(Name uri, Name preferredPrefix) {
        Name prefix = (Name)this._namespaceDecls.get(uri);
        if (prefix == null) {
            prefix = preferredPrefix != null && XSDContext.isValueInHash(this._namespaceDecls, preferredPrefix) ? preferredPrefix : Name.create(PREFIX_FOR_GENERATED_NAMESPACE_PREFIX + Integer.toString(this._nextPrefix++));
            this._namespaceDecls.put(uri, prefix);
        }
        return prefix.toString();
    }

    private static boolean isValueInHash(Hashtable ht, Object value) {
        Enumeration e = ht.elements();
        while (e.hasMoreElements()) {
            Object object = e.nextElement();
            if (!value.equals(object)) continue;
            return true;
        }
        return false;
    }

    public Name getNamespacePrefix(Name uri) {
        return (Name)this._namespaceDecls.get(uri);
    }

    public void addNamespacePrefix(Name uri, Name prefix) {
        this._namespaceDecls.put(uri, prefix);
    }

    int getPadding(Name uri) {
        Object temp = this._tnsPadding.get(uri);
        if (temp == null) {
            this._tnsPadding.put(uri, Integer.toString(1));
            return 1;
        }
        return Integer.parseInt(temp.toString());
    }

    void putPadding(Name uri, int padding) {
        this._tnsPadding.put(uri, Integer.toString(padding));
    }

    void addDupSoapNameCount(String name) {
        int count = 1;
        if (this._dupSoapNames.get(name) != null) {
            count = Integer.parseInt((String)this._dupSoapNames.get(name));
            ++count;
        }
        this._dupSoapNames.put(name, Integer.toString(count));
    }

    void addDeclaredType(Name uri, String typeName) {
        int index;
        HashSet typeList = (HashSet)this._tnsDeclaredTypes.get(uri);
        if (typeList == null) {
            typeList = new HashSet();
            this._tnsDeclaredTypes.put(uri, typeList);
        }
        String name = (index = typeName.indexOf(58)) != -1 ? typeName.substring(index + 1) : typeName;
        typeList.add(name);
    }

    boolean isDeclaredType(Name uri, String typeName) {
        boolean ret = false;
        HashSet typeList = (HashSet)this._tnsDeclaredTypes.get(uri);
        if (typeList != null && typeList.contains(typeName)) {
            ret = true;
        }
        return ret;
    }

    void addDeclaredElement(Name uri, String eName) {
        int index;
        HashSet eList = (HashSet)this._tnsDeclaredElements.get(uri);
        if (eList == null) {
            eList = new HashSet();
            this._tnsDeclaredElements.put(uri, eList);
        }
        String name = (index = eName.indexOf(58)) != -1 ? eName.substring(index + 1) : eName;
        eList.add(name);
    }

    boolean isDeclaredElement(Name uri, String eName) {
        boolean ret = false;
        HashSet eList = (HashSet)this._tnsDeclaredElements.get(uri);
        if (eList != null && eList.contains(eName)) {
            ret = true;
        }
        return ret;
    }

    void putXSDSrc(Name uri, StringBuffer xsdSrc) {
        this._tnsXSD.put(uri, xsdSrc);
    }

    StringBuffer getXSDSrc(Name uri) {
        return (StringBuffer)this._tnsXSD.get(uri);
    }

    void putTNSPrefixes(Name uri, HashSet tnsPrefix) {
        this._tnsPrefixes.put(uri, tnsPrefix);
    }

    HashSet getTNSPrefixes(Name uri) {
        HashSet prefixes = (HashSet)this._tnsPrefixes.get(uri);
        if (prefixes == null) {
            prefixes = new HashSet();
            this.putTNSPrefixes(uri, prefixes);
        }
        return prefixes;
    }

    public boolean isUseSoapArray() {
        return this._useSoapArray;
    }

    public void setUseSoapArray(boolean use) {
        if (use) {
            this.addNamespacePrefix(SoapConstants.SOAP_ENCODING_11_NS, SoapConstants.PREFIX_FOR_SOAP_ENCODING_11);
        }
        this._useSoapArray = use;
    }

    public boolean isWSDL() {
        return this._isWSDL;
    }

    public void setIsWSDL(boolean isWSDL) {
        this._isWSDL = isWSDL;
    }

    IData packageXSD() {
        IData data = this.packageResults();
        IDataCursor idc = data.getCursor();
        boolean isSuccessful = false;
        Object o = IDataUtil.get(idc, "isSuccessful");
        idc.destroy();
        if (o instanceof Boolean) {
            isSuccessful = (Boolean)o;
        } else if (o instanceof String) {
            isSuccessful = new Boolean(o.toString());
        }
        if (isSuccessful) {
            data = this.createXSDStrings(data);
        }
        return data;
    }

    String createOpenSchemaTag(Name targetNS, HashSet prefixes) {
        String src = null;
        StringBuffer sb = new StringBuffer();
        StringBuffer importSB = new StringBuffer();
        String padding = "\n            ";
        sb.append(XML_PROLOG);
        sb.append(SCHEMA_OPEN);
        if (targetNS != SourceBuilders.NULLNS_NAME) {
            src = Strings.cat(padding, TARGET_NAMESPACE, targetNS.toString(), "\"");
            sb.append(src);
            src = Strings.cat(padding, DEFAULT_XMLNS, targetNS.toString(), "\"");
            sb.append(src);
        } else {
            src = Strings.cat(padding, TARGET_NAMESPACE, W3CNamespaces.WEBM_DEFAULT_NAMESPACE_STRING, "\"");
            sb.append(src);
            src = Strings.cat(padding, DEFAULT_XMLNS, W3CNamespaces.WEBM_DEFAULT_NAMESPACE_STRING, "\"");
            sb.append(src);
        }
        this.createXmlnsStrings(padding, targetNS, sb);
        if (this._useSoapArray) {
            importSB.append(padding);
            importSB.append(IMPORT_SOAP_ENC);
        } else if (!this.isWSDL()) {
            this.addXmlnsImportStrings(padding, targetNS, importSB);
        }
        sb.append(">");
        src = Strings.cat(sb.toString(), importSB.toString());
        if (targetNS == SourceBuilders.NULLNS_NAME) {
            SourceBuilders.initialize(targetNS, this);
            StringBuffer stBuffer = this.getXSDSrc(targetNS);
            Enumeration en = this._topNoNsST.elements();
            while (en.hasMoreElements()) {
                stBuffer.append(en.nextElement());
            }
            this.putXSDSrc(targetNS, stBuffer);
        }
        return src;
    }

    private IData createXSDStrings(IData data) {
        StringBuffer sb = null;
        HashSet hset = null;
        String openTag = null;
        String src = null;
        Name skipKey = this.getRootUri();
        IDataCursor idc = data.getCursor();
        hset = this.getTNSPrefixes(skipKey);
        openTag = this.createOpenSchemaTag(skipKey, hset);
        sb = this.getXSDSrc(skipKey);
        Name prefix = (Name)this._namespaceDecls.get(skipKey);
        if (prefix == null) {
            prefix = Name.create(this.getName());
        }
        if (sb != null) {
            String body = sb.toString();
            src = Strings.cat(openTag, body, SCHEMA_CLOSE);
            IDataUtil.put(idc, "url", prefix + XSD_FILE_EXT);
            IDataUtil.put(idc, "source", src);
        }
        Enumeration en = this._tnsXSD.keys();
        while (en.hasMoreElements()) {
            String body;
            Name key = (Name)en.nextElement();
            if (key == skipKey) continue;
            hset = this.getTNSPrefixes(key);
            openTag = this.createOpenSchemaTag(key, hset);
            sb = this.getXSDSrc(key);
            if (sb == null || (body = sb.toString()).length() <= 0) continue;
            src = Strings.cat(openTag, body, SCHEMA_CLOSE);
            prefix = (Name)this._namespaceDecls.get(key);
            if (prefix == null) {
                prefix = Name.create(this.getName());
            }
            Object[][] o = new Object[][]{{"url", prefix + XSD_FILE_EXT}, {"source", src}};
            IData tempData = IDataFactory.create(o);
            idc.insertAfter("import-xsd", tempData);
        }
        idc.destroy();
        return data;
    }

    private void addXmlnsImportStrings(String padding, Name currentUri, StringBuffer sb) {
        HashSet uriRefs = this.getTNSPrefixes(currentUri);
        Iterator itr = uriRefs.iterator();
        while (itr.hasNext()) {
            Name uri = (Name)itr.next();
            if (SourceBuilders.NULLNS_NAME == uri) {
                uri = W3CNamespaces.WEBM_DEFAULT_NAMESPACE;
            }
            if (uri == currentUri || uri == WSDLKeys.SCHEMA_LC_NS || uri == WSDLKeys.SCHEMA_CR_NS || uri == WSDLKeys.SCHEMA_REC_NS) continue;
            Name prefix = (Name)this._namespaceDecls.get(uri);
            sb.append(padding);
            sb.append(IMPORT);
            sb.append(uri.toString());
            sb.append("\" ");
            sb.append(SCHEMA_LOCATION);
            sb.append(prefix.toString());
            sb.append(XSD_FILE_EXT);
            sb.append("\"/>");
        }
    }

    private void createXmlnsStrings(String padding, Name currentUri, StringBuffer sb) {
        Enumeration en = this._namespaceDecls.keys();
        while (en.hasMoreElements()) {
            Name uri = (Name)en.nextElement();
            Name prefix = (Name)this._namespaceDecls.get(uri);
            if (SourceBuilders.NULLNS_NAME == uri) {
                uri = W3CNamespaces.WEBM_DEFAULT_NAMESPACE;
            }
            String src = Strings.cat(padding, XMLNS, prefix.toString(), "=\"", uri.toString(), "\" ");
            sb.append(src);
        }
    }
}

