/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.generator;

import com.wm.data.IData;
import com.wm.lang.ns.NSWSDescriptor;
import com.wm.lang.schema.W3CNamespaces;
import com.wm.lang.wsdl.Binding;
import com.wm.lang.wsdl.Folder;
import com.wm.lang.wsdl.Message;
import com.wm.lang.wsdl.Service;
import com.wm.lang.wsdl.WSD;
import com.wm.lang.wsdl.WSDException;
import com.wm.lang.wsdl.WSDLKeys;
import com.wm.lang.wsdl.generator.BindingSrcBuilder;
import com.wm.lang.wsdl.generator.DefinitionSrcBuilder;
import com.wm.lang.wsdl.generator.MessageSrcBuilder;
import com.wm.lang.wsdl.generator.PortTypeSrcBuilder;
import com.wm.lang.wsdl.generator.ServiceSrcBuilder;
import com.wm.lang.wsdl.generator.SourceBuilders;
import com.wm.lang.wsdl.generator.TypesSrcBuilder;
import com.wm.lang.wsdl.generator.WSDContext;
import com.wm.util.Name;

public class WSDGenerator
implements WSDLKeys {
    public IData generate(WSD wsd) throws WSDException {
        return this.generate(wsd, false);
    }

    public IData generate(WSD wsd, boolean duplicatesInPipeline) throws WSDException {
        return this.generate(wsd, null, duplicatesInPipeline);
    }

    public IData generate(WSD wsd, NSWSDescriptor newWSD, boolean duplicatesInPipeline) throws WSDException {
        WSDContext context = new WSDContext();
        context._wsDescriptor = newWSD;
        WSDGenerator.generate(wsd, context);
        return context.packageWSD(duplicatesInPipeline);
    }

    static void generate(WSD wsd, WSDContext context) throws WSDException {
        int i;
        Binding[] bindings = wsd.getBindings();
        Service[] svcs = wsd.getServices();
        Folder[] folders = wsd.getFolders();
        Message[] msgs = wsd.getMessages();
        String targetNS = wsd.getTargetNamespace();
        if (targetNS == null) {
            targetNS = SourceBuilders.NULLNS;
        }
        Name uri = Name.create(targetNS);
        Name prefix = Name.create("tns");
        if (!targetNS.equals(SourceBuilders.NULLNS)) {
            context.addNamespaceDeclaration(uri, prefix);
        } else {
            uri = W3CNamespaces.WEBM_DEFAULT_NAMESPACE;
            context.addNamespaceDeclaration(uri, prefix);
        }
        context.setTargetNS(uri);
        context.addNamespaceDeclaration(WSDL_NSURI, WSDL_PREFIX);
        context.addNamespaceDeclaration(SOAP_NSURI, SOAP_PREFIX);
        context.addNamespaceDeclaration(HTTP_NSURI, HTTP_PREFIX);
        context.addNamespaceDeclaration(MIME_NSURI, MIME_PREFIX);
        context.addNamespaceDeclaration(WSDL_NSURI, WSDL_PREFIX);
        context.addNamespaceDeclaration(SCHEMA_REC_NS, Name.create("xsd"));
        for (i = 0; i < folders.length; ++i) {
            PortTypeSrcBuilder.setName(folders[i], context);
        }
        if (msgs != null) {
            context._msgs = msgs;
            TypesSrcBuilder.generate(context);
            msgs = context._msgs;
            for (i = 0; i < msgs.length; ++i) {
                MessageSrcBuilder.generate(msgs[i], context);
            }
        }
        for (i = 0; i < folders.length; ++i) {
            PortTypeSrcBuilder.generate(folders[i], context);
        }
        for (i = 0; i < bindings.length; ++i) {
            BindingSrcBuilder.generate(bindings[i], context);
        }
        for (i = 0; i < svcs.length; ++i) {
            ServiceSrcBuilder.generate(svcs[i], context);
        }
        DefinitionSrcBuilder.generate(wsd, context);
    }
}

