/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.generator;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSWSDescriptor;
import com.wm.lang.wsdl.Message;
import com.wm.lang.wsdl.WSDLKeys;
import com.wm.lang.wsdl.WSDWorkspace;
import com.wm.lang.wsdl.generator.TypesSrcBuilder;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Strings;
import com.wm.util.Values;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

class WSDContext
extends WSDWorkspace
implements WSDLKeys {
    private static final boolean debug = false;
    static final int PADDING = 1;
    private int _nextID = 1;
    static final String PREFIX_FOR_GENERATED_NAMESPACE_PREFIX = "wsdns";
    private Hashtable _namespaceDecls = new Hashtable(11);
    StringBuffer _wsdSrc = new StringBuffer();
    Vector _xsdURLs = new Vector();
    IData _xsd;
    private Name _targetNS;
    private int _nextPrefix = 1;
    boolean _importDefault = false;
    String _defName = "default";
    Message[] _msgs;
    HashMap<QName, QName> _duplicatesResolved;
    int _nextIndex = 1;
    NSWSDescriptor _wsDescriptor = null;

    WSDContext() {
    }

    String getName() {
        return this._defName;
    }

    void setName(String name) {
        this._defName = name;
    }

    void setWSDSrc(StringBuffer sb) {
        this._wsdSrc = sb;
    }

    String createNamespacePrefix(Name uri) {
        return this.createNamespacePrefix(uri, null);
    }

    String createNamespacePrefix(Name uri, Name preferredPrefix) {
        Name prefix = (Name)this._namespaceDecls.get(uri);
        if (prefix == null) {
            prefix = preferredPrefix != null && WSDContext.isValueInHash(this._namespaceDecls, preferredPrefix) ? preferredPrefix : Name.create(PREFIX_FOR_GENERATED_NAMESPACE_PREFIX + Integer.toString(this._nextPrefix++));
            this._namespaceDecls.put(uri, prefix);
        }
        return prefix.toString();
    }

    private static boolean isValueInHash(Hashtable ht, Object value) {
        Enumeration e = ht.elements();
        while (e.hasMoreElements()) {
            Object object = e.nextElement();
            if (!value.equals(object)) continue;
            return true;
        }
        return false;
    }

    void addNamespaceDeclaration(Name uri, Name prefix) {
        this._namespaceDecls.put(uri, prefix);
    }

    String getNamespacePrefix(Name uri) {
        Name prefix = (Name)this._namespaceDecls.get(uri);
        return prefix != null ? prefix.toString() : null;
    }

    Name getTargetNS() {
        return this._targetNS;
    }

    void setTargetNS(Name ns) {
        this._targetNS = ns;
    }

    Vector[] getXSDUrls() {
        if (this._xsdURLs != null) {
            Vector[] urls = new Vector[this._xsdURLs.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = (Vector)this._xsdURLs.elementAt(i);
            }
            return urls;
        }
        return null;
    }

    Hashtable getNSDecls() {
        return this._namespaceDecls;
    }

    IData packageWSD() {
        return this.packageWSD(false);
    }

    IData packageWSD(boolean duplicatesInPipeline) {
        IData data = this.packageResults();
        IDataCursor idc = data.getCursor();
        String fileName = Strings.cat(this.getName(), ".wsdl");
        IDataUtil.put(idc, "url", fileName);
        String src = this._wsdSrc.toString();
        IDataUtil.put(idc, "source", src);
        if (duplicatesInPipeline) {
            IDataUtil.put(idc, "DUPLICATES_RESOLVED", this._duplicatesResolved);
        }
        if (TypesSrcBuilder.separateXSD && this._xsd != null) {
            IDataCursor xsdCursor = this._xsd.getCursor();
            boolean isSuccessful = false;
            Object o = IDataUtil.get(xsdCursor, "isSuccessful");
            if (o instanceof Boolean) {
                isSuccessful = (Boolean)o;
            } else if (o instanceof String) {
                isSuccessful = new Boolean(o.toString());
            }
            if (!isSuccessful) {
                IDataUtil.put(idc, "isSuccessful", "false");
                if (idc.first("isSuccessful")) {
                    idc.setValue("false");
                }
                Values[] xsdErrors = (Values[])IDataUtil.get(xsdCursor, "errors");
                Values[] wsdErrors = (Values[])IDataUtil.get(idc, "errors");
                if (wsdErrors == null) {
                    IDataUtil.put(idc, "errors", xsdErrors);
                } else {
                    int len = xsdErrors.length + wsdErrors.length;
                    Values[] errors = new Values[len];
                    System.arraycopy(wsdErrors, 0, errors, 0, wsdErrors.length);
                    System.arraycopy(xsdErrors, 0, errors, wsdErrors.length, xsdErrors.length);
                    IDataUtil.put(idc, "errors", errors);
                }
            } else {
                IDataUtil.put(idc, "type-xsd", this._xsd);
            }
            xsdCursor.destroy();
        }
        idc.destroy();
        return data;
    }

    Name getTypeNameUri() {
        if (this._msgs != null) {
            String nameURI = this._msgs[0].getTypeNameURI();
            if (nameURI == null) {
                nameURI = this._msgs[1].getTypeNameURI();
            }
            if (nameURI != null) {
                return Name.create(nameURI);
            }
        }
        return null;
    }

    NSWSDescriptor getWSDescriptor() {
        return this._wsDescriptor;
    }

    void setWSDescriptor(NSWSDescriptor wsDescriptor) {
        this._wsDescriptor = wsDescriptor;
    }
}

