/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.generator;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.wsdl.Message;
import com.wm.lang.wsdl.WSDException;
import com.wm.lang.wsdl.generator.SourceBuilders;
import com.wm.lang.wsdl.generator.WSDContext;
import com.wm.util.Name;
import com.wm.util.Strings;
import com.wm.xsd.coder.IXSDCoder;
import com.wm.xsd.coder.XSDCoderException;
import com.wm.xsd.coder.XSDCoderFactory;
import com.wm.xsd.component.Namespaces;
import com.wm.xsd.component.XSComponentFactory;
import com.wm.xsd.component.XSImport;
import com.wm.xsd.component.XSSchema;
import com.wm.xsd.util.CreateXSD;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class TypesSrcBuilder
extends SourceBuilders {
    static final boolean debug = false;
    static final String SCHEMA_OPEN = "<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">";
    static final String TYPE_OPEN = "<wsdl:types>";
    static final String TYPE_CLOSE = "</wsdl:types>";
    static final String SCHEMA_CLOSE = "</xsd:schema>";
    static final String INCLUDE_DEFAULT = "<xsd:include schemaLocation=\"{0}.xsd\"/>";
    public static boolean separateXSD = new Boolean(System.getProperty("watt.server.wsdl.separateXSD", "false"));

    static void generate(WSDContext context) throws WSDException {
        int padding = 1;
        StringBuffer sb = context._wsdSrc;
        String src = Strings.cat(TypesSrcBuilder.composePadding(padding), TYPE_OPEN);
        sb.append(src);
        try {
            ++padding;
            IData coderResult = CreateXSD.generateXSD(context._msgs, context.getTypeNameUri(), 8, context.getWSDescriptor());
            IDataCursor idc = coderResult.getCursor();
            context._duplicatesResolved = (HashMap)IDataUtil.get(idc, "DUPLICATES_RESOLVED");
            context._msgs = (Message[])IDataUtil.get(idc, "msgs");
            String xsd = IDataUtil.getString(idc, "xsd");
            IData[] mapWarnings = (IData[])IDataUtil.get(idc, "warnings");
            if (mapWarnings != null) {
                for (int i = 0; i < mapWarnings.length; ++i) {
                    IDataCursor wdc = mapWarnings[i].getCursor();
                    context.addWarning(IDataUtil.getString(wdc, "warningMessage"));
                }
            }
            sb.append(xsd);
            String import_schema = TypesSrcBuilder.generateSchemaImports(context, 8);
            sb.append(import_schema);
        }
        catch (Exception e) {
            throw new WSDException(e.getLocalizedMessage());
        }
        sb.append(TypesSrcBuilder.composePadding(--padding));
        sb.append(TYPE_CLOSE);
        context.setWSDSrc(sb);
    }

    static String generateSchemaImports(WSDContext context, int initialpadding) throws IOException, XSDCoderException {
        int index;
        String schema_imports = new String();
        Message[] msgs = context._msgs;
        if (msgs == null) {
            return schema_imports;
        }
        HashMap<String, XSSchema> import_schemas = new HashMap<String, XSSchema>(4);
        Namespaces namespaces = XSComponentFactory.createNamespaces();
        for (int i = 0; i < msgs.length; ++i) {
            Vector xsd_url_array = msgs[i].getXSDUrlPairs();
            if (xsd_url_array == null) continue;
            for (index = 0; index < xsd_url_array.size(); ++index) {
                String[] xsd_url = (String[])xsd_url_array.get(index);
                Object schema_object = import_schemas.get(xsd_url[0]);
                XSSchema schema = null;
                if (schema_object == null) {
                    Name schema_name;
                    String nameURI = msgs[i].getTypeNameURI();
                    if (nameURI != null && (schema_name = Name.create(nameURI)) != null) {
                        schema = XSComponentFactory.createSchema(schema_name.toString());
                        import_schemas.put(schema_name.toString(), schema);
                        namespaces.put(schema_name, null);
                    }
                } else {
                    schema = (XSSchema)schema_object;
                }
                if (schema == null) continue;
                XSImport imprt = XSComponentFactory.createImport(Name.create(xsd_url[0]));
                imprt.setSchemaLocation(xsd_url[1]);
                boolean duplicate_import = false;
                XSImport[] imports = schema.imports();
                for (int x = 0; x < imports.length; ++x) {
                    if (!imports[x].getNamespace().equals(imprt.getNamespace()) || !imports[x].getSchemaLocation().equals(imprt.getSchemaLocation())) continue;
                    duplicate_import = true;
                }
                if (duplicate_import) continue;
                schema.addImport(imprt);
                namespaces.put(imprt.getNamespace(), null);
            }
        }
        XSSchema[] schemata = new XSSchema[import_schemas.size()];
        Iterator enumvar = import_schemas.values().iterator();
        index = 0;
        while (enumvar.hasNext()) {
            schemata[index] = (XSSchema)enumvar.next();
            ++index;
        }
        IXSDCoder coder = XSDCoderFactory.create(XSDCoderFactory.VERSION_1_0);
        coder.setInitialPadding(initialpadding);
        coder.setMakeItPretty(true);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        coder.encode((OutputStream)stream, schemata, namespaces);
        schema_imports = stream.toString("UTF8");
        return schema_imports;
    }
}

