/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.generator;

import com.wm.lang.ns.NSField;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.wsdl.generator.SimpleTypeSrcBuilder;
import com.wm.lang.wsdl.generator.SourceBuilders;
import com.wm.lang.wsdl.generator.XSDContext;
import com.wm.lang.wsdl.resources.WSDMessageBundle;
import com.wm.soap.coder.SoapConstants;
import com.wm.util.LocalizedMessage;
import com.wm.util.Name;
import com.wm.util.Strings;

public class StringSrcBuilder
extends SourceBuilders {
    private static final boolean debug = false;

    public static void generate(NSField field, XSDContext context, Name recordUri) {
        Name fieldUri = StringSrcBuilder.getXmlNamespace(field);
        String name = field.getName();
        Object type = null;
        ContentType ct = field.getContentType();
        boolean isNillable = field.isNillable();
        boolean useSoapArray = context.isUseSoapArray();
        if (name.startsWith("@")) {
            boolean isOptional = field.isOptional();
            StringSrcBuilder.writeAttrTag(name, recordUri, context, ct, isOptional, useSoapArray);
        } else if (!name.equals("*body")) {
            int dim = field.getDimensions();
            if (useSoapArray && dim > 0) {
                String src = null;
                if (StringSrcBuilder.isProxy(ct)) {
                    StringSrcBuilder.writeSimpleProxyType(fieldUri, context, ct);
                } else {
                    StringSrcBuilder.initialize(fieldUri, context);
                    StringBuffer xsdSrc = context.getXSDSrc(fieldUri);
                    int padding = context.getPadding(fieldUri);
                    String typeName = name;
                    SimpleType st = null;
                    st = (SimpleType)ct;
                    src = SimpleTypeSrcBuilder.getSoapType(typeName, st, context, 1);
                    xsdSrc.append(src);
                    context.putXSDSrc(fieldUri, xsdSrc);
                }
            } else {
                if (dim == 2) {
                    context.addError(new LocalizedMessage(WSDMessageBundle.class, WSDMessageBundle.CANNOT_CONVERT_TABLE_TO_XSD, null, name));
                }
                StringSrcBuilder.writeSimpleTypeTag(name, fieldUri, context, ct, useSoapArray);
            }
        }
    }

    static String writeSimpleType(Name fieldUri, XSDContext context, ContentType ct) {
        String type = null;
        Object inlineType = null;
        SimpleType st = null;
        int padding = context.getPadding(fieldUri);
        if (ct == null) {
            type = "xsd:string";
        } else if (ct.getType() == 1) {
            st = (SimpleType)ct;
            if (st.isProxy()) {
                StringSrcBuilder.writeSimpleProxyType(fieldUri, context, ct);
                type = SimpleTypeSrcBuilder.getProxyType(st, context, fieldUri);
            } else {
                type = SimpleTypeSrcBuilder.getInlineType(st, context, padding);
            }
        }
        return type;
    }

    static void writeSimpleProxyType(Name fieldUri, XSDContext context, ContentType ct) {
        SimpleType st;
        if (ct != null && ct.getType() == 1 && (st = (SimpleType)ct).isProxy() && st.getQName() != null && st.getQName().getNamespace() == null && !context.isDeclaredType(SoapConstants.WEBM_DEFAULT_NAMESPACE, st.getQName().getLocalName().toString())) {
            SimpleTypeSrcBuilder.writeUnqualifiedGlobleProxy(st, context);
        }
    }

    public static String getAttrSrc(NSField field, XSDContext context, int padding) {
        boolean isOptional = field.isOptional();
        String name = field.getName();
        String type = null;
        String inlineType = null;
        SimpleType st = null;
        ContentType ct = field.getContentType();
        String fieldSrc = null;
        if (ct == null) {
            type = "xsd:string";
        } else if (ct.getType() == 1) {
            st = (SimpleType)ct;
            if (st.isProxy()) {
                type = SimpleTypeSrcBuilder.getProxyType(st, context, StringSrcBuilder.getXmlNamespace(field));
            } else {
                inlineType = SimpleTypeSrcBuilder.getInlineType(st, context, ++padding);
                --padding;
            }
        }
        fieldSrc = type != null ? StringSrcBuilder.createAttrProxySrc(name, type, isOptional, padding) : StringSrcBuilder.createAttrInlineSrc(name, inlineType, isOptional, padding);
        return fieldSrc;
    }

    static String createAttrProxySrc(String name, String type, boolean optional, int padding) {
        String part1 = null;
        part1 = optional ? Strings.cat(StringSrcBuilder.composePadding(padding), "<xsd:attribute name=\"", name, "\" type=\"", type, "\"/>") : Strings.cat(StringSrcBuilder.composePadding(padding), "<xsd:attribute name=\"", name, "\" type=\"", type, "\" use=\"required\"/>");
        return part1;
    }

    static String createAttrInlineSrc(String name, String inlineType, boolean optional, int padding) {
        String part1 = null;
        part1 = optional ? Strings.cat(StringSrcBuilder.composePadding(padding), "<xsd:attribute name=\"", name, "\">") : Strings.cat(StringSrcBuilder.composePadding(padding), "<xsd:attribute name=\"", name, "\" use=\"required\">");
        String part2 = Strings.cat(inlineType, StringSrcBuilder.composePadding(padding), "</xsd:attribute>");
        return Strings.cat(part1, part2);
    }

    static void writeAttrTag(String name, Name fieldUri, XSDContext context, ContentType ct, boolean isOptional, boolean useSoapArray) {
        StringSrcBuilder.initialize(fieldUri, context);
        StringBuffer xsdSrc = context.getXSDSrc(fieldUri);
        int padding = context.getPadding(fieldUri);
        boolean isProxy = StringSrcBuilder.isProxy(ct);
        name = name.substring(1);
        String src = Strings.cat("<xsd:attribute name=\"", name);
        src = Strings.cat(StringSrcBuilder.composePadding(padding), src);
        xsdSrc.append(src);
        src = "";
        context.putPadding(fieldUri, padding);
        String type = null;
        if (ct == null) {
            type = "xsd:string";
            src = Strings.cat("\" type=\"", type);
            src = !isOptional ? Strings.cat(src, "\" use=\"required\"/>") : Strings.cat(src, "\"/>");
            xsdSrc.append(src);
        } else if (isProxy) {
            SimpleType st = (SimpleType)ct;
            if (st.getQName() != null && st.getQName().getNamespace() == null) {
                String stPrefix = context.createNamespacePrefix(NULLNS_NAME);
                HashSet tnsPrefix = context.getTNSPrefixes(fieldUri);
                tnsPrefix.add(NULLNS_NAME);
                String tmpType = st.getName();
                int index = tmpType.indexOf(58);
                tmpType = index != -1 ? tmpType.substring(index + 1) : tmpType;
                type = stPrefix + ":" + tmpType;
                SimpleTypeSrcBuilder.writeUnqualifiedGlobleProxy(st, context);
            } else {
                type = StringSrcBuilder.writeSimpleType(fieldUri, context, ct);
            }
            src = Strings.cat("\" type=\"", type);
            src = !isOptional ? Strings.cat(src, "\" use=\"required\"/>") : Strings.cat(src, "\"/>");
            xsdSrc.append(src);
        } else {
            src = !isOptional ? Strings.cat(src, "\" use=\"required\">") : Strings.cat(src, "\">");
            type = StringSrcBuilder.writeSimpleType(fieldUri, context, ct);
            src = Strings.cat(src, type);
            xsdSrc.append(src);
            padding = context.getPadding(fieldUri);
            src = Strings.cat(StringSrcBuilder.composePadding(--padding), "</xsd:attribute>");
            xsdSrc.append(src);
        }
        context.putPadding(fieldUri, padding);
        context.putXSDSrc(fieldUri, xsdSrc);
    }

    static void writeElementTag(String name, Name fieldUri, XSDContext context, ContentType ct, String minOccurs, String maxOccurs, boolean useQualified, boolean useSoapArray, boolean isNillable) {
        if (context.isDeclaredElement(fieldUri, name)) {
            return;
        }
        StringSrcBuilder.initialize(fieldUri, context);
        StringBuffer xsdSrc = context.getXSDSrc(fieldUri);
        int padding = context.getPadding(fieldUri);
        boolean isProxy = StringSrcBuilder.isProxy(ct);
        int index = name.indexOf(58);
        name = index != -1 ? name.substring(index + 1) : name;
        String src = Strings.cat("<xsd:element name=\"", name);
        src = Strings.cat(StringSrcBuilder.composePadding(padding), src);
        if (isNillable) {
            src = Strings.cat(src, "\" nillable=\"true");
        }
        String part2 = "";
        if (minOccurs != null) {
            part2 = Strings.cat("\" minOccurs=\"", minOccurs, "\" maxOccurs=\"", maxOccurs);
        } else if (maxOccurs != null) {
            part2 = Strings.cat("\" maxOccurs=\"", maxOccurs);
        }
        if (useQualified && (minOccurs != null || maxOccurs != null)) {
            part2 = Strings.cat(part2, "\" form=\"qualified");
        }
        String type = null;
        if (ct == null) {
            xsdSrc.append(src);
            type = "xsd:string";
            src = Strings.cat("\" type=\"", type, part2, "\"/>");
            xsdSrc.append(src);
        } else if (isProxy) {
            xsdSrc.append(src);
            SimpleType st = (SimpleType)ct;
            if (st.getQName() != null && st.getQName().getNamespace() == null) {
                type = st.getName();
                SimpleTypeSrcBuilder.writeUnqualifiedGlobleProxy(st, context);
            } else {
                type = StringSrcBuilder.writeSimpleType(fieldUri, context, ct);
            }
            src = Strings.cat("\" type=\"", type, part2, "\"/>");
            xsdSrc.append(src);
        } else {
            src = Strings.cat(src, part2, "\">");
            context.putPadding(fieldUri, ++padding);
            type = StringSrcBuilder.writeSimpleType(fieldUri, context, ct);
            if (type != null) {
                src = Strings.cat(src, type);
                xsdSrc.append(src);
                src = Strings.cat(StringSrcBuilder.composePadding(--padding), "</xsd:element>");
                xsdSrc.append(src);
            }
        }
        context.putPadding(fieldUri, padding);
        context.putXSDSrc(fieldUri, xsdSrc);
        context.addDeclaredElement(fieldUri, name);
    }

    static void writeSimpleTypeTag(String name, Name fieldUri, XSDContext context, ContentType ct, boolean useSoapArray) {
        if (context.isDeclaredType(fieldUri, name)) {
            return;
        }
        StringSrcBuilder.initialize(fieldUri, context);
        StringBuffer xsdSrc = context.getXSDSrc(fieldUri);
        int padding = context.getPadding(fieldUri);
        boolean isProxy = StringSrcBuilder.isProxy(ct);
        String src = "";
        String type = null;
        if (ct != null) {
            if (isProxy) {
                type = StringSrcBuilder.writeSimpleType(fieldUri, context, ct);
            } else {
                context.putPadding(fieldUri, padding);
                type = StringSrcBuilder.writeSimpleType(fieldUri, context, ct);
                if (type != null) {
                    int index = type.indexOf(62);
                    int colon = name.indexOf(58);
                    if (colon != -1) {
                        name = name.substring(colon + 1);
                    }
                    src = Strings.cat(" name=\"", name, "\"");
                    StringBuffer sb = new StringBuffer(type);
                    sb.insert(index, src);
                    xsdSrc.append(sb.toString());
                }
            }
        }
        context.putPadding(fieldUri, padding);
        context.putXSDSrc(fieldUri, xsdSrc);
    }

    public static void main(String[] args) {
        String type = "<xsd:simpleType> /n  <xsd:restriction base=\"xsd:double\">\t/n <xsd:minInclusive value=\"5.0\"/> </xsd:restriction>\t\t</xsd:simpleType>";
        int index = type.indexOf(62);
        if (type != null) {
            String src = Strings.cat(" name=\"", "p_2", "\"");
            StringBuffer sb = new StringBuffer(type);
            sb.insert(index, src);
            System.out.println(sb.toString());
        }
    }
}

