/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.generator;

import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordRef;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.TypeDef;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.wsdl.ExtendedAttribute;
import com.wm.lang.wsdl.ExtendedElement;
import com.wm.lang.wsdl.WSDComponent;
import com.wm.lang.wsdl.WSDLKeys;
import com.wm.lang.wsdl.generator.SimpleTypeSrcBuilder;
import com.wm.lang.wsdl.generator.StringSrcBuilder;
import com.wm.lang.wsdl.generator.WSDContext;
import com.wm.lang.wsdl.generator.XSDContext;
import com.wm.soap.coder.SoapConstants;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Strings;
import java.util.Hashtable;
import java.util.Vector;

public abstract class SourceBuilders
implements WSDLKeys {
    private static final boolean debug = false;
    private static final boolean debugType = false;
    private static final boolean debugElementClose = false;
    static final String ATTR_PREFIX = "@";
    static final String STARBODY = "*body";
    static final String COMPLEXTYPE_OPEN = "<xsd:complexType";
    static final String COMPLEXTYPE_OPEN_FULL = "<xsd:complexType>";
    static final String COMPLEXCONTENT_OPEN = "<xsd:complexContent>";
    static final String SEQUENCE_OPEN = "<xsd:sequence>";
    static final String SEQUENCE_OPEN_WITH_DIM = "<xsd:sequence minOccurs=\"0\" maxOccurs=\"unbounded\">";
    static final String ELEMENT_REF_OPEN = "<xsd:element ref=\"";
    static final String ELEMENT_OPEN = "<xsd:element name=\"";
    static final String ATTR_OPEN = "<xsd:attribute name=\"";
    static final String SIMPLECONTENT_OPEN = "<xsd:simpleContent>";
    static final String MIX_TRUE = " mixed=\"true\">";
    static final String EXTENSION_OPEN = "<xsd:extension base=\"";
    static final String RESTRICTION_OPEN = "<xsd:restriction base=\"";
    static final String RESTRICTION_OPEN_SOAP = "<xsd:restriction base=\"SOAP-ENC:Array\">";
    static final String ATTR_0PEN_WITH_WSDL = "<xsd:attribute ref=\"SOAP-ENC:arrayType\" wsdl:arrayType=\"";
    static final String ANY = "<xsd:any processContents=\"lax\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>";
    static final String ANY_OPEN = "<xsd:any processContents=\"lax\">";
    static final String ANY_ATTR = "<xsd:anyAttribute processContents=\"lax\"/>";
    static final String ANY_TYPE = "xsd:anyType";
    static final String XSD_STRING = "xsd:string";
    static final String SIMPLE_TYPE_OPEN_FULL = "<xsd:simpleType>";
    static final String SIMPLE_TYPE_OPEN = "<xsd:simpleType name=\"";
    static final String FORM = "\" form=\"qualified";
    static final String COMPLEXTYPE_CLOSE = "</xsd:complexType>";
    static final String SEQUENCE_CLOSE = "</xsd:sequence>";
    static final String ELEMENT_CLOSE = "</xsd:element>";
    static final String SIMPLECONTENT_CLOSE = "</xsd:simpleContent>";
    static final String COMPLEXCONTENT_CLOSE = "</xsd:complexContent>";
    static final String EXTENSION_CLOSE = "</xsd:extension>";
    static final String RESTRICTION_CLOSE = "</xsd:restriction>";
    static final String SIMPLE_TYPE_CLOSE = "</xsd:simpleType>";
    static final String LESS_THAN = "<";
    static final String GREATER_THAN = ">";
    static final String CLOSE = "\">";
    static final String SIMPLE_CLOSE = ">";
    static final String PLAIN_CLOSE = "/>";
    static final String FULL_CLOSE = "\"/>";
    static final String ATTR_CLOSE = "</xsd:attribute>";
    static final String TYPE_DEF_POSTFIX_ITEM = "ArrayItem";
    static final String SPACE = " ";
    static final String QUOTE = "\"";
    static final String INPUT_MSG_OPEN = "<wsdl:input message=\"";
    static final String OUTPUT_MSG_OPEN = "<wsdl:output message=\"";
    static final String FAULT_MSG_OPEN = "<wsdl:fault message=\"";
    static final String INPUT_NAME_OPEN = "<wsdl:input name=\"";
    static final String OUTPUT_NAME_OPEN = "<wsdl:output name=\"";
    static final String FAULT_NAME_OPEN = "<wsdl:fault name=\"";
    static final String MESSAGE = " message=\"";
    static final String TYPE = "\" type=\"";
    static final String TNS_PREFIX = "tns:";
    static final String OPERATION_OPEN = "<wsdl:operation name=\"";
    static final String OPERATION_CLOSE = "</wsdl:operation>";
    static final String DEFAULT_XSD = ".xsd";
    static final String IMPORT = "<import namespace=\"";
    static final String IMPORT_LOCATION = "<import schemaLocation=\"";
    static final String SCHEMA_LOCATION = " schemaLocation=\"";
    static final String NILLABLE_TRUE = " nillable=\"true\" ";
    static final String NILLABLE_TRUE_2 = "\" nillable=\"true";
    public static final Name NULLNS_NAME = SoapConstants.WEBM_DEFAULT_NAMESPACE;
    static final int STARBODY_MIXED = 1;
    static final int STARBODY_USE_SIMPLE_CONTENT = 2;
    static final int STARBODY_IGNORE = 3;
    static final int STARBODY_ERROR = -1;

    static void initialize(Name recordUri, XSDContext context) {
        StringBuffer xsdSrc = context.getXSDSrc(recordUri);
        HashSet tnsPrefix = context.getTNSPrefixes(recordUri);
        if (xsdSrc == null) {
            xsdSrc = new StringBuffer(400);
            context.putXSDSrc(recordUri, xsdSrc);
        }
        if (tnsPrefix == null) {
            tnsPrefix = new HashSet();
            context.putTNSPrefixes(recordUri, tnsPrefix);
        }
    }

    static String composePadding(int padding) {
        if (padding <= 0) {
            padding = 1;
        }
        char[] pad = new char[padding + 1];
        pad[0] = 10;
        for (int i = 1; i < pad.length; ++i) {
            pad[i] = 9;
        }
        return new String(pad);
    }

    static String composePadding(int padding, boolean addLineBreak) {
        if (padding <= 0) {
            return "";
        }
        if (addLineBreak) {
            return SourceBuilders.composePadding(padding);
        }
        char[] pad = new char[padding];
        for (int i = 1; i < pad.length; ++i) {
            pad[i] = 9;
        }
        return new String(pad);
    }

    static void writeComplexTypeOpenTag(String name, int starBodyType, XSDContext context, Name recordUri, NSField[] refNames, Hashtable complexTypeRefs) {
        SourceBuilders.writeComplexTypeOpenTag(name, starBodyType, context, recordUri, refNames, null, complexTypeRefs);
    }

    static void writeComplexTypeOpenTag(String fullName, int starBodyType, XSDContext context, Name recordUri, NSField[] refNames, NSField[] childNames, Hashtable complexTypeRefs) {
        String name;
        SourceBuilders.initialize(recordUri, context);
        StringBuffer sb = context.getXSDSrc(recordUri);
        int padding = context.getPadding(recordUri);
        int index = fullName.indexOf(58);
        String string = name = index != -1 ? fullName.substring(index + 1) : fullName;
        if (context.isDeclaredType(recordUri, name)) {
            return;
        }
        String nameSrc = name != null ? " name=\"" + name + QUOTE : "";
        String src = Strings.cat(SourceBuilders.composePadding(padding), COMPLEXTYPE_OPEN, nameSrc);
        switch (starBodyType) {
            case 3: {
                src = Strings.cat(src, ">");
                sb.append(src);
                src = Strings.cat(SourceBuilders.composePadding(++padding), SEQUENCE_OPEN);
                break;
            }
            case 1: {
                src = Strings.cat(src, MIX_TRUE);
                sb.append(src);
                src = Strings.cat(SourceBuilders.composePadding(++padding), SEQUENCE_OPEN);
                break;
            }
            case 2: {
                src = Strings.cat(src, ">");
                sb.append(src);
                src = Strings.cat(SourceBuilders.composePadding(++padding), SIMPLECONTENT_OPEN);
            }
        }
        sb.append(src);
        context.putPadding(recordUri, ++padding);
        context.putXSDSrc(recordUri, sb);
        if (refNames != null) {
            for (int i = 0; i < refNames.length; ++i) {
                if (!refNames[i].getName().startsWith(ATTR_PREFIX)) {
                    src = SourceBuilders.writeElementRef(context, recordUri, refNames[i], padding);
                }
                sb.append(src);
            }
        }
        if (childNames != null) {
            String cName = null;
            for (int i = 0; i < childNames.length; ++i) {
                cName = childNames[i].getName();
                if (cName.startsWith(STARBODY) || cName.startsWith(ATTR_PREFIX)) continue;
                SourceBuilders.writeTypeRef(recordUri, context, childNames[i], padding, complexTypeRefs);
            }
        }
    }

    static void writeComplexTypeCloseTag(String name, int starBodyType, XSDContext context, Name recordUri, boolean isClosed) {
        SourceBuilders.initialize(recordUri, context);
        StringBuffer sb = context.getXSDSrc(recordUri);
        int padding = context.getPadding(recordUri);
        switch (starBodyType) {
            case 2: {
                sb.append(SourceBuilders.composePadding(--padding));
                sb.append(SIMPLECONTENT_CLOSE);
            }
        }
        String src = null;
        if (!isClosed) {
            src = Strings.cat(SourceBuilders.composePadding(padding), ANY_ATTR);
            sb.append(src);
        }
        src = Strings.cat(SourceBuilders.composePadding(--padding), COMPLEXTYPE_CLOSE);
        sb.append(src);
        context.putPadding(recordUri, padding);
        context.putXSDSrc(recordUri, sb);
    }

    static void writeSimpleContentExt(NSRecord record, XSDContext context, boolean isClosed) {
        String temp;
        Name recordUri = SourceBuilders.getXmlNamespace(record);
        SourceBuilders.initialize(recordUri, context);
        StringBuffer sb = context.getXSDSrc(recordUri);
        int padding = context.getPadding(recordUri);
        NSField[] children = record.getFieldNodes();
        String basetype = XSD_STRING;
        Vector<String> holder = new Vector<String>(6);
        for (int index = 0; index < children.length; ++index) {
            String childName = children[index].getName();
            if (childName.equals(STARBODY)) {
                SimpleType st = (SimpleType)children[index].getContentType();
                basetype = SimpleTypeSrcBuilder.getInlineType(st, context, padding);
                continue;
            }
            temp = StringSrcBuilder.getAttrSrc(children[index], context, padding);
            holder.addElement(temp);
        }
        String src = Strings.cat(SourceBuilders.composePadding(padding), EXTENSION_OPEN, basetype, CLOSE);
        sb.append(src);
        ++padding;
        for (int i = 0; i < holder.size(); ++i) {
            temp = (String)holder.elementAt(i);
            src = Strings.cat(SourceBuilders.composePadding(padding), temp);
            sb.append(src);
        }
        if (!isClosed) {
            src = Strings.cat(SourceBuilders.composePadding(padding), ANY_ATTR);
            sb.append(src);
        }
        src = Strings.cat(SourceBuilders.composePadding(--padding), EXTENSION_CLOSE);
        context.putPadding(recordUri, padding);
        context.putXSDSrc(recordUri, sb);
    }

    static String writeElementRef(XSDContext context, Name parentUri, NSField field, int padding) {
        SourceBuilders.initialize(parentUri, context);
        String name = SourceBuilders.fieldToName(context, field, parentUri);
        Name fieldUri = SourceBuilders.getXmlNamespace(field);
        if (parentUri != fieldUri) {
            HashSet childUris = context.getTNSPrefixes(parentUri);
            childUris.add(fieldUri);
        }
        String minOccurs = field.isOptional() ? " minOccurs=\"0\"" : " minOccurs=\"1\"";
        String maxOccurs = field.getDimensions() > 0 ? " maxOccurs=\"unbounded\"" : " maxOccurs=\"1\"";
        String src = Strings.cat(SourceBuilders.composePadding(padding), ELEMENT_REF_OPEN, name, QUOTE, minOccurs, maxOccurs, PLAIN_CLOSE);
        return src;
    }

    protected static String fieldToName(XSDContext context, NSField field, Name recordUri) {
        String name = field.getName();
        int idx = name.indexOf(58);
        if (idx > 0) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    private static String fieldToTypeName(XSDContext context, NSField field) {
        QName schemaTypeName = SourceBuilders.fieldToTypeQName(context, field);
        Name uri = schemaTypeName.getNamespaceName();
        String localName = schemaTypeName.getLocalName().toString();
        Name prefix = context.getNamespacePrefix(uri);
        if (prefix != null) {
            return prefix + ":" + localName;
        }
        return localName;
    }

    private static QName fieldToTypeQName(XSDContext context, NSField field) {
        QName schemaTypeName;
        int dim = field.getDimensions();
        if (field instanceof NSRecord) {
            schemaTypeName = field.getSchemaTypeName();
            if (schemaTypeName == null) {
                Name localName;
                if (field instanceof NSRecordRef) {
                    localName = Name.create(SourceBuilders.getRecordRefName((NSRecordRef)field));
                } else {
                    String name = field.getName();
                    int idx = name.indexOf(58);
                    if (idx > 0) {
                        name = name.substring(idx + 1);
                    }
                    localName = Name.create(SourceBuilders.makeNameNice(name));
                }
                Name uri = SourceBuilders.getXmlNamespace(field);
                if (dim > 0) {
                    localName = Name.create(localName.toString() + TYPE_DEF_POSTFIX_ITEM);
                }
                schemaTypeName = QName.create(uri, localName);
            } else {
                Name uri = schemaTypeName.getNamespaceName();
                if (uri == null) {
                    Name localName = schemaTypeName.getLocalName();
                    schemaTypeName = QName.create(SoapConstants.WEBM_DEFAULT_NAMESPACE, localName);
                }
            }
        } else {
            ContentType ct = field.getContentType();
            if (ct != null && ((TypeDef)ct).getQName() != null) {
                schemaTypeName = ((TypeDef)ct).getQName();
                if (schemaTypeName.getNamespaceName() == null) {
                    Name localName;
                    if (dim > 0) {
                        String name = field.getName();
                        int idx = name.indexOf(58);
                        if (idx > 0) {
                            name = name.substring(idx + 1);
                        }
                        localName = Name.create(name);
                    } else if (SourceBuilders.isProxy(ct)) {
                        localName = schemaTypeName.getLocalName();
                    } else {
                        String name = field.getName();
                        int idx = name.indexOf(58);
                        if (idx > 0) {
                            name = name.substring(idx + 1);
                        }
                        localName = Name.create(name);
                    }
                    schemaTypeName = QName.create(SourceBuilders.getXmlNamespace(field), localName);
                }
            } else {
                schemaTypeName = field.getType() == 3 ? SoapConstants.ANY_TYPE : SoapConstants.DEFAULT_SIMPLE_CODER_PRIMITIVE_TYPE;
            }
        }
        return schemaTypeName;
    }

    static boolean isProxy(ContentType ct) {
        SimpleType st;
        if (ct == null) {
            return true;
        }
        return ct.getType() == 1 && (st = (SimpleType)ct).isProxy();
    }

    private static void writeTypeRef(Name recordUri, XSDContext context, NSField field, int padding, Hashtable complexTypeRefs) {
        SourceBuilders.initialize(recordUri, context);
        String name = field.getName();
        int idx = name.indexOf(58);
        if (idx > 0) {
            name = name.substring(idx + 1);
        }
        int dim = field.getDimensions();
        boolean isOptional = field.isOptional();
        QName fieldTypeQName = SourceBuilders.fieldToTypeQName(context, field);
        Name fieldTypeUri = fieldTypeQName.getNamespaceName();
        Name fieldUri = SourceBuilders.getXmlNamespace(field);
        if (!context.isUseSoapArray() && fieldUri != recordUri) {
            SourceBuilders.writeElementRef(context, recordUri, field, dim, isOptional);
            if (field instanceof NSRecord || dim > 0 && context.isUseSoapArray()) {
                complexTypeRefs.put(name, field);
            } else {
                if (context.isDeclaredElement(fieldUri, name)) {
                    return;
                }
                SourceBuilders.initialize(fieldUri, context);
                HashSet childUris = context.getTNSPrefixes(recordUri);
                childUris.add(fieldUri);
                String prefix = context.createNamespacePrefix(fieldTypeUri);
                String typeName = prefix + ":" + fieldTypeQName.getLocalName().toString();
                StringBuffer xsdSrc = context.getXSDSrc(fieldUri);
                String minOccurs = "";
                String maxOccurs = "";
                int fieldPadding = context.getPadding(fieldUri);
                xsdSrc.append(SourceBuilders.composePadding(fieldPadding));
                xsdSrc.append(ELEMENT_OPEN);
                xsdSrc.append(name);
                xsdSrc.append(TYPE);
                xsdSrc.append(typeName);
                xsdSrc.append(QUOTE);
                xsdSrc.append(minOccurs);
                xsdSrc.append(maxOccurs);
                if (field.isNillable()) {
                    xsdSrc.append(NILLABLE_TRUE);
                }
                xsdSrc.append(PLAIN_CLOSE);
                context.addDeclaredElement(fieldUri, name);
                context.putXSDSrc(fieldUri, xsdSrc);
            }
        } else {
            StringBuffer xsdSrc = context.getXSDSrc(recordUri);
            String typePrefix = context.createNamespacePrefix(fieldTypeUri);
            String typeName = typePrefix + ":" + fieldTypeQName.getLocalName().toString();
            HashSet childUris = context.getTNSPrefixes(recordUri);
            childUris.add(fieldTypeUri);
            if (field instanceof NSRecord) {
                complexTypeRefs.put(typeName, field);
            }
            String minOccurs = "";
            String maxOccurs = "";
            if (dim == 0 || !context.isUseSoapArray()) {
                minOccurs = isOptional ? " minOccurs=\"0\"" : " minOccurs=\"1\"";
                String string = maxOccurs = dim > 0 ? " maxOccurs=\"unbounded\"" : " maxOccurs=\"1\"";
            }
            if (dim > 0 && context.isUseSoapArray()) {
                if (!(field instanceof NSRecord)) {
                    complexTypeRefs.put(name, field);
                }
                if (fieldUri != recordUri) {
                    String prefix = context.createNamespacePrefix(fieldUri);
                    typeName = prefix + ":" + name;
                } else {
                    typeName = name;
                }
                minOccurs = isOptional ? " minOccurs=\"0\"" : " minOccurs=\"1\"";
            }
            xsdSrc.append(SourceBuilders.composePadding(padding));
            xsdSrc.append(ELEMENT_OPEN);
            xsdSrc.append(name);
            xsdSrc.append(TYPE);
            xsdSrc.append(typeName);
            xsdSrc.append(QUOTE);
            xsdSrc.append(minOccurs);
            xsdSrc.append(maxOccurs);
            if (field.isNillable()) {
                xsdSrc.append(NILLABLE_TRUE);
            }
            xsdSrc.append(PLAIN_CLOSE);
            context.putXSDSrc(recordUri, xsdSrc);
        }
    }

    static void writeElementRef(XSDContext context, Name recordUri, NSField field, int dim, boolean isOptional) {
        SourceBuilders.initialize(recordUri, context);
        StringBuffer xsdSrc = context.getXSDSrc(recordUri);
        int padding = context.getPadding(recordUri);
        Name fieldUri = SourceBuilders.getXmlNamespace(field);
        String name = SourceBuilders.fieldToName(context, field, fieldUri);
        if (fieldUri != recordUri) {
            String prefix = context.createNamespacePrefix(fieldUri);
            HashSet childUris = context.getTNSPrefixes(recordUri);
            childUris.add(fieldUri);
            name = prefix + ":" + name;
        }
        String minOccurs = isOptional ? " minOccurs=\"0\"" : " minOccurs=\"1\"";
        String maxOccurs = dim > 0 ? " maxOccurs=\"unbounded\"" : " maxOccurs=\"1\"";
        String src = Strings.cat(SourceBuilders.composePadding(padding), ELEMENT_REF_OPEN, name, QUOTE, minOccurs, maxOccurs, PLAIN_CLOSE);
        xsdSrc.append(src);
        context.putXSDSrc(recordUri, xsdSrc);
    }

    static void writeSequenceCloseTag(Name recordUri, XSDContext context, boolean isClosed) {
        SourceBuilders.initialize(recordUri, context);
        StringBuffer xsdSrc = context.getXSDSrc(recordUri);
        int padding = context.getPadding(recordUri);
        String src = null;
        if (!isClosed) {
            src = Strings.cat(SourceBuilders.composePadding(padding), ANY);
            xsdSrc.append(src);
        }
        src = Strings.cat(SourceBuilders.composePadding(--padding), SEQUENCE_CLOSE);
        xsdSrc.append(src);
        context.putXSDSrc(recordUri, xsdSrc);
        context.putPadding(recordUri, padding);
    }

    static void writeArray(XSDContext context, NSField arrayField, String itemName, boolean writeNotSoap) {
        Name fieldUri = SourceBuilders.getXmlNamespace(arrayField);
        SourceBuilders.initialize(fieldUri, context);
        String typeName = SourceBuilders.fieldToTypeName(context, arrayField);
        if (!context.isDeclaredType(fieldUri, itemName)) {
            int padding = context.getPadding(fieldUri);
            String src = "";
            if (context.isUseSoapArray()) {
                src = SourceBuilders.writeSoapArray(itemName, typeName, arrayField.getDimensions(), padding);
            } else if (writeNotSoap && arrayField instanceof NSRecord) {
                src = SourceBuilders.writeNotSoapArray(itemName, typeName, arrayField.getDimensions(), arrayField.isOptional(), padding, arrayField.isNillable());
            }
            StringBuffer xsdSrc = context.getXSDSrc(fieldUri);
            xsdSrc.append(src);
            context.putXSDSrc(fieldUri, xsdSrc);
            context.putPadding(fieldUri, padding);
            context.addDeclaredType(fieldUri, itemName);
        }
    }

    static void writeArray(XSDContext context, NSField arrayField, boolean writeNotSoap) {
        Name fieldUri = SourceBuilders.getXmlNamespace(arrayField);
        String name = SourceBuilders.fieldToName(context, arrayField, fieldUri);
        SourceBuilders.writeArray(context, arrayField, name, writeNotSoap);
    }

    protected static void writeElementTypeRef(XSDContext context, Name recordUri, String name, String typeName, int dim, boolean isOptional, boolean isTop, boolean isNillable) {
        if (isTop && context.isDeclaredElement(recordUri, name)) {
            return;
        }
        StringBuffer xsdSrc = context.getXSDSrc(recordUri);
        int padding = context.getPadding(recordUri);
        xsdSrc.append(SourceBuilders.composePadding(padding));
        xsdSrc.append(ELEMENT_OPEN);
        xsdSrc.append(name);
        xsdSrc.append(TYPE);
        xsdSrc.append(typeName);
        xsdSrc.append("\" ");
        if (isNillable) {
            xsdSrc.append(NILLABLE_TRUE);
        }
        if (!isTop) {
            String minOccurs = isOptional ? " minOccurs=\"0\"" : " minOccurs=\"1\"";
            xsdSrc.append(minOccurs);
            String maxOccurs = dim > 0 ? " maxOccurs=\"unbounded\"" : " maxOccurs=\"1\"";
            xsdSrc.append(maxOccurs);
        }
        xsdSrc.append(PLAIN_CLOSE);
        context.putXSDSrc(recordUri, xsdSrc);
        if (isTop) {
            context.addDeclaredElement(recordUri, name);
        }
    }

    private static String writeSoapArray(String name, String typeName, int dim, int padding) {
        StringBuffer sb = new StringBuffer();
        String src = null;
        src = Strings.cat(SourceBuilders.composePadding(padding), COMPLEXTYPE_OPEN, " name=\"", name, CLOSE);
        sb.append(src);
        src = Strings.cat(SourceBuilders.composePadding(++padding), COMPLEXCONTENT_OPEN);
        sb.append(src);
        src = Strings.cat(SourceBuilders.composePadding(++padding), RESTRICTION_OPEN_SOAP);
        sb.append(src);
        src = Strings.cat(SourceBuilders.composePadding(++padding), ATTR_0PEN_WITH_WSDL, typeName, SourceBuilders.getSOAPDimention(dim), FULL_CLOSE);
        sb.append(src);
        src = Strings.cat(SourceBuilders.composePadding(--padding), RESTRICTION_CLOSE);
        sb.append(src);
        src = Strings.cat(SourceBuilders.composePadding(--padding), COMPLEXCONTENT_CLOSE);
        sb.append(src);
        src = Strings.cat(SourceBuilders.composePadding(--padding), COMPLEXTYPE_CLOSE);
        sb.append(src);
        return sb.toString();
    }

    private static String writeNotSoapArray(String name, String typeName, int dim, boolean isOptional, int padding, boolean isNillable) {
        StringBuffer sb = new StringBuffer();
        String src = null;
        src = Strings.cat(SourceBuilders.composePadding(padding), ELEMENT_OPEN, name, "\" ");
        sb.append(src);
        if (isNillable) {
            sb.append(NILLABLE_TRUE);
        }
        String minOccurs = isOptional ? "0" : "1";
        String maxOccurs = dim > 0 ? "\" maxOccurs=\"unbounded\"" : "\" maxOccurs=\"1\"";
        src = Strings.cat(" minOccurs=\"", minOccurs, maxOccurs);
        sb.append(src);
        src = Strings.cat(" type=\"", typeName, FULL_CLOSE);
        sb.append(src);
        return sb.toString();
    }

    static String getSOAPDimention(int dim) {
        int len = dim + 1;
        char[] src = new char[len];
        src[0] = 91;
        for (int i = 1; i < src.length - 1; ++i) {
            src[i] = 44;
        }
        src[src.length - 1] = 93;
        return new String(src);
    }

    static int checkStarBody(NSRecord record, XSDContext context) {
        String childName;
        NSField child;
        int index;
        NSField[] children = record.getFieldNodes();
        boolean useSimpleContent = false;
        for (index = 0; index < children.length; ++index) {
            child = children[index];
            childName = child.getName();
            if (!childName.equals(STARBODY)) continue;
            if (StringSrcBuilder.isMixed(child, context)) {
                return 1;
            }
            useSimpleContent = true;
        }
        if (useSimpleContent) {
            for (index = 0; index < children.length; ++index) {
                child = children[index];
                childName = child.getName();
                if (childName.startsWith(ATTR_PREFIX)) continue;
                return -1;
            }
            return 2;
        }
        return 3;
    }

    static boolean isMixed(NSField field, XSDContext context) {
        ContentType ct;
        String name = field.getName();
        return name.equals(STARBODY) && ((ct = field.getContentType()) == null || ((SimpleType)ct).getQName().equals(UR_SIMPLE_TYPE) || SimpleTypeSrcBuilder.computeBaseType((SimpleType)ct) == null);
    }

    static String getComponentName(WSDComponent wc, WSDContext context) {
        Name targetNS;
        if (wc == null) {
            return null;
        }
        QName qName = wc.getQName();
        if (qName == null) {
            return wc.getName();
        }
        String localName = qName.getNCName();
        Name uri = qName.getNamespaceName();
        String name = uri == (targetNS = context.getTargetNS()) || uri == null ? localName : Strings.cat(context.createNamespacePrefix(uri), ":", localName);
        int componentType = wc.getComponentType();
        if (componentType == 1 || componentType == 2 || componentType == 4 || componentType == 3) {
            return SourceBuilders.makeNameNice(name);
        }
        return name;
    }

    static StringBuffer writeExtentedElement(ExtendedElement ee, WSDContext context, StringBuffer sb, int padding) {
        ExtendedElement[] ees;
        String name = SourceBuilders.getComponentName(ee, context);
        String src = Strings.cat(SourceBuilders.composePadding(padding), LESS_THAN, name, SPACE);
        sb.append(src);
        ExtendedAttribute[] eas = ee.getExtendAttributes();
        String value = null;
        if (eas != null) {
            for (int j = 0; j < eas.length; ++j) {
                name = SourceBuilders.getComponentName(eas[j], context);
                value = eas[j].getValue();
                src = j != eas.length - 1 ? Strings.cat(name, "=\"", value, QUOTE, SPACE) : Strings.cat(name, "=\"", value, QUOTE);
                sb.append(src);
            }
        }
        if ((ees = ee.getChildren()) == null) {
            sb.append(PLAIN_CLOSE);
        } else {
            int childPadding = padding + 1;
            for (int i = 0; i < ees.length; ++i) {
                sb = SourceBuilders.writeExtentedElement(ees[i], context, sb, childPadding);
            }
            src = Strings.cat(SourceBuilders.composePadding(padding), "</", name, ">");
            sb.append(src);
        }
        return sb;
    }

    static String getFieldPrefix(XSDContext context, NSField field) {
        String fieldPrefix;
        String fieldName = field.getName();
        int indexOfCol = fieldName.indexOf(":");
        if (indexOfCol != -1) {
            fieldPrefix = fieldName.substring(0, indexOfCol);
            fieldPrefix = context.createNamespacePrefix(SourceBuilders.getXmlNamespace(field), Name.create(fieldPrefix));
        } else {
            fieldPrefix = context.createNamespacePrefix(SourceBuilders.getXmlNamespace(field));
        }
        return fieldPrefix;
    }

    static String getTypePrefix(XSDContext context, String name, Name typeUri) {
        String prefix;
        int indexOfCol = name.indexOf(":");
        if (indexOfCol != -1) {
            prefix = name.substring(0, indexOfCol);
            prefix = context.createNamespacePrefix(typeUri, Name.create(prefix));
        } else {
            prefix = context.createNamespacePrefix(typeUri);
        }
        return prefix;
    }

    static String getFieldPrefix(WSDContext context, NSField field) {
        String fieldPrefix;
        String fieldName = field.getName();
        int indexOfCol = fieldName.indexOf(":");
        if (indexOfCol != -1) {
            fieldPrefix = fieldName.substring(0, indexOfCol);
            fieldPrefix = context.createNamespacePrefix(SourceBuilders.getXmlNamespace(field), Name.create(fieldPrefix));
        } else {
            fieldPrefix = context.createNamespacePrefix(SourceBuilders.getXmlNamespace(field));
        }
        return fieldPrefix;
    }

    public static Name getXmlNamespace(NSField field) {
        Name uri = field.getXmlNamespace();
        if (uri == null) {
            return NULLNS_NAME;
        }
        return uri;
    }

    static String getRecordRefName(NSRecordRef recordRef) {
        return recordRef.getName().toString();
    }

    public static String makeNameNice(String name) {
        name = name.replace(':', '_');
        name = name.replace('.', '_');
        name = name.replace('/', '_');
        name = name.replace('\\', '_');
        return name;
    }
}

