/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.generator;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.W3CKeys;
import com.wm.lang.schema.datatypev2.Constraint;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.xsd.BuiltIns;
import com.wm.lang.wsdl.generator.SourceBuilders;
import com.wm.lang.wsdl.generator.URTypes;
import com.wm.lang.wsdl.generator.XSDContext;
import com.wm.lang.wsdl.resources.WSDMessageBundle;
import com.wm.util.LocalizedMessage;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Strings;

public class SimpleTypeSrcBuilder
extends SourceBuilders
implements W3CKeys {
    private static final boolean debug = false;
    static final Name LC_NAME = Name.create("http://www.w3.org/1999/XMLSchema");
    static final Name CR_NAME = Name.create("http://www.w3.org/2000/10/XMLSchema");
    static final Name REC_NAME = Name.create("http://www.w3.org/2001/XMLSchema");
    static final Name REC_NS = Name.create("http://www.w3.org/2001/XMLSchema");
    static final Name NAME_STRING = Name.create("string");
    static final Name NAME_CENTURY = Name.create("century");
    static final Name NAME_RECURRING_DATE = Name.create("recurringDate");
    static final Name NAME_RECURRING_DAY = Name.create("recurringDay");
    static final Name NAME_TIME_PERIOD = Name.create("timePeriod");
    static final Name NAME_URIREF = Name.create("uriReference");
    static final Name NAME_ANYURI = Name.create("anyURI");
    static final Name NAME_CDATA = Name.create("CDATA");
    static final Name NAME_NORMAL_STRING = Name.create("normalizedString");
    static final Name NAME_RECUR_DURATION = Name.create("recurringDuration");
    static final Name NAME_DATETIME = Name.create("dateTime");
    static final Name NAME_TIME_DURATION = Name.create("timeDuration");
    static final Name NAME_DURATION = Name.create("duration");
    static final Name NAME_MONTH = Name.create("month");
    static final Name NAME_GMONTH = Name.create("gMonth");
    static final Name NAME_YEAR = Name.create("year");
    static final Name NAME_GYEAR = Name.create("gYear");
    static final Name NAME_BINARY = Name.create("binary");
    static final Name NAME_HEXBINARY = Name.create("hexBinary");
    static final Name NAME_BASE64BINARY = Name.create("base64Binary");
    static final QName REC_STRING = QName.create("http://www.w3.org/2001/XMLSchema", "string");
    static final Name[][] typeNames = new Name[][]{{NAME_CENTURY, NAME_STRING}, {NAME_RECURRING_DATE, NAME_STRING}, {NAME_RECURRING_DAY, NAME_STRING}, {NAME_TIME_PERIOD, NAME_STRING}, {NAME_URIREF, NAME_ANYURI}, {NAME_CDATA, NAME_NORMAL_STRING}, {NAME_RECUR_DURATION, NAME_DATETIME}, {NAME_TIME_DURATION, NAME_DURATION}, {NAME_MONTH, NAME_GMONTH}, {NAME_YEAR, NAME_GYEAR}};
    private static final URTypes UR_TYPES = new URTypes();

    public static String getProxyType(SimpleType st, XSDContext context, Name fieldUri) {
        Name ns;
        QName qname = null;
        qname = st.getQName();
        Name name = ns = qname != null ? qname.getNamespaceName() : null;
        if (ns != null && ns != LC_NAME && ns != CR_NAME && ns != REC_NAME) {
            return SimpleTypeSrcBuilder.getUserDefinedGlobleProxy(st, qname, ns, context, fieldUri);
        }
        qname = SimpleTypeSrcBuilder.computeBaseType(st);
        if (qname != null) {
            String src = "xsd:" + qname.getLocalName().toString();
            return src;
        }
        return SimpleTypeSrcBuilder.getGlobleProxy(st, context, fieldUri);
    }

    public static String getInlineType(SimpleType st, XSDContext context, int padding) {
        QName base = SimpleTypeSrcBuilder.computeBaseType(st);
        if (base != null) {
            base = SimpleTypeSrcBuilder.mapTypes(base, st);
            String baseName = "xsd:" + base.getLocalName().toString();
            IData facets = null;
            Constraint[] constraints = null;
            if (st.getVersion().equals("dtVersion1")) {
                facets = st.getFacets();
                return SimpleTypeSrcBuilder.createSrc(st, facets, baseName, null, padding);
            }
            constraints = st.getConstraints();
            return SimpleTypeSrcBuilder.createSrc(st, constraints, baseName, null, padding, context);
        }
        context.addError(new LocalizedMessage(WSDMessageBundle.class, WSDMessageBundle.BASE_TYPE_IS_NULL, null, st.getName()));
        return null;
    }

    public static String getGlobleProxy(SimpleType st, XSDContext context, Name fieldUri) {
        QName base = SimpleTypeSrcBuilder.computeBaseType(st);
        if (base != null) {
            QName qname = st.getQName();
            Name uri = qname.getNamespaceName();
            String name = st.getName();
            base = SimpleTypeSrcBuilder.mapTypes(base, st);
            String baseName = "xsd:" + base.getLocalName().toString();
            IData facets = null;
            Constraint[] constraints = null;
            SimpleTypeSrcBuilder.initialize(fieldUri, context);
            HashSet tnsPrefix = context.getTNSPrefixes(fieldUri);
            String stPrefix = context.createNamespacePrefix(uri);
            tnsPrefix.add(uri);
            int padding = context.getPadding(uri);
            String src = null;
            if (st.getVersion().equals("dtVersion1")) {
                facets = st.getFacets();
                src = SimpleTypeSrcBuilder.createSrc(st, facets, baseName, name, padding);
            } else {
                constraints = st.getConstraints();
                src = SimpleTypeSrcBuilder.createSrc(st, constraints, baseName, name, padding, context);
            }
            SimpleTypeSrcBuilder.initialize(uri, context);
            StringBuffer sb = context.getXSDSrc(uri);
            sb.append(src);
            String proxySrc = Strings.cat(stPrefix, qname.getLocalName().toString());
            return proxySrc;
        }
        context.addError(new LocalizedMessage(WSDMessageBundle.class, WSDMessageBundle.BASE_TYPE_IS_NULL, null, st.getName()));
        return null;
    }

    public static String getUserDefinedGlobleProxy(SimpleType st, QName qname, Name uri, XSDContext context, Name fieldUri) {
        QName base = SimpleTypeSrcBuilder.computeBaseType(st);
        if (base != null) {
            String name = st.getName();
            base = SimpleTypeSrcBuilder.mapTypes(base, st);
            String baseName = "xsd:" + base.getLocalName().toString();
            IData facets = null;
            Constraint[] constraints = null;
            SimpleTypeSrcBuilder.initialize(fieldUri, context);
            HashSet tnsPrefix = context.getTNSPrefixes(fieldUri);
            String stPrefix = context.createNamespacePrefix(uri);
            tnsPrefix.add(uri);
            int padding = context.getPadding(uri);
            String src = null;
            if (st.getVersion().equals("dtVersion1")) {
                facets = st.getFacets();
                src = SimpleTypeSrcBuilder.createSrc(st, facets, baseName, name, padding);
            } else {
                constraints = st.getConstraints();
                src = SimpleTypeSrcBuilder.createSrc(st, constraints, baseName, name, padding, context);
            }
            if (!context._dupSimpleType.contains(qname)) {
                context._dupSimpleType.add(qname);
                SimpleTypeSrcBuilder.initialize(uri, context);
                StringBuffer sb = context.getXSDSrc(uri);
                sb.append(src);
            }
            String proxySrc = Strings.cat(stPrefix, ":", qname.getLocalName().toString());
            return proxySrc;
        }
        context.addError(new LocalizedMessage(WSDMessageBundle.class, WSDMessageBundle.BASE_TYPE_IS_NULL, null, st.getName()));
        return null;
    }

    public static void writeUnqualifiedGlobleProxy(SimpleType st, XSDContext context) {
        QName base = SimpleTypeSrcBuilder.computeBaseType(st);
        if (base == null) {
            context.addError(new LocalizedMessage(WSDMessageBundle.class, WSDMessageBundle.BASE_TYPE_IS_NULL, null, st.getName()));
        } else {
            String name = st.getName();
            base = SimpleTypeSrcBuilder.mapTypes(base, st);
            String baseName = "xsd:" + base.getLocalName().toString();
            IData facets = null;
            Constraint[] constraints = null;
            int padding = 1;
            String src = null;
            if (st.getVersion().equals("dtVersion1")) {
                facets = st.getFacets();
                src = SimpleTypeSrcBuilder.createSrc(st, facets, baseName, name, padding);
            } else {
                constraints = st.getConstraints();
                src = SimpleTypeSrcBuilder.createSrc(st, constraints, baseName, name, padding, context);
            }
            if (!context._topNoNsST.containsKey(name)) {
                context._topNoNsST.put(name, src);
            }
        }
    }

    public static String getSoapType(String typeName, SimpleType st, XSDContext context, int padding) {
        QName base = SimpleTypeSrcBuilder.computeBaseType(st);
        if (base != null) {
            base = SimpleTypeSrcBuilder.mapTypes(base, st);
            String baseName = "xsd:" + base.getLocalName().toString();
            IData facets = null;
            Constraint[] constraints = null;
            if (st.getVersion().equals("dtVersion1")) {
                facets = st.getFacets();
                return SimpleTypeSrcBuilder.createSrc(st, facets, baseName, typeName, padding);
            }
            constraints = st.getConstraints();
            return SimpleTypeSrcBuilder.createSrc(st, constraints, baseName, typeName, padding, context);
        }
        context.addError(new LocalizedMessage(WSDMessageBundle.class, WSDMessageBundle.BASE_TYPE_IS_NULL, null, st.getName()));
        return null;
    }

    static final QName computeBaseType(SimpleType st) {
        HashSet typeHeirarchy;
        QName typeQName;
        BuiltIns builtIns = BuiltIns.current();
        QName concretType = null;
        if (st.isProxy() && builtIns.get(concretType = st.getQName()) != null) {
            return concretType;
        }
        String typeName = st.getName();
        int index = typeName.indexOf("_customized");
        if (index != -1) {
            typeName = typeName.substring(0, index);
        }
        if (builtIns.get(typeQName = QName.create(REC_NS.toString(), typeName)) != null) {
            return typeQName;
        }
        String sname = st.getSourceName();
        if (sname == null) {
            sname = "string";
        }
        if ((typeHeirarchy = st.getTypeHeirarchy()) == null) {
            return QName.create(REC_NS.toString(), sname);
        }
        Object[] heirarchy = typeHeirarchy.toArray();
        for (int i = heirarchy.length - 1; i > -1; --i) {
            QName baseType = (QName)heirarchy[i];
            if (UR_TYPES.contains(baseType) || builtIns.get(baseType) == null) continue;
            return baseType;
        }
        return QName.create(REC_NS.toString(), sname);
    }

    static final QName mapTypes(QName typeName, SimpleType st) {
        if (typeName.getNamespaceName() == REC_NS) {
            return typeName;
        }
        Name localName = typeName.getLocalName();
        Object newName = null;
        if (localName == NAME_BINARY) {
            IData facets = st.getFacets();
            IDataCursor ic = facets.getCursor();
            String encoding = (String)IDataUtil.get(ic, "encoding");
            ic.destroy();
            localName = encoding.equals("Hex") ? NAME_HEXBINARY : NAME_BASE64BINARY;
        } else {
            for (int i = 0; i < typeNames.length; ++i) {
                if (typeNames[i][0] != localName) continue;
                localName = typeNames[i][1];
            }
        }
        return QName.create(SCHEMA_REC_NS, localName);
    }

    static final String mapFacets(String facetType) {
        String[][] simpleKeys = new String[][]{{"precision", "totalDigits"}, {"scale", "fractionDigits"}, {"encoding", null}, {"duration", null}, {"period", null}};
        for (int i = 0; i < simpleKeys.length; ++i) {
            if (!simpleKeys[i][0].equals(facetType)) continue;
            return simpleKeys[i][1];
        }
        return facetType;
    }

    private static String createSrc(SimpleType st, IData facets, String baseName, String name, int padding) {
        StringBuffer sb = new StringBuffer(50);
        String part1 = null;
        part1 = name == null ? Strings.cat(SimpleTypeSrcBuilder.composePadding(padding), "<xsd:simpleType>") : Strings.cat(SimpleTypeSrcBuilder.composePadding(padding), "<xsd:simpleType name=\"", name, "\">");
        sb.append(part1);
        part1 = Strings.cat(SimpleTypeSrcBuilder.composePadding(++padding), "<xsd:restriction base=\"", baseName, "\">");
        sb.append(part1);
        String[] keys = SimpleTypeSrcBuilder.getFacetKeys(st);
        String key = null;
        String tempString = null;
        String value = null;
        if (keys != null && keys.length > 0) {
            ++padding;
            IDataCursor ic = facets.getCursor();
            for (int i = 0; i < keys.length; ++i) {
                key = SimpleTypeSrcBuilder.mapFacets(keys[i]);
                if (key == null) continue;
                value = (String)IDataUtil.get(ic, keys[i]);
                ic.destroy();
                if (value == null) continue;
                if (key.equals("enumeration") || key.equals("pattern")) {
                    String[] va = (String[])value;
                    for (int j = 0; j < va.length; ++j) {
                        tempString = Strings.cat(SimpleTypeSrcBuilder.composePadding(padding), "<xsd:", key, " value=\"", va[j], "\"/>");
                        sb.append(tempString);
                    }
                    continue;
                }
                tempString = Strings.cat(SimpleTypeSrcBuilder.composePadding(padding), "<xsd:", key, " value=\"", value.toString(), "\"/>");
                sb.append(tempString);
            }
        }
        tempString = Strings.cat(SimpleTypeSrcBuilder.composePadding(--padding), "</xsd:restriction>");
        sb.append(tempString);
        tempString = Strings.cat(SimpleTypeSrcBuilder.composePadding(--padding), "</xsd:simpleType>");
        sb.append(tempString);
        return sb.toString();
    }

    private static String createSrc(SimpleType st, Constraint[] facets, String baseName, String name, int padding, XSDContext context) {
        StringBuffer sb = new StringBuffer(50);
        String part1 = null;
        part1 = name == null ? Strings.cat(SimpleTypeSrcBuilder.composePadding(padding), "<xsd:simpleType>") : Strings.cat(SimpleTypeSrcBuilder.composePadding(padding), "<xsd:simpleType name=\"", name, "\">");
        sb.append(part1);
        part1 = Strings.cat(SimpleTypeSrcBuilder.composePadding(++padding), "<xsd:restriction base=\"", baseName, "\">");
        sb.append(part1);
        String key = null;
        String[] temp = null;
        String tempString = null;
        Object value = null;
        String enumString = null;
        String prefix = null;
        String localName = null;
        if (facets != null && facets.length > 0) {
            ++padding;
            for (int i = 0; i < facets.length; ++i) {
                temp = facets[i].getValue();
                if (temp == null) continue;
                key = facets[i].getName();
                if (key.equals("enumeration") || key.equals("pattern")) {
                    for (int j = 0; j < temp.length; ++j) {
                        enumString = temp[j];
                        if (key.equals("enumeration") && (baseName.equals("xsd:QName") || baseName.equals("xsd:NOTATION"))) {
                            localName = enumString.substring(0, enumString.indexOf(123) - 1);
                            prefix = enumString.substring(enumString.indexOf(123) + 1, enumString.indexOf(125));
                            if (prefix.equals("")) {
                                enumString = localName;
                            } else {
                                prefix = context.createNamespacePrefix(Name.create(prefix));
                                enumString = Strings.cat(prefix, ":", localName);
                            }
                        }
                        tempString = Strings.cat(SimpleTypeSrcBuilder.composePadding(padding), "<xsd:", key, " value=\"", enumString, "\"/>");
                        sb.append(tempString);
                    }
                    continue;
                }
                tempString = Strings.cat(SimpleTypeSrcBuilder.composePadding(padding), "<xsd:", key, " value=\"", temp[0], "\"/>");
                sb.append(tempString);
            }
        }
        tempString = Strings.cat(SimpleTypeSrcBuilder.composePadding(--padding), "</xsd:restriction>");
        sb.append(tempString);
        tempString = Strings.cat(SimpleTypeSrcBuilder.composePadding(--padding), "</xsd:simpleType>");
        sb.append(tempString);
        return sb.toString();
    }

    private static String[] getFacetKeys(SimpleType st) {
        NSRecord record = st.getFacetsMetadata();
        NSField[] fields = record.getFields();
        String[] facetKeys = new String[fields.length];
        for (int i = 0; i < facetKeys.length; ++i) {
            facetKeys[i] = fields[i].getName();
        }
        return facetKeys;
    }
}

