/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.generator;

import com.wm.lang.wsdl.ExtendedElement;
import com.wm.lang.wsdl.Port;
import com.wm.lang.wsdl.Service;
import com.wm.lang.wsdl.generator.SourceBuilders;
import com.wm.lang.wsdl.generator.WSDContext;
import com.wm.lang.wsdl.resources.WSDMessageBundle;
import com.wm.util.LocalizedMessage;
import com.wm.util.Strings;

public class ServiceSrcBuilder
extends SourceBuilders {
    static final String SERVICE_OPEN = "<wsdl:service name=\"";
    static final String PORT_OPEN = "<wsdl:port name=\"";
    static final String BINDING = "\" binding=\"";
    static final String SERVICE_CLOSE = "</wsdl:service>";
    static final String PORT_CLOSE = "</wsdl:port>";

    static void generate(Service svc, WSDContext context) {
        String name = ServiceSrcBuilder.getComponentName(svc, context);
        int padding = 1;
        StringBuffer sb = context._wsdSrc;
        String src = Strings.cat(ServiceSrcBuilder.composePadding(padding), SERVICE_OPEN, name, "\">");
        sb.append(src);
        ++padding;
        ExtendedElement ee = null;
        Object eas = null;
        Port[] ports = svc.getPorts();
        String bindingName = null;
        Object value = null;
        for (int i = 0; i < ports.length; ++i) {
            name = ServiceSrcBuilder.makeNameNice(ports[i].getName());
            bindingName = ServiceSrcBuilder.getComponentName(ports[i].getBinding(), context);
            src = Strings.cat(ServiceSrcBuilder.composePadding(padding), PORT_OPEN, name, BINDING, "tns:", bindingName, "\">");
            sb.append(src);
            ee = ports[i].getExtendedElement();
            if (ee == null) {
                context.addError(new LocalizedMessage(WSDMessageBundle.class, WSDMessageBundle.PORT_NULL_EXTENTED_ELEMENT, null, name));
            } else {
                sb = ServiceSrcBuilder.writeExtentedElement(ee, context, sb, ++padding);
                --padding;
            }
            src = Strings.cat(ServiceSrcBuilder.composePadding(padding), PORT_CLOSE);
            sb.append(src);
        }
        ExtendedElement[] ees = svc.getExtendElements();
        if (ees != null) {
            for (int i = 0; i < ees.length; ++i) {
                ee = ees[i];
                sb = ServiceSrcBuilder.writeExtentedElement(ee, context, sb, padding);
            }
        }
        sb.append(ServiceSrcBuilder.composePadding(--padding));
        sb.append(SERVICE_CLOSE);
        context.setWSDSrc(sb);
    }
}

